/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\n\u0010\u0006\u001a\u00020\u0003*\u00020\u0003\u001a\u0012\u0010\u0006\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0003*\u00020\u0003\u001a\u0012\u0010\b\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0012\u0010\t\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000b\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0003*\u00020\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0003*\u00020\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"pathList", "", "", "Ljava/nio/file/Path;", "getPathList", "(Ljava/nio/file/Path;)Ljava/util/List;", "findOrCreateDirectory", "relativePath", "findOrCreateFile", "getResolvedPath", "isAncestor", "", "path", "strict", "toCanonicalPath", "toNioPath", "toNioPathOrNull", "intellij.platform.util"})
@JvmName(name="NioPathUtil")
@SourceDebugExtension(value={"SMAP\nNioPathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioPathUtil.kt\ncom/intellij/openapi/util/io/NioPathUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1549#2:98\n1620#2,3:99\n*S KotlinDebug\n*F\n+ 1 NioPathUtil.kt\ncom/intellij/openapi/util/io/NioPathUtil\n*L\n17#1:98\n17#1:99,3\n*E\n"})
public final class NioPathUtil {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getPathList(@NotNull Path $this$pathList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$pathList, (String)"<this>");
        Iterable $this$map$iv = $this$pathList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(it.toString());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String toCanonicalPath(@NotNull Path $this$toCanonicalPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toCanonicalPath, (String)"<this>");
        Path path2 = $this$toCanonicalPath.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize()");
        return PathsKt.getInvariantSeparatorsPathString((Path)path2);
    }

    @NotNull
    public static final Path getResolvedPath(@NotNull Path $this$getResolvedPath, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$getResolvedPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path path2 = $this$getResolvedPath.resolve(FileUtil.toSystemDependentName(relativePath)).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(FileUtil.toSyste\u2026elativePath)).normalize()");
        return path2;
    }

    public static final boolean isAncestor(@NotNull Path $this$isAncestor, @NotNull Path path2, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)$this$isAncestor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return FileUtil.isAncestor($this$isAncestor, path2, strict);
    }

    @NotNull
    public static final Path findOrCreateFile(@NotNull Path $this$findOrCreateFile) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateFile, (String)"<this>");
        Path path3 = $this$findOrCreateFile.getParent();
        if (path3 != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path4 = Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"createDirectories(this, *attributes)");
        } else {
            path2 = null;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$findOrCreateFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile($this$findOrCreateFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(this, *attributes)");
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile($this$findOrCreateFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new IOException("Expected file instead of directory: " + $this$findOrCreateFile);
        }
        return $this$findOrCreateFile;
    }

    @NotNull
    public static final Path findOrCreateDirectory(@NotNull Path $this$findOrCreateDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateDirectory, (String)"<this>");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$findOrCreateDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory($this$findOrCreateDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("Expected directory instead of file: " + $this$findOrCreateDirectory);
        }
        return $this$findOrCreateDirectory;
    }

    @NotNull
    public static final Path findOrCreateFile(@NotNull Path $this$findOrCreateFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return NioPathUtil.findOrCreateFile(NioPathUtil.getResolvedPath($this$findOrCreateFile, relativePath));
    }

    @NotNull
    public static final Path findOrCreateDirectory(@NotNull Path $this$findOrCreateDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return NioPathUtil.findOrCreateDirectory(NioPathUtil.getResolvedPath($this$findOrCreateDirectory, relativePath));
    }

    @NotNull
    public static final Path toNioPath(@NotNull String $this$toNioPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toNioPath, (String)"<this>");
        Path path2 = Paths.get(FileUtil.toSystemDependentName($this$toNioPath), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(FileUtil.toSystemDependentName(this))");
        return path2;
    }

    @Nullable
    public static final Path toNioPathOrNull(@NotNull String $this$toNioPathOrNull) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)$this$toNioPathOrNull, (String)"<this>");
        try {
            path2 = NioPathUtil.toNioPath($this$toNioPathOrNull);
        }
        catch (InvalidPathException ex) {
            path2 = null;
        }
        return path2;
    }
}

