/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtilRt;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OSAgnosticPathUtil {
    public static final Comparator<String> COMPARATOR = (path1, path2) -> {
        if (Strings.areSameInstance(path1, path2)) {
            return 0;
        }
        if (path1 == null) {
            return -1;
        }
        if (path2 == null) {
            return 1;
        }
        int length1 = path1.length();
        int length2 = path2.length();
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < length1 && pos < length2; ++pos) {
            char ch2;
            char ch1 = path1.charAt(pos);
            if (ch1 == (ch2 = path2.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return -1;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return -1;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return 1;
            }
            int diff = StringUtil.compare(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(length1, length2);
    };

    private OSAgnosticPathUtil() {
    }

    public static boolean isAbsolute(@NotNull String path2) {
        if (path2 == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(0);
        }
        return path2.startsWith("/") || OSAgnosticPathUtil.isAbsoluteDosPath(path2) || OSAgnosticPathUtil.isUncPath(path2);
    }

    public static boolean isAbsoluteDosPath(@NotNull String path2) {
        if (path2 == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(1);
        }
        return path2.length() > 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path2) && PathUtilRt.isSeparator(path2.charAt(2));
    }

    public static boolean startsWithWindowsDrive(@NotNull String path2) {
        if (path2 == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(2);
        }
        return path2.length() >= 2 && path2.charAt(1) == ':' && OSAgnosticPathUtil.isDriveLetter(path2.charAt(0));
    }

    public static boolean isUncPath(@NotNull String path2) {
        if (path2 == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(3);
        }
        if (!PathUtilRt.startsWithSeparatorSeparator(path2)) {
            return false;
        }
        int slashIndex = OSAgnosticPathUtil.nextSeparatorIndex(path2, 2);
        return PathUtilRt.isWindowsUNCRoot(path2, slashIndex == -1 ? path2.length() : slashIndex);
    }

    public static boolean startsWith(@NotNull String path2, @NotNull String prefix) {
        char next2;
        if (path2 == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(5);
        }
        int pathLength = path2.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return true;
        }
        if (prefixLength > pathLength) {
            return false;
        }
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < pathLength && pos < prefixLength; ++pos) {
            char ch2;
            char ch1 = path2.charAt(pos);
            if (ch1 == (ch2 = prefix.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return false;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return false;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return false;
            }
            if (StringUtil.compare(ch1, ch2, ignoreCase) == 0) continue;
            return false;
        }
        if (pathLength == prefixLength) {
            return true;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == '\\') {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        return (next2 = path2.charAt(slashOrSeparatorIdx)) == '/' || next2 == '\\';
    }

    @Nullable
    public static String getParent(@NotNull String path2) {
        int length;
        int lastSeparator;
        if (path2 == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(6);
        }
        if ((lastSeparator = PathUtilRt.lastSeparatorIndex(path2, (length = path2.length()) - 1)) < 0) {
            return null;
        }
        if (lastSeparator == length - 1) {
            lastSeparator = PathUtilRt.lastSeparatorIndex(path2, length - 2);
        }
        if (lastSeparator < 0) {
            return null;
        }
        if (PathUtilRt.startsWithSeparatorSeparator(path2)) {
            int prevSeparator;
            int slashIndex = OSAgnosticPathUtil.nextSeparatorIndex(path2, 2);
            if (lastSeparator > 1 && slashIndex != -1 && slashIndex <= lastSeparator && PathUtilRt.isWindowsUNCRoot(path2, slashIndex) && (prevSeparator = PathUtilRt.lastSeparatorIndex(path2, lastSeparator - 1)) > 1) {
                return path2.substring(0, lastSeparator);
            }
            return null;
        }
        if (lastSeparator == 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path2)) {
            return path2.substring(0, 3);
        }
        return path2.substring(0, lastSeparator == 0 ? 1 : lastSeparator);
    }

    private static int nextSeparatorIndex(String s, int start) {
        for (int i2 = start; i2 < s.length(); ++i2) {
            char c2 = s.charAt(i2);
            if (!PathUtilRt.isSeparator(c2)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isDriveLetter(char c2) {
        return 'A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/io/OSAgnosticPathUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsolute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsoluteDosPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWithWindowsDrive";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWith";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

