/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class HtmlBuilder {
    private final List<HtmlChunk> myChunks = new ArrayList<HtmlChunk>();

    @Contract(value="_ -> this")
    public HtmlBuilder append(@NotNull HtmlChunk chunk) {
        if (chunk == null) {
            HtmlBuilder.$$$reportNull$$$0(0);
        }
        if (!chunk.isEmpty()) {
            this.myChunks.add(chunk);
        }
        return this;
    }

    @Contract(value="_ -> this")
    public HtmlBuilder append(@NotNull HtmlBuilder builder2) {
        if (builder2 == null) {
            HtmlBuilder.$$$reportNull$$$0(1);
        }
        if (this == builder2) {
            throw new IllegalArgumentException("Cannot add builder to itself");
        }
        this.myChunks.addAll(builder2.myChunks);
        return this;
    }

    @Contract(value="_ -> this")
    public HtmlBuilder append(@NotNull @Nls String text2) {
        if (text2 == null) {
            HtmlBuilder.$$$reportNull$$$0(2);
        }
        return this.append(HtmlChunk.text(text2));
    }

    @Contract(value="_ -> this")
    public HtmlBuilder appendRaw(@NotNull @Nls String rawHtml) {
        if (rawHtml == null) {
            HtmlBuilder.$$$reportNull$$$0(3);
        }
        return this.append(HtmlChunk.raw(rawHtml));
    }

    @Contract(value="_, _ -> this")
    public HtmlBuilder appendLink(@NotNull @NonNls String target2, @NotNull @Nls String text2) {
        if (target2 == null) {
            HtmlBuilder.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            HtmlBuilder.$$$reportNull$$$0(5);
        }
        return this.append(HtmlChunk.link(target2, text2));
    }

    @Contract(value="_, _ -> this")
    public HtmlBuilder appendWithSeparators(@NotNull HtmlChunk separator, @NotNull Iterable<? extends HtmlChunk> children2) {
        if (separator == null) {
            HtmlBuilder.$$$reportNull$$$0(6);
        }
        if (children2 == null) {
            HtmlBuilder.$$$reportNull$$$0(7);
        }
        boolean first2 = true;
        for (HtmlChunk htmlChunk : children2) {
            if (!first2) {
                this.append(separator);
            }
            first2 = false;
            this.append(htmlChunk);
        }
        return this;
    }

    @Contract(value=" -> this")
    public HtmlBuilder nbsp() {
        return this.append(HtmlChunk.nbsp());
    }

    @Contract(value="_ -> this")
    public HtmlBuilder nbsp(int count2) {
        return this.append(HtmlChunk.nbsp(count2));
    }

    @Contract(value=" -> this")
    public HtmlBuilder br() {
        return this.append(HtmlChunk.br());
    }

    @Contract(value=" -> this")
    public HtmlBuilder hr() {
        return this.append(HtmlChunk.hr());
    }

    @Contract(pure=true)
    @NotNull
    public HtmlChunk.Element wrapWith(@NotNull @NonNls String tag) {
        if (tag == null) {
            HtmlBuilder.$$$reportNull$$$0(8);
        }
        HtmlChunk.Element element = HtmlChunk.tag(tag).children(this.myChunks.toArray(new HtmlChunk[0]));
        if (element == null) {
            HtmlBuilder.$$$reportNull$$$0(9);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    public HtmlChunk.Element wrapWith(@NotNull HtmlChunk.Element element) {
        if (element == null) {
            HtmlBuilder.$$$reportNull$$$0(10);
        }
        HtmlChunk.Element element2 = element.children(this.myChunks.toArray(new HtmlChunk[0]));
        if (element2 == null) {
            HtmlBuilder.$$$reportNull$$$0(11);
        }
        return element2;
    }

    @Contract(pure=true)
    @NotNull
    public HtmlChunk.Element wrapWithHtmlBody() {
        HtmlChunk.Element element = this.wrapWith("body").wrapWith("html");
        if (element == null) {
            HtmlBuilder.$$$reportNull$$$0(12);
        }
        return element;
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return this.myChunks.isEmpty();
    }

    public HtmlChunk toFragment() {
        if (this.myChunks.isEmpty()) {
            return HtmlChunk.empty();
        }
        if (this.myChunks.size() == 1) {
            return this.myChunks.get(0);
        }
        return new HtmlChunk.Fragment(new ArrayList<HtmlChunk>(this.myChunks));
    }

    @Contract(pure=true)
    @NlsSafe
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (HtmlChunk chunk : this.myChunks) {
            chunk.appendTo(sb);
        }
        return sb.toString();
    }

    public void clear() {
        this.myChunks.clear();
    }

    public void clearAndAppend(@NotNull HtmlChunk chunk) {
        if (chunk == null) {
            HtmlBuilder.$$$reportNull$$$0(13);
        }
        this.clear();
        this.append(chunk);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawHtml";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/HtmlBuilder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/HtmlBuilder";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWith";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithHtmlBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendRaw";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendLink";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendWithSeparators";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapWith";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearAndAppend";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

