/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.CollectionFactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pluralizer {
    static final Pluralizer PLURALIZER;
    private final Map<String, String> irregularSingles = CollectionFactory.createCaseInsensitiveStringMap();
    private final Map<String, String> irregularPlurals = CollectionFactory.createCaseInsensitiveStringMap();
    private final Set<String> uncountables = CollectionFactory.createCaseInsensitiveStringSet();
    private final List<Map.Entry<Pattern, String>> pluralRules = new ArrayList<Map.Entry<Pattern, String>>();
    private final List<Map.Entry<Pattern, String>> singularRules = new ArrayList<Map.Entry<Pattern, String>>();

    public static String restoreCase(String word2, String result2) {
        char lc;
        char uc;
        char wc;
        int i2;
        if (word2 == null || result2 == null || Strings.areSameInstance(word2, result2)) {
            return result2;
        }
        int len = Math.min(result2.length(), word2.length());
        if (len == 0) {
            return result2;
        }
        char[] chars = result2.toCharArray();
        for (i2 = 0; i2 < len; ++i2) {
            wc = word2.charAt(i2);
            if (chars[i2] == wc && i2 != len - 1) continue;
            uc = Character.toUpperCase(chars[i2]);
            lc = Character.toLowerCase(chars[i2]);
            if (wc != lc && wc != uc) break;
            chars[i2] = wc;
        }
        if (i2 > 0 && i2 < chars.length && (uc = Character.toUpperCase(wc = word2.charAt(i2 - 1))) != (lc = Character.toLowerCase(wc))) {
            while (i2 < chars.length) {
                chars[i2] = wc == uc ? Character.toUpperCase(chars[i2]) : Character.toLowerCase(chars[i2]);
                ++i2;
            }
        }
        return new String(chars);
    }

    private String sanitizeWord(String word2, List<? extends Map.Entry<Pattern, String>> rules) {
        if (Strings.isEmpty(word2) || this.uncountables.contains(word2)) {
            return word2;
        }
        int len = rules.size();
        while (--len > -1) {
            Map.Entry<Pattern, String> rule = rules.get(len);
            Matcher matcher = rule.getKey().matcher(word2);
            if (!matcher.find()) continue;
            return matcher.replaceFirst(rule.getValue());
        }
        return null;
    }

    private String replaceWord(String word2, Map<String, String> replaceMap, Map<String, String> keepMap, List<? extends Map.Entry<Pattern, String>> rules) {
        if (Strings.isEmpty(word2)) {
            return word2;
        }
        if (keepMap.containsKey(word2)) {
            return word2;
        }
        String replacement = replaceMap.get(word2);
        if (replacement != null) {
            return replacement;
        }
        return this.sanitizeWord(word2, rules);
    }

    @NotNull
    public String pluralize(@NotNull String word2, int count2, boolean inclusive) {
        if (word2 == null) {
            Pluralizer.$$$reportNull$$$0(0);
        }
        String pluralized = count2 == 1 ? this.singular(word2) : this.plural(word2);
        String string2 = (inclusive ? count2 + " " : "") + Strings.notNullize(pluralized, word2);
        if (string2 == null) {
            Pluralizer.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Nullable
    public String plural(@Nullable String word2) {
        return Pluralizer.restoreCase(word2, this.replaceWord(word2, this.irregularSingles, this.irregularPlurals, this.pluralRules));
    }

    @Nullable
    public String singular(@Nullable String word2) {
        return Pluralizer.restoreCase(word2, this.replaceWord(word2, this.irregularPlurals, this.irregularSingles, this.singularRules));
    }

    private static Pattern sanitizeRule(String rule) {
        return Pattern.compile(rule.startsWith("/") ? rule.substring(1) : "^" + rule + "$", 2);
    }

    private void addPluralRule(String rule, String replacement) {
        this.pluralRules.add(new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pluralizer.sanitizeRule(rule), replacement));
    }

    private void addSingularRule(String rule, String replacement) {
        this.singularRules.add(new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pluralizer.sanitizeRule(rule), replacement));
    }

    private void addUncountableRule(String word2) {
        if (!word2.startsWith("/")) {
            this.uncountables.add(word2);
        } else {
            this.addPluralRule(word2, "$0");
            this.addSingularRule(word2, "$0");
        }
    }

    private void addIrregularRule(String single2, String plural) {
        this.irregularSingles.put(single2, plural);
        this.irregularPlurals.put(plural, single2);
    }

    static {
        Pluralizer pluralizer = new Pluralizer();
        for (String[] stringArray : new String[][]{{"this", "these"}, {"that", "those"}, {"echo", "echoes"}, {"dingo", "dingoes"}, {"volcano", "volcanoes"}, {"tornado", "tornadoes"}, {"torpedo", "torpedoes"}, {"genus", "genera"}, {"viscus", "viscera"}, {"stigma", "stigmata"}, {"stoma", "stomata"}, {"dogma", "dogmata"}, {"lemma", "lemmata"}, {"anathema", "anathemata"}, {"ox", "oxen"}, {"axe", "axes"}, {"die", "dice"}, {"yes", "yeses"}, {"foot", "feet"}, {"eave", "eaves"}, {"goose", "geese"}, {"tooth", "teeth"}, {"quiz", "quizzes"}, {"human", "humans"}, {"proof", "proofs"}, {"carve", "carves"}, {"valve", "valves"}, {"looey", "looies"}, {"thief", "thieves"}, {"groove", "grooves"}, {"pickaxe", "pickaxes"}, {"whiskey", "whiskies"}}) {
            pluralizer.addIrregularRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[][]{{"/s?$", "s"}, {"/([^aeiou]ese)$", "$1"}, {"/(ax|test)is$", "$1es"}, {"/(alias|[^aou]us|t[lm]as|gas|ris)$", "$1es"}, {"/(e[mn]u)s?$", "$1s"}, {"/([^l]ias|[aeiou]las|[ejzr]as|[iu]am)$", "$1"}, {"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1i"}, {"/(alumn|alg|vertebr)(?:a|ae)$", "$1ae"}, {"/(seraph|cherub)(?:im)?$", "$1im"}, {"/(her|at|gr)o$", "$1oes"}, {"/(agend|addend|millenni|medi|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$", "$1a"}, {"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$", "$1a"}, {"/sis$", "ses"}, {"/(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$", "$1$2ves"}, {"/([^aeiouy]|qu)y$", "$1ies"}, {"/([^ch][ieo][ln])ey$", "$1ies"}, {"/(x|ch|ss|sh|zz)$", "$1es"}, {"/(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$", "$1ices"}, {"(m|l)(?:ice|ouse)", "$1ice"}, {"/(pe)(?:rson|ople)$", "$1ople"}, {"/(child)(?:ren)?$", "$1ren"}, {"/eaux$", "$0"}, {"/m[ae]n$", "men"}}) {
            pluralizer.addPluralRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[][]{{"/(.)s$", "$1"}, {"/([^aeiou]s)es$", "$1"}, {"/(wi|kni|(?:after|half|high|low|mid|non|night|[^\\w]|^)li)ves$", "$1fe"}, {"/(ar|(?:wo|[ae])l|[eo][ao])ves$", "$1f"}, {"/ies$", "y"}, {"/\\b([pl]|zomb|(?:neck|cross)?t|coll|faer|food|gen|goon|group|lass|talk|goal|cut)ies$", "$1ie"}, {"/\\b(mon|smil)ies$", "$1ey"}, {"(m|l)ice", "$1ouse"}, {"/(seraph|cherub)im$", "$1"}, {"/.(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|t[lm]as|gas|(?:her|at|gr)o|ris)(?:es)?$", "$1"}, {"/(analy|^ba|diagno|parenthe|progno|synop|the|empha|cri)(?:sis|ses)$", "$1sis"}, {"/(movie|twelve|abuse|e[mn]u)s$", "$1"}, {"/(test)(?:is|es)$", "$1is"}, {"/(x|ch|.ss|sh|zz|tto|go|cho|alias|[^aou]us|tlas|gas|(?:her|at|gr)o|ris)(?:es)?$", "$1"}, {"/(e[mn]u)s?$", "$1"}, {"/(cookie|movie|twelve)s$", "$1"}, {"/(cris|test|diagnos)(?:is|es)$", "$1is"}, {"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1us"}, {"/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$", "$1um"}, {"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$", "$1on"}, {"/(alumn|alg|vertebr)ae$", "$1a"}, {"/(cod|mur|sil|vert|ind)ices$", "$1ex"}, {"/(matr|append)ices$", "$1ix"}, {"/(pe)(rson|ople)$", "$1rson"}, {"/(child)ren$", "$1"}, {"/(eau)x?$", "$1"}, {"/men$", "man"}}) {
            pluralizer.addSingularRule(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : new String[]{"adulthood", "advice", "agenda", "aid", "alcohol", "ammo", "anime", "athletics", "audio", "bison", "blood", "bream", "buffalo", "butter", "carp", "cash", "chassis", "chess", "clothing", "cod", "commerce", "cooperation", "corps", "debris", "diabetes", "digestion", "elk", "energy", "equipment", "excretion", "expertise", "flounder", "fun", "gallows", "garbage", "graffiti", "headquarters", "health", "herpes", "highjinks", "homework", "housework", "information", "jeans", "justice", "kudos", "labour", "literature", "machinery", "mackerel", "mail", "media", "mews", "moose", "music", "news", "pike", "plankton", "pliers", "police", "pollution", "premises", "rain", "research", "rice", "salmon", "scissors", "series", "sewage", "shambles", "shrimp", "species", "staff", "swine", "tennis", "traffic", "transportation", "trout", "tuna", "wealth", "welfare", "whiting", "wildebeest", "wildlife", "you", "/[^aeiou]ese$/i", "/deer$", "/fish$", "/measles$", "/o[iu]s$", "/pox$", "/sheep$"}) {
            pluralizer.addUncountableRule((String)stringArray);
        }
        PLURALIZER = pluralizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/Pluralizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/Pluralizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

