/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0002H\u0007\u001a\u001b\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u001b\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u0019\u0010\f\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u0019\u0010\r\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0006*\u00020\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0002*\u00020\u0016H\u0007\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0002*\u00020\u0016H\u0007\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0016*\u00020\u0002\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0013\u001a\u0012\u0010\u001c\u001a\u00020\u001a*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u001d"}, d2={"isFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "findDirectory", "relativePath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "findDocument", "Lcom/intellij/openapi/editor/Document;", "findFile", "findFileOrDirectory", "findOrCreateDirectory", "findOrCreateFile", "findPsiFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "readBytes", "", "readText", "refreshAndFindVirtualDirectory", "Ljava/nio/file/Path;", "refreshAndFindVirtualFile", "toNioPathOrNull", "writeBytes", "", "content", "writeText", "intellij.platform.core"})
@JvmName(name="VirtualFileUtil")
@SourceDebugExtension(value={"SMAP\nVirtualFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/openapi/vfs/VirtualFileUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class VirtualFileUtil {
    public static final boolean isFile(@NotNull VirtualFile $this$isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isFile, (String)"<this>");
        return $this$isFile.isValid() && !$this$isFile.isDirectory();
    }

    @NotNull
    public static final String readText(@NotNull VirtualFile $this$readText) {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        String string2 = VfsUtilCore.loadText($this$readText);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"loadText(this)");
        return string2;
    }

    public static final void writeText(@NotNull VirtualFile $this$writeText, @NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        VfsUtilCore.saveText($this$writeText, content2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readBytes(@NotNull VirtualFile $this$readBytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        Closeable closeable = $this$readBytes.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byArray = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    public static final void writeBytes(@NotNull VirtualFile $this$writeBytes, @NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        $this$writeBytes.setBinaryContent(content2);
    }

    @Nullable
    public static final Path toNioPathOrNull(@NotNull VirtualFile $this$toNioPathOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toNioPathOrNull, (String)"<this>");
        Object object2 = $this$toNioPathOrNull;
        try {
            VirtualFile $this$toNioPathOrNull_u24lambda_u241 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$toNioPathOrNull_u24lambda_u241.toNioPath());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @RequiresReadLock
    @Nullable
    public static final Document findDocument(@NotNull VirtualFile $this$findDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$findDocument, (String)"<this>");
        return FileDocumentManager.getInstance().getDocument($this$findDocument);
    }

    @RequiresReadLock
    @Nullable
    public static final PsiFile findPsiFile(@NotNull VirtualFile $this$findPsiFile, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$findPsiFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return PsiManager.getInstance(project2).findFile($this$findPsiFile);
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFileOrDirectory(@NotNull VirtualFile $this$findFileOrDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findFileOrDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile2 = $this$findFileOrDirectory.getFileSystem().findFileByPath("/");
        if (virtualFile2 == null) {
            boolean $i$a$-checkNotNull-VirtualFileUtil$findFileOrDirectory$virtualFile$22 = false;
            String $i$a$-checkNotNull-VirtualFileUtil$findFileOrDirectory$virtualFile$22 = "Cannot find file system root for file: " + $this$findFileOrDirectory.getPath() + '/' + relativePath;
            throw new IllegalStateException($i$a$-checkNotNull-VirtualFileUtil$findFileOrDirectory$virtualFile$22.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"checkNotNull(fileSystem.\u2026 $path/$relativePath\"\n  }");
        VirtualFile virtualFile3 = virtualFile2;
        String string2 = $this$findFileOrDirectory.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        List<String> names = NioPathUtil.getPathList(NioPathUtil.getResolvedPath(NioPathUtil.toNioPath(string2), relativePath));
        for (String name : names) {
            if (virtualFile3.findChild(name) != null) continue;
            return null;
        }
        return virtualFile3;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFile(@NotNull VirtualFile $this$findFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile2 = VirtualFileUtil.findFileOrDirectory($this$findFile, relativePath);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        if (!VirtualFileUtil.isFile(file2)) {
            throw new IOException("Expected file instead of directory: " + $this$findFile.getPath() + '/' + relativePath);
        }
        return file2;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findDirectory(@NotNull VirtualFile $this$findDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile2 = VirtualFileUtil.findFileOrDirectory($this$findDirectory, relativePath);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        if (!file2.isDirectory()) {
            throw new IOException("Expected directory instead of file: " + $this$findDirectory.getPath() + '/' + relativePath);
        }
        return file2;
    }

    @RequiresWriteLock
    @NotNull
    public static final VirtualFile findOrCreateFile(@NotNull VirtualFile $this$findOrCreateFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile directory = VirtualFileUtil.findOrCreateDirectory($this$findOrCreateFile, relativePath + "/..");
        String string2 = $this$findOrCreateFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        String name = PathsKt.getName((Path)NioPathUtil.getResolvedPath(NioPathUtil.toNioPath(string2), relativePath));
        VirtualFile virtualFile2 = directory.findChild(name);
        if (virtualFile2 == null) {
            virtualFile2 = directory.createChildData($this$findOrCreateFile.getFileSystem(), name);
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"directory.findChild(name\u2026ildData(fileSystem, name)");
        VirtualFile file2 = virtualFile2;
        if (!VirtualFileUtil.isFile(file2)) {
            throw new IOException("Expected file instead of directory: " + $this$findOrCreateFile.getPath() + '/' + relativePath);
        }
        return file2;
    }

    @RequiresWriteLock
    @NotNull
    public static final VirtualFile findOrCreateDirectory(@NotNull VirtualFile $this$findOrCreateDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile2 = $this$findOrCreateDirectory.getFileSystem().findFileByPath("/");
        if (virtualFile2 == null) {
            boolean $i$a$-checkNotNull-VirtualFileUtil$findOrCreateDirectory$directory$22 = false;
            String $i$a$-checkNotNull-VirtualFileUtil$findOrCreateDirectory$directory$22 = "Cannot find file system root for file: " + $this$findOrCreateDirectory.getPath() + '/' + relativePath;
            throw new IllegalStateException($i$a$-checkNotNull-VirtualFileUtil$findOrCreateDirectory$directory$22.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"checkNotNull(fileSystem.\u2026 $path/$relativePath\"\n  }");
        VirtualFile directory = virtualFile2;
        String string2 = $this$findOrCreateDirectory.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        List<String> names = NioPathUtil.getPathList(NioPathUtil.getResolvedPath(NioPathUtil.toNioPath(string2), relativePath));
        for (String name : names) {
            VirtualFile virtualFile3 = directory.findChild(name);
            if (virtualFile3 == null) {
                VirtualFile virtualFile4 = directory.createChildDirectory($this$findOrCreateDirectory.getFileSystem(), name);
                virtualFile3 = virtualFile4;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"directory.createChildDirectory(fileSystem, name)");
            }
            if ((directory = virtualFile3).isDirectory()) continue;
            throw new IOException("Expected directory instead of file: " + directory.getPath());
        }
        return directory;
    }

    @RequiresWriteLock
    @Nullable
    public static final VirtualFile refreshAndFindVirtualFile(@NotNull Path $this$refreshAndFindVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshAndFindVirtualFile, (String)"<this>");
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        VirtualFile virtualFile2 = fileManager.refreshAndFindFileByNioPath($this$refreshAndFindVirtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        if (!VirtualFileUtil.isFile(file2)) {
            throw new IOException("Expected file instead of directory: " + $this$refreshAndFindVirtualFile);
        }
        return file2;
    }

    @RequiresWriteLock
    @Nullable
    public static final VirtualFile refreshAndFindVirtualDirectory(@NotNull Path $this$refreshAndFindVirtualDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshAndFindVirtualDirectory, (String)"<this>");
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        VirtualFile virtualFile2 = fileManager.refreshAndFindFileByNioPath($this$refreshAndFindVirtualDirectory);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        if (!file2.isDirectory()) {
            throw new IOException("Expected directory instead of file: " + $this$refreshAndFindVirtualDirectory);
        }
        return file2;
    }
}

