/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.encoding.FileEncodingConfigurableUI;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileEncodingConfigurable
extends PerFileConfigurableBase<Charset> {
    private final FileEncodingConfigurableUI ui;
    private Charset myPropsCharset;
    private final PerFileConfigurableBase.Mapping<Charset> myProjectMapping;
    private final PerFileConfigurableBase.Mapping<Charset> myGlobalMapping;

    FileEncodingConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(0);
        }
        super(project2, FileEncodingConfigurable.createMappings(project2));
        this.ui = new FileEncodingConfigurableUI();
        EncodingManager app = EncodingManager.getInstance();
        EncodingProjectManagerImpl prj = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance(this.myProject);
        this.myProjectMapping = new PerFileConfigurableBase.Mapping<Charset>(IdeBundle.message((String)"file.encoding.option.global.encoding", (Object[])new Object[0]), () -> app.getDefaultCharsetName().isEmpty() ? null : app.getDefaultCharset(), o -> app.setDefaultCharsetName(FileEncodingConfigurable.getCharsetName(o)));
        this.myGlobalMapping = new PerFileConfigurableBase.Mapping<Charset>(IdeBundle.message((String)"file.encoding.option.project.encoding", (Object[])new Object[0]), () -> ((EncodingProjectManagerImpl)prj).getConfiguredDefaultCharset(), o -> prj.setDefaultCharsetName(FileEncodingConfigurable.getCharsetName(o)));
    }

    @Override
    protected boolean isGlobalMapping(PerFileConfigurableBase.Mapping<Charset> prop) {
        return prop == this.myGlobalMapping || super.isGlobalMapping(prop);
    }

    @Override
    protected boolean isProjectMapping(PerFileConfigurableBase.Mapping<Charset> prop) {
        return prop == this.myProjectMapping || super.isProjectMapping(prop);
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"file.encodings.configurable", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settingsdialog.project.file.encodings";
    }

    @Override
    @NotNull
    public String getId() {
        return "File.Encoding";
    }

    @Override
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(1);
        }
        if (key == DESCRIPTION) {
            return IdeBundle.message((String)"encodings.dialog.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        }
        if (key == MAPPING_TITLE) {
            return IdeBundle.message((String)"file.encoding.option.encoding.column", (Object[])new Object[0]);
        }
        if (key == TARGET_TITLE) {
            return IdeBundle.message((String)"file.encoding.option.path.column", (Object[])new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return null;
        }
        if (key == OVERRIDE_TITLE) {
            return null;
        }
        if (key == EMPTY_TEXT) {
            return IdeBundle.message((String)"file.encodings.not.configured", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    protected void renderValue(@Nullable Object target2, @NotNull Charset t, @NotNull ColoredTextContainer renderer) {
        if (t == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(3);
        }
        VirtualFile file2 = target2 instanceof VirtualFile ? (VirtualFile)target2 : null;
        EncodingUtil.FailReason result2 = file2 == null || file2.isDirectory() ? null : EncodingUtil.checkCanConvertAndReload((VirtualFile)file2);
        @NlsSafe String encodingText = t.displayName();
        SimpleTextAttributes attributes = result2 == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        renderer.append(encodingText + (String)(result2 == null ? "" : " (" + EncodingUtil.reasonToString((EncodingUtil.FailReason)result2, (VirtualFile)file2) + ")"), attributes);
    }

    @Override
    @NotNull
    protected ActionGroup createActionListGroup(@Nullable Object target2, final @NotNull Consumer<? super Charset> onChosen2) {
        if (onChosen2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(4);
        }
        VirtualFile file2 = target2 instanceof VirtualFile ? (VirtualFile)target2 : null;
        byte[] b = null;
        try {
            b = file2 == null || file2.isDirectory() ? null : file2.contentsToByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] bytes = b;
        Document document = file2 == null ? null : FileDocumentManager.getInstance().getDocument(file2);
        DefaultActionGroup defaultActionGroup = new ChangeFileEncodingAction(true){

            protected boolean chosen(Document document, Editor editor2, VirtualFile virtualFile2, byte[] bytes, @NotNull Charset charset) {
                if (charset == null) {
                    1.$$$reportNull$$$0(0);
                }
                onChosen2.consume(charset);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$1", "chosen"));
            }
        }.createActionGroup(file2, null, document, bytes, this.getClearValueText(target2));
        if (defaultActionGroup == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    @Override
    @NlsActions.ActionText
    @Nullable
    protected String getClearValueText(@Nullable Object target2) {
        return target2 != null ? super.getClearValueText(target2) : LangBundle.message("action.set.system.default.encoding.text", new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    @Nullable
    protected String getNullValueText(@Nullable Object target2) {
        return target2 != null ? super.getNullValueText(target2) : IdeBundle.message((String)"encoding.name.system.default", (Object[])new Object[]{CharsetToolkit.getDefaultSystemCharset().displayName()});
    }

    @Override
    @NotNull
    protected Collection<Charset> getValueVariants(@Nullable Object target2) {
        List<Charset> list2 = Arrays.asList(CharsetToolkit.getAvailableCharsets());
        if (list2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        String nullTextValue = IdeBundle.message((String)"encoding.name.properties.default", (Object[])new Object[]{StandardCharsets.ISO_8859_1.displayName()});
        JComponent tablePanel = super.createComponent();
        Dimension size = tablePanel.getPreferredSize();
        tablePanel.setPreferredSize(new Dimension(400, size.height));
        final class PropertiesCharsetValue
        implements PerFileConfigurableBase.Value<Charset> {
            PropertiesCharsetValue() {
            }

            @Override
            public void commit() {
            }

            @Override
            public Charset get() {
                return FileEncodingConfigurable.this.myPropsCharset;
            }

            @Override
            public void set(Charset value) {
                FileEncodingConfigurable.this.myPropsCharset = FileEncodingConfigurable.this.adjustChosenValue((Object)null, value);
            }
        }
        DialogPanel dialogPanel = this.ui.createContent(tablePanel, this.createActionPanel((AnAction)new PerFileConfigurableBase.PerFileConfigurableComboBoxAction(this, new PropertiesCharsetValue(), null, nullTextValue)));
        if (dialogPanel == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(7);
        }
        return dialogPanel;
    }

    @Override
    @NotNull
    protected List<PerFileConfigurableBase.Mapping<Charset>> getDefaultMappings() {
        List<PerFileConfigurableBase.Mapping<Charset>> list2 = Arrays.asList(this.myProjectMapping, this.myGlobalMapping);
        if (list2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    protected Charset adjustChosenValue(@Nullable Object target2, Charset chosen) {
        return chosen == ChooseFileEncodingAction.NO_ENCODING ? null : chosen;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance(this.myProject);
        boolean same = Comparing.equal(encodingManager.getDefaultCharsetForPropertiesFiles(null), this.myPropsCharset) && encodingManager.isNative2AsciiForPropertiesFiles() == this.ui.transparentNativeToAsciiCheckBox.isSelected() && encodingManager.getBOMForNewUTF8Files() == this.ui.bomForUTF8Combo.getSelectedItem();
        return !same;
    }

    @NotNull
    private static String getCharsetName(@Nullable Charset c2) {
        String string2 = c2 == null ? "" : c2.name();
        if (string2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance(this.myProject);
        encodingManager.setDefaultCharsetForPropertiesFiles(null, this.myPropsCharset);
        encodingManager.setNative2AsciiForPropertiesFiles(null, this.ui.transparentNativeToAsciiCheckBox.isSelected());
        EncodingProjectManagerImpl.BOMForNewUTF8Files option = ObjectUtils.notNull((EncodingProjectManagerImpl.BOMForNewUTF8Files)this.ui.bomForUTF8Combo.getSelectedItem(), EncodingProjectManagerImpl.BOMForNewUTF8Files.NEVER);
        encodingManager.setBOMForNewUtf8Files(option);
    }

    @Override
    public void reset() {
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance(this.myProject);
        this.ui.transparentNativeToAsciiCheckBox.setSelected(encodingManager.isNative2AsciiForPropertiesFiles());
        this.myPropsCharset = encodingManager.getDefaultCharsetForPropertiesFiles(null);
        this.ui.bomForUTF8Combo.setSelectedItem((Object)encodingManager.getBOMForNewUTF8Files());
        super.reset();
    }

    @Override
    protected boolean canEditTarget(@Nullable Object target2, Charset value) {
        return target2 == null || target2 instanceof VirtualFile && (((VirtualFile)target2).isDirectory() || EncodingUtil.checkCanConvertAndReload((VirtualFile)((VirtualFile)target2)) == null);
    }

    @NotNull
    private static PerFileMappingsEx<Charset> createMappings(@NotNull Project project2) {
        if (project2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(10);
        }
        final EncodingProjectManagerImpl prjManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance(project2);
        return new PerFileMappingsEx<Charset>(){

            @Override
            @NotNull
            public Map<VirtualFile, Charset> getMappings() {
                return new HashMap<VirtualFile, Charset>(prjManager.getAllMappings());
            }

            @Override
            public void setMappings(@NotNull Map<VirtualFile, Charset> mappings) {
                if (mappings == null) {
                    2.$$$reportNull$$$0(0);
                }
                prjManager.setMapping(mappings);
            }

            @Override
            public void setMapping(@Nullable VirtualFile file2, Charset value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Charset getMapping(@Nullable VirtualFile file2) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public Charset getDefaultMapping(@Nullable VirtualFile file2) {
                return prjManager.getEncoding(file2, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$2", "setMappings"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionListGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createActionListGroup";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMappings";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 7, 8, 9 -> new IllegalStateException(string2);
        };
    }
}

