/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.util.scopeChooser.PackageSetChooserCombo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyConfigurable
implements Configurable,
Configurable.NoScroll {
    private final Project myProject;
    private MyTableModel myDenyRulesModel;
    private MyTableModel myAllowRulesModel;
    private TableView<DependencyRule> myDenyTable;
    private TableView<DependencyRule> myAllowTable;
    private final ColumnInfo<DependencyRule, NamedScope> DENY_USAGES_OF = new LeftColumn(CodeInsightBundle.message("dependency.configurable.deny.table.column1", new Object[0]));
    private final ColumnInfo<DependencyRule, NamedScope> DENY_USAGES_IN = new RightColumn(CodeInsightBundle.message("dependency.configurable.deny.table.column2", new Object[0]));
    private final ColumnInfo<DependencyRule, NamedScope> ALLOW_USAGES_OF = new LeftColumn(CodeInsightBundle.message("dependency.configurable.allow.table.column1", new Object[0]));
    private final ColumnInfo<DependencyRule, NamedScope> ALLOW_USAGES_ONLY_IN = new RightColumn(CodeInsightBundle.message("dependency.configurable.allow.table.column2", new Object[0]));
    private JCheckBox mySkipImports;
    private static final Logger LOG = Logger.getInstance(DependencyConfigurable.class);
    private static final DefaultTableCellRenderer CELL_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText(value == null ? "" : ((NamedScope)value).getPresentableName());
            return this;
        }
    };

    public DependencyConfigurable(Project project2) {
        this.myProject = project2;
    }

    public String getDisplayName() {
        return CodeInsightBundle.message("dependency.configurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "editing.analyzeDependencies.validation";
    }

    public JComponent createComponent() {
        JPanel wholePanel = new JPanel(new GridBagLayout());
        GridBag constraint = new GridBag().setDefaultWeightX(1.0).setDefaultWeightY(1.0).setDefaultFill(1);
        this.myDenyRulesModel = new MyTableModel(new ColumnInfo[]{this.DENY_USAGES_OF, this.DENY_USAGES_IN}, true);
        this.myDenyRulesModel.setSortable(false);
        this.myAllowRulesModel = new MyTableModel(new ColumnInfo[]{this.ALLOW_USAGES_OF, this.ALLOW_USAGES_ONLY_IN}, false);
        this.myAllowRulesModel.setSortable(false);
        this.myDenyTable = new TableView((ListTableModel)this.myDenyRulesModel);
        this.myAllowTable = new TableView((ListTableModel)this.myAllowRulesModel);
        this.mySkipImports = new JCheckBox(CodeInsightBundle.message("skip.import.statements.checkbox.title", new Object[0]));
        wholePanel.add((Component)this.createRulesPanel(this.myDenyTable), constraint.nextLine());
        wholePanel.add((Component)this.createRulesPanel(this.myAllowTable), constraint.nextLine().insets(12, 0, 4, 0));
        wholePanel.add((Component)this.mySkipImports, constraint.nextLine().weighty(0.0));
        wholePanel.setMinimumSize(new Dimension(400, 400));
        return wholePanel;
    }

    private JPanel createRulesPanel(TableView<DependencyRule> table) {
        table.setSurrendersFocusOnKeystroke(true);
        table.setPreferredScrollableViewportSize((Dimension)JBUI.size(300, 150));
        table.setShowGrid(true);
        table.setRowHeight(new PackageSetChooserCombo((Project)this.myProject, null).getPreferredSize().height);
        return ToolbarDecorator.createDecorator(table).createPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDenyTable;
    }

    public void apply() throws ConfigurationException {
        this.stopTableEditing();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance(this.myProject);
        validationManager.removeAllRules();
        HashMap<String, PackageSet> unUsed = new HashMap<String, PackageSet>(validationManager.getUnnamedScopes());
        ArrayList modelItems = new ArrayList();
        modelItems.addAll(this.myDenyRulesModel.getItems());
        modelItems.addAll(this.myAllowRulesModel.getItems());
        for (DependencyRule rule : modelItems) {
            NamedScope toScope;
            validationManager.addRule(rule);
            NamedScope fromScope = rule.getFromScope();
            if (fromScope instanceof NamedScope.UnnamedScope) {
                PackageSet fromPackageSet = fromScope.getValue();
                LOG.assertTrue(fromPackageSet != null);
                unUsed.remove(fromPackageSet.getText());
            }
            if (!((toScope = rule.getToScope()) instanceof NamedScope.UnnamedScope)) continue;
            PackageSet toPackageSet = toScope.getValue();
            LOG.assertTrue(toPackageSet != null);
            unUsed.remove(toPackageSet.getText());
        }
        for (String text2 : unUsed.keySet()) {
            validationManager.getUnnamedScopes().remove(text2);
        }
        validationManager.setSkipImportStatements(this.mySkipImports.isSelected());
        DaemonCodeAnalyzer.getInstance(this.myProject).restart();
    }

    private void stopTableEditing() {
        this.myDenyTable.stopEditing();
        this.myAllowTable.stopEditing();
    }

    public void reset() {
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance(this.myProject);
        DependencyRule[] rules = validationManager.getAllRules();
        ArrayList<DependencyRule> denyList = new ArrayList<DependencyRule>();
        ArrayList<DependencyRule> allowList = new ArrayList<DependencyRule>();
        for (DependencyRule rule : rules) {
            if (rule.isDenyRule()) {
                denyList.add(rule.createCopy());
                continue;
            }
            allowList.add(rule.createCopy());
        }
        this.myDenyRulesModel.setItems(denyList);
        this.myAllowRulesModel.setItems(allowList);
        this.mySkipImports.setSelected(validationManager.skipImportStatements());
    }

    public boolean isModified() {
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance(this.myProject);
        if (validationManager.skipImportStatements() != this.mySkipImports.isSelected()) {
            return true;
        }
        ArrayList rules = new ArrayList();
        rules.addAll(this.myDenyRulesModel.getItems());
        rules.addAll(this.myAllowRulesModel.getItems());
        return !Arrays.asList(validationManager.getAllRules()).equals(rules);
    }

    public static JButton getConfigureButton(@NotNull Project project2) {
        if (project2 == null) {
            DependencyConfigurable.$$$reportNull$$$0(0);
        }
        JButton button2 = new JButton(CodeInsightBundle.message("jvm.inspections.dependency.configure.button.text", new Object[0]));
        button2.addActionListener(e -> ShowSettingsUtil.getInstance().editConfigurable((Component)button2, (Configurable)new DependencyConfigurable(project2)));
        return button2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/ui/DependencyConfigurable", "getConfigureButton"));
    }

    private class LeftColumn
    extends MyColumnInfo {
        LeftColumn(String name) {
            super(name);
        }

        public NamedScope valueOf(DependencyRule rule) {
            return rule.getToScope();
        }

        @Override
        public void setValue(DependencyRule rule, NamedScope set2) {
            rule.setToScope(set2);
        }
    }

    private class RightColumn
    extends MyColumnInfo {
        RightColumn(String name) {
            super(name);
        }

        public NamedScope valueOf(DependencyRule rule) {
            return rule.getFromScope();
        }

        @Override
        public void setValue(DependencyRule rule, NamedScope set2) {
            rule.setFromScope(set2);
        }
    }

    private static class MyTableModel
    extends ListTableModel<DependencyRule>
    implements EditableModel {
        private final boolean myDenyRule;

        MyTableModel(ColumnInfo[] columnInfos, boolean isDenyRule) {
            super(columnInfos);
            this.myDenyRule = isDenyRule;
        }

        @Override
        public void addRow() {
            ArrayList<DependencyRule> newList = new ArrayList<DependencyRule>(this.getItems());
            NamedScope scope = CustomScopesProviderEx.getAllScope();
            newList.add(new DependencyRule(scope, scope, this.myDenyRule));
            this.setItems(newList);
        }

        @Override
        public void exchangeRows(int index1, int index2) {
            ArrayList<DependencyRule> newList = new ArrayList<DependencyRule>(this.getItems());
            DependencyRule r1 = (DependencyRule)newList.get(index1);
            DependencyRule r2 = (DependencyRule)newList.get(index2);
            newList.set(index1, r2);
            newList.set(index2, r1);
            this.setItems(newList);
        }
    }

    public abstract class MyColumnInfo
    extends ColumnInfo<DependencyRule, NamedScope> {
        protected MyColumnInfo(String name) {
            super(name);
        }

        public boolean isCellEditable(DependencyRule rule) {
            return true;
        }

        public TableCellRenderer getRenderer(DependencyRule rule) {
            return CELL_RENDERER;
        }

        public TableCellEditor getEditor(DependencyRule packageSetDependencyRule) {
            return new AbstractTableCellEditor(){
                private PackageSetChooserCombo myCombo;

                @Override
                public Object getCellEditorValue() {
                    return this.myCombo.getSelectedScope();
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    this.myCombo = new PackageSetChooserCombo(DependencyConfigurable.this.myProject, value == null ? null : ((NamedScope)value).getScopeId());
                    return new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)this.myCombo, (TableCellEditor)this);
                }
            };
        }

        public abstract void setValue(DependencyRule var1, NamedScope var2);
    }
}

