/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PatternDialectProvider {
    public static final ExtensionPointName<PatternDialectProvider> EP_NAME = ExtensionPointName.create("com.intellij.patternDialectProvider");

    public static PatternDialectProvider getInstance(String shortName) {
        for (PatternDialectProvider provider2 : EP_NAME.getExtensionList()) {
            if (!Comparing.strEqual(provider2.getShortName(), shortName)) continue;
            return provider2;
        }
        return "file".equals(shortName) ? null : PatternDialectProvider.getInstance("file");
    }

    public abstract TreeModel createTreeModel(Project var1, Marker var2);

    public abstract TreeModel createTreeModel(Project var1, Set<? extends PsiFile> var2, Marker var3, DependenciesPanel.DependencyPanelSettings var4);

    @Contract(pure=true)
    @NlsActions.ActionText
    public abstract String getDisplayName();

    @Contract(pure=true)
    @NonNls
    @NotNull
    public abstract String getShortName();

    public abstract AnAction[] createActions(Project var1, Runnable var2);

    @Nullable
    public abstract PackageSet createPackageSet(PackageDependenciesNode var1, boolean var2);

    @Nullable
    protected static String getModulePattern(PackageDependenciesNode node2) {
        ModuleNode moduleParent = PatternDialectProvider.getModuleParent(node2);
        return moduleParent != null ? moduleParent.getModuleName() : null;
    }

    @Nullable
    protected static ModuleNode getModuleParent(PackageDependenciesNode node2) {
        if (node2 instanceof ModuleNode) {
            return (ModuleNode)node2;
        }
        if (node2 == null || node2 instanceof RootNode) {
            return null;
        }
        return PatternDialectProvider.getModuleParent((PackageDependenciesNode)node2.getParent());
    }

    public abstract Icon getIcon();

    @Nls
    @NotNull
    public String getHintMessage() {
        return "";
    }

    @NotNull
    protected static String getGroupModulePattern(ModuleGroupNode node2) {
        if (ModuleGrouperKt.isQualifiedModuleNamesEnabled(node2.getProject())) {
            String string2 = node2.getModuleGroup().getQualifiedName() + "*";
            if (string2 == null) {
                PatternDialectProvider.$$$reportNull$$$0(0);
            }
            return string2;
        }
        String string3 = "group:" + node2.getModuleGroup().toString();
        if (string3 == null) {
            PatternDialectProvider.$$$reportNull$$$0(1);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/PatternDialectProvider", "getGroupModulePattern"));
    }
}

