/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.GeneralGroupNode;
import com.intellij.packageDependencies.ui.LibraryNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPatternProvider
extends PatternDialectProvider {
    @NonNls
    public static final String FILE = "file";
    private static final Logger LOG = Logger.getInstance(ProjectPatternProvider.class);

    @Override
    public TreeModel createTreeModel(Project project2, Marker marker) {
        return FileTreeModelBuilder.createTreeModel(project2, false, marker);
    }

    @Override
    public TreeModel createTreeModel(Project project2, Set<? extends PsiFile> deps, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return FileTreeModelBuilder.createTreeModel(project2, false, deps, marker, settings);
    }

    @Override
    public String getDisplayName() {
        return IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getShortName() {
        return FILE;
    }

    @Override
    public AnAction[] createActions(Project project2, Runnable update2) {
        if (ProjectViewDirectoryHelper.getInstance(project2).supportsHideEmptyMiddlePackages()) {
            return new AnAction[]{new CompactEmptyMiddlePackagesAction(update2)};
        }
        return AnAction.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PackageSet createPackageSet(PackageDependenciesNode node2, boolean recursively) {
        if (node2 instanceof ModuleGroupNode) {
            if (!recursively) {
                return null;
            }
            return new FilePatternPackageSet(ProjectPatternProvider.getGroupModulePattern((ModuleGroupNode)node2), "*//*");
        }
        if (node2 instanceof ModuleNode) {
            if (!recursively) {
                return null;
            }
            String modulePattern = ((ModuleNode)node2).getModuleName();
            return new FilePatternPackageSet(modulePattern, "*/");
        }
        if (node2 instanceof DirectoryNode) {
            Object pattern = ((DirectoryNode)node2).getFQName();
            if (pattern != null) {
                pattern = ((String)pattern).length() > 0 ? (String)pattern + (recursively ? "//*" : "/*") : (String)pattern + (recursively ? "*/" : "*");
            }
            VirtualFile vDir = ((DirectoryNode)node2).getDirectory();
            PsiElement psiElement = node2.getPsiElement();
            boolean projectFiles = true;
            String modulePattern = null;
            if (psiElement != null) {
                Project project2 = psiElement.getProject();
                Module module2 = ModuleUtilCore.findModuleForFile(vDir, project2);
                if (module2 == null) {
                    projectFiles = false;
                    modulePattern = ProjectFileIndex.getInstance(project2).getOrderEntriesForFile(vDir).stream().filter(entry -> entry instanceof LibraryOrSdkOrderEntry).findFirst().map(entry -> entry instanceof JdkOrderEntry ? ((JdkOrderEntry)entry).getJdkName() : entry.getPresentableName()).orElse(null);
                } else {
                    modulePattern = module2.getName();
                }
            }
            return new FilePatternPackageSet(modulePattern, (String)pattern, projectFiles);
        }
        if (node2 instanceof LibraryNode) {
            return new FilePatternPackageSet(node2.toString(), recursively ? "*/" : "*", false);
        }
        if (node2 instanceof FileNode) {
            FileNode fNode = (FileNode)node2;
            if (recursively) {
                return null;
            }
            PsiFile file2 = (PsiFile)fNode.getPsiElement();
            if (file2 == null) {
                return null;
            }
            VirtualFile virtualFile2 = file2.getVirtualFile();
            LOG.assertTrue(virtualFile2 != null);
            VirtualFile contentRoot = ProjectRootManager.getInstance(file2.getProject()).getFileIndex().getContentRootForFile(virtualFile2);
            if (contentRoot == null) {
                return null;
            }
            String fqName = VfsUtilCore.getRelativePath(virtualFile2, contentRoot, '/');
            if (fqName != null) {
                return new FilePatternPackageSet(ProjectPatternProvider.getModulePattern(node2), fqName);
            }
        } else if (node2 instanceof GeneralGroupNode) {
            return new FilePatternPackageSet("", recursively ? "*/" : "*", false);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.General.ProjectTab;
    }

    @Override
    @Nls
    @NotNull
    public String getHintMessage() {
        String string2 = LangBundle.message("package.pattern.provider.hint.label", new Object[0]);
        if (string2 == null) {
            ProjectPatternProvider.$$$reportNull$$$0(0);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/ProjectPatternProvider", "getHintMessage"));
    }

    private static final class CompactEmptyMiddlePackagesAction
    extends ToggleAction {
        private final Runnable myUpdate;

        CompactEmptyMiddlePackagesAction(Runnable update2) {
            super(IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]), IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]), AllIcons.ObjectBrowser.CompactEmptyPackages);
            this.myUpdate = update2;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                CompactEmptyMiddlePackagesAction.$$$reportNull$$$0(0);
            }
            return DependencyUISettings.getInstance().UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CompactEmptyMiddlePackagesAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag2) {
            if (event == null) {
                CompactEmptyMiddlePackagesAction.$$$reportNull$$$0(2);
            }
            DependencyUISettings.getInstance().UI_COMPACT_EMPTY_MIDDLE_PACKAGES = flag2;
            this.myUpdate.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/packageDependencies/ui/ProjectPatternProvider$CompactEmptyMiddlePackagesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/packageDependencies/ui/ProjectPatternProvider$CompactEmptyMiddlePackagesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

