/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;

public class RefactoringScopeElementListenerProvider
implements RefactoringElementListenerProvider {
    private static final Logger LOG = Logger.getInstance(RefactoringScopeElementListenerProvider.class);

    @Override
    public RefactoringElementListener getListener(PsiElement element) {
        if (!(element instanceof PsiQualifiedNamedElement) && !(element instanceof PsiDirectory)) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        RefactoringElementListenerComposite composite2 = new RefactoringElementListenerComposite();
        RefactoringScopeElementListenerProvider.registerListeners(element, composite2, containingFile, ReferenceKind.FILE_PATH);
        RefactoringScopeElementListenerProvider.registerListeners(element, composite2, containingFile, ReferenceKind.QUALIFIED_NAME);
        return composite2;
    }

    private static void registerListeners(PsiElement element, RefactoringElementListenerComposite result2, PsiFile containingFile, @NotNull ReferenceKind referenceKind) {
        if (referenceKind == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(0);
        }
        String oldName = RefactoringScopeElementListenerProvider.getQualifiedName(element, referenceKind);
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(element.getProject())) {
            NamedScope[] scopes = holder.getEditableScopes();
            for (int i2 = 0; i2 < scopes.length; ++i2) {
                NamedScope scope = scopes[i2];
                PackageSet packageSet = scope.getValue();
                if (packageSet == null || containingFile != null && !packageSet.contains(containingFile, holder)) continue;
                RefactoringScopeElementListenerProvider.registerListeners(packageSet, result2, new OldScopeDescriptor(scope, i2, holder), oldName, referenceKind);
            }
        }
    }

    private static String getQualifiedName(@NotNull PsiElement element, @NotNull ReferenceKind referenceKind) {
        if (element == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(1);
        }
        if (referenceKind == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(2);
        }
        if (referenceKind == ReferenceKind.QUALIFIED_NAME) {
            return element instanceof PsiQualifiedNamedElement ? ((PsiQualifiedNamedElement)element).getQualifiedName() : null;
        }
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(element);
        if (virtualFile2 == null) {
            return null;
        }
        Project project2 = element.getProject();
        return FilePatternPackageSet.getRelativePath(virtualFile2, ProjectRootManager.getInstance(project2).getFileIndex(), true, project2.getBaseDir());
    }

    private static PackageSet updateNameInPattern(@NotNull PackageSet packageSet, String oldName, @NotNull String newName2) {
        if (packageSet == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(3);
        }
        if (newName2 == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(4);
        }
        if (packageSet instanceof PatternBasedPackageSet && ((PatternBasedPackageSet)packageSet).isOn(oldName)) {
            return ((PatternBasedPackageSet)packageSet).updatePattern(oldName, newName2);
        }
        return packageSet;
    }

    private static void registerListeners(@NotNull PackageSet packageSet, @NotNull RefactoringElementListenerComposite result2, final @NotNull OldScopeDescriptor descriptor2, final String oldQualifiedName, final @NotNull ReferenceKind referenceKind) {
        NamedScope oldScope;
        PackageSet oldSet;
        if (packageSet == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(7);
        }
        if (referenceKind == null) {
            RefactoringScopeElementListenerProvider.$$$reportNull$$$0(8);
        }
        if ((oldSet = (oldScope = descriptor2.getOldScope()).getValue()) != null && packageSet.anyMatches(set2 -> set2 instanceof PatternBasedPackageSet && ((PatternBasedPackageSet)set2).isOn(oldQualifiedName))) {
            result2.addListener((RefactoringElementListener)new RefactoringElementAdapter(){

                @Override
                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    PackageSet newSet;
                    if (newElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LOG.assertTrue(newElement instanceof PsiQualifiedNamedElement || newElement instanceof PsiDirectory);
                    String newName2 = RefactoringScopeElementListenerProvider.getQualifiedName(newElement, referenceKind);
                    if (newName2 != null && (newSet = oldSet.map(set2 -> RefactoringScopeElementListenerProvider.updateNameInPattern(set2, oldQualifiedName, newName2))) != oldSet) {
                        String presentableName = oldScope.getPresentableName();
                        descriptor2.replaceScope(new NamedScope(oldScope.getScopeId(), () -> presentableName, oldScope.getIcon(), newSet));
                    }
                }

                @Override
                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName2) {
                    if (newElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    LOG.assertTrue(newElement instanceof PsiQualifiedNamedElement || newElement instanceof PsiDirectory);
                    descriptor2.replaceScope(oldScope);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/packageDependencies/ui/RefactoringScopeElementListenerProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packageDependencies/ui/RefactoringScopeElementListenerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerListeners";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNameInPattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum ReferenceKind {
        QUALIFIED_NAME,
        FILE_PATH;

    }

    private static final class OldScopeDescriptor {
        private final NamedScopesHolder myHolder;
        private final int myIndex;
        private final NamedScope myOldScope;

        private OldScopeDescriptor(NamedScope oldScope, int index2, NamedScopesHolder holder) {
            this.myHolder = holder;
            this.myIndex = index2;
            this.myOldScope = oldScope;
        }

        public NamedScope getOldScope() {
            return this.myOldScope;
        }

        public void replaceScope(NamedScope newScope) {
            NamedScope[] currentScopes = this.myHolder.getEditableScopes();
            if (this.myIndex < currentScopes.length) {
                currentScopes[this.myIndex] = newScope;
                this.myHolder.setScopes(currentScopes);
            }
        }
    }
}

