/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UsagesPanel
extends JPanel
implements Disposable,
DataProvider {
    protected static final Logger LOG = Logger.getInstance(UsagesPanel.class);
    private final Project myProject;
    ProgressIndicator myCurrentProgress;
    private JComponent myCurrentComponent;
    private UsageView myCurrentUsageView;
    protected final Alarm myAlarm;

    public UsagesPanel(@NotNull Project project2) {
        if (project2 == null) {
            UsagesPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myAlarm = new Alarm();
        this.myProject = project2;
    }

    public void setToInitialPosition() {
        this.cancelCurrentFindRequest();
        this.setToComponent(UsagesPanel.createLabel(this.getInitialPositionText()));
    }

    @Nls
    public abstract String getInitialPositionText();

    @Nls
    public abstract String getCodeUsagesString();

    void cancelCurrentFindRequest() {
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
        }
    }

    protected void showUsages(PsiElement @NotNull [] primaryElements, UsageInfo @NotNull [] usageInfos2) {
        if (primaryElements == null) {
            UsagesPanel.$$$reportNull$$$0(1);
        }
        if (usageInfos2 == null) {
            UsagesPanel.$$$reportNull$$$0(2);
        }
        if (this.myCurrentUsageView != null) {
            Disposer.dispose((Disposable)this.myCurrentUsageView);
        }
        try {
            Usage[] usages = UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo[])usageInfos2);
            UsageViewPresentation presentation2 = new UsageViewPresentation();
            presentation2.setCodeUsagesString(this.getCodeUsagesString());
            this.myCurrentUsageView = UsageViewManager.getInstance((Project)this.myProject).createUsageView(UsageTarget.EMPTY_ARRAY, usages, presentation2, null);
            ((UsageViewImpl)this.myCurrentUsageView).expandRoot();
            this.setToComponent(this.myCurrentUsageView.getComponent());
        }
        catch (ProcessCanceledException e) {
            this.setToCanceled();
        }
    }

    private void setToCanceled() {
        this.setToComponent(UsagesPanel.createLabel(CodeInsightBundle.message("usage.view.canceled", new Object[0])));
    }

    final void setToComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            UsagesPanel.$$$reportNull$$$0(3);
        }
        ((AppUIExecutor)AppUIExecutor.onWriteThread(ModalityState.any()).expireWith(this.myProject)).execute(() -> {
            if (this.myCurrentComponent != null) {
                if (this.myCurrentUsageView != null && this.myCurrentComponent == this.myCurrentUsageView.getComponent()) {
                    Disposer.dispose((Disposable)this.myCurrentUsageView);
                    this.myCurrentUsageView = null;
                }
                this.remove(this.myCurrentComponent);
            }
            this.myCurrentComponent = component2;
            this.add((Component)component2, "Center");
            this.revalidate();
        });
    }

    @Override
    public void dispose() {
        if (this.myCurrentUsageView != null) {
            Disposer.dispose((Disposable)this.myCurrentUsageView);
            this.myCurrentUsageView = null;
        }
    }

    private static JComponent createLabel(@Nls String text2) {
        JLabel label2 = new JLabel(text2);
        label2.setHorizontalAlignment(0);
        return label2;
    }

    @Nullable
    @NonNls
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            UsagesPanel.$$$reportNull$$$0(4);
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return "ideaInterface.find";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packageDependencies/ui/UsagesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setToComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

