/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.patterns.compiler.PatternClassBean;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.patterns.compiler.PatternCompilerFactory;
import com.intellij.patterns.compiler.PatternCompilerImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class PatternCompilerFactoryImpl
extends PatternCompilerFactory {
    private static final ExtensionPointName<PatternClassBean> PATTERN_CLASS_EP = new ExtensionPointName("com.intellij.patterns.patternClass");
    private final Map<List<Class<?>>, PatternCompiler<?>> compilers = new ConcurrentHashMap();
    private final Map<String, Class[]> myClasses = ConcurrentFactoryMap.createMap(key -> {
        ArrayList result2 = new ArrayList(1);
        List<String> typeList = key == null ? null : Arrays.asList(key.split(",|\\s"));
        PATTERN_CLASS_EP.processWithPluginDescriptor((bean, descriptor2) -> {
            if (typeList == null || typeList.contains(bean.getAlias())) {
                try {
                    result2.add(ApplicationManager.getApplication().loadClass(bean.className, (PluginDescriptor)descriptor2));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Logger.getInstance(PatternCompilerFactoryImpl.class).error(e);
                }
            }
        });
        return result2.isEmpty() ? ArrayUtilRt.EMPTY_CLASS_ARRAY : result2.toArray(ArrayUtilRt.EMPTY_CLASS_ARRAY);
    });

    PatternCompilerFactoryImpl() {
        PATTERN_CLASS_EP.addChangeListener(this::dropCache, null);
    }

    @Override
    public Class<?> @NotNull [] getPatternClasses(String alias) {
        Class[] classArray = this.myClasses.get(alias);
        if (classArray == null) {
            PatternCompilerFactoryImpl.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    @Override
    @NotNull
    public <T> PatternCompiler<T> getPatternCompiler(Class @NotNull [] patternClasses) {
        if (patternClasses == null) {
            PatternCompilerFactoryImpl.$$$reportNull$$$0(1);
        }
        PatternCompiler patternCompiler = this.compilers.computeIfAbsent(Arrays.asList(patternClasses), PatternCompilerImpl::new);
        if (patternCompiler == null) {
            PatternCompilerFactoryImpl.$$$reportNull$$$0(2);
        }
        return patternCompiler;
    }

    @Override
    public void dropCache() {
        this.myClasses.clear();
        this.compilers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/compiler/PatternCompilerFactoryImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/compiler/PatternCompilerFactoryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternCompiler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPatternCompiler";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

