/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.SaveProjectAsTemplateDialog;
import com.intellij.project.ProjectKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.EdtInvocationManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveProjectAsTemplateAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(SaveProjectAsTemplateAction.class);
    @NonNls
    private static final String PROJECT_TEMPLATE_XML = "project-template.xml";
    @NonNls
    static final String FILE_HEADER_TEMPLATE_PLACEHOLDER = "<IntelliJ_File_Header>";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveProjectAsTemplateAction.$$$reportNull$$$0(0);
        }
        final Project project2 = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        assert (project2 != null);
        if (!ProjectKt.isDirectoryBased(project2)) {
            Messages.showErrorDialog((Project)project2, (String)LangBundle.message("dialog.message.project.templates.do.support.old.ipr.file", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project2, ".idea/description.html");
        final SaveProjectAsTemplateDialog dialog = new SaveProjectAsTemplateDialog(project2, descriptionFile);
        if (dialog.showAndGet()) {
            final Module moduleToSave = dialog.getModuleToSave();
            final Path file2 = dialog.getTemplateFile();
            final String description = dialog.getDescription();
            FileDocumentManager.getInstance().saveAllDocuments();
            ProgressManager.getInstance().run(new Task.Backgroundable(project2, LangBundle.message("progress.title.saving.project.as.template", new Object[0]), true){

                @Override
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SaveProjectAsTemplateAction.saveProject(project2, file2, moduleToSave, description, dialog.isReplaceParameters(), indicator, SaveProjectAsTemplateAction.shouldEscape());
                }

                @Override
                public void onSuccess() {
                    AnAction newProjectAction = ActionManager.getInstance().getAction(SaveProjectAsTemplateAction.getNewProjectActionId());
                    newProjectAction.getTemplatePresentation().setText(ActionsBundle.actionText((String)"NewDirectoryProject"));
                    AnAction manageAction = ActionManager.getInstance().getAction("ManageProjectTemplates");
                    Notification notification = new Notification("Project Template", LangBundle.message("notification.title.template.created", new Object[0]), LangBundle.message("notification.content.was.successfully.created", FileUtilRt.getNameWithoutExtension(file2.getFileName().toString())), NotificationType.INFORMATION);
                    notification.addAction(newProjectAction);
                    if (manageAction != null) {
                        notification.addAction(manageAction);
                    }
                    notification.notify(this.getProject());
                }

                @Override
                public void onCancel() {
                    PathKt.delete(file2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/platform/templates/SaveProjectAsTemplateAction$1", "run"));
                }
            });
        }
    }

    public static VirtualFile getDescriptionFile(Project project2, String path2) {
        VirtualFile baseDir = project2.getBaseDir();
        return baseDir != null ? baseDir.findFileByRelativePath(path2) : null;
    }

    public static void saveProject(Project project2, @NotNull Path zipFile, Module moduleToSave, String description, boolean replaceParameters, ProgressIndicator indicator, boolean shouldEscape) {
        if (zipFile == null) {
            SaveProjectAsTemplateAction.$$$reportNull$$$0(1);
        }
        Map<String, String> parameters2 = SaveProjectAsTemplateAction.computeParameters(project2, replaceParameters);
        indicator.setText(LangBundle.message("progress.text.saving.project", new Object[0]));
        StoreUtil.saveSettings((ComponentManager)project2, (boolean)true);
        indicator.setText(LangBundle.message("progress.text.processing.project.files", new Object[0]));
        VirtualFile dir = SaveProjectAsTemplateAction.getDirectoryToSave(project2, moduleToSave);
        List<LocalArchivedTemplate.RootDescription> roots2 = SaveProjectAsTemplateAction.collectStructure(project2, moduleToSave);
        LocalArchivedTemplate.RootDescription basePathRoot = SaveProjectAsTemplateAction.findOrAddBaseRoot(roots2, dir);
        try {
            NioFiles.createDirectories(zipFile.getParent());
            try (Compressor.Zip stream = new Compressor.Zip(zipFile);){
                SaveProjectAsTemplateAction.writeFile(".idea/description.html", description, project2, basePathRoot.myRelativePath, stream, true);
                if (replaceParameters) {
                    String text2 = SaveProjectAsTemplateAction.getInputFieldsText(parameters2);
                    SaveProjectAsTemplateAction.writeFile(".idea/project-template.xml", text2, project2, basePathRoot.myRelativePath, stream, false);
                }
                String metaDescription = SaveProjectAsTemplateAction.getTemplateMetaText(shouldEscape, roots2);
                SaveProjectAsTemplateAction.writeFile(".idea/template-meta.xml", metaDescription, project2, basePathRoot.myRelativePath, stream, true);
                FileIndex index2 = moduleToSave == null ? ProjectRootManager.getInstance(project2).getFileIndex() : ModuleRootManager.getInstance(moduleToSave).getFileIndex();
                MyContentIterator iterator2 = new MyContentIterator(indicator, stream, project2, parameters2, shouldEscape);
                for (LocalArchivedTemplate.RootDescription root : roots2) {
                    String prefix = "root" + root.myIndex;
                    VirtualFile rootFile = root.myFile;
                    iterator2.setRootAndPrefix(rootFile, prefix);
                    index2.iterateContentUnderDirectory(rootFile, iterator2);
                }
            }
        }
        catch (ProcessCanceledException stream) {
        }
        catch (Exception e) {
            LOG.error(e);
            EdtInvocationManager.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project2, (String)LangBundle.message("dialog.message.can.t.save.project.as.template", new Object[0]), (String)LangBundle.message("dialog.message.internal.error", new Object[0])));
        }
    }

    private static LocalArchivedTemplate.RootDescription findOrAddBaseRoot(List<LocalArchivedTemplate.RootDescription> roots2, VirtualFile dirToSave) {
        for (LocalArchivedTemplate.RootDescription root : roots2) {
            if (!root.myRelativePath.isEmpty()) continue;
            return root;
        }
        LocalArchivedTemplate.RootDescription root = new LocalArchivedTemplate.RootDescription(dirToSave, "", roots2.size());
        roots2.add(root);
        return root;
    }

    static String getFileHeaderTemplateName() {
        if (PlatformUtils.isIntelliJ()) {
            return FileTemplateBase.getQualifiedName("File Header", "java");
        }
        if (PlatformUtils.isPhpStorm()) {
            return FileTemplateBase.getQualifiedName("PHP File Header", "php");
        }
        if (PlatformUtils.isWebStorm()) {
            return FileTemplateBase.getQualifiedName("JavaScript File", "js");
        }
        if (PlatformUtils.isGoIde()) {
            return FileTemplateBase.getQualifiedName("Go File", "go");
        }
        throw new IllegalStateException("Provide file header template for your IDE: " + PlatformUtils.getPlatformPrefix());
    }

    static String getNewProjectActionId() {
        if (PlatformUtils.isIntelliJ() || PlatformUtils.isWebStorm()) {
            return "NewProject";
        }
        if (PlatformUtils.isPhpStorm()) {
            return "NewDirectoryProject";
        }
        if (PlatformUtils.isGoIde()) {
            return "GoIdeNewProjectAction";
        }
        throw new IllegalStateException("Provide new project action id for your IDE");
    }

    private static void writeFile(String path2, String text2, Project project2, String prefix, Compressor zip2, boolean overwrite) throws IOException {
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project2, path2);
        if (descriptionFile == null) {
            zip2.addFile(prefix + "/" + path2, text2.getBytes(StandardCharsets.UTF_8));
        } else if (overwrite) {
            Ref exceptionRef = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    WriteAction.run(() -> VfsUtil.saveText(descriptionFile, text2));
                }
                catch (IOException e) {
                    exceptionRef.set(e);
                }
            });
            IOException e = (IOException)exceptionRef.get();
            if (e != null) {
                throw e;
            }
        }
    }

    public static Map<String, String> computeParameters(Project project2, boolean replaceParameters) {
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        if (replaceParameters) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (ProjectTemplateParameterFactory extension2 : ProjectTemplateParameterFactory.EP_NAME.getExtensionList()) {
                    String value = extension2.detectParameterValue(project2);
                    if (value == null) continue;
                    parameters2.put(value, extension2.getParameterId());
                }
            });
        }
        return parameters2;
    }

    public static String getEncodedContent(VirtualFile virtualFile2, Project project2, Map<String, String> parameters2) throws IOException {
        return SaveProjectAsTemplateAction.getEncodedContent(virtualFile2, project2, parameters2, FileTemplateBase.getQualifiedName("File Header", "java"), true);
    }

    private static String getEncodedContent(VirtualFile virtualFile2, Project project2, Map<String, String> parameters2, String fileHeaderTemplateName, boolean shouldEscape) throws IOException {
        String text2 = VfsUtilCore.loadText(virtualFile2);
        FileTemplate template = FileTemplateManager.getInstance((Project)project2).getDefaultTemplate(fileHeaderTemplateName);
        String templateText = template.getText();
        Pattern pattern = FileTemplateUtil.getTemplatePattern(template, project2, new Int2ObjectOpenHashMap<String>());
        String result2 = SaveProjectAsTemplateAction.convertTemplates(text2, pattern, templateText, shouldEscape);
        result2 = ProjectTemplateFileProcessor.encodeFile(result2, virtualFile2, project2);
        for (Map.Entry<String, String> entry : parameters2.entrySet()) {
            result2 = result2.replace(entry.getKey(), "${" + entry.getValue() + "}");
        }
        return result2;
    }

    private static VirtualFile getDirectoryToSave(Project project2, @Nullable Module module2) {
        if (module2 == null) {
            return project2.getBaseDir();
        }
        VirtualFile moduleFile = module2.getModuleFile();
        assert (moduleFile != null);
        return moduleFile.getParent();
    }

    @NotNull
    private static List<LocalArchivedTemplate.RootDescription> collectStructure(Project project2, Module moduleToSave) {
        ArrayList<LocalArchivedTemplate.RootDescription> result2 = new ArrayList<LocalArchivedTemplate.RootDescription>();
        if (moduleToSave != null) {
            PathMacroManager macroManager = PathMacroManager.getInstance(moduleToSave);
            ModuleRootManager rootManager = ModuleRootManager.getInstance(moduleToSave);
            int i2 = 0;
            for (VirtualFile file2 : rootManager.getContentRoots()) {
                result2.add(i2, SaveProjectAsTemplateAction.describeRoot(file2, i2, macroManager));
                ++i2;
            }
        } else {
            PathMacroManager macroManager = PathMacroManager.getInstance(project2);
            ProjectRootManager rootManager = ProjectRootManager.getInstance(project2);
            int i3 = 0;
            for (VirtualFile file3 : rootManager.getContentRoots()) {
                result2.add(i3, SaveProjectAsTemplateAction.describeRoot(file3, i3, macroManager));
                ++i3;
            }
        }
        ArrayList<LocalArchivedTemplate.RootDescription> arrayList = result2;
        if (arrayList == null) {
            SaveProjectAsTemplateAction.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static LocalArchivedTemplate.RootDescription describeRoot(VirtualFile root, int rootIndex, PathMacroManager pathMacroManager) {
        return new LocalArchivedTemplate.RootDescription(root, SaveProjectAsTemplateAction.getRelativePath(pathMacroManager, root), rootIndex);
    }

    private static String getRelativePath(PathMacroManager pathMacroManager, VirtualFile moduleRoot) {
        String path2 = pathMacroManager.collapsePath(moduleRoot.getPath());
        path2 = StringUtil.trimStart(path2, "$PROJECT_DIR$");
        path2 = StringUtil.trimStart(path2, "$MODULE_DIR$");
        path2 = StringUtil.trimStart(path2, "/");
        return path2;
    }

    public static String convertTemplates(String input, Pattern pattern, String template, boolean shouldEscape) {
        int start;
        Matcher matcher = pattern.matcher(input);
        int n = start = matcher.matches() ? matcher.start(1) : -1;
        if (!shouldEscape) {
            if (start == -1) {
                return input;
            }
            return input.substring(0, start) + FILE_HEADER_TEMPLATE_PLACEHOLDER + input.substring(matcher.end(1));
        }
        StringBuilder builder2 = new StringBuilder(input.length() + 10);
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2;
            if (start == i2) {
                builder2.append(template);
                i2 = matcher.end(1);
            }
            if ((c2 = input.charAt(i2)) == '$') {
                builder2.append("#[[\\$]]#");
                continue;
            }
            if (c2 == '#') {
                builder2.append('\\');
            }
            builder2.append(c2);
        }
        return builder2.toString();
    }

    private static String getInputFieldsText(Map<String, String> parameters2) {
        Element element = new Element("template");
        for (Map.Entry<String, String> entry : parameters2.entrySet()) {
            Element field = new Element("input-field");
            field.setText(entry.getValue());
            field.setAttribute("default", entry.getKey());
            element.addContent(field);
        }
        return JDOMUtil.writeElement(element);
    }

    private static String getTemplateMetaText(boolean shouldEncode, List<? extends LocalArchivedTemplate.RootDescription> roots2) {
        Element element = new Element("template");
        element.setAttribute("unencoded", String.valueOf(!shouldEncode));
        LocalArchivedTemplate.RootDescription.writeRoots(element, roots2);
        return JDOMUtil.writeElement(element);
    }

    private static boolean shouldEscape() {
        return !PlatformUtils.isPhpStorm();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveProjectAsTemplateAction.$$$reportNull$$$0(3);
        }
        Project project2 = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabled(project2 != null && !project2.isDefault());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SaveProjectAsTemplateAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/SaveProjectAsTemplateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/SaveProjectAsTemplateAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveProject";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4 -> new IllegalStateException(string2);
        };
    }

    private static class MyContentIterator
    implements ContentIterator {
        private static final Set<String> ALLOWED_FILES = ContainerUtil.newHashSet("description.html", "project-template.xml", "template-meta.xml", "misc.xml", "modules.xml", "workspace.xml");
        private final ProgressIndicator myIndicator;
        private final Compressor myStream;
        private final Project myProject;
        private final Map<String, String> myParameters;
        private final boolean myShouldEscape;
        private VirtualFile myRootDir;
        private String myPrefix;

        MyContentIterator(ProgressIndicator indicator, Compressor stream, Project project2, Map<String, String> parameters2, boolean shouldEscape) {
            this.myIndicator = indicator;
            this.myStream = stream;
            this.myProject = project2;
            this.myParameters = parameters2;
            this.myShouldEscape = shouldEscape;
        }

        public void setRootAndPrefix(VirtualFile root, String prefix) {
            this.myRootDir = root;
            this.myPrefix = prefix;
        }

        @Override
        public boolean processFile(@NotNull VirtualFile virtualFile2) {
            if (virtualFile2 == null) {
                MyContentIterator.$$$reportNull$$$0(0);
            }
            this.myIndicator.checkCanceled();
            String relativePath = VfsUtilCore.getRelativePath(virtualFile2, this.myRootDir, '/');
            if (relativePath == null) {
                throw new RuntimeException("Can't find relative path for " + virtualFile2 + " in " + this.myRootDir);
            }
            String entryName = this.myPrefix + "/" + relativePath;
            if (virtualFile2.isDirectory()) {
                try {
                    this.myStream.addDirectory(entryName);
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            } else {
                String fileName = virtualFile2.getName();
                this.myIndicator.setText2(fileName);
                boolean system = ".idea".equals(virtualFile2.getParent().getName());
                if (!system || ALLOWED_FILES.contains(fileName) || fileName.endsWith(".iml")) {
                    try {
                        if (virtualFile2.getFileType().isBinary() || SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML.equals(virtualFile2.getName())) {
                            this.myStream.addFile(entryName, new File(virtualFile2.getPath()));
                        } else {
                            String result2 = SaveProjectAsTemplateAction.getEncodedContent(virtualFile2, this.myProject, this.myParameters, SaveProjectAsTemplateAction.getFileHeaderTemplateName(), this.myShouldEscape);
                            this.myStream.addFile(entryName, result2.getBytes(StandardCharsets.UTF_8));
                        }
                    }
                    catch (IOException e) {
                        LOG.error(e);
                    }
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/platform/templates/SaveProjectAsTemplateAction$MyContentIterator", "processFile"));
        }
    }
}

