/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SystemFileProcessor
extends ProjectTemplateFileProcessor {
    private static final String[] COMPONENT_NAMES = new String[]{FileEditorManager.class.getName(), "org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent"};
    private static final Logger LOG = Logger.getInstance(SystemFileProcessor.class);

    SystemFileProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected String encodeFileText(String content2, VirtualFile file2, @NotNull Project project2) throws IOException {
        void var8_10;
        if (project2 == null) {
            SystemFileProcessor.$$$reportNull$$$0(0);
        }
        String fileName = file2.getName();
        if (!file2.getParent().getName().equals(".idea") || !fileName.equals("workspace.xml")) {
            return null;
        }
        ArrayList<FileEditorManager> componentList = new ArrayList<FileEditorManager>();
        String[] stringArray = COMPONENT_NAMES;
        int n = stringArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            FileEditorManager component2;
            String componentName = stringArray[var8_10];
            if (componentName.equals("org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent")) {
                Object component22 = ((ComponentManagerImpl)project2).getServiceByClassName(componentName);
            } else if (componentName.equals(FileEditorManager.class.getName())) {
                component2 = FileEditorManager.getInstance(project2);
            } else {
                throw new IllegalStateException("Unknown component name: " + componentName);
            }
            if (component2 == null) {
                try {
                    Class<?> aClass = Class.forName(componentName);
                    component2 = project2.getComponent(aClass);
                    if (component2 == null) {
                        component2 = project2.getService(aClass);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (component2 != null) {
                componentList.add(component2);
            }
            ++var8_10;
        }
        if (componentList.isEmpty()) {
            return null;
        }
        Element root = new Element("project");
        for (Object e : componentList) {
            Element element = new Element("component");
            element.setAttribute("name", e instanceof NamedComponent ? ((NamedComponent)e).getComponentName() : e.getClass().getName());
            root.addContent(element);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (component3 instanceof JDOMExternalizable) {
                    try {
                        ((JDOMExternalizable)component3).writeExternal(element);
                    }
                    catch (WriteExternalException ignore) {
                        LOG.error(ignore);
                    }
                } else if (component3 instanceof PersistentStateComponent) {
                    Object state = WriteAction.compute(() -> ((PersistentStateComponent)component3).getState());
                    if (state == null) {
                        return;
                    }
                    Element element1 = state instanceof Element ? (Element)state : XmlSerializer.serialize(state);
                    element.addContent(element1.cloneContent());
                    element.setAttribute("name", StoreUtilKt.getStateSpec((PersistentStateComponent)((PersistentStateComponent)component3)).name());
                }
            }, ModalityState.defaultModalityState());
        }
        return JbXmlOutputter.collapseMacrosAndWrite(root, project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/templates/SystemFileProcessor", "encodeFileText"));
    }
}

