/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeManagerIprProvider;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.BaseInspectionProfileManagerKt;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileProcessor;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectBasedInspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManagerKt;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManagerState;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="InspectionProjectProfileManager", storages={@Storage(value="inspectionProfiles/profiles_settings.xml", exclusive=true)})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\b\u0017\u0018\u0000 22\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005:\u00012B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0007J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#H\u0016J\r\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0019H\u0016J\u0006\u0010+\u001a\u00020!J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0011H\u0014J\u0012\u0010/\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u00100\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u00101\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager;", "Lcom/intellij/profile/codeInspection/BaseInspectionProfileManager;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lorg/jdom/Element;", "Lcom/intellij/profile/codeInspection/ProjectBasedInspectionProfileManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectProfile", "", "getProjectProfile", "()Ljava/lang/String;", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "schemeManagerIprProvider", "Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "state", "Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManagerState;", "dispose", "", "fireProfileChanged", "profile", "forceLoadSchemes", "getCurrentProfile", "getProfile", "name", "returnRootProfileIfNamedIsAbsent", "", "getProfiles", "", "getScopesManager", "Lcom/intellij/packageDependencies/DependencyValidationManager;", "Lorg/jetbrains/annotations/NotNull;", "getState", "getStateModificationCount", "", "initializeComponent", "isCurrentProfileInitialized", "loadState", "schemeRemoved", "scheme", "setCurrentProfile", "setRootProfile", "useApplicationProfile", "Companion", "intellij.platform.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nProjectInspectionProfileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectInspectionProfileManager.kt\ncom/intellij/profile/codeInspection/ProjectInspectionProfileManager\n+ 2 startUpMeasurer.kt\ncom/intellij/diagnostic/StartUpMeasurerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n19#2,5:273\n1#3:278\n*S KotlinDebug\n*F\n+ 1 ProjectInspectionProfileManager.kt\ncom/intellij/profile/codeInspection/ProjectInspectionProfileManager\n*L\n91#1:273,5\n*E\n"})
public class ProjectInspectionProfileManager
extends BaseInspectionProfileManager
implements PersistentStateComponentWithModificationTracker<Element>,
ProjectBasedInspectionProfileManager,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private ProjectInspectionProfileManagerState state;
    @Nullable
    private final SchemeManagerIprProvider schemeManagerIprProvider;
    @NotNull
    private final SchemeManager<InspectionProfileImpl> schemeManager;

    public ProjectInspectionProfileManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MessageBus messageBus = project2.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"project.messageBus");
        super(messageBus);
        this.project = project2;
        this.state = new ProjectInspectionProfileManagerState();
        this.schemeManagerIprProvider = ProjectKt.isDirectoryBased(this.getProject()) ? null : new SchemeManagerIprProvider("profile", null, 2, null);
        this.schemeManager = SchemeManagerFactory.create$default(SchemeManagerFactory.Companion.getInstance(this.getProject()), "inspectionProfiles", new InspectionProfileProcessor(this){
            final /* synthetic */ ProjectInspectionProfileManager this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public InspectionProfileImpl createScheme(@NotNull SchemeDataHolder<? super InspectionProfileImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
                InspectionProfileImpl profile = new InspectionProfileImpl(name, InspectionToolRegistrar.Companion.getInstance(), this.this$0, dataHolder);
                profile.setProjectLevel(true);
                return profile;
            }

            public boolean isSchemeFile(@NotNull CharSequence name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return !StringUtil.equals(name, "profiles_settings.xml");
            }

            public boolean isSchemeDefault(@NotNull InspectionProfileImpl scheme, @NotNull byte[] digest) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
                return Intrinsics.areEqual((Object)scheme.getName(), (Object)"Project Default") && Arrays.equals(digest, ProjectInspectionProfileManagerKt.access$getDefaultSchemeDigest$p());
            }

            public void onSchemeDeleted(@NotNull InspectionProfileImpl scheme) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                this.this$0.schemeRemoved(scheme);
            }

            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                if (scheme.wasInitialized()) {
                    this.this$0.fireProfileChanged(scheme);
                }
            }

            public void onCurrentSchemeSwitched(@Nullable InspectionProfileImpl oldScheme, @Nullable InspectionProfileImpl newScheme, boolean processChangeSynchronously) {
                MessageBus messageBus = this.this$0.getProject().getMessageBus();
                Topic<ProfileChangeAdapter> topic = ProfileChangeAdapter.TOPIC;
                Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                messageBus.syncPublisher(topic).profileActivated(oldScheme, newScheme);
            }
        }, null, null, Scheme_implKt.getOLD_NAME_CONVERTER(), this.schemeManagerIprProvider, null, false, null, 460, null);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    protected SchemeManager<InspectionProfileImpl> getSchemeManager() {
        return this.schemeManager;
    }

    @Override
    public void initializeComponent() {
        Application app = ApplicationManager.getApplication();
        if (!ProjectKt.isDirectoryBased(this.getProject()) || app.isUnitTestMode()) {
            return;
        }
        String name$iv = "project inspection profile loading";
        ActivityCategory category$iv = ActivityCategory.DEFAULT;
        boolean $i$f$runActivity = false;
        Activity activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity(name$iv, category$iv) : null;
        boolean bl = false;
        this.getSchemeManager().loadSchemes();
        this.getCurrentProfile().initInspectionTools(this.getProject());
        Unit result$iv = Unit.INSTANCE;
        Activity activity = activity$iv;
        if (activity != null) {
            activity.end();
        }
        StartupManager.getInstance(this.getProject()).runAfterOpened(() -> ProjectInspectionProfileManager.initializeComponent$lambda$2(this));
    }

    @Override
    public void dispose() {
        Function0 cleanupInspectionProfilesRunnable2 = (Function0)new Function0<Unit>(this){
            final /* synthetic */ ProjectInspectionProfileManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                this.this$0.cleanupSchemes$intellij_platform_analysis_impl(this.this$0.getProject());
                boolean $i$f$serviceIfCreated = false;
                Application application = ApplicationManager.getApplication();
                BaseInspectionProfileManager baseInspectionProfileManager = (BaseInspectionProfileManager)(application != null ? application.getServiceIfCreated(InspectionProfileManager.class) : null);
                if (baseInspectionProfileManager != null) {
                    baseInspectionProfileManager.cleanupSchemes$intellij_platform_analysis_impl(this.this$0.getProject());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        };
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            cleanupInspectionProfilesRunnable2.invoke();
        } else {
            CoroutineScope coroutineScope = app.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"app.coroutineScope");
            BuildersKt.launch$default(coroutineScope, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function0<Unit>)cleanupInspectionProfilesRunnable2, null){
                int label;
                final /* synthetic */ Function0<Unit> $cleanupInspectionProfilesRunnable;
                {
                    this.$cleanupInspectionProfilesRunnable = $cleanupInspectionProfilesRunnable;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$cleanupInspectionProfilesRunnable.invoke();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    @Override
    public long getStateModificationCount() {
        SchemeManagerIprProvider schemeManagerIprProvider = this.schemeManagerIprProvider;
        return this.state.getModificationCount() + this.getSeverityRegistrar().getModificationCount() + (schemeManagerIprProvider != null ? schemeManagerIprProvider.getModificationCount() : 0L);
    }

    @TestOnly
    public final void forceLoadSchemes() {
        BaseInspectionProfileManagerKt.LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        this.getSchemeManager().loadSchemes();
    }

    public final boolean isCurrentProfileInitialized() {
        return this.getCurrentProfile().wasInitialized();
    }

    @Override
    protected void schemeRemoved(@NotNull InspectionProfileImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        scheme.cleanup(this.getProject());
    }

    @Override
    @Nullable
    public synchronized Element getState() {
        Element result2 = new Element("settings");
        SchemeManagerIprProvider schemeManagerIprProvider = this.schemeManagerIprProvider;
        if (schemeManagerIprProvider != null) {
            schemeManagerIprProvider.writeState(result2);
        }
        XmlSerializer.serializeObjectInto$default(this.state, result2, null, 4, null);
        List<Element> list2 = result2.getChildren();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"result.children");
        if (!((Collection)list2).isEmpty()) {
            result2.addContent(new Element("version").setAttribute("value", "1.0"));
        }
        this.getSeverityRegistrar().writeExternal(result2);
        return Scheme_implKt.wrapState(result2, this.getProject());
    }

    @Override
    public synchronized void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Element data2 = Scheme_implKt.unwrapState(state, this.getProject(), this.schemeManagerIprProvider, this.getSchemeManager());
        ProjectInspectionProfileManagerState newState = new ProjectInspectionProfileManagerState();
        Element element = data2;
        if (element != null) {
            Element it = element;
            boolean bl = false;
            try {
                this.getSeverityRegistrar().readExternal(it);
            }
            catch (Throwable e) {
                BaseInspectionProfileManagerKt.LOG.error(e);
            }
            XmlSerializer.deserializeInto(it, newState);
        }
        this.state = newState;
        if (data2 != null) {
            Element element2 = data2.getChild("version");
            if (!Intrinsics.areEqual((Object)(element2 != null ? element2.getAttributeValue("value") : null), (Object)"1.0")) {
                for (Element o : data2.getChildren("option")) {
                    if (!Intrinsics.areEqual((Object)o.getAttributeValue("name"), (Object)"USE_PROJECT_LEVEL_SETTINGS")) continue;
                    if (!o.getAttributeBooleanValue("value") || newState.getProjectProfile() == null) break;
                    this.getCurrentProfile().convert(data2, this.getProject());
                    break;
                }
            }
        }
    }

    @Override
    @NotNull
    public DependencyValidationManager getScopesManager() {
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dependencyValidationManager, (String)"getInstance(project)");
        return dependencyValidationManager;
    }

    @Override
    @NotNull
    public synchronized Collection<InspectionProfileImpl> getProfiles() {
        this.getCurrentProfile();
        return this.getSchemeManager().getAllSchemes();
    }

    @Nullable
    public final String getProjectProfile() {
        return this.state.getProjectProfile();
    }

    @Override
    public synchronized void setRootProfile(@Nullable String name) {
        this.state.setUseProjectProfile(name != null);
        if (name != null) {
            this.state.setProjectProfile(name);
        }
        this.getSchemeManager().setCurrentSchemeName(name, true);
    }

    public final synchronized void useApplicationProfile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.state.setUseProjectProfile(false);
        this.state.setProjectProfile(name);
    }

    @TestOnly
    public final synchronized void setCurrentProfile(@Nullable InspectionProfileImpl profile) {
        SchemeManager.setCurrent$default(this.getSchemeManager(), profile, false, false, 6, null);
        this.state.setUseProjectProfile(profile != null);
        if (profile != null) {
            this.state.setProjectProfile(profile.getName());
        }
    }

    @Override
    @NotNull
    public synchronized InspectionProfileImpl getCurrentProfile() {
        InspectionProfileImpl currentScheme;
        if (!this.state.getUseProjectProfile()) {
            InspectionProfileImpl inspectionProfileImpl;
            InspectionProfileImpl inspectionProfileImpl2;
            InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileManager, (String)"getInstance()");
            InspectionProfileManager applicationProfileManager = inspectionProfileManager;
            String string2 = this.state.getProjectProfile();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                v2 = applicationProfileManager.getProfile(it, false);
            } else {
                v2 = inspectionProfileImpl2 = null;
            }
            if (inspectionProfileImpl2 == null) {
                InspectionProfileImpl inspectionProfileImpl3 = applicationProfileManager.getCurrentProfile();
                inspectionProfileImpl = inspectionProfileImpl3;
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl3, (String)"applicationProfileManager.currentProfile");
            } else {
                inspectionProfileImpl = inspectionProfileImpl2;
            }
            return inspectionProfileImpl;
        }
        String string3 = this.state.getProjectProfile();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            v6 = this.getSchemeManager().findSchemeByName(it);
        } else {
            v6 = currentScheme = null;
        }
        if (currentScheme == null) {
            currentScheme = (InspectionProfileImpl)CollectionsKt.firstOrNull(this.getSchemeManager().getAllSchemes());
            if (currentScheme == null) {
                currentScheme = new InspectionProfileImpl("Project Default", (InspectionToolsSupplier)InspectionToolRegistrar.Companion.getInstance(), this);
                InspectionProfileImpl inspectionProfileImpl = InspectionProfileManager.getInstance().getCurrentProfile();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getInstance().currentProfile");
                currentScheme.copyFrom(inspectionProfileImpl);
                currentScheme.setProjectLevel(true);
                currentScheme.setName("Project Default");
                this.getSchemeManager().addScheme(currentScheme);
            }
            SchemeManager.setCurrent$default(this.getSchemeManager(), currentScheme, false, false, 4, null);
        }
        return currentScheme;
    }

    @Override
    @Nullable
    public synchronized InspectionProfileImpl getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InspectionProfileImpl profile = this.getSchemeManager().findSchemeByName(name);
        InspectionProfileImpl inspectionProfileImpl = profile;
        if (inspectionProfileImpl == null) {
            inspectionProfileImpl = InspectionProfileManager.getInstance().getProfile(name, returnRootProfileIfNamedIsAbsent);
        }
        return inspectionProfileImpl;
    }

    public final void fireProfileChanged() {
        this.fireProfileChanged(this.getCurrentProfile());
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        profile.profileChanged();
        MessageBus messageBus = this.getProject().getMessageBus();
        Topic<ProfileChangeAdapter> topic = ProfileChangeAdapter.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBus.syncPublisher(topic).profileChanged(profile);
    }

    private static final void initializeComponent$lambda$2$lambda$1(ProjectInspectionProfileManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (InspectionProfileImpl profile : this$0.getSchemeManager().getAllSchemes()) {
            profile.scopesChanged();
        }
    }

    private static final void initializeComponent$lambda$2(ProjectInspectionProfileManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MessageBus messageBus = this$0.getProject().getMessageBus();
        Topic<ProfileChangeAdapter> topic = ProfileChangeAdapter.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBus.syncPublisher(topic).profilesInitialized();
        NamedScopesHolder.ScopeListener projectScopeListener = () -> ProjectInspectionProfileManager.initializeComponent$lambda$2$lambda$1(this$0);
        this$0.getScopesManager().addScopeListener(projectScopeListener, this$0.getProject());
        NamedScopeManager.getInstance(this$0.getProject()).addScopeListener(projectScopeListener, this$0.getProject());
    }

    @JvmStatic
    @NotNull
    public static final ProjectInspectionProfileManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.analysis.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProjectInspectionProfileManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            InspectionProjectProfileManager inspectionProjectProfileManager = project2.getService(InspectionProjectProfileManager.class);
            Intrinsics.checkNotNull((Object)inspectionProjectProfileManager, (String)"null cannot be cast to non-null type com.intellij.profile.codeInspection.ProjectInspectionProfileManager");
            return (ProjectInspectionProfileManager)inspectionProjectProfileManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

