/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.profile.codeInspection.ui.HighlightAction;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.GroupHeaderSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

class HighlightElementRenderer
implements ListCellRenderer<PopupFactoryImpl.ActionItem> {
    private final EditorTextFieldCellRenderer.RendererComponent myTextComponent = new EditorTextFieldCellRenderer.SimpleRendererComponent(null, null, true);
    private final JPanel myTextPanel = new NonOpaquePanel();
    private final JPanel mySeparatorPanel = new NonOpaquePanel();
    private final JBLabel myLabel = new JBLabel();

    HighlightElementRenderer() {
        this.myTextComponent.getEditor().getContentComponent().setOpaque(false);
        this.myTextPanel.add((Component)this.myTextComponent);
        this.myTextPanel.setBorder(new CompoundBorder(new EmptyBorder(JBUI.CurrentTheme.ActionsList.cellPadding()), JBUI.Borders.empty(1, 0)));
        OpaquePanel opaquePanel = new OpaquePanel((LayoutManager)new BorderLayout(), JBUI.CurrentTheme.Popup.BACKGROUND);
        GroupHeaderSeparator separator = new GroupHeaderSeparator((Insets)JBUI.emptyInsets());
        opaquePanel.add((Component)separator);
        this.mySeparatorPanel.add((Component)opaquePanel, "North");
        this.myLabel.setBorder((Border)new CompoundBorder(new EmptyBorder(JBUI.CurrentTheme.ActionsList.cellPadding()), this.myLabel.getBorder()));
        this.mySeparatorPanel.add((Component)this.myLabel, "Center");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends PopupFactoryImpl.ActionItem> list2, PopupFactoryImpl.ActionItem value, int index2, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            AnAction action2 = value.getAction();
            if (action2 instanceof HighlightAction) {
                HighlightAction highlightAction = (HighlightAction)action2;
                TextAttributes attributes = highlightAction.getTextAttributes();
                this.myTextComponent.setText(action2.getTemplateText(), attributes, false);
                this.myTextComponent.setSize(this.myTextComponent.getPreferredSize());
                return this.myTextPanel;
            }
            this.myLabel.setText(action2.getTemplateText());
            return this.mySeparatorPanel;
        }
        return null;
    }
}

