/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class LevelChooserAction
extends ComboBoxAction
implements DumbAware {
    private final SeverityRegistrar mySeverityRegistrar;
    private final boolean myIncludeDoNotShow;
    private HighlightSeverity myChosen = null;

    public LevelChooserAction(SeverityRegistrar severityRegistrar) {
        this(severityRegistrar, false);
    }

    public LevelChooserAction(SeverityRegistrar severityRegistrar, boolean includeDoNotShow) {
        this.mySeverityRegistrar = severityRegistrar;
        this.myIncludeDoNotShow = includeDoNotShow;
    }

    @NotNull
    public DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext context2) {
        if (button2 == null) {
            LevelChooserAction.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            LevelChooserAction.$$$reportNull$$$0(1);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(this.mySeverityRegistrar, this.myIncludeDoNotShow)) {
            HighlightSeverityAction action2 = new HighlightSeverityAction(severity);
            if (this.myChosen == null) {
                this.setChosen(action2.getSeverity());
            }
            group2.add((AnAction)action2);
        }
        group2.addSeparator();
        group2.add((AnAction)new DumbAwareAction(InspectionsBundle.message("inspection.edit.severities.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project2;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project2 = e.getProject()) == null) {
                    project2 = ProjectManager.getInstance().getDefaultProject();
                }
                SeverityEditorDialog.show(project2, LevelChooserAction.this.myChosen, LevelChooserAction.this.mySeverityRegistrar, true, severity -> {
                    LevelChooserAction.this.setChosen((HighlightSeverity)severity);
                    LevelChooserAction.this.onChosen((HighlightSeverity)severity);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/LevelChooserAction$1", "actionPerformed"));
            }
        });
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            LevelChooserAction.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @NotNull
    public static @NotNull List<@NotNull HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar) {
        return LevelChooserAction.getSeverities(severityRegistrar, true);
    }

    @NotNull
    public static @NotNull List<@NotNull HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar, boolean includeDoNotShow) {
        ArrayList<HighlightSeverity> severities = new ArrayList<HighlightSeverity>();
        for (SeverityRegistrar.SeverityBasedTextAttributes type : SeverityUtil.getRegisteredHighlightingInfoTypes(severityRegistrar)) {
            if (!type.getType().isApplicableToInspections()) continue;
            severities.add(type.getSeverity());
        }
        if (includeDoNotShow) {
            severities.add(HighlightSeverity.INFORMATION);
        }
        ArrayList<HighlightSeverity> arrayList = severities;
        if (arrayList == null) {
            LevelChooserAction.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    protected abstract void onChosen(@NotNull HighlightSeverity var1);

    public void setChosen(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            LevelChooserAction.$$$reportNull$$$0(4);
        }
        this.myChosen = severity;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(SingleInspectionProfilePanel.renderSeverity(severity));
        templatePresentation.setIcon(HighlightDisplayLevel.find(severity).getIcon());
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            LevelChooserAction.$$$reportNull$$$0(5);
        }
        if (place == null) {
            LevelChooserAction.$$$reportNull$$$0(6);
        }
        ComboBoxAction.ComboBoxButton button2 = this.createComboBoxButton(presentation2);
        button2.setMinimumSize(new Dimension(100, button2.getPreferredSize().height));
        button2.setPreferredSize(button2.getMinimumSize());
        ComboBoxAction.ComboBoxButton comboBoxButton = button2;
        if (comboBoxButton == null) {
            LevelChooserAction.$$$reportNull$$$0(7);
        }
        return comboBoxButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/LevelChooserAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/LevelChooserAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverities";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setChosen";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 7 -> new IllegalStateException(string2);
        };
    }

    private final class HighlightSeverityAction
    extends DumbAwareAction {
        @NotNull
        private final HighlightSeverity mySeverity;

        @NotNull
        HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.mySeverity;
            if (highlightSeverity == null) {
                HighlightSeverityAction.$$$reportNull$$$0(0);
            }
            return highlightSeverity;
        }

        private HighlightSeverityAction(HighlightSeverity severity) {
            if (severity == null) {
                HighlightSeverityAction.$$$reportNull$$$0(1);
            }
            this.mySeverity = severity;
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setText(SingleInspectionProfilePanel.renderSeverity(severity));
            presentation2.setIcon(HighlightDisplayLevel.find(severity).getIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HighlightSeverityAction.$$$reportNull$$$0(2);
            }
            HighlightSeverity severity = this.getSeverity();
            LevelChooserAction.this.setChosen(severity);
            LevelChooserAction.this.onChosen(severity);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profile/codeInspection/ui/LevelChooserAction$HighlightSeverityAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profile/codeInspection/ui/LevelChooserAction$HighlightSeverityAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }
}

