/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.ScopesOrderDialog;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ScopesChooser
extends ComboBoxAction
implements DumbAware {
    private final List<? extends Descriptor> myDefaultDescriptors;
    @NotNull
    private final InspectionProfileImpl myInspectionProfile;
    private final Project myProject;
    private final Set<String> myExcludedScopeNames;

    public ScopesChooser(List<? extends Descriptor> defaultDescriptors, @NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project2, String[] excludedScopeNames) {
        if (inspectionProfile == null) {
            ScopesChooser.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ScopesChooser.$$$reportNull$$$0(1);
        }
        this.myDefaultDescriptors = defaultDescriptors;
        this.myInspectionProfile = inspectionProfile;
        this.myProject = project2;
        this.myExcludedScopeNames = excludedScopeNames == null ? Collections.emptySet() : ContainerUtil.newHashSet(excludedScopeNames);
        this.setPopupTitle(LangBundle.message("scopes.chooser.popup.title.select.scope.to.change.its.settings", new Object[0]));
        this.getTemplatePresentation().setText(InspectionsBundle.messagePointer("action.presentation.ScopesChooser.text", new Object[0]));
    }

    @NotNull
    public DefaultActionGroup createPopupActionGroup(final @NotNull JComponent component2, @NotNull DataContext context2) {
        if (component2 == null) {
            ScopesChooser.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            ScopesChooser.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        ArrayList<NamedScope> predefinedScopes = new ArrayList<NamedScope>();
        ArrayList customScopes = new ArrayList();
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(this.myProject)) {
            Collections.addAll(customScopes, holder.getEditableScopes());
            predefinedScopes.addAll(holder.getPredefinedScopes());
        }
        predefinedScopes.remove(CustomScopesProviderEx.getAllScope());
        for (NamedScope predefinedScope : predefinedScopes) {
            if (!(predefinedScope instanceof NonProjectFilesScope)) continue;
            predefinedScopes.remove(predefinedScope);
            break;
        }
        this.fillActionGroup(group2, predefinedScopes, this.myDefaultDescriptors, this.myInspectionProfile, this.myExcludedScopeNames);
        group2.addSeparator();
        this.fillActionGroup(group2, customScopes, this.myDefaultDescriptors, this.myInspectionProfile, this.myExcludedScopeNames);
        group2.addSeparator();
        group2.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.edit.scopes.order", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ScopesOrderDialog dlg;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((dlg = new ScopesOrderDialog(component2, ScopesChooser.this.myInspectionProfile, ScopesChooser.this.myProject)).showAndGet()) {
                    ScopesChooser.this.onScopesOrderChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/ScopesChooser$1", "actionPerformed"));
            }
        });
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            ScopesChooser.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    protected abstract void onScopesOrderChanged();

    protected abstract void onScopeAdded(@NotNull String var1);

    private void fillActionGroup(DefaultActionGroup group2, List<? extends NamedScope> scopes, final List<? extends Descriptor> defaultDescriptors, final InspectionProfileImpl inspectionProfile, Set<String> excludedScopeNames) {
        for (final NamedScope namedScope : scopes) {
            final String scopeName = namedScope.getScopeId();
            if (excludedScopeNames.contains(scopeName)) continue;
            group2.add((AnAction)new DumbAwareAction(namedScope.getPresentableName()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    for (Descriptor defaultDescriptor : defaultDescriptors) {
                        InspectionToolWrapper<?, ?> wrapper2 = defaultDescriptor.getToolWrapper().createCopy();
                        ((InspectionProfileEntry)wrapper2.getTool()).readSettings(Descriptor.createConfigElement(defaultDescriptor.getToolWrapper()));
                        inspectionProfile.addScope(wrapper2, namedScope, defaultDescriptor.getLevel(), true, e.getProject());
                    }
                    ScopesChooser.this.onScopeAdded(scopeName);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/ScopesChooser$2", "actionPerformed"));
                }
            });
        }
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            ScopesChooser.$$$reportNull$$$0(5);
        }
        if (place == null) {
            ScopesChooser.$$$reportNull$$$0(6);
        }
        ComboBoxAction.ComboBoxButton comboBoxButton = this.createComboBoxButton(presentation2);
        if (comboBoxButton == null) {
            ScopesChooser.$$$reportNull$$$0(7);
        }
        return comboBoxButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/ScopesChooser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/ScopesChooser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 7 -> new IllegalStateException(string2);
        };
    }
}

