/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesPanel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionProfileSchemesModel
implements SchemesModel<InspectionProfileModifiableModel> {
    private static final Logger LOG = Logger.getInstance(InspectionProfileSchemesModel.class);
    private final List<SingleInspectionProfilePanel> myProfilePanels;
    private final List<InspectionProfileImpl> myDeletedProfiles;
    private final InspectionProfileManager myApplicationProfileManager;
    private final InspectionProfileManager myProjectProfileManager;

    InspectionProfileSchemesModel(@NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProfileManager projectProfileManager) {
        if (appProfileManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(0);
        }
        if (projectProfileManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(1);
        }
        this.myProfilePanels = new ArrayList<SingleInspectionProfilePanel>();
        this.myDeletedProfiles = new SmartList<InspectionProfileImpl>();
        this.myApplicationProfileManager = appProfileManager;
        this.myProjectProfileManager = projectProfileManager;
    }

    public boolean canDuplicateScheme(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(2);
        }
        return true;
    }

    public boolean canResetScheme(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean canDeleteScheme(@NotNull InspectionProfileModifiableModel candidateToDelete) {
        boolean isProjectProfile;
        SingleInspectionProfilePanel profilePanel;
        InspectionProfileModifiableModel profile;
        if (candidateToDelete == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(4);
        }
        boolean projectProfileFound = false;
        boolean ideProfileFound = false;
        Iterator<SingleInspectionProfilePanel> iterator2 = this.myProfilePanels.iterator();
        while (!(!iterator2.hasNext() || candidateToDelete != (profile = (profilePanel = iterator2.next()).getProfile()) && (ideProfileFound |= !(isProjectProfile = profile.getProfileManager() == this.myProjectProfileManager)) && (projectProfileFound |= isProjectProfile))) {
        }
        return candidateToDelete.getProfileManager() == this.myProjectProfileManager ? projectProfileFound : ideProfileFound;
    }

    public boolean isProjectScheme(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(5);
        }
        return profile.isProjectLevel();
    }

    public boolean canRenameScheme(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean containsScheme(@NotNull String name, boolean isProjectProfile) {
        if (name == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(7);
        }
        return this.hasName(name, isProjectProfile);
    }

    public boolean differsFromDefault(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(8);
        }
        return this.getProfilePanel(profile).differsFromDefault();
    }

    public void removeScheme(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(9);
        }
        SingleInspectionProfilePanel panel2 = this.getProfilePanel(profile);
        this.removeProfile(profile);
        this.myDeletedProfiles.add(profile);
        this.onProfileRemoved(panel2);
    }

    protected abstract void onProfileRemoved(@NotNull SingleInspectionProfilePanel var1);

    synchronized void addProfile(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(10);
        }
        this.myProfilePanels.add(this.createPanel(profile));
    }

    private void removeProfile(@NotNull InspectionProfileImpl profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(11);
        }
        this.myProfilePanels.removeIf(panel2 -> {
            if (panel2.getProfile().equals(profile)) {
                panel2.disposeUI();
                return true;
            }
            return false;
        });
    }

    void updatePanel(@NotNull InspectionProfileSchemesPanel panel2) {
        if (panel2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(12);
        }
        List<InspectionProfileModifiableModel> allProfiles = ContainerUtil.map(this.myProfilePanels, p -> p.getProfile());
        panel2.resetSchemes(allProfiles);
    }

    void apply(InspectionProfileModifiableModel selected, Consumer<? super InspectionProfileImpl> applyRootProfileAction) {
        for (InspectionProfileImpl profile : this.myDeletedProfiles) {
            profile.getProfileManager().deleteProfile(profile);
        }
        this.myDeletedProfiles.clear();
        SingleInspectionProfilePanel selectedPanel = this.getProfilePanel(selected);
        for (SingleInspectionProfilePanel panel2 : this.getProfilePanels()) {
            panel2.apply();
            if (panel2 != selectedPanel) continue;
            applyRootProfileAction.consume(panel2.getProfile());
        }
    }

    void reset() {
        this.disposeUI();
        this.myDeletedProfiles.clear();
        InspectionProfileSchemesModel.getSortedProfiles(this.myApplicationProfileManager, this.myProjectProfileManager).parallelStream().map(source -> {
            try {
                return new InspectionProfileModifiableModel((InspectionProfileImpl)source);
            }
            catch (Exception e) {
                LOG.error("'" + source.getName() + "' profile is corrupted (project profile = " + source.isProjectLevel() + ")", e);
                return null;
            }
        }).filter(Objects::nonNull).forEachOrdered(this::addProfile);
    }

    void disposeUI() {
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            panel2.disposeUI();
        }
        this.myProfilePanels.clear();
    }

    SingleInspectionProfilePanel getProfilePanel(InspectionProfileImpl profile) {
        return (SingleInspectionProfilePanel)((Object)ContainerUtil.find(this.myProfilePanels, panel2 -> panel2.getProfile().equals(profile)));
    }

    @NotNull
    protected abstract SingleInspectionProfilePanel createPanel(@NotNull InspectionProfileModifiableModel var1);

    private boolean hasName(@NotNull String name, boolean shared) {
        boolean hasName;
        if (name == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(13);
        }
        if (hasName = this.myProfilePanels.stream().map(SingleInspectionProfilePanel::getProfile).anyMatch(p -> name.equals(p.getName()) && p.isProjectLevel() == shared)) {
            return true;
        }
        return this.myProfilePanels.stream().anyMatch(p -> {
            InspectionProfileModifiableModel profile = p.getProfile();
            return name.equals(profile.getName()) && profile.isProjectLevel() == shared;
        });
    }

    @NotNull
    List<SingleInspectionProfilePanel> getProfilePanels() {
        List<SingleInspectionProfilePanel> list2 = this.myProfilePanels;
        if (list2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(14);
        }
        return list2;
    }

    int getSize() {
        return this.myProfilePanels.size();
    }

    boolean hasDeletedProfiles() {
        return !this.myDeletedProfiles.isEmpty();
    }

    @Nullable
    InspectionProfileModifiableModel getModifiableModelFor(@NotNull InspectionProfileImpl profile) {
        if (profile == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(15);
        }
        if (profile instanceof InspectionProfileModifiableModel) {
            return (InspectionProfileModifiableModel)profile;
        }
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            InspectionProfileModifiableModel modifiableModel = panel2.getProfile();
            if (!modifiableModel.getSource().equals(profile)) continue;
            return modifiableModel;
        }
        return null;
    }

    @NotNull
    public static List<InspectionProfileImpl> getSortedProfiles(@NotNull InspectionProfileManager appManager, @NotNull InspectionProfileManager projectManager) {
        if (appManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(16);
        }
        if (projectManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(17);
        }
        List<InspectionProfileImpl> list2 = ContainerUtil.notNullize(ContainerUtil.concat(ContainerUtil.sorted(appManager.getProfiles()), ContainerUtil.sorted(projectManager.getProfiles())));
        if (list2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(18);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appProfileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateToDelete";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilePanels";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addProfile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeProfile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updatePanel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
            case 14: 
            case 18: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModelFor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSortedProfiles";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 14, 18 -> new IllegalStateException(string2);
        };
    }
}

