/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionConfigTreeNode
extends DefaultMutableTreeNode {
    private final ClearableLazyValue<Boolean> myProperSetting = ClearableLazyValue.create(this::calculateIsProperSettings);

    public final boolean isProperSetting() {
        return this.myProperSetting.getValue();
    }

    public final void dropCache() {
        this.myProperSetting.drop();
    }

    protected abstract boolean calculateIsProperSettings();

    @NotNull
    public abstract String getText();

    @Override
    public String toString() {
        Object userObject = this.getUserObject();
        if (userObject instanceof ToolDescriptors) {
            return ((ToolDescriptors)userObject).getDefaultDescriptor().getText();
        }
        if (userObject instanceof Descriptor) {
            return ((Descriptor)userObject).getText();
        }
        return super.toString();
    }

    public static void updateUpHierarchy(@NotNull InspectionConfigTreeNode node2) {
        if (node2 == null) {
            InspectionConfigTreeNode.$$$reportNull$$$0(0);
        }
        InspectionConfigTreeNode.updateUpHierarchy(Collections.singletonList(node2));
    }

    public static void updateUpHierarchy(Collection<? extends InspectionConfigTreeNode> nodes2) {
        InspectionConfigTreeNode inspectionConfigTreeNode;
        ArrayDeque<InspectionConfigTreeNode> q = new ArrayDeque<InspectionConfigTreeNode>(nodes2.size());
        HashSet<InspectionConfigTreeNode> alreadyUpdated = new HashSet<InspectionConfigTreeNode>();
        for (InspectionConfigTreeNode inspectionConfigTreeNode2 : nodes2) {
            q.addLast(inspectionConfigTreeNode2);
        }
        while ((inspectionConfigTreeNode = (InspectionConfigTreeNode)q.pollFirst()) != null) {
            if (!alreadyUpdated.add(inspectionConfigTreeNode)) continue;
            inspectionConfigTreeNode.dropCache();
            TreeNode treeNode = inspectionConfigTreeNode.getParent();
            if (treeNode == null || treeNode.getParent() == null) continue;
            q.addLast((InspectionConfigTreeNode)treeNode);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionConfigTreeNode", "updateUpHierarchy"));
    }

    public static class Tool
    extends InspectionConfigTreeNode {
        private final Supplier<ToolDescriptors> myGetter;

        public Tool(Supplier<ToolDescriptors> getter) {
            this.myGetter = getter;
        }

        @Override
        public Object getUserObject() {
            return this.myGetter.get();
        }

        @Override
        protected boolean calculateIsProperSettings() {
            Descriptor defaultDescriptor = this.getDescriptors().getDefaultDescriptor();
            return defaultDescriptor.getInspectionProfile().isProperSetting(defaultDescriptor.getToolWrapper().getShortName());
        }

        @Override
        @NotNull
        public String getText() {
            String string2 = this.getDefaultDescriptor().getText();
            if (string2 == null) {
                Tool.$$$reportNull$$$0(0);
            }
            return string2;
        }

        public HighlightDisplayKey getKey() {
            return this.getDefaultDescriptor().getKey();
        }

        @NotNull
        public Descriptor getDefaultDescriptor() {
            Descriptor descriptor2 = this.getDescriptors().getDefaultDescriptor();
            if (descriptor2 == null) {
                Tool.$$$reportNull$$$0(1);
            }
            return descriptor2;
        }

        @NotNull
        public ToolDescriptors getDescriptors() {
            ToolDescriptors toolDescriptors = (ToolDescriptors)this.getUserObject();
            if (toolDescriptors == null) {
                Tool.$$$reportNull$$$0(2);
            }
            return toolDescriptors;
        }

        @Nullable
        public String getScopeName() {
            return this.getDescriptors().getDefaultScopeToolState().getScopeName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionConfigTreeNode$Tool";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptors";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Group
    extends InspectionConfigTreeNode {
        public Group(@NotNull String label2) {
            if (label2 == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.setUserObject(label2);
        }

        @Override
        protected boolean calculateIsProperSettings() {
            return IntStream.range(0, this.getChildCount()).mapToObj(i2 -> (InspectionConfigTreeNode)this.getChildAt(i2)).anyMatch(InspectionConfigTreeNode::isProperSetting);
        }

        @Override
        @NotNull
        public String getText() {
            String string2 = this.getGroupName();
            if (string2 == null) {
                Group.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @NotNull
        public String getGroupName() {
            String string2 = (String)this.getUserObject();
            if (string2 == null) {
                Group.$$$reportNull$$$0(2);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionConfigTreeNode$Group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionConfigTreeNode$Group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2 -> new IllegalStateException(string2);
            };
        }
    }
}

