/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorTreeRendererContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jdesktop.swingx.renderer.DefaultTreeRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionsConfigTreeRenderer
extends DefaultTreeRenderer
implements UiInspectorTreeRendererContextProvider {
    protected abstract String getFilter();

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SimpleColoredComponent component2 = new SimpleColoredComponent();
        if (!(value instanceof InspectionConfigTreeNode)) {
            return component2;
        }
        InspectionConfigTreeNode node2 = (InspectionConfigTreeNode)value;
        boolean reallyHasFocus = ((TreeTableTree)tree).getTreeTable().hasFocus();
        Color background = UIUtil.getTreeBackground(selected, reallyHasFocus);
        UIUtil.changeBackGround((Component)component2, background);
        Color foreground = selected ? UIUtil.getTreeSelectionForeground(reallyHasFocus) : (node2.isProperSetting() ? PlatformColors.BLUE : UIUtil.getTreeForeground());
        int style = 0;
        String hint = null;
        if (node2 instanceof InspectionConfigTreeNode.Group) {
            style = 1;
        } else {
            InspectionConfigTreeNode.Tool toolNode = (InspectionConfigTreeNode.Tool)node2;
            hint = InspectionsConfigTreeRenderer.getHint(toolNode.getDefaultDescriptor());
        }
        SearchUtil.appendFragments((String)this.getFilter(), (String)node2.getText(), (int)style, (Color)foreground, (Color)background, (SimpleColoredComponent)component2);
        if (hint != null) {
            component2.append(" " + hint, selected ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        component2.setForeground(foreground);
        return component2;
    }

    @Nullable
    @NlsContexts.Label
    private static String getHint(Descriptor descriptor2) {
        InspectionToolWrapper<?, ?> toolWrapper = descriptor2.getToolWrapper();
        if (toolWrapper instanceof LocalInspectionToolWrapper || toolWrapper instanceof GlobalInspectionToolWrapper && !((GlobalInspectionToolWrapper)toolWrapper).worksInBatchModeOnly()) {
            return null;
        }
        return InspectionsBundle.message("inspection.tool.availability.in.tree.node1", new Object[0]);
    }

    @NotNull
    public List<PropertyBean> getUiInspectorContext(@NotNull JTree tree, @Nullable Object value, int row) {
        if (tree == null) {
            InspectionsConfigTreeRenderer.$$$reportNull$$$0(0);
        }
        if (value instanceof InspectionConfigTreeNode.Tool) {
            InspectionConfigTreeNode.Tool toolNode = (InspectionConfigTreeNode.Tool)value;
            ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
            result2.add(new PropertyBean("Inspection Key", (Object)toolNode.getKey().getID(), true));
            result2.add(new PropertyBean("Inspection tool Class", (Object)UiInspectorUtil.getClassPresentation(toolNode.getDefaultDescriptor().getToolWrapper().getTool())));
            ArrayList<PropertyBean> arrayList = result2;
            if (arrayList == null) {
                InspectionsConfigTreeRenderer.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        List<PropertyBean> list2 = Collections.emptyList();
        if (list2 == null) {
            InspectionsConfigTreeRenderer.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiInspectorContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUiInspectorContext";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

