/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ScopesAndSeveritiesHintTable
extends JBTable {
    private static final int SCOPE_COLUMN = 0;
    private static final int SEVERITY_COLUMN = 1;

    public ScopesAndSeveritiesHintTable(LinkedHashMap<String, HighlightDisplayLevel> scopeToAverageSeverityMap, String defaultScopeName) {
        super((TableModel)new MyModel(scopeToAverageSeverityMap, defaultScopeName));
        this.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setOpaque(false);
                UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, this);
                return this;
            }
        });
        this.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                HighlightDisplayLevel level = (HighlightDisplayLevel)value;
                this.setIcon(level.getIcon());
                this.setText(SingleInspectionProfilePanel.renderSeverity(level.getSeverity()));
                this.setOpaque(false);
                UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, this);
                return this;
            }
        });
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setOpaque(false);
        for (int i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
            int w = 0;
            TableColumn column = this.getColumnModel().getColumn(i2);
            for (int j = 0; j < this.getModel().getRowCount(); ++j) {
                Component component2 = this.prepareRenderer(column.getCellRenderer(), j, i2);
                w = Math.max(component2.getPreferredSize().width, w);
            }
            column.setPreferredWidth(w + 1);
        }
    }

    private static final class MyModel
    extends AbstractTableModel {
        private final LinkedHashMap<String, HighlightDisplayLevel> myScopeToAverageSeverityMap;
        private final String myDefaultScopeName;
        private final List<String> myScopes;

        MyModel(LinkedHashMap<String, HighlightDisplayLevel> scopeToAverageSeverityMap, String defaultScopeName) {
            this.myScopeToAverageSeverityMap = scopeToAverageSeverityMap;
            this.myDefaultScopeName = defaultScopeName;
            this.myScopes = new ArrayList<String>(this.myScopeToAverageSeverityMap.keySet());
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> String.class;
                case 1 -> HighlightDisplayLevel.class;
                default -> throw new IllegalArgumentException();
            };
        }

        @Override
        public int getRowCount() {
            return this.myScopes.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String scopeName = this.myScopes.get(rowIndex);
            return switch (columnIndex) {
                case 0 -> {
                    if (this.myDefaultScopeName.equals(scopeName)) {
                        yield "Everywhere else";
                    }
                    yield scopeName;
                }
                case 1 -> this.myScopeToAverageSeverityMap.get(scopeName);
                default -> throw new IllegalArgumentException();
            };
        }
    }
}

