/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profile/codeInspection/ui/table/ScopesOrderTable;", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "()V", "model", "Lcom/intellij/util/ui/ListTableModel;", "getScopeAt", "i", "", "move", "", "offset", "moveDown", "moveUp", "updateItems", "scopes", "", "IconColumn", "NameColumn", "SetColumn", "intellij.platform.lang.impl"})
public final class ScopesOrderTable
extends TableView<NamedScope> {
    @NotNull
    private final ListTableModel<NamedScope> model;

    public ScopesOrderTable() {
        Object object = new ColumnInfo[]{IconColumn.INSTANCE, NameColumn.INSTANCE, SetColumn.INSTANCE};
        this.model = new ListTableModel((ColumnInfo[])object);
        this.setModelAndUpdateColumns(this.model);
        this.rowSelectionAllowed = true;
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        this.tableHeader.setReorderingAllowed(false);
        this.setSelectionMode(0);
        Object $this$_init__u24lambda_u240 = object = this.getColumnModel().getColumn(0);
        boolean bl = false;
        ((TableColumn)$this$_init__u24lambda_u240).setMaxWidth(JBUI.scale(34));
        ((TableColumn)$this$_init__u24lambda_u240).setMinWidth(JBUI.scale(34));
        Object $this$_init__u24lambda_u241 = object = this.getColumnModel().getColumn(1);
        boolean bl2 = false;
        ((TableColumn)$this$_init__u24lambda_u241).setPreferredWidth(JBUI.scale(200));
    }

    public final void updateItems(@NotNull Collection<? extends NamedScope> scopes) {
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        this.model.addRows(scopes);
    }

    @Nullable
    public final NamedScope getScopeAt(int i2) {
        return (NamedScope)this.model.getItem(i2);
    }

    public final void moveUp() {
        if (this.getSelectedRow() > 0) {
            this.move(-1);
        }
    }

    public final void moveDown() {
        if (this.getSelectedRow() + 1 < this.getRowCount()) {
            this.move(1);
        }
    }

    private final void move(int offset2) {
        ListSelectionModel listSelectionModel;
        int selected = this.getSelectedRow();
        this.model.exchangeRows(selected, selected + offset2);
        ListSelectionModel $this$move_u24lambda_u242 = listSelectionModel = this.selectionModel;
        boolean bl = false;
        $this$move_u24lambda_u242.clearSelection();
        $this$move_u24lambda_u242.addSelectionInterval(selected + offset2, selected + offset2);
        this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), 0, true));
        this.repaint();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/profile/codeInspection/ui/table/ScopesOrderTable$IconColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "", "()V", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "item", "valueOf", "intellij.platform.lang.impl"})
    private static final class IconColumn
    extends ColumnInfo<NamedScope, String> {
        @NotNull
        public static final IconColumn INSTANCE = new IconColumn();

        private IconColumn() {
            super("");
        }

        @NotNull
        public String valueOf(@NotNull NamedScope item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return "";
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable NamedScope item) {
            return (TableCellRenderer)new IconTableCellRenderer<String>(item){
                final /* synthetic */ NamedScope $item;
                {
                    this.$item = $item;
                }

                @Nullable
                protected Icon getIcon(@NotNull String value, @Nullable JTable table, int row) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    NamedScope namedScope = this.$item;
                    if ((namedScope != null ? namedScope.getIcon() : null) instanceof OffsetIcon) {
                        Icon icon2 = this.$item.getIcon();
                        Intrinsics.checkNotNull((Object)icon2, (String)"null cannot be cast to non-null type com.intellij.ui.OffsetIcon");
                        return ((OffsetIcon)icon2).getIcon();
                    }
                    NamedScope namedScope2 = this.$item;
                    return namedScope2 != null ? namedScope2.getIcon() : null;
                }

                protected boolean isCenterAlignment() {
                    return true;
                }
            };
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profile/codeInspection/ui/table/ScopesOrderTable$NameColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "", "()V", "valueOf", "item", "intellij.platform.lang.impl"})
    private static final class NameColumn
    extends ColumnInfo<NamedScope, String> {
        @NotNull
        public static final NameColumn INSTANCE = new NameColumn();

        private NameColumn() {
            super(AnalysisBundle.message("inspections.settings.scopes.name", new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull NamedScope item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            String string2 = item.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.presentableName");
            return string2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profile/codeInspection/ui/table/ScopesOrderTable$SetColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "", "()V", "valueOf", "item", "intellij.platform.lang.impl"})
    private static final class SetColumn
    extends ColumnInfo<NamedScope, String> {
        @NotNull
        public static final SetColumn INSTANCE = new SetColumn();

        private SetColumn() {
            super(AnalysisBundle.message("inspections.settings.scopes.pattern", new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull NamedScope item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            PackageSet packageSet = item.getValue();
            String string2 = packageSet != null ? packageSet.getText() : null;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }
    }
}

