/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CompositeSequentialTask;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.SequentialTaskWithFixedIterationsNumber;
import com.intellij.util.SequentialModalProgressTask;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsCodeFragmentFilter {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsCodeFragmentFilter.class);
    private final Project myProject;
    private final PsiFile myFile;
    private final Document myDocument;
    private final RangeMarker myTextRangeMarker;
    private final LanguageCodeStyleSettingsProvider myProvider;

    public CodeStyleSettingsCodeFragmentFilter(@NotNull PsiFile file2, @NotNull TextRange range, @NotNull LanguageCodeStyleSettingsProvider settingsProvider) {
        if (file2 == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(1);
        }
        if (settingsProvider == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(2);
        }
        this.myProvider = settingsProvider;
        this.myProject = file2.getProject();
        this.myFile = PsiFileFactory.getInstance(this.myProject).createFileFromText("copy" + file2.getName(), file2.getLanguage(), (CharSequence)file2.getText(), true, false);
        this.myDocument = PsiDocumentManager.getInstance(this.myProject).getDocument(this.myFile);
        LOG.assertTrue(this.myDocument != null);
        this.myTextRangeMarker = this.myDocument.createRangeMarker(range.getStartOffset(), range.getEndOffset());
    }

    @NotNull
    public CodeStyleSettingsToShow getFieldNamesAffectingCodeFragment(LanguageCodeStyleSettingsProvider.SettingsType ... types) {
        Ref settingsToShow = new Ref();
        CodeStyle.doWithTemporarySettings((Project)this.myProject, (CodeStyleSettings)CodeStyle.getSettings((PsiFile)this.myFile), tempSettings -> settingsToShow.set(this.computeFieldsWithTempSettings((CodeStyleSettings)tempSettings, types)));
        CodeStyleSettingsToShow codeStyleSettingsToShow = (CodeStyleSettingsToShow)settingsToShow.get();
        if (codeStyleSettingsToShow == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(3);
        }
        return codeStyleSettingsToShow;
    }

    @NotNull
    private CodeStyleSettingsToShow computeFieldsWithTempSettings(@NotNull CodeStyleSettings tempSettings, LanguageCodeStyleSettingsProvider.SettingsType @NotNull [] types) {
        if (tempSettings == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(4);
        }
        if (types == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(5);
        }
        CommonCodeStyleSettings commonSettings = tempSettings.getCommonSettings(this.myProvider.getLanguage());
        CustomCodeStyleSettings customSettings = CodeStyleSettingsCodeFragmentFilter.getCustomSettings(this.myProvider, tempSettings);
        String title = CodeInsightBundle.message("configure.code.style.on.fragment.dialog.title", new Object[0]);
        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(this.myProject, StringUtil.capitalizeWords(title, true));
        progressTask.setCancelText(CodeInsightBundle.message("configure.code.style.on.fragment.dialog.cancel", new Object[0]));
        CompositeSequentialTask compositeTask = new CompositeSequentialTask(progressTask);
        compositeTask.setProgressText(CodeInsightBundle.message("configure.code.style.on.fragment.dialog.progress.text", new Object[0]));
        compositeTask.setProgressText2(CodeInsightBundle.message("configure.code.style.on.fragment.dialog.progress.text.under", new Object[0]));
        final HashMap<LanguageCodeStyleSettingsProvider.SettingsType, FilterFieldsTask> typeToTask = new HashMap<LanguageCodeStyleSettingsProvider.SettingsType, FilterFieldsTask>();
        for (LanguageCodeStyleSettingsProvider.SettingsType type : types) {
            Set<String> fields = this.myProvider.getSupportedFields(type);
            FilterFieldsTask task2 = new FilterFieldsTask(commonSettings, customSettings, fields);
            compositeTask.addTask(task2);
            typeToTask.put(type, task2);
        }
        Set<String> otherFields = this.myProvider.getSupportedFields();
        final FilterFieldsTask otherFieldsTask = new FilterFieldsTask(commonSettings, customSettings, otherFields);
        if (!otherFields.isEmpty()) {
            compositeTask.addTask(otherFieldsTask);
        }
        progressTask.setTask(compositeTask);
        progressTask.setMinIterationTime(10L);
        ProgressManager.getInstance().run(progressTask);
        return new CodeStyleSettingsToShow(){

            @Override
            public List<String> getSettings(LanguageCodeStyleSettingsProvider.SettingsType type) {
                return ((FilterFieldsTask)typeToTask.get((Object)type)).getAffectedFields();
            }

            @Override
            public List<String> getOtherSetting() {
                return new ArrayList<String>(otherFieldsTask.getAffectedFields());
            }
        };
    }

    @Nullable
    private static CustomCodeStyleSettings getCustomSettings(@NotNull LanguageCodeStyleSettingsProvider languageProvider, @NotNull CodeStyleSettings tempSettings) {
        CustomCodeStyleSettings fromLanguageProvider;
        if (languageProvider == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(6);
        }
        if (tempSettings == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(7);
        }
        if ((fromLanguageProvider = CodeStyleSettingsCodeFragmentFilter.getCustomSettingsFromProvider(languageProvider, tempSettings)) != null) {
            return fromLanguageProvider;
        }
        for (CodeStyleSettingsProvider codeStyleSettingsProvider : CodeStyleSettingsProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            CustomCodeStyleSettings settings;
            if (!languageProvider.getLanguage().equals(codeStyleSettingsProvider.getLanguage()) || (settings = CodeStyleSettingsCodeFragmentFilter.getCustomSettingsFromProvider(codeStyleSettingsProvider, tempSettings)) == null) continue;
            return settings;
        }
        return null;
    }

    @Nullable
    private static CustomCodeStyleSettings getCustomSettingsFromProvider(@NotNull CodeStyleSettingsProvider languageProvider, @NotNull CodeStyleSettings tempSettings) {
        CustomCodeStyleSettings modelSettings;
        if (languageProvider == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(8);
        }
        if (tempSettings == null) {
            CodeStyleSettingsCodeFragmentFilter.$$$reportNull$$$0(9);
        }
        return (modelSettings = languageProvider.createCustomSettings(tempSettings)) != null ? tempSettings.getCustomSettings(modelSettings.getClass()) : null;
    }

    private boolean formattingChangedFragment() {
        CharSequence fragmentAfter;
        int rangeStart = this.myTextRangeMarker.getStartOffset();
        int rangeEnd = this.myTextRangeMarker.getEndOffset();
        CharSequence textBefore = this.myDocument.getCharsSequence();
        ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance(this.myProject).reformatText(this.myFile, rangeStart, rangeEnd));
        if (rangeStart != this.myTextRangeMarker.getStartOffset() || rangeEnd != this.myTextRangeMarker.getEndOffset()) {
            return true;
        }
        CharSequence fragmentBefore = textBefore.subSequence(rangeStart, rangeEnd);
        return !StringUtil.equals(fragmentBefore, fragmentAfter = this.myDocument.getCharsSequence().subSequence(rangeStart, rangeEnd));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettingsCodeFragmentFilter";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsCodeFragmentFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldNamesAffectingCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeFieldsWithTempSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettingsFromProvider";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }

    public static interface CodeStyleSettingsToShow {
        public List<String> getSettings(LanguageCodeStyleSettingsProvider.SettingsType var1);

        public List<String> getOtherSetting();
    }

    private class FilterFieldsTask
    implements SequentialTaskWithFixedIterationsNumber {
        private final Iterator<String> myIterator;
        private final int myTotalFieldsNumber;
        private final Collection<String> myAllFields;
        private List<String> myAffectingFields;
        private final Object myCommonSettings;
        @Nullable
        private final CustomCodeStyleSettings myCustomSettings;

        FilterFieldsTask(@Nullable CommonCodeStyleSettings commonSettings, @NotNull CustomCodeStyleSettings customSettings, Collection<String> fields) {
            if (commonSettings == null) {
                FilterFieldsTask.$$$reportNull$$$0(0);
            }
            if (fields == null) {
                FilterFieldsTask.$$$reportNull$$$0(1);
            }
            this.myAffectingFields = new ArrayList<String>();
            this.myCustomSettings = customSettings;
            this.myAllFields = fields;
            this.myIterator = fields.iterator();
            this.myCommonSettings = commonSettings;
            this.myTotalFieldsNumber = fields.size();
        }

        public List<String> getAffectedFields() {
            return this.myAffectingFields;
        }

        @Override
        public int getTotalIterationsNumber() {
            return this.myTotalFieldsNumber;
        }

        @Override
        public void stop() {
            if (!this.isDone()) {
                this.myAffectingFields = new ArrayList<String>(this.myAllFields);
            }
        }

        @Override
        public boolean isDone() {
            return !this.myIterator.hasNext();
        }

        @Override
        public boolean iteration() {
            if (!this.myIterator.hasNext()) {
                return true;
            }
            String field = this.myIterator.next();
            if (this.myCustomSettings != null) {
                this.checkFieldAffectsSettings(this.myCustomSettings, field);
            }
            this.checkFieldAffectsSettings(this.myCommonSettings, field);
            return true;
        }

        private void checkFieldAffectsSettings(@NotNull Object settings, String field) {
            if (settings == null) {
                FilterFieldsTask.$$$reportNull$$$0(2);
            }
            try {
                Field classField = settings.getClass().getField(field);
                if (classField.getType() == Integer.TYPE) {
                    int oldValue = classField.getInt(settings);
                    int newValue = this.getNewIntValue(classField, oldValue);
                    if (newValue == oldValue) {
                        return;
                    }
                    classField.set(settings, newValue);
                } else if (classField.getType() == Boolean.TYPE) {
                    boolean value = classField.getBoolean(settings);
                    classField.set(settings, !value);
                } else {
                    return;
                }
                if (CodeStyleSettingsCodeFragmentFilter.this.formattingChangedFragment()) {
                    this.myAffectingFields.add(field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getNewIntValue(Field classField, int oldValue) {
            String fieldName = classField.getName();
            if (fieldName.contains("WRAP")) {
                return oldValue == 2 ? 0 : 2;
            }
            if (fieldName.contains("BRACE_FORCE")) {
                return oldValue == 3 ? 0 : 1;
            }
            if (fieldName.contains("BRACE_STYLE")) {
                return oldValue == 1 ? 4 : 1;
            }
            return oldValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commonSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fields";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsCodeFragmentFilter$FilterFieldsTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkFieldAffectsSettings";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

