/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjuster;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetectorImpl;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

class DetectAndAdjustIndentOptionsTask {
    private static final ExecutorService BOUNDED_EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("DetectableIndentOptionsProvider Pool");
    private static final Logger LOG = Logger.getInstance(DetectAndAdjustIndentOptionsTask.class);
    private static final int INDENT_COMPUTATION_TIMEOUT = 5000;
    private final Document myDocument;
    private final Project myProject;
    private final TimeStampedIndentOptions myOptionsToAdjust;

    DetectAndAdjustIndentOptionsTask(@NotNull Project project2, @NotNull Document document, @NotNull TimeStampedIndentOptions toAdjust) {
        if (project2 == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(1);
        }
        if (toAdjust == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myDocument = document;
        this.myOptionsToAdjust = toAdjust;
    }

    private VirtualFile getFile() {
        return FileDocumentManager.getInstance().getFile(this.myDocument);
    }

    @NotNull
    private Runnable calcIndentAdjuster(@NotNull ProgressIndicator indicator) {
        VirtualFile file2;
        if (indicator == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(3);
        }
        IndentOptionsAdjuster adjuster = (file2 = this.getFile()) == null ? null : new IndentOptionsDetectorImpl(this.myProject, file2, this.myDocument, indicator).getIndentOptionsAdjuster();
        Runnable runnable = adjuster != null ? () -> this.adjustOptions(adjuster) : EmptyRunnable.INSTANCE;
        if (runnable == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(4);
        }
        return runnable;
    }

    private void adjustOptions(IndentOptionsAdjuster adjuster) {
        VirtualFile virtualFile2 = this.getFile();
        if (virtualFile2 == null) {
            return;
        }
        TimeStampedIndentOptions currentDefault = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(this.myProject, virtualFile2, this.myDocument);
        this.myOptionsToAdjust.copyFrom(currentDefault);
        adjuster.adjust(this.myOptionsToAdjust);
        this.myOptionsToAdjust.setTimeStamp(this.myDocument.getModificationStamp());
        this.myOptionsToAdjust.setOriginalIndentOptionsHash(currentDefault.hashCode());
        if (!currentDefault.equals((Object)this.myOptionsToAdjust)) {
            this.myOptionsToAdjust.setDetected(true);
            this.myOptionsToAdjust.setOverrideLanguageOptions(true);
            CodeStyleSettingsManager.getInstance((Project)this.myProject).fireCodeStyleSettingsChanged(virtualFile2);
        }
    }

    private void logTooLongComputation() {
        VirtualFile file2 = this.getFile();
        String fileName = file2 != null ? file2.getName() : "";
        LOG.debug("Indent detection is too long for: " + fileName);
    }

    void scheduleInBackgroundForCommittedDocument() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
            this.calcIndentAdjuster(new DumbProgressIndicator()).run();
        } else {
            ReadAction.nonBlocking(() -> {
                Runnable indentAdjuster = (Runnable)ProgressIndicatorUtils.withTimeout((long)5000L, () -> this.calcIndentAdjuster(Objects.requireNonNull(ProgressIndicatorProvider.getGlobalProgressIndicator())));
                if (indentAdjuster == null) {
                    this.logTooLongComputation();
                    return EmptyRunnable.INSTANCE;
                }
                return indentAdjuster;
            }).finishOnUiThread(ModalityState.defaultModalityState(), Runnable::run).withDocumentsCommitted(this.myProject).submit(BOUNDED_EXECUTOR);
        }
    }

    @NotNull
    static TimeStampedIndentOptions getDefaultIndentOptions(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull Document document) {
        if (project2 == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(6);
        }
        if (document == null) {
            DetectAndAdjustIndentOptionsTask.$$$reportNull$$$0(7);
        }
        FileType fileType = file2.getFileType();
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project2, (VirtualFile)file2);
        return new TimeStampedIndentOptions(settings.getIndentOptions(fileType), document.getModificationStamp());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdjust";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/DetectAndAdjustIndentOptionsTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcIndentAdjuster";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcIndentAdjuster";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultIndentOptions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

