/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DetectAndAdjustIndentOptionsTask;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider {
    private boolean myIsEnabledInTest;
    private final Map<VirtualFile, CommonCodeStyleSettings.IndentOptions> myDiscardedOptions = new WeakHashMap<VirtualFile, CommonCodeStyleSettings.IndentOptions>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project2, @NotNull CodeStyleSettings settings, @NotNull VirtualFile file2) {
        TimeStampedIndentOptions options2;
        if (project2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(2);
        }
        if (!this.isEnabled(settings, file2)) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        synchronized (document2) {
            options2 = this.getValidCachedIndentOptions(project2, file2, document);
            if (options2 != null) {
                return options2;
            }
            options2 = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(project2, file2, document);
            options2.associateWithDocument(document);
        }
        this.scheduleDetectionInBackground(project2, document, options2);
        return options2;
    }

    protected void scheduleDetectionInBackground(@NotNull Project project2, @NotNull Document document, @NotNull TimeStampedIndentOptions options2) {
        if (project2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(3);
        }
        if (document == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(4);
        }
        if (options2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(5);
        }
        new DetectAndAdjustIndentOptionsTask(project2, document, options2).scheduleInBackgroundForCommittedDocument();
    }

    public boolean useOnFullReformat() {
        return false;
    }

    @TestOnly
    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull VirtualFile file2) {
        if (settings == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(7);
        }
        if (!file2.isValid() || !file2.isWritable() || ScratchUtil.isScratch(file2)) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        if (file2 instanceof LightVirtualFile || this.myDiscardedOptions.containsKey(file2)) {
            return false;
        }
        return DetectableIndentOptionsProvider.hasFormattingModelBuilder(file2) && settings.AUTODETECT_INDENTS;
    }

    private static boolean hasFormattingModelBuilder(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(8);
        }
        if ((fileType = file2.getFileType()) instanceof LanguageFileType) {
            Language language = ((LanguageFileType)fileType).getLanguage();
            return LanguageFormatting.INSTANCE.forLanguage(language) != null;
        }
        return false;
    }

    @TestOnly
    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class);
    }

    private void disableForFile(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(9);
        }
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(10);
        }
        this.myDiscardedOptions.put(file2, indentOptions);
    }

    public TimeStampedIndentOptions getValidCachedIndentOptions(@NotNull Project project2, @NotNull VirtualFile virtualFile2, Document document) {
        TimeStampedIndentOptions defaultIndentOptions;
        TimeStampedIndentOptions cachedInDocument;
        CommonCodeStyleSettings.IndentOptions options2;
        if (project2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(11);
        }
        if (virtualFile2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(12);
        }
        if ((options2 = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument((Document)document)) instanceof TimeStampedIndentOptions && !(cachedInDocument = (TimeStampedIndentOptions)options2).isOutdated(document, defaultIndentOptions = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(project2, virtualFile2, document))) {
            return cachedInDocument;
        }
        return null;
    }

    private static void showDisabledDetectionNotification(@NotNull Project project2) {
        if (project2 == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(13);
        }
        DetectionDisabledNotification notification = new DetectionDisabledNotification(project2);
        notification.notify(project2);
    }

    private static boolean areDetected(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(14);
        }
        return indentOptions instanceof TimeStampedIndentOptions && ((TimeStampedIndentOptions)indentOptions).isDetected();
    }

    @Nullable
    public IndentStatusBarUIContributor getIndentStatusBarUiContributor(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            DetectableIndentOptionsProvider.$$$reportNull$$$0(15);
        }
        return new MyUIContributor(indentOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleDetectionInBackground";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFormattingModelBuilder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "disableForFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidCachedIndentOptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "showDisabledDetectionNotification";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "areDetected";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentStatusBarUiContributor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DetectionDisabledNotification
    extends Notification {
        private DetectionDisabledNotification(Project project2) {
            super("Automatic indent detection", ApplicationBundle.message((String)"code.style.indent.detector.notification.content", (Object[])new Object[0]), "", NotificationType.INFORMATION);
            this.addAction((AnAction)new ReEnableDetection(project2, this));
            this.addAction((AnAction)new ShowIndentDetectionOptionAction(ApplicationBundle.message((String)"code.style.indent.provider.notification.settings", (Object[])new Object[0])));
        }
    }

    private final class MyUIContributor
    extends IndentStatusBarUIContributor {
        private MyUIContributor(CommonCodeStyleSettings.IndentOptions options2) {
            super(options2);
        }

        public AnAction @Nullable [] getActions(@NotNull PsiFile file2) {
            if (file2 == null) {
                MyUIContributor.$$$reportNull$$$0(0);
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions();
            ArrayList<Object> actions = new ArrayList<Object>();
            VirtualFile virtualFile2 = file2.getVirtualFile();
            Project project2 = file2.getProject();
            CommonCodeStyleSettings.IndentOptions projectOptions = CodeStyle.getSettings((Project)project2).getIndentOptions(file2.getFileType());
            String projectOptionsTip = StringUtil.capitalizeWords(IndentStatusBarUIContributor.getIndentInfo(projectOptions), true);
            if (indentOptions instanceof TimeStampedIndentOptions) {
                if (((TimeStampedIndentOptions)indentOptions).isDetected()) {
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.reject", (Object[])new Object[]{projectOptionsTip}), e -> {
                        DetectableIndentOptionsProvider.this.disableForFile(virtualFile2, indentOptions);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project2, (VirtualFile)virtualFile2);
                    }));
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.reindent", (Object[])new Object[]{projectOptionsTip}), e -> {
                        DetectableIndentOptionsProvider.this.disableForFile(virtualFile2, indentOptions);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project2, (VirtualFile)virtualFile2);
                        CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance(project2).adjustLineIndent(file2, file2.getTextRange())));
                        DetectableIndentOptionsProvider.this.myDiscardedOptions.remove(virtualFile2);
                    }));
                    actions.add(Separator.getInstance());
                }
            } else if (virtualFile2 != null && DetectableIndentOptionsProvider.this.myDiscardedOptions.containsKey(virtualFile2)) {
                CommonCodeStyleSettings.IndentOptions discardedOptions = DetectableIndentOptionsProvider.this.myDiscardedOptions.get(virtualFile2);
                Document document = PsiDocumentManager.getInstance(project2).getDocument(file2);
                if (document != null) {
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.apply", (Object[])new Object[]{IndentStatusBarUIContributor.getIndentInfo(discardedOptions), ColorUtil.toHex(JBColor.GRAY)}), e -> {
                        DetectableIndentOptionsProvider.this.myDiscardedOptions.remove(virtualFile2);
                        discardedOptions.associateWithDocument(document);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project2, (VirtualFile)virtualFile2);
                    }));
                    actions.add(Separator.getInstance());
                }
            }
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }

        @NotNull
        public AnAction createDisableAction(@NotNull Project project2) {
            if (project2 == null) {
                MyUIContributor.$$$reportNull$$$0(1);
            }
            DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.disable", (Object[])new Object[0]), e -> {
                CodeStyle.getSettings((Project)project2).AUTODETECT_INDENTS = false;
                DetectableIndentOptionsProvider.this.myDiscardedOptions.clear();
                FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project2);
                DetectableIndentOptionsProvider.showDisabledDetectionNotification(project2);
            });
            if (dumbAwareAction == null) {
                MyUIContributor.$$$reportNull$$$0(2);
            }
            return dumbAwareAction;
        }

        @Override
        public String getHint() {
            if (DetectableIndentOptionsProvider.areDetected(this.getIndentOptions())) {
                return LangBundle.message("indent.option.detected", new Object[0]);
            }
            return null;
        }

        public boolean areActionsAvailable(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyUIContributor.$$$reportNull$$$0(3);
            }
            return DetectableIndentOptionsProvider.areDetected(this.getIndentOptions()) || DetectableIndentOptionsProvider.this.myDiscardedOptions.containsKey(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$MyUIContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$MyUIContributor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDisableAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createDisableAction";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "areActionsAvailable";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class ReEnableDetection
    extends DumbAwareAction {
        private final Project myProject;
        private final Notification myNotification;

        private ReEnableDetection(@NotNull Project project2, Notification notification) {
            if (project2 == null) {
                ReEnableDetection.$$$reportNull$$$0(0);
            }
            super(ApplicationBundle.message((String)"code.style.indent.provider.notification.re.enable", (Object[])new Object[0]));
            this.myProject = project2;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReEnableDetection.$$$reportNull$$$0(1);
            }
            CodeStyle.getSettings((Project)this.myProject).AUTODETECT_INDENTS = true;
            FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)this.myProject);
            this.myNotification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$ReEnableDetection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ShowIndentDetectionOptionAction
    extends DumbAwareAction {
        private ShowIndentDetectionOptionAction(@Nullable @NlsActions.ActionText String text2) {
            super(text2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowIndentDetectionOptionAction.$$$reportNull$$$0(0);
            }
            ShowSettingsUtilImpl.showSettingsDialog((Project)e.getProject(), (String)"preferences.sourceCode", (String)"detect indent");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$ShowIndentDetectionOptionAction", "actionPerformed"));
        }
    }
}

