/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.CodeStyleBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentStatusBarUIContributor
implements CodeStyleStatusBarUIContributor {
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

    public IndentStatusBarUIContributor(CommonCodeStyleSettings.IndentOptions options2) {
        this.myIndentOptions = options2;
    }

    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.myIndentOptions;
    }

    @Nullable
    @NlsContexts.HintText
    public abstract String getHint();

    @Nullable
    public String getTooltip() {
        return IndentStatusBarUIContributor.createTooltip(IndentStatusBarUIContributor.getIndentInfo(this.myIndentOptions), this.getHint());
    }

    @Nls
    @NotNull
    public static String getIndentInfo(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(0);
        }
        String string2 = indentOptions.USE_TAB_CHARACTER ? CodeStyleBundle.message((String)"indent.status.bar.tab", (Object[])new Object[0]) : CodeStyleBundle.message((String)"indent.status.bar.spaces", (Object[])new Object[]{indentOptions.INDENT_SIZE});
        if (string2 == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return true;
    }

    @NotNull
    @NlsContexts.Tooltip
    public static String createTooltip(@Nls String indentInfo, @NlsContexts.HintText String hint) {
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append(CodeStyleBundle.message((String)"indent.status.bar.indent.tooltip", (Object[])new Object[0])).append(" ").append(indentInfo);
        if (hint != null) {
            builder2.nbsp(2).append(HtmlChunk.span("color: " + ColorUtil.toHtmlColor(JBColor.GRAY)).addText(hint));
        }
        String string2 = builder2.wrapWith("html").toString();
        if (string2 == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public String getStatusText(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(3);
        }
        Object widgetText = IndentStatusBarUIContributor.getIndentInfo(this.myIndentOptions);
        CommonCodeStyleSettings.IndentOptions projectIndentOptions = CodeStyle.getSettings((Project)psiFile.getProject()).getLanguageIndentOptions(psiFile.getLanguage());
        if (!projectIndentOptions.equals((Object)this.myIndentOptions)) {
            widgetText = (String)widgetText + "*";
        }
        String string2 = widgetText;
        if (string2 == null) {
            IndentStatusBarUIContributor.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/IndentStatusBarUIContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/IndentStatusBarUIContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInfo";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 4 -> new IllegalStateException(string2);
        };
    }
}

