/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProviderService;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageCodeStyleSettingsProvider
extends CodeStyleSettingsProvider
implements LanguageCodeStyleProvider {
    public static final ExtensionPointName<LanguageCodeStyleSettingsProvider> EP_NAME = ExtensionPointName.create("com.intellij.langCodeStyleSettingsProvider");
    private static final AtomicReference<Set<LanguageCodeStyleSettingsProvider>> ourSettingsPagesProviders = new AtomicReference();

    @NotNull
    public static List<LanguageCodeStyleSettingsProvider> getAllProviders() {
        List<LanguageCodeStyleSettingsProvider> list2 = LanguageCodeStyleSettingsProviderService.getInstance().getAllProviders();
        if (list2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    public abstract String getCodeSample(@NotNull SettingsType var1);

    public int getRightMargin(@NotNull SettingsType settingsType) {
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return settingsType == SettingsType.WRAPPING_AND_BRACES_SETTINGS ? 30 : -1;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer2, @NotNull SettingsType settingsType) {
        if (consumer2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
    }

    @Nullable
    public static CommonCodeStyleSettings getDefaultCommonSettings(Language lang) {
        LanguageCodeStyleSettingsProvider provider2 = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider2 != null ? provider2.getDefaultCommonSettings() : null;
    }

    @Nullable
    public String getFileExt() {
        return null;
    }

    @Nullable
    @NlsContexts.Label
    public String getLanguageName() {
        return null;
    }

    @NotNull
    public String getExternalLanguageId() {
        String string2 = StringUtil.toLowerCase(this.getLanguage().getID());
        if (string2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull Project project2, @NotNull String text2) {
        if (project2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Deprecated
    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings(this.getLanguage());
        defaultSettings.initIndentOptions();
        this.customizeDefaults(defaultSettings, defaultSettings.getIndentOptions());
        CommonCodeStyleSettings commonCodeStyleSettings = defaultSettings;
        if (commonCodeStyleSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        return commonCodeStyleSettings;
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        if (indentOptions == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
    }

    @Deprecated
    public DisplayPriority getDisplayPriority() {
        return this.getPriority();
    }

    public List<Language> getApplicableLanguages() {
        return LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
    }

    @NotNull
    public static List<Language> getLanguagesWithCodeStyleSettings() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (LanguageCodeStyleSettingsProvider provider2 : LanguageCodeStyleSettingsProvider.getAllProviders()) {
            languages.add(provider2.getLanguage());
        }
        languages.sort((l1, l2) -> Comparing.compare(LanguageCodeStyleSettingsProvider.getLanguageName(l1), LanguageCodeStyleSettingsProvider.getLanguageName(l2)));
        ArrayList<Language> arrayList = languages;
        if (arrayList == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public static String getCodeSample(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider2;
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        return (provider2 = LanguageCodeStyleSettingsProvider.forLanguage(lang)) != null ? provider2.getCodeSample(settingsType) : null;
    }

    public static int getRightMargin(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider2;
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        return (provider2 = LanguageCodeStyleSettingsProvider.forLanguage(lang)) != null ? provider2.getRightMargin(settingsType) : -1;
    }

    @Override
    @NotNull
    public abstract Language getLanguage();

    @Nullable
    public static Language getLanguage(String langName) {
        for (LanguageCodeStyleSettingsProvider provider2 : LanguageCodeStyleSettingsProvider.getAllProviders()) {
            String name = provider2.getLanguageName();
            if (name == null) {
                name = provider2.getLanguage().getDisplayName();
            }
            if (!langName.equals(name)) continue;
            return provider2.getLanguage();
        }
        return null;
    }

    @Nullable
    public static String getFileExt(Language lang) {
        LanguageCodeStyleSettingsProvider provider2 = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider2 != null ? provider2.getFileExt() : null;
    }

    @NotNull
    @NlsSafe
    public static String getLanguageName(Language lang) {
        LanguageCodeStyleSettingsProvider provider2 = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        String providerLangName = provider2 != null ? provider2.getLanguageName() : null;
        String string2 = providerLangName != null ? providerLangName : lang.getDisplayName();
        if (string2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider forLanguage(Language language) {
        for (LanguageCodeStyleSettingsProvider provider2 : LanguageCodeStyleSettingsProvider.getAllProviders()) {
            if (!provider2.getLanguage().equals(language)) continue;
            return provider2;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider findUsingBaseLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(14);
        }
        for (Language currLang = language; currLang != null; currLang = currLang.getBaseLanguage()) {
            LanguageCodeStyleSettingsProvider curr = LanguageCodeStyleSettingsProvider.forLanguage(currLang);
            if (curr == null) continue;
            return curr;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider findByExternalLanguageId(@NotNull String languageId) {
        if (languageId == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(15);
        }
        return (LanguageCodeStyleSettingsProvider)((Object)ContainerUtil.find(LanguageCodeStyleSettingsProvider.getAllProviders(), provider2 -> provider2.getExternalLanguageId().equals(languageId)));
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return null;
    }

    public Set<String> getSupportedFields() {
        return new SupportedFieldCollector().collectFields();
    }

    public Set<String> getSupportedFields(SettingsType type) {
        return new SupportedFieldCollector().collectFields(type);
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(16);
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(17);
        }
        return docCommentSettings;
    }

    @Override
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(18);
        }
        if (modelSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(19);
        }
        throw new RuntimeException(this.getClass().getCanonicalName() + " for language #" + this.getLanguage().getID() + " doesn't implement createConfigurable()");
    }

    public static Set<LanguageCodeStyleSettingsProvider> getSettingsPagesProviders() {
        return ourSettingsPagesProviders.updateAndGet(providers -> providers != null ? providers : LanguageCodeStyleSettingsProvider.calcSettingPagesProviders());
    }

    @NotNull
    private static Set<LanguageCodeStyleSettingsProvider> calcSettingPagesProviders() {
        HashSet<LanguageCodeStyleSettingsProvider> settingsPagesProviders = new HashSet<LanguageCodeStyleSettingsProvider>();
        for (LanguageCodeStyleSettingsProvider provider2 : LanguageCodeStyleSettingsProvider.getAllProviders()) {
            LanguageCodeStyleSettingsProvider.registerSettingsPageProvider(settingsPagesProviders, provider2);
        }
        HashSet<LanguageCodeStyleSettingsProvider> hashSet = settingsPagesProviders;
        if (hashSet == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @ApiStatus.Internal
    public static void registerSettingsPageProvider(@NotNull LanguageCodeStyleSettingsProvider provider2) {
        if (provider2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(21);
        }
        LanguageCodeStyleSettingsProvider.registerSettingsPageProvider(LanguageCodeStyleSettingsProvider.getSettingsPagesProviders(), provider2);
    }

    @ApiStatus.Internal
    public static void unregisterSettingsPageProvider(@NotNull LanguageCodeStyleSettingsProvider provider2) {
        if (provider2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(22);
        }
        LanguageCodeStyleSettingsProvider.getSettingsPagesProviders().remove(provider2);
    }

    private static void registerSettingsPageProvider(@NotNull Set<? super LanguageCodeStyleSettingsProvider> settingsPagesProviders, @NotNull LanguageCodeStyleSettingsProvider provider2) {
        if (settingsPagesProviders == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(23);
        }
        if (provider2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(24);
        }
        try {
            Method configMethod = provider2.getClass().getMethod("createConfigurable", CodeStyleSettings.class, CodeStyleSettings.class);
            Class<?> declaringClass = configMethod.getDeclaringClass();
            if (!declaringClass.equals(LanguageCodeStyleSettingsProvider.class)) {
                settingsPagesProviders.add(provider2);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @ApiStatus.Experimental
    @NotNull
    public final AbstractCodeStylePropertyMapper getPropertyMapper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(25);
        }
        return new LanguageCodeStylePropertyMapper(settings, this.getLanguage(), this.getExternalLanguageId());
    }

    @ApiStatus.Experimental
    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(26);
        }
        if (field == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(27);
        }
        return null;
    }

    public List<CodeStylePropertyAccessor> getAdditionalAccessors(@NotNull Object codeStyleObject) {
        if (codeStyleObject == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(28);
        }
        return Collections.emptyList();
    }

    public boolean supportsExternalFormats() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsPagesProviders";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProviders";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLanguageId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCommonSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesWithCodeStyleSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSettingPagesProviders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findUsingBaseLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findByExternalLanguageId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerSettingsPageProvider";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "unregisterSettingsPageProvider";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMapper";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAccessors";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 5, 6, 8, 9, 11, 12, 14, 15, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28 -> new IllegalArgumentException(string2);
        };
    }

    public static enum SettingsType {
        BLANK_LINES_SETTINGS,
        SPACING_SETTINGS,
        WRAPPING_AND_BRACES_SETTINGS,
        INDENT_SETTINGS,
        COMMENTER_SETTINGS,
        LANGUAGE_SPECIFIC;

    }

    private final class SupportedFieldCollector
    implements CodeStyleSettingsCustomizable {
        private final Set<String> myCollectedFields = new HashSet<String>();
        private SettingsType myCurrSettingsType;

        private SupportedFieldCollector() {
        }

        Set<String> collectFields() {
            SettingsType[] settingsTypeArray = SettingsType.values();
            int n = settingsTypeArray.length;
            for (int j = 0; j < n; ++j) {
                SettingsType settingsType;
                this.myCurrSettingsType = settingsType = settingsTypeArray[j];
                LanguageCodeStyleSettingsProvider.this.customizeSettings(this, settingsType);
            }
            return this.myCollectedFields;
        }

        Set<String> collectFields(SettingsType type) {
            this.myCurrSettingsType = type;
            LanguageCodeStyleSettingsProvider.this.customizeSettings(this, type);
            return this.myCollectedFields;
        }

        @Override
        public void showAllStandardOptions() {
            switch (this.myCurrSettingsType) {
                case BLANK_LINES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.BlankLinesOption blankLinesOption : CodeStyleSettingsCustomizable.BlankLinesOption.values()) {
                        this.myCollectedFields.add(blankLinesOption.name());
                    }
                    break;
                }
                case SPACING_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.SpacingOption spacingOption : CodeStyleSettingsCustomizable.SpacingOption.values()) {
                        this.myCollectedFields.add(spacingOption.name());
                    }
                    break;
                }
                case WRAPPING_AND_BRACES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.WrappingOrBraceOption wrappingOrBraceOption : CodeStyleSettingsCustomizable.WrappingOrBraceOption.values()) {
                        this.myCollectedFields.add(wrappingOrBraceOption.name());
                    }
                    break;
                }
                case COMMENTER_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.CommenterOption commenterOption : CodeStyleSettingsCustomizable.CommenterOption.values()) {
                        this.myCollectedFields.add(commenterOption.name());
                    }
                    break;
                }
                case INDENT_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.IndentOption indentOption : CodeStyleSettingsCustomizable.IndentOption.values()) {
                        this.myCollectedFields.add(indentOption.name());
                    }
                    break;
                }
            }
        }

        @Override
        public void showStandardOptions(String ... optionNames) {
            ContainerUtil.addAll(this.myCollectedFields, optionNames);
        }

        @Override
        public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title, @Nls @Nullable String groupName, Object ... options2) {
            if (settingsClass == null) {
                SupportedFieldCollector.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                SupportedFieldCollector.$$$reportNull$$$0(1);
            }
            if (title == null) {
                SupportedFieldCollector.$$$reportNull$$$0(2);
            }
            this.myCollectedFields.add(fieldName);
        }

        @Override
        public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title, @Nls @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @NonNls @Nullable String anchorFieldName, Object ... options2) {
            if (settingsClass == null) {
                SupportedFieldCollector.$$$reportNull$$$0(3);
            }
            if (fieldName == null) {
                SupportedFieldCollector.$$$reportNull$$$0(4);
            }
            if (title == null) {
                SupportedFieldCollector.$$$reportNull$$$0(5);
            }
            this.myCollectedFields.add(fieldName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingsClass";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SupportedFieldCollector";
            objectArray[2] = "showCustomOption";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

