/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsContributor;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
final class LanguageCodeStyleSettingsProviderService
implements Disposable {
    private volatile List<LanguageCodeStyleSettingsProvider> allProviders;
    private final Object lock = new Object();

    public static LanguageCodeStyleSettingsProviderService getInstance() {
        return ApplicationManager.getApplication().getService(LanguageCodeStyleSettingsProviderService.class);
    }

    public LanguageCodeStyleSettingsProviderService() {
        LanguageCodeStyleSettingsProvider.EP_NAME.addChangeListener(() -> {
            this.allProviders = null;
        }, this);
        LanguageCodeStyleSettingsContributor.EP_NAME.addChangeListener(() -> {
            this.allProviders = null;
        }, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<LanguageCodeStyleSettingsProvider> getAllProviders() {
        List<LanguageCodeStyleSettingsProvider> providers = this.allProviders;
        if (providers != null) {
            List<LanguageCodeStyleSettingsProvider> list2 = providers;
            if (list2 == null) {
                LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Object object = this.lock;
        synchronized (object) {
            providers = this.allProviders;
            if (providers != null) {
                List<LanguageCodeStyleSettingsProvider> list3 = providers;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                if (list3 == null) {
                    LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(1);
                }
                return list3;
            }
            this.allProviders = providers = LanguageCodeStyleSettingsProviderService.computeAllProviders();
        }
        List<LanguageCodeStyleSettingsProvider> list4 = providers;
        if (list4 == null) {
            LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(2);
        }
        return list4;
    }

    @NotNull
    private static List<LanguageCodeStyleSettingsProvider> computeAllProviders() {
        List<LanguageCodeStyleSettingsProvider> extensions2 = LanguageCodeStyleSettingsProvider.EP_NAME.getExtensionList();
        List<LanguageCodeStyleSettingsContributor> contributors = LanguageCodeStyleSettingsContributor.EP_NAME.getExtensionList();
        if (contributors.isEmpty()) {
            List<LanguageCodeStyleSettingsProvider> list2 = extensions2;
            if (list2 == null) {
                LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(3);
            }
            return list2;
        }
        ArrayList<LanguageCodeStyleSettingsProvider> allExtensions = new ArrayList<LanguageCodeStyleSettingsProvider>(extensions2);
        for (LanguageCodeStyleSettingsContributor contributor : contributors) {
            allExtensions.addAll(contributor.getProviders());
        }
        ArrayList<LanguageCodeStyleSettingsProvider> arrayList = allExtensions;
        if (arrayList == null) {
            LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProviderService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProviders";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllProviders";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

