/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.LanguageAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.TextAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEntryWrapper;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementMoveInfo;
import com.intellij.psi.codeStyle.arrangement.engine.RestoreFoldArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.CustomArrangementOrderToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class ArrangementEngine {
    private boolean myCodeChanged;

    public static ArrangementEngine getInstance() {
        return ApplicationManager.getApplication().getService(ArrangementEngine.class);
    }

    @Nullable
    @NlsContexts.HintText
    public String getUserNotificationInfo() {
        if (this.myCodeChanged) {
            return CodeInsightBundle.message("hint.text.rearranged.code", new Object[0]);
        }
        return null;
    }

    public void arrange(@NotNull Editor editor2, @NotNull PsiFile file2, Collection<? extends TextRange> ranges2) {
        if (editor2 == null) {
            ArrangementEngine.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ArrangementEngine.$$$reportNull$$$0(1);
        }
        this.arrange(file2, ranges2, new RestoreFoldArrangementCallback(editor2));
    }

    public void arrange(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges2) {
        if (file2 == null) {
            ArrangementEngine.$$$reportNull$$$0(2);
        }
        if (ranges2 == null) {
            ArrangementEngine.$$$reportNull$$$0(3);
        }
        this.arrange(file2, ranges2, null);
    }

    public void arrange(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges2, @Nullable ArrangementCallback callback) {
        if (file2 == null) {
            ArrangementEngine.$$$reportNull$$$0(4);
        }
        if (ranges2 == null) {
            ArrangementEngine.$$$reportNull$$$0(5);
        }
        this.myCodeChanged = false;
        Document document = PsiDocumentManager.getInstance(file2.getProject()).getDocument(file2);
        if (document == null || !document.isWritable()) {
            return;
        }
        Rearranger rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(file2.getLanguage());
        if (rearranger == null) {
            return;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file2);
        if (settings.getExcludedFiles().contains(file2)) {
            return;
        }
        ArrangementSettings arrangementSettings = ArrangementUtil.getArrangementSettings((CodeStyleSettings)settings, (Language)file2.getLanguage());
        if (arrangementSettings == null) {
            return;
        }
        Context context2 = DumbService.getInstance(file2.getProject()).computeWithAlternativeResolveEnabled(() -> Context.from(rearranger, document, file2, ranges2, arrangementSettings, settings));
        ApplicationManager.getApplication().runWriteAction(() -> VcsFacade.getInstance().runHeavyModificationTask(file2.getProject(), document, () -> {
            this.doArrange(context2);
            if (callback != null) {
                callback.afterArrangement(context2.moveInfos);
            }
        }));
    }

    private <E extends ArrangementEntry> void doArrange(Context<E> context2) {
        Stack<StackEntry> stack = new Stack<StackEntry>();
        ArrayList entries2 = new ArrayList(context2.wrappers);
        stack.push(new StackEntry(0, context2.wrappers.size()));
        while (!stack.isEmpty()) {
            ArrangementEntryWrapper wrapper2;
            List children2;
            StackEntry stackEntry = (StackEntry)stack.peek();
            if (stackEntry.current >= stackEntry.end) {
                List subEntries = entries2.subList(stackEntry.start, stackEntry.end);
                this.doArrange(subEntries, context2);
                subEntries.clear();
                stack.pop();
                continue;
            }
            if ((children2 = (wrapper2 = (ArrangementEntryWrapper)entries2.get(stackEntry.current++)).getChildren()).isEmpty()) continue;
            entries2.addAll(children2);
            stack.push(new StackEntry(stackEntry.end, children2.size()));
        }
    }

    @NotNull
    public static <E extends ArrangementEntry> List<E> arrange(@NotNull Collection<? extends E> entries2, @NotNull List<ArrangementSectionRule> sectionRules, @NotNull List<? extends ArrangementMatchRule> rulesByPriority, @Nullable Map<E, ArrangementSectionRule> entryToSection) {
        if (entries2 == null) {
            ArrangementEngine.$$$reportNull$$$0(6);
        }
        if (sectionRules == null) {
            ArrangementEngine.$$$reportNull$$$0(7);
        }
        if (rulesByPriority == null) {
            ArrangementEngine.$$$reportNull$$$0(8);
        }
        ArrayList<Object> arranged = new ArrayList<Object>();
        LinkedHashSet<ArrangementEntry> unprocessed = new LinkedHashSet<ArrangementEntry>();
        ArrayList dependent = new ArrayList();
        for (ArrangementEntry entry : entries2) {
            List dependencies = entry.getDependencies();
            if (dependencies == null) {
                unprocessed.add(entry);
                continue;
            }
            if (dependencies.size() == 1 && dependencies.get(0) == entry.getParent()) {
                arranged.add(entry);
                continue;
            }
            HashSet hashSet = new HashSet(dependencies);
            dependent.add(Pair.create(hashSet, entry));
        }
        HashSet<ArrangementEntry> matched = new HashSet<ArrangementEntry>();
        MultiMap<ArrangementMatchRule, ArrangementEntry> elementsByRule = new MultiMap<ArrangementMatchRule, ArrangementEntry>();
        for (ArrangementMatchRule arrangementMatchRule : rulesByPriority) {
            matched.clear();
            for (ArrangementEntry entry : unprocessed) {
                if (!entry.canBeMatched() || !arrangementMatchRule.getMatcher().isMatched(entry)) continue;
                elementsByRule.putValue(arrangementMatchRule, entry);
                matched.add(entry);
            }
            unprocessed.removeAll(matched);
        }
        for (ArrangementSectionRule arrangementSectionRule : sectionRules) {
            for (ArrangementMatchRule rule : arrangementSectionRule.getMatchRules()) {
                Collection<ArrangementEntry> arrangedEntries = ArrangementEngine.arrangeByRule(arranged, elementsByRule, rule);
                if (entryToSection == null || arrangedEntries == null) continue;
                for (ArrangementEntry entry : arrangedEntries) {
                    entryToSection.put(entry, arrangementSectionRule);
                }
            }
        }
        arranged.addAll(unprocessed);
        for (int i2 = 0; i2 < arranged.size() && !dependent.isEmpty(); ++i2) {
            ArrangementEntry arrangementEntry = (ArrangementEntry)arranged.get(i2);
            ArrayList<ArrangementEntry> shouldBeAddedAfterCurrentElement = new ArrayList<ArrangementEntry>();
            Iterator iterator2 = dependent.iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                ((Set)pair.first).remove(arrangementEntry);
                if (!((Set)pair.first).isEmpty()) continue;
                iterator2.remove();
                shouldBeAddedAfterCurrentElement.add((ArrangementEntry)pair.second);
            }
            if (entryToSection != null && entryToSection.containsKey(arrangementEntry)) {
                ArrangementMatchRule rule;
                rule = entryToSection.get(arrangementEntry);
                for (ArrangementEntry e1 : shouldBeAddedAfterCurrentElement) {
                    entryToSection.put(e1, (ArrangementSectionRule)rule);
                }
            }
            arranged.addAll(i2 + 1, shouldBeAddedAfterCurrentElement);
        }
        ArrayList<Object> arrayList = arranged;
        if (arrayList == null) {
            ArrangementEngine.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static <E extends ArrangementEntry> Collection<E> arrangeByRule(@NotNull List<? super E> arranged, @NotNull MultiMap<ArrangementMatchRule, E> elementsByRule, @NotNull ArrangementMatchRule rule) {
        if (arranged == null) {
            ArrangementEngine.$$$reportNull$$$0(10);
        }
        if (elementsByRule == null) {
            ArrangementEngine.$$$reportNull$$$0(11);
        }
        if (rule == null) {
            ArrangementEngine.$$$reportNull$$$0(12);
        }
        if (elementsByRule.containsKey(rule)) {
            List arrangedEntries = (List)elementsByRule.remove(rule);
            assert (arrangedEntries != null);
            ArrangementSettingsToken order = rule.getOrderType();
            if (order instanceof CustomArrangementOrderToken) {
                arrangedEntries.sort(((CustomArrangementOrderToken)order).getEntryComparator());
            } else if (rule.getOrderType().equals((Object)StdArrangementTokens.Order.BY_NAME)) {
                ArrangementEngine.sortByName(arrangedEntries);
            }
            arranged.addAll(arrangedEntries);
            return arrangedEntries;
        }
        return null;
    }

    private static <E extends ArrangementEntry> void sortByName(@NotNull List<E> entries2) {
        if (entries2 == null) {
            ArrangementEngine.$$$reportNull$$$0(13);
        }
        if (entries2.size() < 2) {
            return;
        }
        Object2IntOpenHashMap<ArrangementEntry> weights = new Object2IntOpenHashMap<ArrangementEntry>();
        int i2 = 0;
        for (ArrangementEntry e : entries2) {
            weights.put(e, ++i2);
        }
        ContainerUtil.sort(entries2, (e1, e2) -> {
            String name2;
            String name1 = e1 instanceof NameAwareArrangementEntry ? ((NameAwareArrangementEntry)e1).getName() : null;
            String string2 = name2 = e2 instanceof NameAwareArrangementEntry ? ((NameAwareArrangementEntry)e2).getName() : null;
            if (name1 != null && name2 != null) {
                return name1.compareTo(name2);
            }
            if (name1 == null && name2 == null) {
                return weights.getInt(e1) - weights.getInt(e2);
            }
            if (name2 == null) {
                return -1;
            }
            return 1;
        });
    }

    private <E extends ArrangementEntry> void doArrange(@NotNull List<? extends ArrangementEntryWrapper<E>> wrappers, @NotNull Context<E> context2) {
        if (wrappers == null) {
            ArrangementEngine.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            ArrangementEngine.$$$reportNull$$$0(15);
        }
        if (wrappers.isEmpty()) {
            return;
        }
        HashMap entryToSection = new HashMap();
        HashMap<E, ArrangementEntryWrapper<E>> map2 = new HashMap<E, ArrangementEntryWrapper<E>>();
        ArrayList arranged = new ArrayList();
        ArrayList<E> toArrange = new ArrayList<E>();
        for (ArrangementEntryWrapper<E> wrapper2 : wrappers) {
            E entry = wrapper2.getEntry();
            map2.put(wrapper2.getEntry(), wrapper2);
            if (!entry.canBeMatched()) {
                arranged.add(entry);
                toArrange.clear();
                continue;
            }
            toArrange.add(entry);
        }
        if (!toArrange.isEmpty()) {
            ArrangementEntry contextEntry = (ArrangementEntry)toArrange.get(0);
            Language language = contextEntry instanceof LanguageAwareArrangementEntry ? ((LanguageAwareArrangementEntry)contextEntry).getLanguage() : null;
            ArrangementSettings settings = context2.getArrangementSettings(language);
            List rulesByPriority = settings.getRulesSortedByPriority();
            List sectionRules = ArrangementUtil.getExtendedSectionRules((ArrangementSettings)settings);
            arranged.addAll(ArrangementEngine.arrange(toArrange, sectionRules, rulesByPriority, entryToSection));
        }
        NewSectionInfo newSectionsInfo = NewSectionInfo.create(arranged, entryToSection);
        context2.changer.prepare(wrappers, context2);
        for (int i2 = arranged.size() - 1; i2 >= 0; --i2) {
            ArrangementEntryWrapper arrangedWrapper = (ArrangementEntryWrapper)map2.get(arranged.get(i2));
            ArrangementEntryWrapper<E> initialWrapper = wrappers.get(i2);
            ArrangementEntryWrapper previous = i2 > 0 ? (ArrangementEntryWrapper)map2.get(arranged.get(i2 - 1)) : null;
            ArrangementEntryWrapper<E> previousInitial = i2 > 0 ? wrappers.get(i2 - 1) : null;
            ArrangementEntryWrapper<E> parentWrapper = initialWrapper.getParent();
            if (arrangedWrapper.equals(initialWrapper) && (previous != null && previous.equals(previousInitial) || previous == null && previousInitial == null)) {
                int beforeOffset = arrangedWrapper.getStartOffset();
                int afterOffset = arrangedWrapper.getEndOffset();
                boolean isInserted = context2.changer.insertSection(context2, (ArrangementEntry)arranged.get(i2), newSectionsInfo, parentWrapper, beforeOffset, afterOffset);
                this.myCodeChanged = isInserted || this.myCodeChanged;
                continue;
            }
            ArrangementEntryWrapper next2 = i2 < arranged.size() - 1 ? (ArrangementEntryWrapper)map2.get(arranged.get(i2 + 1)) : null;
            context2.changer.replace(arrangedWrapper, initialWrapper, previous, next2, context2);
            context2.changer.insertSection(context2, (ArrangementEntry)arranged.get(i2), newSectionsInfo, arrangedWrapper, initialWrapper, parentWrapper);
            this.myCodeChanged = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionRules";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rulesByPriority";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arranged";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsByRule";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "arrange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "arrange";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "arrangeByRule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortByName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doArrange";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9 -> new IllegalStateException(string2);
        };
    }

    private static final class Context<E extends ArrangementEntry> {
        @NotNull
        public final List<ArrangementMoveInfo> moveInfos;
        @NotNull
        private final Rearranger<E> rearranger;
        @NotNull
        public final Collection<ArrangementEntryWrapper<E>> wrappers;
        @NotNull
        public final Document document;
        @NotNull
        private final ArrangementSettings arrangementSettings;
        @NotNull
        public final CodeStyleSettings settings;
        @NotNull
        public final Changer changer;

        private Context(@NotNull Rearranger<E> rearranger, @NotNull Collection<ArrangementEntryWrapper<E>> wrappers, @NotNull Document document, @NotNull ArrangementSettings arrangementSettings, @NotNull CodeStyleSettings settings, @NotNull Changer changer) {
            if (rearranger == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (wrappers == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (document == null) {
                Context.$$$reportNull$$$0(2);
            }
            if (arrangementSettings == null) {
                Context.$$$reportNull$$$0(3);
            }
            if (settings == null) {
                Context.$$$reportNull$$$0(4);
            }
            if (changer == null) {
                Context.$$$reportNull$$$0(5);
            }
            this.moveInfos = new ArrayList<ArrangementMoveInfo>();
            this.rearranger = rearranger;
            this.wrappers = wrappers;
            this.document = document;
            this.arrangementSettings = arrangementSettings;
            this.settings = settings;
            this.changer = changer;
        }

        public void addMoveInfo(int oldStart, int oldEnd, int newStart) {
            this.moveInfos.add(new ArrangementMoveInfo(oldStart, oldEnd, newStart));
        }

        @NotNull
        public ArrangementSettings getArrangementSettings(@Nullable Language languageOverride) {
            ArrangementSettings languageSettings;
            if (languageOverride != null && (languageSettings = ArrangementUtil.getArrangementSettings((CodeStyleSettings)this.settings, (Language)languageOverride)) != null) {
                ArrangementSettings arrangementSettings = languageSettings;
                if (arrangementSettings == null) {
                    Context.$$$reportNull$$$0(6);
                }
                return arrangementSettings;
            }
            ArrangementSettings arrangementSettings = this.arrangementSettings;
            if (arrangementSettings == null) {
                Context.$$$reportNull$$$0(7);
            }
            return arrangementSettings;
        }

        @NotNull
        public Rearranger<E> getRearranger(@Nullable Language language) {
            Rearranger forLanguage;
            if (language != null && (forLanguage = (Rearranger)Rearranger.EXTENSION.forLanguage(language)) != null) {
                Rearranger rearranger = forLanguage;
                if (rearranger == null) {
                    Context.$$$reportNull$$$0(8);
                }
                return rearranger;
            }
            Rearranger<E> rearranger = this.rearranger;
            if (rearranger == null) {
                Context.$$$reportNull$$$0(9);
            }
            return rearranger;
        }

        public static <T extends ArrangementEntry> Context<T> from(@NotNull Rearranger<T> rearranger, @NotNull Document document, @NotNull PsiElement root, @NotNull Collection<? extends TextRange> ranges2, @NotNull ArrangementSettings arrangementSettings, @NotNull CodeStyleSettings codeStyleSettings) {
            if (rearranger == null) {
                Context.$$$reportNull$$$0(10);
            }
            if (document == null) {
                Context.$$$reportNull$$$0(11);
            }
            if (root == null) {
                Context.$$$reportNull$$$0(12);
            }
            if (ranges2 == null) {
                Context.$$$reportNull$$$0(13);
            }
            if (arrangementSettings == null) {
                Context.$$$reportNull$$$0(14);
            }
            if (codeStyleSettings == null) {
                Context.$$$reportNull$$$0(15);
            }
            List entries2 = rearranger.parse(root, document, ranges2, arrangementSettings);
            ArrayList<ArrangementEntryWrapper<ArrangementEntryWrapper<ArrangementEntry>>> wrappers = new ArrayList<ArrangementEntryWrapper<ArrangementEntryWrapper<ArrangementEntry>>>();
            ArrangementEntryWrapper<ArrangementEntry> previous = null;
            for (ArrangementEntry entry : entries2) {
                ArrangementEntryWrapper<ArrangementEntry> wrapper2 = new ArrangementEntryWrapper<ArrangementEntry>(entry);
                if (previous != null) {
                    previous.setNext(wrapper2);
                    wrapper2.setPrevious(previous);
                }
                wrappers.add(wrapper2);
                previous = wrapper2;
            }
            Changer changer = document instanceof DocumentEx ? new RangeMarkerAwareChanger((DocumentEx)document) : new DefaultChanger();
            return new Context<T>(rearranger, wrappers, document, arrangementSettings, codeStyleSettings, changer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rearranger";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 2: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrangementSettings";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changer";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeStyleSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrangementSettings";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRearranger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 6, 7, 8, 9 -> new IllegalStateException(string2);
            };
        }
    }

    private static class StackEntry {
        public int start;
        public int current;
        public int end;

        StackEntry(int start, int count2) {
            this.start = start;
            this.current = start;
            this.end = start + count2;
        }
    }

    private static class NewSectionInfo<E extends ArrangementEntry> {
        private final Map<E, String> mySectionStarts = new HashMap<E, String>();
        private final Map<E, String> mySectionEnds = new HashMap<E, String>();

        private NewSectionInfo() {
        }

        private static <E extends ArrangementEntry> NewSectionInfo create(@NotNull List<? extends E> arranged, @NotNull Map<E, ArrangementSectionRule> entryToSection) {
            if (arranged == null) {
                NewSectionInfo.$$$reportNull$$$0(0);
            }
            if (entryToSection == null) {
                NewSectionInfo.$$$reportNull$$$0(1);
            }
            NewSectionInfo<ArrangementEntry> info2 = new NewSectionInfo<ArrangementEntry>();
            boolean sectionIsOpen = false;
            ArrangementSectionRule prevSection = null;
            ArrangementEntry prev = null;
            for (ArrangementEntry e : arranged) {
                ArrangementSectionRule section = entryToSection.get(e);
                if (section != prevSection) {
                    String startComment;
                    NewSectionInfo.closeSection(prevSection, prev, info2, sectionIsOpen);
                    sectionIsOpen = false;
                    if (section != null && StringUtil.isNotEmpty(startComment = section.getStartComment()) && !NewSectionInfo.isSectionEntry(e, startComment)) {
                        sectionIsOpen = true;
                        info2.addSectionStart(e, startComment);
                    }
                    prevSection = section;
                }
                prev = e;
            }
            NewSectionInfo.closeSection(prevSection, prev, info2, sectionIsOpen);
            return info2;
        }

        public static boolean isSectionEntry(@NotNull ArrangementEntry entry, @NotNull String sectionText) {
            ArrangementSettingsToken type;
            Set types;
            if (entry == null) {
                NewSectionInfo.$$$reportNull$$$0(2);
            }
            if (sectionText == null) {
                NewSectionInfo.$$$reportNull$$$0(3);
            }
            if (entry instanceof TypeAwareArrangementEntry && entry instanceof TextAwareArrangementEntry && (types = ((TypeAwareArrangementEntry)entry).getTypes()).size() == 1 && ((type = (ArrangementSettingsToken)types.iterator().next()).equals((Object)StdArrangementTokens.Section.START_SECTION) || type.equals((Object)StdArrangementTokens.Section.END_SECTION))) {
                return StringUtil.equals(((TextAwareArrangementEntry)entry).getText(), sectionText);
            }
            return false;
        }

        private static <E extends ArrangementEntry> void closeSection(@Nullable ArrangementSectionRule section, @Nullable E entry, @NotNull NewSectionInfo<E> info2, boolean sectionIsOpen) {
            if (info2 == null) {
                NewSectionInfo.$$$reportNull$$$0(4);
            }
            if (sectionIsOpen) {
                assert (section != null && entry != null);
                if (StringUtil.isNotEmpty(section.getEndComment())) {
                    info2.addSectionEnd(entry, section.getEndComment());
                }
            }
        }

        private void addSectionStart(E entry, String comment) {
            this.mySectionStarts.put(entry, comment);
        }

        private void addSectionEnd(E entry, String comment) {
            this.mySectionEnds.put(entry, comment);
        }

        @Nullable
        public String getStartComment(E entry) {
            return this.mySectionStarts.get(entry);
        }

        @Nullable
        public String getEndComment(E entry) {
            return this.mySectionEnds.get(entry);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arranged";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryToSection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sectionText";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$NewSectionInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSectionEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "closeSection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Changer<E extends ArrangementEntry> {
        private Changer() {
        }

        public abstract void prepare(@NotNull List<? extends ArrangementEntryWrapper<E>> var1, @NotNull Context<E> var2);

        public abstract void replace(@NotNull ArrangementEntryWrapper<E> var1, @NotNull ArrangementEntryWrapper<E> var2, @Nullable ArrangementEntryWrapper<E> var3, @Nullable ArrangementEntryWrapper<E> var4, @NotNull Context<E> var5);

        public abstract void insert(@NotNull Context<E> var1, int var2, @NotNull String var3);

        public abstract void insertSection(@NotNull Context<E> var1, @NotNull E var2, @NotNull NewSectionInfo<E> var3, @NotNull ArrangementEntryWrapper<E> var4, @NotNull ArrangementEntryWrapper<E> var5, @Nullable ArrangementEntryWrapper<E> var6);

        protected abstract boolean insertSection(@NotNull Context<E> var1, @NotNull E var2, @NotNull NewSectionInfo<E> var3, @Nullable ArrangementEntryWrapper<E> var4, int var5, int var6);

        protected int getBlankLines(@NotNull Context<E> context2, @Nullable ArrangementEntryWrapper<E> parentWrapper, @NotNull ArrangementEntryWrapper<E> targetWrapper, @Nullable ArrangementEntryWrapper<E> previousWrapper, @Nullable ArrangementEntryWrapper<E> nextWrapper) {
            ArrangementEntry previous;
            if (context2 == null) {
                Changer.$$$reportNull$$$0(0);
            }
            if (targetWrapper == null) {
                Changer.$$$reportNull$$$0(1);
            }
            E target2 = targetWrapper.getEntry();
            ArrangementEntry arrangementEntry = previous = previousWrapper == null ? null : (ArrangementEntry)previousWrapper.getEntry();
            if (this.isTypeOf(target2, StdArrangementTokens.Section.END_SECTION) || this.isTypeOf(previous, StdArrangementTokens.Section.START_SECTION)) {
                return 0;
            }
            ArrangementEntry next2 = nextWrapper == null ? null : (ArrangementEntry)nextWrapper.getEntry();
            ArrangementEntry parentEntry = parentWrapper == null ? null : (ArrangementEntry)parentWrapper.getEntry();
            Language language = parentEntry instanceof LanguageAwareArrangementEntry ? ((LanguageAwareArrangementEntry)parentEntry).getLanguage() : null;
            Rearranger<E> rearranger = context2.getRearranger(language);
            if (next2 != null && this.isTypeOf(target2, StdArrangementTokens.Section.START_SECTION)) {
                return rearranger.getBlankLines(context2.settings, parentEntry, previous, next2);
            }
            return rearranger.getBlankLines(context2.settings, parentEntry, previous, target2);
        }

        private boolean isTypeOf(@Nullable E element, @NotNull ArrangementSettingsToken token) {
            if (token == null) {
                Changer.$$$reportNull$$$0(2);
            }
            if (element instanceof TypeAwareArrangementEntry) {
                Set types = ((TypeAwareArrangementEntry)element).getTypes();
                return types.size() == 1 && token.equals(types.iterator().next());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetWrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Changer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBlankLines";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTypeOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RangeMarkerAwareChanger<E extends ArrangementEntry>
    extends Changer<E> {
        @NotNull
        private final List<ArrangementEntryWrapper<E>> myWrappers;
        @NotNull
        private final DocumentEx myDocument;

        RangeMarkerAwareChanger(@NotNull DocumentEx document) {
            if (document == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(0);
            }
            this.myWrappers = new ArrayList<ArrangementEntryWrapper<E>>();
            this.myDocument = document;
        }

        @Override
        public void prepare(@NotNull List<? extends ArrangementEntryWrapper<E>> toArrange, @NotNull Context<E> context2) {
            if (toArrange == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(1);
            }
            if (context2 == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(2);
            }
            this.myWrappers.clear();
            this.myWrappers.addAll(toArrange);
            for (ArrangementEntryWrapper<E> wrapper2 : toArrange) {
                wrapper2.updateBlankLines(this.myDocument);
            }
        }

        @Override
        public void replace(@NotNull ArrangementEntryWrapper<E> newWrapper, @NotNull ArrangementEntryWrapper<E> oldWrapper, @Nullable ArrangementEntryWrapper<E> previous, @Nullable ArrangementEntryWrapper<E> next2, @NotNull Context<E> context2) {
            if (newWrapper == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(3);
            }
            if (oldWrapper == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(4);
            }
            if (context2 == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(5);
            }
            int blankLinesBefore = oldWrapper.getBlankLinesBefore();
            ArrangementEntryWrapper<E> parentWrapper = oldWrapper.getParent();
            int desiredBlankLinesNumber = this.getBlankLines(context2, parentWrapper, newWrapper, previous, next2);
            if ((desiredBlankLinesNumber < 0 || desiredBlankLinesNumber == blankLinesBefore) && newWrapper.equals(oldWrapper)) {
                return;
            }
            int lineFeedsDiff = desiredBlankLinesNumber - blankLinesBefore;
            int insertionOffset = oldWrapper.getStartOffset();
            if (oldWrapper.getStartOffset() > newWrapper.getStartOffset()) {
                insertionOffset -= newWrapper.getEndOffset() - newWrapper.getStartOffset();
            }
            if (newWrapper.getStartOffset() != oldWrapper.getStartOffset() || !newWrapper.equals(oldWrapper)) {
                context2.addMoveInfo(newWrapper.getStartOffset(), newWrapper.getEndOffset(), oldWrapper.getStartOffset());
                this.myDocument.moveText(newWrapper.getStartOffset(), newWrapper.getEndOffset(), oldWrapper.getStartOffset());
                for (int i2 = this.myWrappers.size() - 1; i2 >= 0; --i2) {
                    ArrangementEntryWrapper<E> w = this.myWrappers.get(i2);
                    if (w == newWrapper) continue;
                    if (w.getStartOffset() >= oldWrapper.getStartOffset() && w.getStartOffset() < newWrapper.getStartOffset()) {
                        w.applyShift(newWrapper.getEndOffset() - newWrapper.getStartOffset());
                        continue;
                    }
                    if (oldWrapper == w || w.getStartOffset() > oldWrapper.getStartOffset() || w.getStartOffset() <= newWrapper.getStartOffset()) continue;
                    w.applyShift(newWrapper.getStartOffset() - newWrapper.getEndOffset());
                }
            }
            if (desiredBlankLinesNumber >= 0 && lineFeedsDiff > 0) {
                this.myDocument.insertString(insertionOffset, StringUtil.repeat("\n", lineFeedsDiff));
                this.shiftOffsets(lineFeedsDiff, insertionOffset);
            }
            if (desiredBlankLinesNumber >= 0 && lineFeedsDiff < 0) {
                int replacementStartOffset = this.getBlankLineOffset(-lineFeedsDiff, insertionOffset);
                this.myDocument.deleteString(replacementStartOffset, insertionOffset);
                this.shiftOffsets(replacementStartOffset - insertionOffset, insertionOffset);
            }
            if (desiredBlankLinesNumber < 0) {
                return;
            }
            this.updateAllWrapperRanges(parentWrapper, lineFeedsDiff);
        }

        protected void updateAllWrapperRanges(@Nullable ArrangementEntryWrapper<E> parentWrapper, int lineFeedsDiff) {
            if (lineFeedsDiff == 0 || parentWrapper == null) {
                return;
            }
            ArrayDeque<ArrangementEntryWrapper<E>> parents2 = new ArrayDeque<ArrangementEntryWrapper<E>>();
            do {
                parents2.add(parentWrapper);
                parentWrapper.setEndOffset(parentWrapper.getEndOffset() + lineFeedsDiff);
            } while ((parentWrapper = parentWrapper.getParent()) != null);
            while (!parents2.isEmpty()) {
                for (ArrangementEntryWrapper wrapper2 = ((ArrangementEntryWrapper)parents2.removeLast()).getNext(); wrapper2 != null; wrapper2 = wrapper2.getNext()) {
                    wrapper2.applyShift(lineFeedsDiff);
                }
            }
        }

        @Override
        public void insert(@NotNull Context<E> context2, int startOffset, @NotNull String text2) {
            if (context2 == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(7);
            }
            this.myDocument.insertString(startOffset, text2);
            int shift = text2.length();
            for (int i2 = this.myWrappers.size() - 1; i2 >= 0; --i2) {
                ArrangementEntryWrapper<E> wrapper2 = this.myWrappers.get(i2);
                if (wrapper2.getStartOffset() < startOffset) continue;
                wrapper2.applyShift(shift);
            }
        }

        @Override
        public void insertSection(@NotNull Context<E> context2, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @NotNull ArrangementEntryWrapper<E> arrangedWrapper, @NotNull ArrangementEntryWrapper<E> initialWrapper, @Nullable ArrangementEntryWrapper<E> parent2) {
            if (context2 == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(8);
            }
            if (entry == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(9);
            }
            if (newSectionsInfo == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(10);
            }
            if (arrangedWrapper == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(11);
            }
            if (initialWrapper == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(12);
            }
            int afterOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getEndOffset() : initialWrapper.getStartOffset();
            int length = arrangedWrapper.getEndOffset() - arrangedWrapper.getStartOffset();
            int beforeOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getStartOffset() : afterOffset - length;
            this.insertSection(context2, entry, newSectionsInfo, parent2, beforeOffset, afterOffset);
        }

        @Override
        protected boolean insertSection(@NotNull Context<E> context2, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @Nullable ArrangementEntryWrapper<E> parent2, int beforeOffset, int afterOffset) {
            String beforeComment;
            if (context2 == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(13);
            }
            if (entry == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(14);
            }
            if (newSectionsInfo == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(15);
            }
            boolean isInserted = false;
            int diff = 0;
            String afterComment = newSectionsInfo.getEndComment(entry);
            if (afterComment != null) {
                this.insert(context2, afterOffset, "\n" + afterComment);
                diff += afterComment.length() + 1;
                isInserted = true;
            }
            if ((beforeComment = newSectionsInfo.getStartComment(entry)) != null) {
                this.insert(context2, beforeOffset, beforeComment + "\n");
                diff += beforeComment.length() + 1;
                isInserted = true;
            }
            this.updateAllWrapperRanges(parent2, diff);
            return isInserted;
        }

        private int getBlankLineOffset(int blankLinesNumber, int startOffset) {
            int startLine = this.myDocument.getLineNumber(startOffset);
            if (startLine <= 0) {
                return 0;
            }
            CharSequence text2 = this.myDocument.getCharsSequence();
            int i2 = this.myDocument.getLineStartOffset(startLine - 1) - 1;
            while (i2 >= 0) {
                if (--blankLinesNumber <= 0) {
                    return i2 + 1;
                }
                i2 = CharArrayUtil.lastIndexOf(text2, "\n", i2 - 1);
            }
            return 0;
        }

        private void shiftOffsets(int shift, int changeOffset) {
            ArrangementEntryWrapper<E> wrapper2;
            for (int i2 = this.myWrappers.size() - 1; i2 >= 0 && (wrapper2 = this.myWrappers.get(i2)).getStartOffset() >= changeOffset; --i2) {
                wrapper2.applyShift(shift);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toArrange";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldWrapper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSectionsInfo";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrangedWrapper";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialWrapper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insert";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insertSection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DefaultChanger<E extends ArrangementEntry>
    extends Changer<E> {
        @NotNull
        private String myParentText;
        private int myParentShift;

        private DefaultChanger() {
        }

        @Override
        public void prepare(@NotNull List<? extends ArrangementEntryWrapper<E>> toArrange, @NotNull Context<E> context2) {
            ArrangementEntryWrapper<E> parent2;
            if (toArrange == null) {
                DefaultChanger.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                DefaultChanger.$$$reportNull$$$0(1);
            }
            if ((parent2 = toArrange.get(0).getParent()) == null) {
                this.myParentText = context2.document.getText();
                this.myParentShift = 0;
            } else {
                this.myParentText = context2.document.getCharsSequence().subSequence(parent2.getStartOffset(), parent2.getEndOffset()).toString();
                this.myParentShift = parent2.getStartOffset();
            }
        }

        @Override
        public void replace(@NotNull ArrangementEntryWrapper<E> newWrapper, @NotNull ArrangementEntryWrapper<E> oldWrapper, @Nullable ArrangementEntryWrapper<E> previous, @Nullable ArrangementEntryWrapper<E> next2, @NotNull Context<E> context2) {
            ArrangementEntryWrapper<E> parentWrapper;
            int desiredBlankLinesNumber;
            if (newWrapper == null) {
                DefaultChanger.$$$reportNull$$$0(2);
            }
            if (oldWrapper == null) {
                DefaultChanger.$$$reportNull$$$0(3);
            }
            if (context2 == null) {
                DefaultChanger.$$$reportNull$$$0(4);
            }
            int blankLinesBefore = 0;
            IntArrayList lineFeedOffsets = new IntArrayList();
            int oldStartLine = context2.document.getLineNumber(oldWrapper.getStartOffset());
            if (oldStartLine > 0) {
                int lastLineFeed = context2.document.getLineStartOffset(oldStartLine) - 1;
                lineFeedOffsets.add(lastLineFeed);
                for (int i2 = lastLineFeed - 1 - this.myParentShift; i2 >= 0 && this.myParentText.charAt(i2 = CharArrayUtil.shiftBackward(this.myParentText, i2, " \t")) == '\n'; --i2) {
                    ++blankLinesBefore;
                    lineFeedOffsets.add(i2 + this.myParentShift);
                }
            }
            if ((desiredBlankLinesNumber = this.getBlankLines(context2, parentWrapper = oldWrapper.getParent(), newWrapper, previous, next2)) == blankLinesBefore && newWrapper.equals(oldWrapper)) {
                return;
            }
            String newEntryText = this.myParentText.substring(newWrapper.getStartOffset() - this.myParentShift, newWrapper.getEndOffset() - this.myParentShift);
            int lineFeedsDiff = desiredBlankLinesNumber - blankLinesBefore;
            if (lineFeedsDiff == 0 || desiredBlankLinesNumber < 0) {
                context2.addMoveInfo(newWrapper.getStartOffset() - this.myParentShift, newWrapper.getEndOffset() - this.myParentShift, oldWrapper.getStartOffset());
                context2.document.replaceString(oldWrapper.getStartOffset(), oldWrapper.getEndOffset(), newEntryText);
                return;
            }
            if (lineFeedsDiff > 0) {
                StringBuilder buffer = new StringBuilder(StringUtil.repeat("\n", lineFeedsDiff));
                buffer.append(newEntryText);
                context2.document.replaceString(oldWrapper.getStartOffset(), oldWrapper.getEndOffset(), buffer);
            } else {
                int replacementStartOffset = lineFeedOffsets.getInt(-lineFeedsDiff) + 1;
                context2.document.replaceString(replacementStartOffset, oldWrapper.getEndOffset(), newEntryText);
            }
            ArrangementEntryWrapper<E> parent2 = oldWrapper.getParent();
            if (parent2 == null) {
                return;
            }
            ArrayDeque<ArrangementEntryWrapper<E>> parents2 = new ArrayDeque<ArrangementEntryWrapper<E>>();
            do {
                parents2.add(parent2);
                parent2.setEndOffset(parent2.getEndOffset() + lineFeedsDiff);
            } while ((parent2 = parent2.getParent()) != null);
            while (!parents2.isEmpty()) {
                for (ArrangementEntryWrapper wrapper2 = ((ArrangementEntryWrapper)parents2.removeLast()).getNext(); wrapper2 != null; wrapper2 = wrapper2.getNext()) {
                    wrapper2.applyShift(lineFeedsDiff);
                }
            }
        }

        @Override
        public void insert(@NotNull Context<E> context2, int startOffset, @NotNull String text2) {
            if (context2 == null) {
                DefaultChanger.$$$reportNull$$$0(5);
            }
            if (text2 == null) {
                DefaultChanger.$$$reportNull$$$0(6);
            }
            context2.document.insertString(startOffset, text2);
        }

        @Override
        public void insertSection(@NotNull Context<E> context2, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @NotNull ArrangementEntryWrapper<E> arrangedWrapper, @NotNull ArrangementEntryWrapper<E> initialWrapper, @Nullable ArrangementEntryWrapper<E> parent2) {
            if (context2 == null) {
                DefaultChanger.$$$reportNull$$$0(7);
            }
            if (entry == null) {
                DefaultChanger.$$$reportNull$$$0(8);
            }
            if (newSectionsInfo == null) {
                DefaultChanger.$$$reportNull$$$0(9);
            }
            if (arrangedWrapper == null) {
                DefaultChanger.$$$reportNull$$$0(10);
            }
            if (initialWrapper == null) {
                DefaultChanger.$$$reportNull$$$0(11);
            }
            int beforeOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getStartOffset() : initialWrapper.getStartOffset();
            int length = arrangedWrapper.getEndOffset() - arrangedWrapper.getStartOffset();
            int afterOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getEndOffset() : beforeOffset + length;
            this.insertSection(context2, entry, newSectionsInfo, parent2, beforeOffset, afterOffset);
        }

        @Override
        protected boolean insertSection(@NotNull Context<E> context2, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, ArrangementEntryWrapper<E> parent2, int beforeOffset, int afterOffset) {
            String beforeComment;
            if (context2 == null) {
                DefaultChanger.$$$reportNull$$$0(12);
            }
            if (entry == null) {
                DefaultChanger.$$$reportNull$$$0(13);
            }
            if (newSectionsInfo == null) {
                DefaultChanger.$$$reportNull$$$0(14);
            }
            boolean isInserted = false;
            String afterComment = newSectionsInfo.getEndComment(entry);
            if (afterComment != null) {
                this.insert(context2, afterOffset, "\n" + afterComment);
                isInserted = true;
            }
            if ((beforeComment = newSectionsInfo.getStartComment(entry)) != null) {
                this.insert(context2, beforeOffset, beforeComment + "\n");
                isInserted = true;
            }
            return isInserted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toArrange";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newWrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldWrapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSectionsInfo";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrangedWrapper";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialWrapper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insert";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insertSection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

