/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementEntryWrapper<E extends ArrangementEntry> {
    @NotNull
    private final List<ArrangementEntryWrapper<E>> myChildren;
    @NotNull
    private final E myEntry;
    @Nullable
    private ArrangementEntryWrapper<E> myParent;
    @Nullable
    private ArrangementEntryWrapper<E> myPrevious;
    @Nullable
    private ArrangementEntryWrapper<E> myNext;
    private int myStartOffset;
    private int myEndOffset;
    private int myBlankLinesBefore;

    public ArrangementEntryWrapper(@NotNull E entry) {
        if (entry == null) {
            ArrangementEntryWrapper.$$$reportNull$$$0(0);
        }
        this.myChildren = new ArrayList<ArrangementEntryWrapper<E>>();
        this.myEntry = entry;
        this.myStartOffset = entry.getStartOffset();
        this.myEndOffset = entry.getEndOffset();
        ArrangementEntryWrapper<ArrangementEntry> previous = null;
        for (ArrangementEntry child : entry.getChildren()) {
            ArrangementEntryWrapper<ArrangementEntry> childWrapper = new ArrangementEntryWrapper<ArrangementEntry>(child);
            childWrapper.setParent(this);
            if (previous != null) {
                previous.setNext(childWrapper);
                childWrapper.setPrevious(previous);
            }
            previous = childWrapper;
            this.myChildren.add(childWrapper);
        }
    }

    @NotNull
    public E getEntry() {
        E e = this.myEntry;
        if (e == null) {
            ArrangementEntryWrapper.$$$reportNull$$$0(1);
        }
        return e;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public void setEndOffset(int endOffset) {
        this.myEndOffset = endOffset;
    }

    @Nullable
    public ArrangementEntryWrapper<E> getParent() {
        return this.myParent;
    }

    public void setParent(@Nullable ArrangementEntryWrapper<E> parent2) {
        this.myParent = parent2;
    }

    @Nullable
    public ArrangementEntryWrapper<E> getPrevious() {
        return this.myPrevious;
    }

    public void setPrevious(@Nullable ArrangementEntryWrapper<E> previous) {
        this.myPrevious = previous;
    }

    @Nullable
    public ArrangementEntryWrapper<E> getNext() {
        return this.myNext;
    }

    public int getBlankLinesBefore() {
        return this.myBlankLinesBefore;
    }

    public void updateBlankLines(@NotNull Document document) {
        if (document == null) {
            ArrangementEntryWrapper.$$$reportNull$$$0(2);
        }
        this.myBlankLinesBefore = 0;
        int lineFeeds = 0;
        CharSequence text2 = document.getCharsSequence();
        int current = this.getStartOffset() - 1;
        while (current >= 0 && (current = CharArrayUtil.shiftBackward(text2, current, " \t")) > 0 && text2.charAt(current) == '\n') {
            ++lineFeeds;
            --current;
        }
        if (lineFeeds > 0) {
            this.myBlankLinesBefore = lineFeeds - 1;
        }
    }

    public void setNext(@Nullable ArrangementEntryWrapper<E> next2) {
        this.myNext = next2;
    }

    @NotNull
    public List<ArrangementEntryWrapper<E>> getChildren() {
        List<ArrangementEntryWrapper<E>> list2 = this.myChildren;
        if (list2 == null) {
            ArrangementEntryWrapper.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void applyShift(int shift) {
        this.myStartOffset += shift;
        this.myEndOffset += shift;
        for (ArrangementEntryWrapper<E> child : this.myChildren) {
            child.applyShift(shift);
        }
    }

    public int hashCode() {
        return this.myEntry.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementEntryWrapper wrapper2 = (ArrangementEntryWrapper)o;
        return this.myEntry.equals(wrapper2.myEntry);
    }

    public String toString() {
        return String.format("range: [%d; %d), entry: %s", this.myStartOffset, this.myEndOffset, this.myEntry.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEntryWrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEntryWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateBlankLines";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3 -> new IllegalStateException(string2);
        };
    }
}

