/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.InvertibleArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementStandardSettingsManager {
    @NotNull
    private final ObjectIntMap<ArrangementSettingsToken> myWidths;
    @NotNull
    private final ObjectIntMap<ArrangementSettingsToken> myWeights;
    @NotNull
    private final Comparator<ArrangementSettingsToken> myComparator;
    @NotNull
    private final ArrangementStandardSettingsAware myDelegate;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final Collection<Set<ArrangementSettingsToken>> myMutexes;
    @Nullable
    private final StdArrangementSettings myDefaultSettings;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myGroupingTokens;
    @Nullable
    private final List<CompositeArrangementSettingsToken> myMatchingTokens;
    @NotNull
    private final Collection<StdArrangementRuleAliasToken> myRuleAliases;
    @NotNull
    private final Set<ArrangementSettingsToken> myRuleAliasMutex;
    @Nullable
    private CompositeArrangementSettingsToken myRuleAliasToken;

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate2, @NotNull ArrangementColorsProvider colorsProvider) {
        if (delegate2 == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(1);
        }
        this(delegate2, colorsProvider, ContainerUtil.emptyList());
    }

    public ArrangementStandardSettingsManager(@NotNull ArrangementStandardSettingsAware delegate2, @NotNull ArrangementColorsProvider colorsProvider, @NotNull Collection<StdArrangementRuleAliasToken> aliases) {
        if (delegate2 == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(2);
        }
        if (colorsProvider == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(3);
        }
        if (aliases == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(4);
        }
        this.myWidths = new ObjectIntHashMap<ArrangementSettingsToken>();
        this.myWeights = new ObjectIntHashMap<ArrangementSettingsToken>();
        this.myComparator = (t1, t2) -> {
            if (this.myWeights.containsKey((ArrangementSettingsToken)t1)) {
                if (this.myWeights.containsKey((ArrangementSettingsToken)t2)) {
                    return this.myWeights.get((ArrangementSettingsToken)t1) - this.myWeights.get((ArrangementSettingsToken)t2);
                }
                return -1;
            }
            if (this.myWeights.containsKey((ArrangementSettingsToken)t2)) {
                return 1;
            }
            return t1.compareTo(t2);
        };
        this.myDelegate = delegate2;
        this.myColorsProvider = colorsProvider;
        this.myMutexes = delegate2.getMutexes();
        this.myDefaultSettings = delegate2.getDefaultSettings();
        SimpleColoredComponent renderer = new SimpleColoredComponent();
        this.myGroupingTokens = delegate2.getSupportedGroupingTokens();
        if (this.myGroupingTokens != null) {
            this.parseWidths(this.myGroupingTokens, renderer);
            this.buildWeights(this.myGroupingTokens);
        }
        this.myMatchingTokens = delegate2.getSupportedMatchingTokens();
        if (this.myMatchingTokens != null) {
            this.parseWidths(this.myMatchingTokens, renderer);
            this.buildWeights(this.myMatchingTokens);
        }
        HashSet<StdArrangementRuleAliasToken> aliasTokens = new HashSet<StdArrangementRuleAliasToken>(aliases);
        this.myRuleAliases = aliases;
        this.myRuleAliasMutex = aliasTokens;
        if (!this.myRuleAliases.isEmpty()) {
            this.myRuleAliasToken = new CompositeArrangementSettingsToken(StdArrangementTokens.General.ALIAS, aliasTokens);
        }
    }

    @NotNull
    public Collection<StdArrangementRuleAliasToken> getRuleAliases() {
        Collection<StdArrangementRuleAliasToken> collection = this.myRuleAliases;
        if (collection == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public ArrangementStandardSettingsAware getDelegate() {
        ArrangementStandardSettingsAware arrangementStandardSettingsAware = this.myDelegate;
        if (arrangementStandardSettingsAware == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(6);
        }
        return arrangementStandardSettingsAware;
    }

    private void parseWidths(@NotNull Collection<? extends CompositeArrangementSettingsToken> compositeTokens, @NotNull SimpleColoredComponent renderer) {
        if (compositeTokens == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(7);
        }
        if (renderer == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(8);
        }
        int width = 0;
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            width = Math.max(width, this.parseWidth(compositeArrangementSettingsToken.getToken(), renderer));
        }
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            this.myWidths.put(compositeArrangementSettingsToken.getToken(), width);
            this.parseWidths(compositeArrangementSettingsToken.getChildren(), renderer);
        }
    }

    private void buildWeights(@NotNull Collection<? extends CompositeArrangementSettingsToken> compositeTokens) {
        if (compositeTokens == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(9);
        }
        for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : compositeTokens) {
            this.myWeights.put(compositeArrangementSettingsToken.getToken(), this.myWeights.size());
            this.buildWeights(compositeArrangementSettingsToken.getChildren());
        }
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    public boolean isSectionRulesSupported() {
        return this.myDelegate instanceof ArrangementSectionRuleAwareSettings;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return this.myGroupingTokens;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        if (this.myMatchingTokens == null || this.myRuleAliasToken == null) {
            return this.myMatchingTokens;
        }
        ArrayList<CompositeArrangementSettingsToken> allTokens = new ArrayList<CompositeArrangementSettingsToken>(this.myMatchingTokens);
        allTokens.add(this.myRuleAliasToken);
        return allTokens;
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(10);
        }
        if (this.myRuleAliasMutex.contains(token)) {
            return true;
        }
        return this.myDelegate.isEnabled(token, current);
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        ArrangementEntryMatcher matcher;
        if (condition == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(11);
        }
        if ((matcher = ArrangementUtil.buildMatcher((ArrangementMatchCondition)condition)) == null) {
            matcher = this.myDelegate.buildMatcher(condition);
        }
        ArrangementEntryMatcher arrangementEntryMatcher = matcher;
        if (arrangementEntryMatcher == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(12);
        }
        return arrangementEntryMatcher;
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        if (this.myRuleAliasMutex.isEmpty()) {
            Collection<Set<ArrangementSettingsToken>> collection = this.myMutexes;
            if (collection == null) {
                ArrangementStandardSettingsManager.$$$reportNull$$$0(13);
            }
            return collection;
        }
        ArrayList<Set<ArrangementSettingsToken>> allMutexes = new ArrayList<Set<ArrangementSettingsToken>>(this.myMutexes);
        allMutexes.add(this.myRuleAliasMutex);
        ArrayList<Set<ArrangementSettingsToken>> arrayList = allMutexes;
        if (arrayList == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public int getWidth(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(15);
        }
        if (this.myWidths.containsKey(token)) {
            return this.myWidths.get(token);
        }
        return this.parseWidth(token, new SimpleColoredComponent());
    }

    private int parseWidth(@NotNull ArrangementSettingsToken token, @NotNull SimpleColoredComponent renderer) {
        if (token == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(16);
        }
        if (renderer == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(17);
        }
        renderer.clear();
        String value = ArrangementStandardSettingsManager.getPresentationValue(token);
        renderer.append(value, SimpleTextAttributes.fromTextAttributes((TextAttributes)this.myColorsProvider.getTextAttributes(token, true)));
        int result2 = renderer.getPreferredSize().width;
        renderer.clear();
        renderer.append(value, SimpleTextAttributes.fromTextAttributes((TextAttributes)this.myColorsProvider.getTextAttributes(token, false)));
        return Math.max(result2, renderer.getPreferredSize().width);
    }

    @NotNull
    @Nls
    private static String getPresentationValue(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(18);
        }
        if (token instanceof InvertibleArrangementSettingsToken) {
            String string2 = ((InvertibleArrangementSettingsToken)token).getInvertedRepresentationValue();
            if (string2 == null) {
                ArrangementStandardSettingsManager.$$$reportNull$$$0(19);
            }
            return string2;
        }
        String string3 = token.getRepresentationValue();
        if (string3 == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(20);
        }
        return string3;
    }

    public List<ArrangementSettingsToken> sort(@NotNull Collection<? extends ArrangementSettingsToken> tokens) {
        if (tokens == null) {
            ArrangementStandardSettingsManager.$$$reportNull$$$0(21);
        }
        ArrayList<ArrangementSettingsToken> result2 = new ArrayList<ArrangementSettingsToken>(tokens);
        result2.sort(this.myComparator);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 12, 13, 14, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeTokens";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/std/ArrangementStandardSettingsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuleAliases";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutexes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseWidths";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildWeights";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getWidth";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseWidth";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 12, 13, 14, 19, 20 -> new IllegalStateException(string2);
        };
    }
}

