/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjuster;
import com.intellij.psi.codeStyle.autodetect.IndentUsageInfo;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatistics;
import org.jetbrains.annotations.NotNull;

class IndentOptionsAdjusterImpl
implements IndentOptionsAdjuster {
    private static final double RATE_THRESHOLD = 0.8;
    private static final int MAX_INDENT_TO_DETECT = 8;
    private final IndentUsageStatistics myStats;

    IndentOptionsAdjusterImpl(IndentUsageStatistics stats) {
        this.myStats = stats;
    }

    @Override
    public void adjust(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        int newIndentSize;
        if (indentOptions == null) {
            IndentOptionsAdjusterImpl.$$$reportNull$$$0(0);
        }
        boolean isTabsUsed = IndentOptionsAdjusterImpl.isTabsUsed(this.myStats);
        boolean isSpacesUsed = IndentOptionsAdjusterImpl.isSpacesUsed(this.myStats);
        int n = newIndentSize = isSpacesUsed ? IndentOptionsAdjusterImpl.getPositiveIndentSize(this.myStats) : 0;
        if (isTabsUsed) {
            IndentOptionsAdjusterImpl.adjustForTabUsage(indentOptions);
        } else if (isSpacesUsed) {
            indentOptions.USE_TAB_CHARACTER = false;
            if (newIndentSize > 0 && indentOptions.INDENT_SIZE != newIndentSize) {
                indentOptions.INDENT_SIZE = newIndentSize;
            }
        }
    }

    private static void adjustForTabUsage(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            IndentOptionsAdjusterImpl.$$$reportNull$$$0(1);
        }
        if (indentOptions.USE_TAB_CHARACTER) {
            return;
        }
        int continuationRatio = indentOptions.INDENT_SIZE == 0 ? 1 : indentOptions.CONTINUATION_INDENT_SIZE / indentOptions.INDENT_SIZE;
        indentOptions.USE_TAB_CHARACTER = true;
        indentOptions.INDENT_SIZE = indentOptions.TAB_SIZE;
        indentOptions.CONTINUATION_INDENT_SIZE = indentOptions.TAB_SIZE * continuationRatio;
    }

    private static boolean isSpacesUsed(IndentUsageStatistics stats) {
        int total;
        int spaces = stats.getTotalLinesWithLeadingSpaces();
        return (double)spaces / (double)(total = stats.getTotalLinesWithLeadingSpaces() + stats.getTotalLinesWithLeadingTabs()) > 0.8;
    }

    private static boolean isTabsUsed(IndentUsageStatistics stats) {
        return stats.getTotalLinesWithLeadingTabs() > stats.getTotalLinesWithLeadingSpaces();
    }

    private static int getPositiveIndentSize(@NotNull IndentUsageStatistics stats) {
        double usageRate;
        int totalIndentSizesDetected;
        if (stats == null) {
            IndentOptionsAdjusterImpl.$$$reportNull$$$0(2);
        }
        if ((totalIndentSizesDetected = stats.getTotalIndentSizesDetected()) == 0) {
            return -1;
        }
        IndentUsageInfo maxUsedIndentInfo = stats.getKMostUsedIndentInfo(0);
        int maxUsedIndentSize = maxUsedIndentInfo.getIndentSize();
        if (maxUsedIndentSize == 0) {
            if (totalIndentSizesDetected < 2) {
                return -1;
            }
            maxUsedIndentInfo = stats.getKMostUsedIndentInfo(1);
            maxUsedIndentSize = maxUsedIndentInfo.getIndentSize();
        }
        if (maxUsedIndentSize <= 8 && (usageRate = (double)maxUsedIndentInfo.getTimesUsed() / (double)stats.getTotalLinesWithLeadingSpaces()) > 0.8) {
            return maxUsedIndentSize;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stats";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/autodetect/IndentOptionsAdjusterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjust";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustForTabUsage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPositiveIndentSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

