/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.autodetect.FormatterBasedLineIndentInfoBuilder;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjuster;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjusterImpl;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetector;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatisticsImpl;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentOptionsDetectorImpl
implements IndentOptionsDetector {
    private final VirtualFile myFile;
    private final Project myProject;
    private final Document myDocument;
    private final ProgressIndicator myProgressIndicator;

    public IndentOptionsDetectorImpl(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull Document document, @NotNull ProgressIndicator indicator) {
        if (project2 == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(1);
        }
        if (document == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(3);
        }
        this.myFile = file2;
        this.myProject = project2;
        this.myDocument = document;
        this.myProgressIndicator = indicator;
    }

    @Override
    @Nullable
    public IndentOptionsAdjuster getIndentOptionsAdjuster() {
        try {
            List<LineIndentInfo> linesInfo = this.calcLineIndentInfo(this.myProgressIndicator);
            if (linesInfo != null) {
                return new IndentOptionsAdjusterImpl(new IndentUsageStatisticsImpl(linesInfo));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)CodeStyle.getSettings((Project)this.myProject, (VirtualFile)this.myFile).getIndentOptions(this.myFile.getFileType()).clone();
        IndentOptionsAdjuster adjuster = this.getIndentOptionsAdjuster();
        if (adjuster != null) {
            adjuster.adjust(indentOptions);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        if (indentOptions2 == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(4);
        }
        return indentOptions2;
    }

    @Nullable
    private List<LineIndentInfo> calcLineIndentInfo(@Nullable ProgressIndicator indicator) {
        if (this.myDocument.getLineCount() < 3 || this.isFileBigToDetect()) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myDocument);
        if (psiFile == null || !this.isUpToDate(psiFile, this.myDocument)) {
            return null;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((Project)this.myProject, (VirtualFile)this.myFile);
        FormattingModelBuilder modelBuilder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
        if (modelBuilder2 == null) {
            return null;
        }
        FormattingModel model2 = modelBuilder2.createModel(FormattingContext.create((PsiElement)psiFile, (CodeStyleSettings)settings));
        Block rootBlock = model2.getRootBlock();
        return new FormatterBasedLineIndentInfoBuilder(this.myDocument, rootBlock, indicator).build();
    }

    private boolean isUpToDate(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(5);
        }
        if (document == null) {
            IndentOptionsDetectorImpl.$$$reportNull$$$0(6);
        }
        return PsiDocumentManager.getInstance(this.myProject).isCommitted(this.myDocument) && file2.isValid() && file2.getTextLength() == document.getTextLength();
    }

    private boolean isFileBigToDetect() {
        return this.myFile.getLength() > 0x100000L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

