/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.processor.GenProcessor;
import com.intellij.psi.codeStyle.extractor.ui.CodeStyleSettingsNameProvider;
import com.intellij.psi.codeStyle.extractor.ui.ExtractedSettingsDialog;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class ExtractCodeStyleAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext2;
        Project project2;
        if (e == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2 = e.getDataContext())) == null) {
            return;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext2);
        PsiElement file2 = null;
        if (editor2 == null && files2 != null && files2.length == 1 && !files2[0].isDirectory()) {
            file2 = PsiManager.getInstance(project2).findFile(files2[0]);
        } else if (editor2 != null) {
            file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        }
        if (file2 == null) {
            return;
        }
        final Language language = file2.getLanguage();
        LangCodeStyleExtractor extractor = LangCodeStyleExtractor.EXTENSION.forLanguage(language);
        if (extractor == null) {
            return;
        }
        final CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file2);
        final GenProcessor genProcessor = new GenProcessor(extractor);
        PsiElement finalFile = file2;
        Task.Backgroundable task2 = new Task.Backgroundable(project2, LangBundle.message("progress.title.code.style.extractor", new Object[0]), true, (PsiFile)finalFile){
            final /* synthetic */ PsiFile val$finalFile;
            {
                this.val$finalFile = psiFile;
                super(arg0, arg1, arg2);
            }

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CodeStyleSettings cloneSettings = CodeStyleSettingsManager.getInstance().cloneSettings(settings);
                    Map<Value, Object> backup = genProcessor.backupValues(cloneSettings, language);
                    ValuesExtractionResult res = genProcessor.runWithProgress(project2, cloneSettings, this.val$finalFile, indicator);
                    ExtractCodeStyleAction.this.reportResult(genProcessor.getHTMLReport(), res, project2, cloneSettings, this.val$finalFile, backup);
                }
                catch (ProcessCanceledException e) {
                    Utils.logError("Code extraction was canceled");
                }
                catch (Throwable t) {
                    Utils.logError("Unexpected exception: " + t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/codeStyle/extractor/ExtractCodeStyleAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run(task2);
    }

    public void reportResult(@NotNull String htmlReport, final @NotNull ValuesExtractionResult calculatedValues, final @NotNull Project project2, final @NotNull CodeStyleSettings cloneSettings, final @NotNull PsiFile file2, @NotNull Map<Value, Object> backup) {
        if (htmlReport == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(1);
        }
        if (calculatedValues == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(3);
        }
        if (cloneSettings == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(5);
        }
        if (backup == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(6);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            BalloonLayout layout;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(LangBundle.message("popup.content.formatting.options", file2.getName(), !htmlReport.isEmpty() ? "<br/>" + htmlReport : ""), MessageType.INFO, new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        boolean apply2 = "apply".equals(e.getDescription());
                        ExtractedSettingsDialog myDialog = null;
                        if (!apply2) {
                            List<Value> values2 = calculatedValues.getValues();
                            Language language = file2.getLanguage();
                            CodeStyleSettingsNameProvider nameProvider = new CodeStyleSettingsNameProvider();
                            for (LanguageCodeStyleSettingsProvider provider2 : LanguageCodeStyleSettingsProvider.getAllProviders()) {
                                Language target2 = provider2.getLanguage();
                                if (!target2.equals(language)) continue;
                                nameProvider.addSettings(provider2);
                                myDialog = new ExtractedSettingsDialog(project2, nameProvider, values2);
                                apply2 = myDialog.showAndGet();
                                break;
                            }
                        }
                        if (apply2) {
                            calculatedValues.applySelected();
                            CodeStyleScheme derivedScheme = CodeStyleSchemes.getInstance().createNewScheme("Derived from " + file2.getName(), null);
                            derivedScheme.getCodeStyleSettings().copyFrom(cloneSettings);
                            CodeStyleSchemes.getInstance().addScheme(derivedScheme);
                            CodeStyleSchemesImpl.getSchemeManager().setCurrent(derivedScheme);
                            CodeStyleSettingsManager.getInstance((Project)project2).PREFERRED_PROJECT_CODE_STYLE = derivedScheme.getName();
                        }
                    }
                }
            }).setFadeoutTime(0L).setShowCallout(false).setAnimationCycle(0).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnLinkClick(true).setCloseButtonEnabled(true).createBalloon();
            Disposer.register(project2, (Disposable)balloon);
            Frame window = WindowManager.getInstance().getFrame(project2);
            if (window == null) {
                window = JOptionPane.getRootFrame();
            }
            if (window instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)((IdeFrame)window).getComponent()){

                    @Override
                    public RelativePoint recalculateLocation(@NotNull Balloon object) {
                        if (object == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        Component c2 = this.getComponent();
                        int y = c2.getHeight() - 45;
                        return new RelativePoint(c2, new Point(c2.getWidth() - 150, y));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/psi/codeStyle/extractor/ExtractCodeStyleAction$3", "recalculateLocation"));
                    }
                }, Balloon.Position.above);
            }
        });
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(7);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext2 = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            presentation2.setEnabled(false);
            return;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        PsiFile file2 = null;
        if (editor2 != null) {
            file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        } else {
            VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext2);
            if (files2 != null && files2.length == 1 && !files2[0].isDirectory()) {
                file2 = PsiManager.getInstance(project2).findFile(files2[0]);
            }
        }
        if (file2 == null || file2.getVirtualFile() == null) {
            presentation2.setEnabled(false);
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
            presentation2.setEnabled(true);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(8);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlReport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculatedValues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloneSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/extractor/ExtractCodeStyleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/extractor/ExtractCodeStyleAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportResult";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8 -> new IllegalStateException(string2);
        };
    }
}

