/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class SourceRootIconProvider {
    @NotNull
    public static Icon getDirectoryIcon(VirtualFile vFile, Project project2) {
        SourceFolder sourceFolder = ProjectRootsUtil.getModuleSourceRoot(vFile, project2);
        if (sourceFolder != null) {
            Icon icon2 = SourceRootPresentation.getSourceRootIcon(sourceFolder);
            if (icon2 == null) {
                SourceRootIconProvider.$$$reportNull$$$0(0);
            }
            return icon2;
        }
        Icon excludedIcon = SourceRootIconProvider.getIconIfExcluded(project2, vFile);
        Icon icon3 = excludedIcon != null ? excludedIcon : PlatformIcons.FOLDER_ICON;
        if (icon3 == null) {
            SourceRootIconProvider.$$$reportNull$$$0(1);
        }
        return icon3;
    }

    @Nullable
    public static Icon getIconIfExcluded(@NotNull Project project2, @NotNull VirtualFile vFile) {
        boolean ignored;
        if (project2 == null) {
            SourceRootIconProvider.$$$reportNull$$$0(2);
        }
        if (vFile == null) {
            SourceRootIconProvider.$$$reportNull$$$0(3);
        }
        if (!Registry.is("ide.hide.excluded.files") && (ignored = ProjectRootManager.getInstance(project2).getFileIndex().isExcluded(vFile))) {
            return AllIcons.Modules.ExcludeRoot;
        }
        return null;
    }

    @Nullable
    private static Icon calcFileLayerIcon(VirtualFile vFile, Project project2) {
        ProjectFileIndex index2 = ProjectFileIndex.getInstance(project2);
        if (vFile != null) {
            VirtualFile parent2 = vFile.getParent();
            if (index2.isExcluded(vFile)) {
                if (parent2 == null || !index2.isExcluded(parent2)) {
                    return AllIcons.Nodes.ExcludedFromCompile;
                }
            } else {
                VirtualFile sourceRoot = index2.getSourceRootForFile(vFile);
                if (vFile.equals(sourceRoot)) {
                    VirtualFile parentSourceRoot;
                    VirtualFile virtualFile2 = parentSourceRoot = parent2 == null ? null : index2.getSourceRootForFile(parent2);
                    if (parentSourceRoot == null || !sourceRoot.equals(parentSourceRoot)) {
                        JpsModuleSourceRootType<?> rootType = index2.getContainingSourceRootType(vFile);
                        return rootType != null ? SourceRootPresentation.getSourceRootFileLayerIcon(rootType) : null;
                    }
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/SourceRootIconProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryIcon";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/SourceRootIconProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIconIfExcluded";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3 -> new IllegalArgumentException(string2);
        };
    }

    public static class FileLayerProvider
    implements IconLayerProvider,
    DumbAware {
        @Override
        @Nullable
        public Icon getLayerIcon(@NotNull Iconable element, boolean isLocked) {
            if (element == null) {
                FileLayerProvider.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiFile) {
                Project project2 = ((PsiFile)element).getProject();
                VirtualFile virtualFile2 = ((PsiFile)element).getVirtualFile();
                return (Icon)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create(SourceRootIconProvider.calcFileLayerIcon(virtualFile2, project2), ProjectRootManager.getInstance(project2)));
            }
            return null;
        }

        @Override
        @NotNull
        public String getLayerDescription() {
            return "Source root files";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/SourceRootIconProvider$FileLayerProvider", "getLayerIcon"));
        }
    }

    public static class DirectoryProvider
    extends IconProvider
    implements DumbAware {
        @Override
        public Icon getIcon(@NotNull PsiElement element, int flags) {
            if (element == null) {
                DirectoryProvider.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)element;
                return SourceRootIconProvider.getDirectoryIcon(psiDirectory.getVirtualFile(), psiDirectory.getProject());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/SourceRootIconProvider$DirectoryProvider", "getIcon"));
        }
    }
}

