/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileIncludeManagerImpl
extends FileIncludeManager
implements Disposable {
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final PsiFileFactory myPsiFileFactory;
    private final IncludeCacheHolder myIncludedHolder;
    private final IncludeCacheHolder myIncludingHolder;
    private final Map<String, FileIncludeProvider> myProviderMap;

    public void processIncludes(PsiFile file2, Processor<? super FileIncludeInfo> processor) {
        List<FileIncludeInfo> infoList = FileIncludeIndex.getIncludes(file2.getVirtualFile(), this.myProject);
        for (FileIncludeInfo info2 : infoList) {
            if (processor.process(info2)) continue;
            return;
        }
    }

    @Override
    public void processIncludingFiles(PsiFile context2, Processor<? super Pair<VirtualFile, FileIncludeInfo>> processor) {
        VirtualFile contextFile = (context2 = context2.getOriginalFile()).getVirtualFile();
        if (contextFile == null) {
            return;
        }
        if (FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null) {
            return;
        }
        String originalName = context2.getName();
        Collection<String> names = FileIncludeManagerImpl.getPossibleIncludeNames(context2, originalName);
        GlobalSearchScope scope = GlobalSearchScope.allScope(this.myProject);
        for (String name : names) {
            MultiMap<VirtualFile, FileIncludeInfoImpl> infoList = FileIncludeIndex.getIncludingFileCandidates(name, scope);
            for (VirtualFile candidate : infoList.keySet()) {
                PsiFile psiFile = this.myPsiManager.findFile(candidate);
                if (psiFile == null || context2.equals(psiFile)) continue;
                for (FileIncludeInfo fileIncludeInfo : infoList.get(candidate)) {
                    PsiFileSystemItem item = this.resolveFileInclude(fileIncludeInfo, psiFile);
                    if (item == null || !contextFile.equals(item.getVirtualFile()) || processor.process(Pair.create(candidate, fileIncludeInfo))) continue;
                    return;
                }
            }
        }
    }

    @NotNull
    private static Collection<String> getPossibleIncludeNames(@NotNull PsiFile context2, @NotNull String originalName) {
        if (context2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(0);
        }
        if (originalName == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(1);
        }
        HashSet<String> names = new HashSet<String>();
        names.add(originalName);
        for (FileIncludeProvider provider2 : FileIncludeProvider.EP_NAME.getExtensionList()) {
            String newName2 = provider2.getIncludeName(context2, originalName);
            if (Strings.areSameInstance(newName2, originalName)) continue;
            names.add(newName2);
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public FileIncludeManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(3);
        }
        this.myIncludedHolder = new IncludeCacheHolder("compile time includes", "runtime includes"){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
                HashSet files2 = new HashSet();
                FileIncludeManagerImpl.this.processIncludes(file2, info2 -> {
                    PsiFileSystemItem item;
                    if (compileTimeOnly != info2.runtimeOnly && (item = FileIncludeManagerImpl.this.resolveFileInclude((FileIncludeInfo)info2, file2)) != null) {
                        ContainerUtil.addIfNotNull(files2, item.getVirtualFile());
                    }
                    return true;
                });
                return VfsUtilCore.toVirtualFileArray(files2);
            }
        };
        this.myIncludingHolder = new IncludeCacheHolder("compile time contexts", "runtime contexts"){

            @Override
            protected VirtualFile[] computeFiles(PsiFile context2, boolean compileTimeOnly) {
                HashSet files2 = new HashSet();
                FileIncludeManagerImpl.this.processIncludingFiles(context2, virtualFileFileIncludeInfoPair -> {
                    files2.add((VirtualFile)virtualFileFileIncludeInfoPair.first);
                    return true;
                });
                return VfsUtilCore.toVirtualFileArray(files2);
            }
        };
        this.myProviderMap = new HashMap<String, FileIncludeProvider>();
        this.myProject = project2;
        this.myPsiManager = PsiManager.getInstance(project2);
        this.myPsiFileFactory = PsiFileFactory.getInstance(this.myProject);
        FileIncludeProvider.EP_NAME.getPoint().addExtensionPointListener(new ExtensionPointListener<FileIncludeProvider>(){

            @Override
            public void extensionAdded(@NotNull FileIncludeProvider provider2, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                FileIncludeProvider old = FileIncludeManagerImpl.this.myProviderMap.put(provider2.getId(), provider2);
                assert (old == null);
            }

            @Override
            public void extensionRemoved(@NotNull FileIncludeProvider provider2, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                FileIncludeManagerImpl.this.myProviderMap.remove(provider2.getId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, (Disposable)this);
    }

    @Override
    public void dispose() {
    }

    @Override
    public VirtualFile[] getIncludedFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
        if (file2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(4);
        }
        return this.getIncludedFiles(file2, compileTimeOnly, false);
    }

    @Override
    public VirtualFile[] getIncludedFiles(@NotNull VirtualFile file2, boolean compileTimeOnly, boolean recursively) {
        if (file2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(5);
        }
        if (file2 instanceof VirtualFileWithId) {
            return this.myIncludedHolder.getAllFiles(file2, compileTimeOnly, recursively);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    public VirtualFile[] getIncludingFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
        if (file2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(6);
        }
        return this.myIncludingHolder.getAllFiles(file2, compileTimeOnly, false);
    }

    @Override
    public PsiFileSystemItem resolveFileInclude(@NotNull FileIncludeInfo info2, @NotNull PsiFile context2) {
        if (info2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(8);
        }
        return this.doResolve(info2, context2);
    }

    @Nullable
    private PsiFileSystemItem doResolve(@NotNull FileIncludeInfo info2, @NotNull PsiFile context2) {
        if (info2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            FileIncludeManagerImpl.$$$reportNull$$$0(10);
        }
        if (info2 instanceof FileIncludeInfoImpl) {
            PsiFileSystemItem resolvedByProvider;
            String id = ((FileIncludeInfoImpl)info2).providerId;
            FileIncludeProvider provider2 = id == null ? null : this.myProviderMap.get(id);
            PsiFileSystemItem psiFileSystemItem = resolvedByProvider = provider2 == null ? null : provider2.resolveIncludedFile(info2, context2);
            if (resolvedByProvider != null) {
                return resolvedByProvider;
            }
        }
        PsiFileImpl psiFile = (PsiFileImpl)this.myPsiFileFactory.createFileFromText("dummy.txt", FileTypes.PLAIN_TEXT, (CharSequence)info2.path);
        psiFile.setOriginalFile(context2);
        return new FileReferenceSet(psiFile){

            @Override
            protected boolean useIncludingFileAsContext() {
                return false;
            }
        }.resolve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/include/FileIncludeManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleIncludeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleIncludeNames";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIncludingFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileInclude";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }

    private abstract class IncludeCacheHolder {
        private final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> COMPILE_TIME_KEY;
        private final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> RUNTIME_KEY;
        private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> COMPILE_TIME_PROVIDER = new IncludedFilesProvider(true){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
                return IncludeCacheHolder.this.computeFiles(file2, compileTimeOnly);
            }
        };
        private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> RUNTIME_PROVIDER = new IncludedFilesProvider(false){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
                return IncludeCacheHolder.this.computeFiles(file2, compileTimeOnly);
            }
        };

        private IncludeCacheHolder(String compileTimeKey, String runtimeKey) {
            this.COMPILE_TIME_KEY = Key.create(compileTimeKey);
            this.RUNTIME_KEY = Key.create(runtimeKey);
        }

        private VirtualFile @NotNull [] getAllFiles(@NotNull VirtualFile file2, boolean compileTimeOnly, boolean recursively) {
            if (file2 == null) {
                IncludeCacheHolder.$$$reportNull$$$0(0);
            }
            if (recursively) {
                HashSet result2 = new HashSet();
                this.getAllFilesRecursively(file2, compileTimeOnly, result2);
                VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
                if (virtualFileArray == null) {
                    IncludeCacheHolder.$$$reportNull$$$0(1);
                }
                return virtualFileArray;
            }
            VirtualFile[] virtualFileArray = this.getFiles(file2, compileTimeOnly);
            if (virtualFileArray == null) {
                IncludeCacheHolder.$$$reportNull$$$0(2);
            }
            return virtualFileArray;
        }

        private void getAllFilesRecursively(@NotNull VirtualFile file2, boolean compileTimeOnly, Set<? super VirtualFile> result2) {
            VirtualFile[] includes;
            if (file2 == null) {
                IncludeCacheHolder.$$$reportNull$$$0(3);
            }
            if (!result2.add(file2)) {
                return;
            }
            for (VirtualFile include : includes = this.getFiles(file2, compileTimeOnly)) {
                this.getAllFilesRecursively(include, compileTimeOnly, result2);
            }
        }

        private VirtualFile[] getFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
            PsiFile psiFile;
            if (file2 == null) {
                IncludeCacheHolder.$$$reportNull$$$0(4);
            }
            if ((psiFile = FileIncludeManagerImpl.this.myPsiManager.findFile(file2)) == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            if (compileTimeOnly) {
                return CachedValuesManager.getManager(FileIncludeManagerImpl.this.myProject).getParameterizedCachedValue(psiFile, this.COMPILE_TIME_KEY, this.COMPILE_TIME_PROVIDER, false, psiFile);
            }
            return CachedValuesManager.getManager(FileIncludeManagerImpl.this.myProject).getParameterizedCachedValue(psiFile, this.RUNTIME_KEY, this.RUNTIME_PROVIDER, false, psiFile);
        }

        protected abstract VirtualFile[] computeFiles(PsiFile var1, boolean var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/include/FileIncludeManagerImpl$IncludeCacheHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeManagerImpl$IncludeCacheHolder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllFiles";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllFilesRecursively";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static abstract class IncludedFilesProvider
    implements ParameterizedCachedValueProvider<VirtualFile[], PsiFile> {
        private final boolean myRuntimeOnly;

        IncludedFilesProvider(boolean runtimeOnly) {
            this.myRuntimeOnly = runtimeOnly;
        }

        protected abstract VirtualFile[] computeFiles(PsiFile var1, boolean var2);

        @Override
        public CachedValueProvider.Result<VirtualFile[]> compute(PsiFile psiFile) {
            VirtualFile[] value = this.computeFiles(psiFile, this.myRuntimeOnly);
            ArrayList<VirtualFile> deps = new ArrayList<VirtualFile>(Arrays.asList(value));
            deps.add((VirtualFile)((Object)psiFile));
            deps.add((VirtualFile)((Object)VirtualFileManager.getInstance()));
            return CachedValueProvider.Result.create(value, deps);
        }
    }
}

