/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileElementInfo
extends SmartPointerElementInfo {
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myLanguageId;
    @NotNull
    private final String myFileClassName;

    FileElementInfo(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileElementInfo.$$$reportNull$$$0(0);
        }
        this.myVirtualFile = file2.getViewProvider().getVirtualFile();
        this.myProject = file2.getProject();
        this.myLanguageId = LanguageUtil.getRootLanguage(file2).getID();
        this.myFileClassName = file2.getClass().getName();
    }

    @Override
    PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        Language language;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(1);
        }
        if ((language = Language.findLanguageByID(this.myLanguageId)) == null) {
            return null;
        }
        PsiFile file2 = SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, language);
        return file2 != null && file2.getClass().getName().equals(this.myFileClassName) ? file2 : null;
    }

    @Override
    PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager) {
        PsiElement element;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(2);
        }
        return (element = this.restoreElement(manager)) == null ? null : element.getContainingFile();
    }

    @Override
    int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        if (other == null) {
            FileElementInfo.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(4);
        }
        return other instanceof FileElementInfo && Objects.equals(this.myVirtualFile, ((FileElementInfo)other).myVirtualFile);
    }

    @Override
    @NotNull
    VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myVirtualFile;
        if (virtualFile2 == null) {
            FileElementInfo.$$$reportNull$$$0(5);
        }
        return virtualFile2;
    }

    @Override
    Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(6);
        }
        if (!this.myVirtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        return document == null ? null : TextRange.from(0, document.getTextLength());
    }

    @Override
    @Nullable
    Segment getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        Document currentDoc;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(7);
        }
        DocumentEx committedDoc = (currentDoc = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile)) == null ? null : ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).getLastCommittedDocument(currentDoc);
        return committedDoc == null ? this.getRange(manager) : new TextRange(0, committedDoc.getTextLength());
    }

    public String toString() {
        return "file{" + this.myVirtualFile + ", " + this.myLanguageId + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/FileElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/FileElementInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPsiRange";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

