/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class SmartPointerTracker {
    private static final ReferenceQueue<SmartPsiElementPointerImpl<?>> ourQueue = new ReferenceQueue();
    private int nextAvailableIndex;
    private int size;
    private PointerReference[] references = new PointerReference[10];
    private final MarkerCache markerCache = new MarkerCache(this);
    private boolean mySorted;

    SmartPointerTracker() {
    }

    synchronized void addReference(@NotNull SmartPsiElementPointerImpl<?> pointer) {
        if (pointer == null) {
            SmartPointerTracker.$$$reportNull$$$0(0);
        }
        PointerReference reference2 = new PointerReference(pointer, this);
        if (this.needsExpansion() || this.isTooSparse()) {
            this.resize();
        }
        if (this.references[this.nextAvailableIndex] != null) {
            throw new AssertionError(this.references[this.nextAvailableIndex]);
        }
        SmartPointerTracker.storePointerReference(this.references, this.nextAvailableIndex++, reference2);
        ++this.size;
        this.mySorted = false;
        if (((SelfElementInfo)pointer.getElementInfo()).hasRange()) {
            this.markerCache.rangeChanged();
        }
    }

    private boolean needsExpansion() {
        return this.nextAvailableIndex >= this.references.length;
    }

    private boolean isTooSparse() {
        return this.nextAvailableIndex > this.size * 2;
    }

    private void resize() {
        PointerReference[] newReferences = new PointerReference[this.size * 3 / 2 + 1];
        int index2 = 0;
        for (PointerReference ref : this.references) {
            if (ref == null) continue;
            SmartPointerTracker.storePointerReference(newReferences, index2++, ref);
        }
        assert (index2 == this.size) : index2 + " != " + this.size;
        this.references = newReferences;
        this.nextAvailableIndex = index2;
    }

    synchronized void removeReference(@NotNull PointerReference reference2) {
        int index2;
        if (reference2 == null) {
            SmartPointerTracker.$$$reportNull$$$0(1);
        }
        if ((index2 = reference2.index) < 0) {
            return;
        }
        if (this.references[index2] != reference2) {
            throw new AssertionError((Object)("At " + index2 + " expected " + reference2 + ", found " + this.references[index2]));
        }
        this.references[index2].index = -1;
        this.references[index2] = null;
        --this.size;
    }

    private void processAlivePointers(@NotNull Processor<? super SmartPsiElementPointerImpl<?>> processor) {
        if (processor == null) {
            SmartPointerTracker.$$$reportNull$$$0(2);
        }
        for (int i2 = 0; i2 < this.nextAvailableIndex; ++i2) {
            PointerReference ref = this.references[i2];
            if (ref == null) continue;
            SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
            if (pointer == null) {
                this.removeReference(ref);
                continue;
            }
            if (processor.process(pointer)) continue;
            return;
        }
    }

    private void ensureSorted() {
        if (!this.mySorted) {
            ArrayList pointers2 = new ArrayList();
            this.processAlivePointers(new CommonProcessors.CollectProcessor(pointers2));
            if (this.size != pointers2.size()) {
                throw new AssertionError();
            }
            pointers2.sort((p1, p2) -> MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo()));
            for (int i2 = 0; i2 < pointers2.size(); ++i2) {
                SmartPointerTracker.storePointerReference(this.references, i2, ((SmartPsiElementPointerImpl)pointers2.get((int)i2)).pointerReference);
            }
            Arrays.fill(this.references, pointers2.size(), this.nextAvailableIndex, null);
            this.nextAvailableIndex = pointers2.size();
            this.mySorted = true;
        }
    }

    synchronized void updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        boolean stillSorted;
        if (frozen == null) {
            SmartPointerTracker.$$$reportNull$$$0(3);
        }
        if (events == null) {
            SmartPointerTracker.$$$reportNull$$$0(4);
        }
        if (!(stillSorted = this.markerCache.updateMarkers(frozen, events))) {
            this.mySorted = false;
        }
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull SelfElementInfo info2, @NotNull FrozenDocument document, @NotNull List<? extends DocumentEvent> events) {
        if (info2 == null) {
            SmartPointerTracker.$$$reportNull$$$0(5);
        }
        if (document == null) {
            SmartPointerTracker.$$$reportNull$$$0(6);
        }
        if (events == null) {
            SmartPointerTracker.$$$reportNull$$$0(7);
        }
        return this.markerCache.getUpdatedRange(info2, document, events);
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull PsiFile containingFile, @NotNull Segment segment, boolean isSegmentGreedy, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        if (containingFile == null) {
            SmartPointerTracker.$$$reportNull$$$0(8);
        }
        if (segment == null) {
            SmartPointerTracker.$$$reportNull$$$0(9);
        }
        if (frozen == null) {
            SmartPointerTracker.$$$reportNull$$$0(10);
        }
        if (events == null) {
            SmartPointerTracker.$$$reportNull$$$0(11);
        }
        return MarkerCache.getUpdatedRange(containingFile, segment, isSegmentGreedy, frozen, events);
    }

    synchronized void switchStubToAst(@NotNull AnchorElementInfo info2, @NotNull PsiElement element) {
        if (info2 == null) {
            SmartPointerTracker.$$$reportNull$$$0(12);
        }
        if (element == null) {
            SmartPointerTracker.$$$reportNull$$$0(13);
        }
        info2.switchToTreeRange(element);
        this.markerCache.rangeChanged();
        this.mySorted = false;
    }

    synchronized void fastenBelts(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            SmartPointerTracker.$$$reportNull$$$0(14);
        }
        SmartPointerTracker.processQueue();
        this.processAlivePointers(pointer -> {
            pointer.getElementInfo().fastenBelt(manager);
            return true;
        });
    }

    synchronized void updatePointerTargetsAfterReparse() {
        this.processAlivePointers(pointer -> {
            if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                SmartPointerTracker.updatePointerTarget(pointer, pointer.getPsiRange());
            }
            return true;
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        E actual;
        E cachedElement;
        if (pointer == null) {
            SmartPointerTracker.$$$reportNull$$$0(15);
        }
        if ((cachedElement = pointer.getCachedElement()) == null) {
            return;
        }
        boolean cachedValid = cachedElement.isValid();
        if (cachedValid) {
            if (pointerRange == null) {
                ((SelfElementInfo)pointer.getElementInfo()).switchToAnchor((PsiElement)cachedElement);
                return;
            }
            if (pointerRange.equals(cachedElement.getTextRange())) {
                return;
            }
        }
        if ((actual = pointer.doRestoreElement()) == null && cachedValid && ((SelfElementInfo)pointer.getElementInfo()).updateRangeToPsi(pointerRange, (PsiElement)cachedElement)) {
            return;
        }
        if (actual != cachedElement) {
            pointer.cacheElement(actual);
        }
    }

    private static void storePointerReference(PointerReference[] references, int index2, PointerReference ref) {
        references[index2] = ref;
        ref.index = index2;
    }

    synchronized List<SelfElementInfo> getSortedInfos() {
        this.ensureSorted();
        ArrayList<SelfElementInfo> infos = new ArrayList<SelfElementInfo>(this.size);
        this.processAlivePointers(pointer -> {
            SelfElementInfo info2 = (SelfElementInfo)pointer.getElementInfo();
            if (!info2.hasRange()) {
                return false;
            }
            infos.add(info2);
            return true;
        });
        return infos;
    }

    @TestOnly
    synchronized int getSize() {
        return this.size;
    }

    static void processQueue() {
        PointerReference reference2;
        while ((reference2 = (PointerReference)ourQueue.poll()) != null) {
            if (reference2.get() != null) {
                throw new IllegalStateException("Queued reference has referent!");
            }
            reference2.tracker.removeReference(reference2);
        }
    }

    static {
        Application application = ApplicationManager.getApplication();
        if (!application.isDisposed()) {
            LowMemoryWatcher.register(() -> SmartPointerTracker.processQueue(), application);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartPointerTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processAlivePointers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateMarkers";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpdatedRange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStubToAst";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "fastenBelts";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePointerTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl<?>> {
        @NotNull
        final SmartPointerTracker tracker;
        private int index;

        private PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull SmartPointerTracker tracker) {
            if (pointer == null) {
                PointerReference.$$$reportNull$$$0(0);
            }
            if (tracker == null) {
                PointerReference.$$$reportNull$$$0(1);
            }
            super(pointer, ourQueue);
            this.index = -2;
            this.tracker = tracker;
            pointer.pointerReference = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pointer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tracker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

