/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPsiFileImpl
extends PsiElementBase
implements PsiFileEx {
    private static final Logger LOG = Logger.getInstance(LightPsiFileImpl.class);
    private PsiFile myOriginalFile;
    private boolean myExplicitlySetAsValid;
    private boolean myInvalidated;
    private final FileViewProvider myViewProvider;
    private final PsiManagerImpl myManager;
    private final Language myLanguage;

    public LightPsiFileImpl(@NotNull FileViewProvider provider2, @NotNull Language language) {
        if (provider2 == null) {
            LightPsiFileImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            LightPsiFileImpl.$$$reportNull$$$0(1);
        }
        this.myOriginalFile = null;
        this.myExplicitlySetAsValid = false;
        this.myInvalidated = false;
        this.myViewProvider = provider2;
        this.myManager = (PsiManagerImpl)provider2.getManager();
        this.myLanguage = language;
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    @Override
    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            LightPsiFileImpl.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.myInvalidated) {
            return false;
        }
        if (!this.getViewProvider().isPhysical() || this.myExplicitlySetAsValid) {
            return true;
        }
        return this.getViewProvider().getVirtualFile().isValid();
    }

    public void setIsValidExplicitly(boolean b) {
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        this.myExplicitlySetAsValid = b;
    }

    @Override
    public String getText() {
        return this.getViewProvider().getContents().toString();
    }

    @Override
    public long getModificationStamp() {
        return this.getViewProvider().getModificationStamp();
    }

    @Override
    public void subtreeChanged() {
        this.clearCaches();
        this.getViewProvider().rootChanged(this);
    }

    @Override
    public abstract void clearCaches();

    @Override
    protected LightPsiFileImpl clone() {
        FileViewProvider provider2 = this.getViewProvider().clone();
        LightPsiFileImpl clone = (LightPsiFileImpl)provider2.getPsi(this.getLanguage());
        this.copyCopyableDataTo(clone);
        if (this.getViewProvider().isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        return clone;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.getViewProvider().getVirtualFile().getName();
        if (string2 == null) {
            LightPsiFileImpl.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            LightPsiFileImpl.$$$reportNull$$$0(4);
        }
        this.checkSetName(name);
        this.subtreeChanged();
        return PsiFileImplUtil.setName(this, name);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getViewProvider().getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return this;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFile == null) {
            LightPsiFileImpl.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    public void setOriginalFile(PsiFile originalFile) {
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @Override
    public PsiFile @NotNull [] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            LightPsiFileImpl.$$$reportNull$$$0(6);
        }
        return psiFileArray;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            LightPsiFileImpl.$$$reportNull$$$0(7);
        }
        return language;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            LightPsiFileImpl.$$$reportNull$$$0(8);
        }
        return fileViewProvider;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project2 = manager.getProject();
        if (project2 == null) {
            LightPsiFileImpl.$$$reportNull$$$0(9);
        }
        return project2;
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightPsiFileImpl.$$$reportNull$$$0(10);
        }
        PsiElement child = this.getFirstChild();
        while (child != null) {
            PsiElement nextSibling = child.getNextSibling();
            child.accept(visitor2);
            child = nextSibling;
        }
    }

    @Override
    public final synchronized PsiElement copy() {
        return this.clone();
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(11);
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public synchronized PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            LightPsiFileImpl.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().getDescriptor(this).navigate(requestFocus);
    }

    @Override
    public synchronized PsiElement findElementAt(int offset2) {
        return this.getViewProvider().findElementAt(offset2);
    }

    @Override
    public synchronized PsiReference findReferenceAt(int offset2) {
        return this.getViewProvider().findReferenceAt(offset2);
    }

    @Override
    public char @NotNull [] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence(this.getViewProvider().getContents());
        if (cArray == null) {
            LightPsiFileImpl.$$$reportNull$$$0(13);
        }
        return cArray;
    }

    @Override
    public boolean isContentsLoaded() {
        return true;
    }

    @Override
    public void onContentReload() {
    }

    @Override
    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    @Override
    public abstract PsiElement @NotNull [] getChildren();

    @Override
    public PsiElement getFirstChild() {
        PsiElement[] children2 = this.getChildren();
        return children2.length == 0 ? null : children2[0];
    }

    @Override
    public PsiElement getLastChild() {
        PsiElement[] children2 = this.getChildren();
        return children2.length == 0 ? null : children2[children2.length - 1];
    }

    @Override
    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public int getStartOffsetInParent() {
        return 0;
    }

    @Override
    public int getTextLength() {
        return this.getViewProvider().getContents().length();
    }

    @Override
    public int getTextOffset() {
        return 0;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(14);
        }
        return this.textMatches(element.getText());
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        if (text2 == null) {
            LightPsiFileImpl.$$$reportNull$$$0(15);
        }
        return text2.equals(this.getViewProvider().getContents());
    }

    @Override
    public boolean textContains(char c2) {
        return this.getText().indexOf(c2) >= 0;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(16);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(17);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(18);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addRange(PsiElement first2, PsiElement last2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public final PsiElement addRangeBefore(@NotNull PsiElement first2, @NotNull PsiElement last2, PsiElement anchor) throws IncorrectOperationException {
        if (first2 == null) {
            LightPsiFileImpl.$$$reportNull$$$0(19);
        }
        if (last2 == null) {
            LightPsiFileImpl.$$$reportNull$$$0(20);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public final PsiElement addRangeAfter(PsiElement first2, PsiElement last2, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public void deleteChildRange(PsiElement first2, PsiElement last2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            LightPsiFileImpl.$$$reportNull$$$0(21);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    public abstract LightPsiFileImpl copyLight(FileViewProvider var1);

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 8, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/LightPsiFileImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/LightPsiFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 6, 7, 8, 9, 12, 13 -> new IllegalStateException(string2);
        };
    }
}

