/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeImpl
extends ExternalizableSchemeAdapter
implements CodeStyleScheme,
SerializableScheme {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemeImpl.class);
    private volatile SchemeDataHolder<? super CodeStyleSchemeImpl> myDataHolder;
    private final boolean myIsDefault;
    @NotNull
    private volatile CodeStyleSettings myCodeStyleSettings;
    private long myLastModificationCount;
    private final Object lock;

    CodeStyleSchemeImpl(@NotNull String name, @NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder) {
        if (name == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(0);
        }
        if (dataHolder == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(1);
        }
        this.lock = new Object();
        this.setName(name);
        this.myDataHolder = dataHolder;
        this.myIsDefault = "Default".equals(name);
        this.myCodeStyleSettings = CodeStyleSchemeImpl.init(null);
    }

    public CodeStyleSchemeImpl(@NotNull String name, boolean isDefault, @Nullable CodeStyleScheme parentScheme) {
        if (name == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(2);
        }
        this.lock = new Object();
        this.setName(name);
        this.myIsDefault = isDefault;
        this.myCodeStyleSettings = CodeStyleSchemeImpl.init(parentScheme);
    }

    @NotNull
    private static CodeStyleSettings init(@Nullable CodeStyleScheme parentScheme) {
        CodeStyleSettings settings;
        if (parentScheme == null) {
            settings = CodeStyleSettingsManager.getInstance().createSettings();
            LOG.debug("Initialized using empty settings");
        } else {
            CodeStyleSettings parentSettings = parentScheme.getCodeStyleSettings();
            settings = CodeStyleSettingsManager.getInstance().cloneSettings(parentSettings);
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            settings.setParentSettings(parentSettings);
            LOG.debug("Initialized using parent scheme '" + parentScheme.getName() + "'");
        }
        CodeStyleSettings codeStyleSettings = settings;
        if (codeStyleSettings == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(3);
        }
        return codeStyleSettings;
    }

    private static void readFromDataHolder(@NotNull CodeStyleSettings settings, @NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder) {
        if (settings == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(4);
        }
        if (dataHolder == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(5);
        }
        Element root = dataHolder.read();
        try {
            settings.readExternal(root);
        }
        catch (InvalidDataException e) {
            LOG.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CodeStyleSettings getCodeStyleSettings() {
        SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder = this.myDataHolder;
        if (dataHolder == null) {
            CodeStyleSettings codeStyleSettings = this.myCodeStyleSettings;
            if (codeStyleSettings != null) return codeStyleSettings;
            CodeStyleSchemeImpl.$$$reportNull$$$0(6);
            return codeStyleSettings;
        }
        Object object = this.lock;
        // MONITORENTER : object
        dataHolder = this.myDataHolder;
        if (dataHolder == null) {
            CodeStyleSettings codeStyleSettings = this.myCodeStyleSettings;
            // MONITOREXIT : object
            if (codeStyleSettings != null) return codeStyleSettings;
            CodeStyleSchemeImpl.$$$reportNull$$$0(7);
            return codeStyleSettings;
        }
        this.logDebug("Reinit settings from dataHolder");
        CodeStyleSettings settings = CodeStyleSchemeImpl.init(null);
        CodeStyleSchemeImpl.readFromDataHolder(settings, dataHolder);
        this.myDataHolder = null;
        dataHolder.updateDigest(this);
        this.myCodeStyleSettings = settings;
        CodeStyleSettings codeStyleSettings = settings;
        // MONITOREXIT : object
        if (codeStyleSettings != null) return codeStyleSettings;
        CodeStyleSchemeImpl.$$$reportNull$$$0(8);
        return codeStyleSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(9);
        }
        this.myCodeStyleSettings = codeStyleSettings;
        Object object = this.lock;
        synchronized (object) {
            this.myDataHolder = null;
        }
        this.logDebug("Replaced code style settings");
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SchemeState getSchemeState() {
        Object object = this.lock;
        synchronized (object) {
            long currModificationCount;
            if (this.myDataHolder == null && this.myLastModificationCount != (currModificationCount = this.myCodeStyleSettings.getModificationTracker().getModificationCount())) {
                this.myLastModificationCount = currModificationCount;
                this.logDebug("Possibly changed");
                return SchemeState.POSSIBLY_CHANGED;
            }
            return SchemeState.UNCHANGED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Element writeScheme() {
        SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder;
        Object object = this.lock;
        synchronized (object) {
            dataHolder = this.myDataHolder;
        }
        if (dataHolder == null) {
            Element newElement = new Element("code_scheme");
            newElement.setAttribute("name", this.getName());
            this.myCodeStyleSettings.writeExternal(newElement);
            this.logDebug("Saved from CodeStyleSettings");
            Element element = newElement;
            if (element == null) {
                CodeStyleSchemeImpl.$$$reportNull$$$0(10);
            }
            return element;
        }
        this.logDebug("Saved from dataHolder");
        Element element = dataHolder.read();
        if (element == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(11);
        }
        return element;
    }

    @Override
    @NotNull
    @Nls
    public String getDisplayName() {
        if ("Default".equals(this.getName())) {
            String string2 = ApplicationBundle.message((String)"code.style.scheme.default", (Object[])new Object[0]);
            if (string2 == null) {
                CodeStyleSchemeImpl.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String string3 = super.getDisplayName();
        if (string3 == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(13);
        }
        return string3;
    }

    private void logDebug(@NotNull String message) {
        if (message == null) {
            CodeStyleSchemeImpl.$$$reportNull$$$0(14);
        }
        LOG.debug("Scheme '" + this.getName() + "': " + message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 8, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeStyleSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readFromDataHolder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCodeStyleSettings";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logDebug";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 6, 7, 8, 10, 11, 12, 13 -> new IllegalStateException(string2);
        };
    }
}

