/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiCommentManipulator
extends AbstractElementManipulator<PsiComment> {
    @Override
    public PsiComment handleContentChange(@NotNull PsiComment psiComment, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (psiComment == null) {
            PsiCommentManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PsiCommentManipulator.$$$reportNull$$$0(1);
        }
        String oldText = psiComment.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        FileType type = psiComment.getContainingFile().getFileType();
        PsiFile fromText2 = PsiFileFactory.getInstance(psiComment.getProject()).createFileFromText("__." + type.getDefaultExtension(), type, (CharSequence)newText);
        PsiComment newElement = (PsiComment)PsiTreeUtil.getParentOfType(fromText2.findElementAt(0), psiComment.getClass(), false);
        assert (newElement != null) : type + " " + type.getDefaultExtension() + " " + newText;
        return (PsiComment)psiComment.replace(newElement);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull PsiComment element) {
        String text2;
        if (element == null) {
            PsiCommentManipulator.$$$reportNull$$$0(2);
        }
        if ((text2 = element.getText()).startsWith("//")) {
            return new TextRange(2, element.getTextLength());
        }
        int length = text2.length();
        if (length > 4 && text2.startsWith("/**") && text2.endsWith("*/")) {
            return new TextRange(3, element.getTextLength() - 2);
        }
        if (length > 3 && (text2.startsWith("/*") && text2.endsWith("*/") || text2.startsWith("(*") && text2.endsWith("*)"))) {
            return new TextRange(2, element.getTextLength() - 2);
        }
        if (length > 6 && text2.startsWith("<!--") && text2.endsWith("-->")) {
            return new TextRange(4, element.getTextLength() - 3);
        }
        if (text2.startsWith("--")) {
            return new TextRange(2, element.getTextLength());
        }
        if (text2.startsWith("#")) {
            return new TextRange(1, element.getTextLength());
        }
        TextRange textRange = super.getRangeInElement(element);
        if (textRange == null) {
            PsiCommentManipulator.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiComment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

