/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSetParameters;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileReferenceHelper {
    public static final ExtensionPointName<FileReferenceHelper> EP_NAME = new ExtensionPointName("com.intellij.psi.fileReferenceHelper");

    @ApiStatus.Experimental
    public boolean processContexts(@NotNull FileReferenceSetParameters parameters2, @NotNull VirtualFile hostFile, boolean bind, @NotNull Processor<? super PsiFileSystemItem> processor) {
        if (parameters2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(0);
        }
        if (hostFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            FileReferenceHelper.$$$reportNull$$$0(2);
        }
        PsiElement element = parameters2.getElement();
        this.getContexts(element.getProject(), hostFile).forEach(processor::process);
        return true;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module2, @NotNull VirtualFile hostFile) {
        if (module2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(3);
        }
        if (hostFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(4);
        }
        Collection<PsiFileSystemItem> collection = this.getRoots(module2);
        if (collection == null) {
            FileReferenceHelper.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public abstract boolean isMine(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    public PsiFileSystemItem findRoot(@NotNull Project project2, @NotNull VirtualFile dstVFile) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(6);
        }
        if (dstVFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(7);
        }
        return null;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project2, @NotNull VirtualFile hostFile) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(8);
        }
        if (hostFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(9);
        }
        Set<PsiFileSystemItem> set2 = Collections.emptySet();
        if (set2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(10);
        }
        return set2;
    }

    @ApiStatus.Experimental
    public boolean isMine(@NotNull Project project2, @NotNull VirtualFile contextFile, @NotNull VirtualFile referencedFile) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(11);
        }
        if (contextFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(12);
        }
        if (referencedFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(13);
        }
        return this.isMine(project2, referencedFile);
    }

    @ApiStatus.Experimental
    public boolean processTargetContexts(@NotNull FileReferenceSetParameters parameters2, @NotNull VirtualFile hostFile, @NotNull Processor<? super FileTargetContext> processor) {
        if (parameters2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(14);
        }
        if (hostFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            FileReferenceHelper.$$$reportNull$$$0(16);
        }
        PsiElement element = parameters2.getElement();
        this.getTargetContexts(element.getProject(), hostFile, parameters2.isAbsolutePathReference()).forEach(processor::process);
        return true;
    }

    @NotNull
    public Collection<FileTargetContext> getTargetContexts(@NotNull Project project2, @NotNull VirtualFile hostFile, boolean isAbsoluteReference) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(17);
        }
        if (hostFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(18);
        }
        if (isAbsoluteReference) {
            ProjectFileIndex index2 = ProjectRootManager.getInstance(project2).getFileIndex();
            Module module2 = index2.getModuleForFile(hostFile);
            if (module2 == null) {
                List<FileTargetContext> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileReferenceHelper.$$$reportNull$$$0(19);
                }
                return list2;
            }
            List<FileTargetContext> list3 = ContainerUtil.map(this.getRoots(module2, hostFile), FileTargetContext::new);
            if (list3 == null) {
                FileReferenceHelper.$$$reportNull$$$0(20);
            }
            return list3;
        }
        List<FileTargetContext> list4 = ContainerUtil.map(this.getContexts(project2, hostFile), FileTargetContext::new);
        if (list4 == null) {
            FileReferenceHelper.$$$reportNull$$$0(21);
        }
        return list4;
    }

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            FileReferenceHelper.$$$reportNull$$$0(22);
        }
        String string2 = url;
        if (string2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(23);
        }
        return string2;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(@NotNull FileReference reference2) {
        if (reference2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(24);
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @Nullable
    public PsiFileSystemItem getPsiFileSystemItem(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(27);
        }
        PsiManager psiManager = PsiManager.getInstance(project2);
        return FileReferenceHelper.getPsiFileSystemItem(psiManager, file2);
    }

    @Nullable
    public static PsiFileSystemItem getPsiFileSystemItem(@NotNull PsiManager psiManager, @NotNull VirtualFile file2) {
        if (psiManager == null) {
            FileReferenceHelper.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(29);
        }
        return file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
    }

    @Deprecated
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module2) {
        if (module2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(30);
        }
        List<PsiFileSystemItem> list2 = Collections.emptyList();
        if (list2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(31);
        }
        return list2;
    }

    public boolean isFallback() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 19, 20, 21, 23, 25, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstVFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper";
                break;
            }
            case 5: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContexts";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processContexts";
                break;
            }
            case 3: 
            case 4: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 5: 
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 31: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processTargetContexts";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContexts";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileSystemItem";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 10, 19, 20, 21, 23, 25, 31 -> new IllegalStateException(string2);
        };
    }
}

