/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class JpsFileTargetContextUtils {
    private JpsFileTargetContextUtils() {
    }

    @NotNull
    public static Collection<FileTargetContext> prepareTargetContexts(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull Collection<FileTargetContext> targetContexts) {
        if (project2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(1);
        }
        if (targetContexts == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(2);
        }
        if (targetContexts.size() <= 1) {
            Collection<FileTargetContext> collection = targetContexts;
            if (collection == null) {
                JpsFileTargetContextUtils.$$$reportNull$$$0(3);
            }
            return collection;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project2);
        boolean isInSources = projectFileIndex.isInSourceContent(file2) && !projectFileIndex.isInTestSourceContent(file2);
        List<FileTargetContextWrapper> targetContextWrappers = ContainerUtil.filter(JpsFileTargetContextUtils.findSourceRootTypes(targetContexts), tc -> {
            if (isInSources && tc.getSourceRootType() != null && tc.getSourceRootType().isForTests()) {
                return false;
            }
            return !tc.isInGeneratedSource();
        });
        if (!JpsFileTargetContextUtils.hasEqualSourceRootTypes(targetContextWrappers)) {
            targetContextWrappers = projectFileIndex.isInTestSourceContent(file2) ? ContainerUtil.sorted(targetContextWrappers, JpsFileTargetContextUtils::compareTargetsForTests) : ContainerUtil.sorted(targetContextWrappers, JpsFileTargetContextUtils::compareTargetsForProduction);
        }
        List<FileTargetContext> list2 = ContainerUtil.map(targetContextWrappers, FileTargetContextWrapper::getTargetContext);
        if (list2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static boolean hasEqualSourceRootTypes(@NotNull List<FileTargetContextWrapper> wrappers) {
        if (wrappers == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(5);
        }
        if (wrappers.size() <= 1) {
            return true;
        }
        JpsModuleSourceRootType<?> sourceRootType = null;
        for (FileTargetContextWrapper item : wrappers) {
            JpsModuleSourceRootType<?> itemSourceRootType = item.getSourceRootType();
            if (sourceRootType == null) {
                if (itemSourceRootType == null) continue;
                sourceRootType = itemSourceRootType;
                continue;
            }
            if (sourceRootType == itemSourceRootType) continue;
            return false;
        }
        return true;
    }

    private static List<FileTargetContextWrapper> findSourceRootTypes(Collection<? extends FileTargetContext> targetContexts) {
        return ContainerUtil.map(targetContexts, c2 -> {
            Project project2 = c2.getFileSystemItem().getProject();
            VirtualFile file2 = c2.getFileSystemItem().getVirtualFile();
            if (file2 != null) {
                ProjectFileIndex fileIndex = ProjectFileIndex.getInstance(project2);
                return new FileTargetContextWrapper((FileTargetContext)c2, fileIndex.getContainingSourceRootType(file2), fileIndex.isInGeneratedSources(file2));
            }
            return new FileTargetContextWrapper((FileTargetContext)c2, null, false);
        });
    }

    private static int compareTargetsForTests(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        if (d1 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(6);
        }
        if (d2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(7);
        }
        int o1 = JpsFileTargetContextUtils.getTestsTargetOrdinal(d1);
        int o2 = JpsFileTargetContextUtils.getTestsTargetOrdinal(d2);
        if (o1 > 0 || o2 > 0) {
            return Integer.compare(o1, o2);
        }
        return JpsFileTargetContextUtils.compareDirectoryPaths(d1, d2);
    }

    private static int compareTargetsForProduction(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        if (d1 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(8);
        }
        if (d2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(9);
        }
        int o1 = JpsFileTargetContextUtils.getSourcesTargetOrdinal(d1);
        int o2 = JpsFileTargetContextUtils.getSourcesTargetOrdinal(d2);
        if (o1 > 0 || o2 > 0) {
            return Integer.compare(o1, o2);
        }
        return JpsFileTargetContextUtils.compareDirectoryPaths(d1, d2);
    }

    private static int getTestsTargetOrdinal(@NotNull FileTargetContextWrapper item) {
        JpsModuleSourceRootType<?> type;
        if (item == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(10);
        }
        if (JpsFileTargetContextUtils.isSourceItem(type = item.getSourceRootType())) {
            return 4;
        }
        if (JpsFileTargetContextUtils.isTestSourceItem(type)) {
            return 3;
        }
        if (JpsFileTargetContextUtils.isResourceItem(type)) {
            return 2;
        }
        if (JpsFileTargetContextUtils.isTestResourceItem(type)) {
            return 1;
        }
        return 0;
    }

    private static int getSourcesTargetOrdinal(@NotNull FileTargetContextWrapper item) {
        JpsModuleSourceRootType<?> type;
        if (item == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(11);
        }
        if (JpsFileTargetContextUtils.isTestSourceItem(type = item.getSourceRootType())) {
            return 4;
        }
        if (JpsFileTargetContextUtils.isSourceItem(type)) {
            return 3;
        }
        if (JpsFileTargetContextUtils.isTestResourceItem(type)) {
            return 2;
        }
        if (JpsFileTargetContextUtils.isResourceItem(type)) {
            return 1;
        }
        return 0;
    }

    private static int compareDirectoryPaths(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        if (d1 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(12);
        }
        if (d2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(13);
        }
        PsiFileSystemItem directory1 = d1.getTargetContext().getFileSystemItem();
        PsiFileSystemItem directory2 = d2.getTargetContext().getFileSystemItem();
        assert (directory1 != null) : "Invalid PsiFileSystemItem instances found";
        assert (directory2 != null) : "Invalid PsiFileSystemItem instances found";
        VirtualFile f1 = directory1.getVirtualFile();
        VirtualFile f2 = directory2.getVirtualFile();
        return f1.getPath().compareTo(f2.getPath());
    }

    private static boolean isTestResourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaResourceRootType.TEST_RESOURCE;
    }

    private static boolean isResourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaResourceRootType.RESOURCE;
    }

    private static boolean isTestSourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaSourceRootType.TEST_SOURCE;
    }

    private static boolean isSourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaSourceRootType.SOURCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetContexts";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JpsFileTargetContextUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d1";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d2";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JpsFileTargetContextUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTargetContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetContexts";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasEqualSourceRootTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareTargetsForTests";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTargetsForProduction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestsTargetOrdinal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesTargetOrdinal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compareDirectoryPaths";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }

    private static final class FileTargetContextWrapper {
        private final FileTargetContext myTargetContext;
        private final JpsModuleSourceRootType<?> mySourceRootType;
        private final boolean myInGeneratedSource;

        private FileTargetContextWrapper(@NotNull FileTargetContext context2, @Nullable JpsModuleSourceRootType<?> sourceRootType, boolean inGeneratedSource) {
            if (context2 == null) {
                FileTargetContextWrapper.$$$reportNull$$$0(0);
            }
            this.myTargetContext = context2;
            this.mySourceRootType = sourceRootType;
            this.myInGeneratedSource = inGeneratedSource;
        }

        public FileTargetContext getTargetContext() {
            return this.myTargetContext;
        }

        @Nullable
        public JpsModuleSourceRootType<?> getSourceRootType() {
            return this.mySourceRootType;
        }

        private boolean isInGeneratedSource() {
            return this.myInGeneratedSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JpsFileTargetContextUtils$FileTargetContextWrapper", "<init>"));
        }
    }
}

