/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JpsFileTargetContextUtils;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PsiFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public static PsiFileReferenceHelper getInstance() {
        PsiFileReferenceHelper psiFileReferenceHelper = Objects.requireNonNull(FileReferenceHelper.EP_NAME.findExtension(PsiFileReferenceHelper.class));
        if (psiFileReferenceHelper == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(0);
        }
        return psiFileReferenceHelper;
    }

    @Override
    @NotNull
    public List<? extends LocalQuickFix> registerFixes(@NotNull FileReference reference2) {
        if (reference2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(1);
        }
        List<? extends LocalQuickFix> list2 = FileReferenceQuickFixProvider.registerQuickFix(reference2);
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public PsiFileSystemItem findRoot(@NotNull Project project2, @NotNull VirtualFile file2) {
        ProjectFileIndex index2;
        VirtualFile contentRootForFile;
        if (project2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(4);
        }
        if ((contentRootForFile = (index2 = ProjectRootManager.getInstance(project2).getFileIndex()).getSourceRootForFile(file2)) == null) {
            contentRootForFile = index2.getContentRootForFile(file2);
        }
        if (contentRootForFile != null) {
            return PsiManager.getInstance(project2).findDirectory(contentRootForFile);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module2) {
        if (module2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(5);
        }
        List<PsiFileSystemItem> list2 = PsiFileReferenceHelper.getContextsForModule(module2, "", module2.getModuleWithDependenciesScope());
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<FileTargetContext> getTargetContexts(@NotNull Project project2, @NotNull VirtualFile file2, boolean isAbsoluteReference) {
        List<PsiFileSystemItem> contexts;
        if (project2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(8);
        }
        if (isAbsoluteReference) {
            ProjectFileIndex index2 = ProjectRootManager.getInstance(project2).getFileIndex();
            Module module2 = index2.getModuleForFile(file2);
            if (module2 == null) {
                List<FileTargetContext> list2 = Collections.emptyList();
                if (list2 == null) {
                    PsiFileReferenceHelper.$$$reportNull$$$0(9);
                }
                return list2;
            }
            contexts = PsiFileReferenceHelper.getContextsForModule(module2, "", module2.getModuleWithDependenciesScope());
        } else {
            contexts = this.getContexts(project2, file2, true);
        }
        ArrayList<FileTargetContext> fileTargetContexts = new ArrayList<FileTargetContext>();
        for (PsiFileSystemItem context2 : contexts) {
            if (context2 instanceof VirtualPsiDirectory) {
                VirtualPsiDirectory virtual = (VirtualPsiDirectory)context2;
                fileTargetContexts.add(new FileTargetContext(virtual.getRoot(), virtual.getPathToCreate()));
                continue;
            }
            fileTargetContexts.add(new FileTargetContext(context2));
        }
        Collection<FileTargetContext> collection = JpsFileTargetContextUtils.prepareTargetContexts(project2, file2, fileTargetContexts);
        if (collection == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private static String @NotNull [] removeCommonStartPackages(String @NotNull [] path2, @NotNull String packagePath) {
        String existingPackage;
        String part;
        int i2;
        if (packagePath == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(11);
        }
        if (path2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(12);
        }
        List<String> packages = StringUtil.split(packagePath, ".");
        SmartList<String> result2 = new SmartList<String>();
        for (i2 = 0; i2 < packages.size() && i2 < path2.length && Objects.equals(part = path2[i2], existingPackage = packages.get(i2)); ++i2) {
        }
        while (i2 < path2.length) {
            result2.add(path2[i2]);
            ++i2;
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    private static String @NotNull [] getRelativePath(@NotNull VirtualFile file2, @NotNull VirtualFile root) {
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(14);
        }
        if (root == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(15);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (VirtualFile parent2 = file2; parent2 != null && !parent2.equals(root); parent2 = parent2.getParent()) {
            names.add(parent2.getName());
        }
        if (names.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PsiFileReferenceHelper.$$$reportNull$$$0(16);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] path2 = new String[names.size()];
        for (int i2 = 0; i2 < names.size(); ++i2) {
            path2[i2] = (String)names.get(names.size() - i2 - 1);
        }
        if (path2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(17);
        }
        return path2;
    }

    @NotNull
    private static List<SourceFolder> getMissingTargetFolders(@NotNull Module module2, @NotNull Collection<? extends PsiFileSystemItem> contextsForModule) {
        if (module2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(18);
        }
        if (contextsForModule == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(19);
        }
        ModuleRootManager model2 = ModuleRootManager.getInstance(module2);
        List list2 = Arrays.stream(model2.getContentEntries()).flatMap(contentEntry -> Arrays.stream(contentEntry.getSourceFolders())).filter(sourceFolder -> {
            if (sourceFolder.getFile() == null) {
                return false;
            }
            for (PsiFileSystemItem contextItem : contextsForModule) {
                if (!VfsUtilCore.isAncestor(sourceFolder.getFile(), contextItem.getVirtualFile(), false)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toCollection(SmartList::new));
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    private List<PsiFileSystemItem> getContexts(@NotNull Project project2, @NotNull VirtualFile file2, boolean includeMissingPackages) {
        PsiFileSystemItem parent2;
        PsiFileSystemItem item;
        if (project2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(21);
        }
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(22);
        }
        if ((item = this.getPsiFileSystemItem(project2, file2)) != null && (parent2 = item.getParent()) != null) {
            Module module2;
            Object path2;
            ProjectFileIndex index2 = ProjectRootManager.getInstance(project2).getFileIndex();
            VirtualFile parentFile = parent2.getVirtualFile();
            assert (parentFile != null);
            VirtualFile root = index2.getSourceRootForFile(parentFile);
            if (root != null && (path2 = VfsUtilCore.getRelativePath(parentFile, root, '.')) != null && (module2 = index2.getModuleForFile(file2)) != null) {
                List<PsiFileSystemItem> contextsForModule;
                OrderEntry orderEntry2 = ModuleRootManager.getInstance(module2).getFileIndex().getOrderEntryForFile(file2);
                String rootPackagePrefix = PsiFileReferenceHelper.getSourceRootPackagePrefix(orderEntry2, root);
                if (!rootPackagePrefix.isEmpty()) {
                    path2 = (String)path2 + "." + rootPackagePrefix;
                }
                List<PsiFileSystemItem> list2 = contextsForModule = ModelBranch.getPsiBranch(item) != null ? PsiFileReferenceHelper.getContextsForScope(project2, (String)path2, item.getResolveScope().intersectWith(ProjectScope.getContentScope(project2))) : PsiFileReferenceHelper.getContextsForModule(module2, (String)path2, module2.getModuleWithDependenciesScope());
                if (!includeMissingPackages) {
                    List<PsiFileSystemItem> list3 = contextsForModule;
                    if (list3 == null) {
                        PsiFileReferenceHelper.$$$reportNull$$$0(23);
                    }
                    return list3;
                }
                return PsiFileReferenceHelper.getAdditionalContexts(parentFile, root, module2, contextsForModule);
            }
            List<PsiFileSystemItem> list4 = Collections.singletonList(parent2);
            if (list4 == null) {
                PsiFileReferenceHelper.$$$reportNull$$$0(24);
            }
            return list4;
        }
        List<PsiFileSystemItem> list5 = Collections.emptyList();
        if (list5 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(25);
        }
        return list5;
    }

    @NotNull
    private static List<PsiFileSystemItem> getAdditionalContexts(@NotNull VirtualFile parentFile, @NotNull VirtualFile root, @NotNull Module module2, @NotNull List<PsiFileSystemItem> contextsForModule) {
        List<SourceFolder> additionalSourceFolders;
        if (parentFile == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(26);
        }
        if (root == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(27);
        }
        if (module2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(28);
        }
        if (contextsForModule == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(29);
        }
        if ((additionalSourceFolders = PsiFileReferenceHelper.getMissingTargetFolders(module2, contextsForModule)).isEmpty()) {
            List<PsiFileSystemItem> list2 = contextsForModule;
            if (list2 == null) {
                PsiFileReferenceHelper.$$$reportNull$$$0(30);
            }
            return list2;
        }
        ArrayList<PsiFileSystemItem> joinedContexts = new ArrayList<PsiFileSystemItem>(contextsForModule.size() + additionalSourceFolders.size());
        joinedContexts.addAll(contextsForModule);
        PsiManager manager = PsiManager.getInstance(module2.getProject());
        String[] relativePath = PsiFileReferenceHelper.getRelativePath(parentFile, root);
        for (SourceFolder sourceFolder : additionalSourceFolders) {
            PsiDirectory directory;
            if (sourceFolder.getFile() == null || (directory = manager.findDirectory(sourceFolder.getFile())) == null) continue;
            String srcPackagePrefix = sourceFolder.getPackagePrefix();
            String[] pathToCreate = srcPackagePrefix.isEmpty() ? relativePath : PsiFileReferenceHelper.removeCommonStartPackages(relativePath, srcPackagePrefix);
            joinedContexts.add(new VirtualPsiDirectory(directory, pathToCreate));
        }
        ArrayList<PsiFileSystemItem> arrayList = joinedContexts;
        if (arrayList == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(32);
        }
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(33);
        }
        return this.getContexts(project2, file2, false);
    }

    @NotNull
    private static String getSourceRootPackagePrefix(@Nullable OrderEntry orderEntry2, @NotNull VirtualFile sourceRootOfFile) {
        if (sourceRootOfFile == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(34);
        }
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            for (ContentEntry e : ((ModuleSourceOrderEntry)orderEntry2).getRootModel().getContentEntries()) {
                for (SourceFolder sf : e.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    String s;
                    if (!sourceRootOfFile.equals(sf.getFile()) || (s = sf.getPackagePrefix()).isEmpty()) continue;
                    String string2 = s;
                    if (string2 == null) {
                        PsiFileReferenceHelper.$$$reportNull$$$0(35);
                    }
                    return string2;
                }
            }
        }
        return "";
    }

    @Override
    public boolean isMine(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(36);
        }
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(37);
        }
        ProjectFileIndex index2 = ProjectRootManager.getInstance(project2).getFileIndex();
        return index2.isInSourceContent(file2);
    }

    @Override
    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(38);
        }
        String string2 = url.trim();
        if (string2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(39);
        }
        return string2;
    }

    static List<PsiFileSystemItem> getContextsForModule(@NotNull Module module2, @NotNull String packageName, @Nullable GlobalSearchScope scope) {
        if (module2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(40);
        }
        if (packageName == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(41);
        }
        Query<VirtualFile> query2 = PlatformPackageUtil.getDirectoriesByPackageName(packageName, false, module2.getProject());
        return ((StreamEx)StreamEx.of(query2.findAll()).filter(scope == null ? Predicates.alwaysTrue() : file2 -> scope.contains((VirtualFile)file2))).map(PsiManager.getInstance(module2.getProject())::findDirectory).nonNull().toList();
    }

    @NotNull
    static List<PsiFileSystemItem> getContextsForScope(@NotNull Project project2, @NotNull String packageName, @NotNull GlobalSearchScope scope) {
        if (project2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(42);
        }
        if (packageName == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(43);
        }
        if (scope == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(44);
        }
        Query<VirtualFile> query2 = PlatformPackageUtil.getDirectoriesByPackageName(packageName, scope, project2);
        List<VirtualFile> files2 = ContainerUtil.reverse(ContainerUtil.sorted(query2.findAll(), scope::compare));
        List<PsiFileSystemItem> list2 = ContainerUtil.mapNotNull(files2, PsiManager.getInstance(project2)::findDirectory);
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(45);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 7, 8, 11, 12, 14, 15, 18, 19, 21, 22, 26, 27, 28, 29, 32, 33, 34, 36, 37, 38, 40, 41, 42, 43, 44 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 7: 
            case 21: 
            case 32: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 22: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 18: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextsForModule";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootOfFile";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContexts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCommonStartPackages";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingTargetFolders";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalContexts";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootPackagePrefix";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextsForScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContexts";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonStartPackages";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMissingTargetFolders";
                break;
            }
            case 21: 
            case 22: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalContexts";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootPackagePrefix";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getContextsForModule";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getContextsForScope";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 3, 4, 5, 7, 8, 11, 12, 14, 15, 18, 19, 21, 22, 26, 27, 28, 29, 32, 33, 34, 36, 37, 38, 40, 41, 42, 43, 44 -> new IllegalArgumentException(string2);
        };
    }

    private static final class VirtualPsiDirectory
    extends SyntheticFileSystemItem {
        private final PsiDirectory myRoot;
        private final String[] myPathToCreate;

        private VirtualPsiDirectory(@NotNull PsiDirectory root, String @NotNull [] pathToCreate) {
            if (root == null) {
                VirtualPsiDirectory.$$$reportNull$$$0(0);
            }
            if (pathToCreate == null) {
                VirtualPsiDirectory.$$$reportNull$$$0(1);
            }
            super(root.getProject());
            this.myRoot = root;
            this.myPathToCreate = pathToCreate;
        }

        @Override
        @Nullable
        public PsiFileSystemItem getParent() {
            return this.myRoot;
        }

        @Override
        public VirtualFile getVirtualFile() {
            return null;
        }

        private PsiDirectory getRoot() {
            return this.myRoot;
        }

        private String @NotNull [] getPathToCreate() {
            if (this.myPathToCreate == null) {
                VirtualPsiDirectory.$$$reportNull$$$0(2);
            }
            return this.myPathToCreate;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        @NotNull
        public String getName() {
            String string2 = this.myPathToCreate.length == 0 ? this.myRoot.getName() : this.myPathToCreate[this.myPathToCreate.length - 1];
            if (string2 == null) {
                VirtualPsiDirectory.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
            if (processor == null) {
                VirtualPsiDirectory.$$$reportNull$$$0(4);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathToCreate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper$VirtualPsiDirectory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper$VirtualPsiDirectory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathToCreate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processChildren";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

