/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.annotations.NotNull;

@Service
public final class ConcatenationInjectorManager
extends SimpleModificationTracker
implements Disposable {
    public static final ProjectExtensionPointName<ConcatenationAwareInjector> EP_NAME = new ProjectExtensionPointName("com.intellij.concatenationAwareInjector");
    private static final Key<ParameterizedCachedValue<InjectionResult, PsiElement>> INJECTED_PSI_IN_CONCATENATION = Key.create("INJECTED_PSI_IN_CONCATENATION");
    private static final Key<Integer> NO_CONCAT_INJECTION_TIMESTAMP = Key.create("NO_CONCAT_INJECTION_TIMESTAMP");

    public ConcatenationInjectorManager(@NotNull Project project2) {
        if (project2 == null) {
            ConcatenationInjectorManager.$$$reportNull$$$0(0);
        }
        EP_NAME.addChangeListener(project2, this::concatenationInjectorsChanged, null);
        project2.getMessageBus().connect(this).subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ConcatenationInjectorManager.this.incModificationCount();
            }
        });
    }

    public static ConcatenationInjectorManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ConcatenationInjectorManager.$$$reportNull$$$0(1);
        }
        return project2.getService(ConcatenationInjectorManager.class);
    }

    private static InjectionResult doCompute(@NotNull PsiFile containingFile, @NotNull Project project2, @NotNull PsiElement anchor, PsiElement @NotNull [] operands) {
        if (containingFile == null) {
            ConcatenationInjectorManager.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            ConcatenationInjectorManager.$$$reportNull$$$0(3);
        }
        if (anchor == null) {
            ConcatenationInjectorManager.$$$reportNull$$$0(4);
        }
        if (operands == null) {
            ConcatenationInjectorManager.$$$reportNull$$$0(5);
        }
        PsiDocumentManager docManager = PsiDocumentManager.getInstance(project2);
        InjectionRegistrarImpl registrar = new InjectionRegistrarImpl(project2, containingFile, anchor, docManager);
        InjectionResult result2 = null;
        for (ConcatenationAwareInjector concatenationInjector : EP_NAME.getExtensions(project2)) {
            concatenationInjector.getLanguagesToInject(registrar, operands);
            result2 = registrar.getInjectedResult();
            if (result2 == null) continue;
            break;
        }
        return result2;
    }

    private void concatenationInjectorsChanged() {
        this.incModificationCount();
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operands";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/ConcatenationInjectorManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doCompute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class BaseConcatenation2InjectorAdapter
    implements MultiHostInjector {
        private final Project myProject;

        public BaseConcatenation2InjectorAdapter(@NotNull Project project2) {
            if (project2 == null) {
                BaseConcatenation2InjectorAdapter.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context2) {
            InjectionResult result2;
            if (registrar == null) {
                BaseConcatenation2InjectorAdapter.$$$reportNull$$$0(1);
            }
            if (context2 == null) {
                BaseConcatenation2InjectorAdapter.$$$reportNull$$$0(2);
            }
            if (!EP_NAME.hasAnyExtensions(context2.getProject())) {
                return;
            }
            PsiFile containingFile = ((InjectionRegistrarImpl)registrar).getHostPsiFile();
            Project project2 = containingFile.getProject();
            long modificationCount = PsiManager.getInstance(project2).getModificationTracker().getModificationCount();
            Pair<PsiElement, PsiElement[]> pair = this.computeAnchorAndOperands(context2);
            PsiElement anchor = (PsiElement)pair.first;
            PsiElement[] operands = (PsiElement[])pair.second;
            Integer noInjectionTimestamp = anchor.getUserData(NO_CONCAT_INJECTION_TIMESTAMP);
            ParameterizedCachedValue<InjectionResult, PsiElement> data2 = null;
            if (operands.length == 0 || noInjectionTimestamp != null && (long)noInjectionTimestamp.intValue() == modificationCount) {
                result2 = null;
            } else {
                data2 = anchor.getUserData(INJECTED_PSI_IN_CONCATENATION);
                InjectionResult injectionResult = result2 = data2 == null ? null : data2.getValue(context2);
                if (result2 == null || !result2.isValid()) {
                    result2 = ConcatenationInjectorManager.doCompute(containingFile, project2, anchor, operands);
                }
            }
            if (result2 != null) {
                ((InjectionRegistrarImpl)registrar).addToResults(result2);
                if (data2 == null) {
                    CachedValueProvider.Result<InjectionResult> cachedResult = CachedValueProvider.Result.create(result2, ConcatenationInjectorManager.getInstance(this.myProject));
                    data2 = CachedValuesManager.getManager(project2).createParameterizedCachedValue(context1 -> {
                        PsiFile containingFile1 = context1.getContainingFile();
                        Project project1 = containingFile1.getProject();
                        Pair<PsiElement, PsiElement[]> pair1 = this.computeAnchorAndOperands((PsiElement)context1);
                        InjectionResult result1 = ((PsiElement[])pair1.second).length == 0 ? null : ConcatenationInjectorManager.doCompute(containingFile1, project1, (PsiElement)pair1.first, (PsiElement[])pair1.second);
                        return result1 == null ? null : CachedValueProvider.Result.create(result1, ConcatenationInjectorManager.getInstance(this.myProject));
                    }, false);
                    ((PsiParameterizedCachedValue)data2).setValue(cachedResult);
                    anchor.putUserData(INJECTED_PSI_IN_CONCATENATION, data2);
                    if (anchor.getUserData(NO_CONCAT_INJECTION_TIMESTAMP) != null) {
                        anchor.putUserData(NO_CONCAT_INJECTION_TIMESTAMP, null);
                    }
                }
            } else {
                if (anchor.getUserData(INJECTED_PSI_IN_CONCATENATION) != null) {
                    anchor.putUserData(INJECTED_PSI_IN_CONCATENATION, null);
                }
                anchor.putUserData(NO_CONCAT_INJECTION_TIMESTAMP, (int)modificationCount);
            }
        }

        protected abstract Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(@NotNull PsiElement var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registrar";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/ConcatenationInjectorManager$BaseConcatenation2InjectorAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLanguagesToInject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

