/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.LightHighlighterClient;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.CaretModelWindow;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.EditorWindowTracker;
import com.intellij.psi.impl.source.tree.injected.FoldingModelWindow;
import com.intellij.psi.impl.source.tree.injected.FoldingRegionWindow;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InlayModelWindow;
import com.intellij.psi.impl.source.tree.injected.ListenerWrapperMap;
import com.intellij.psi.impl.source.tree.injected.SelectionModelWindow;
import com.intellij.psi.impl.source.tree.injected.SoftWrapModelWindow;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.UnsafeWeakList;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.IntFunction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorWindowTrackerImpl
extends EditorWindowTracker {
    private final Collection<EditorWindowImpl> allEditors = new UnsafeWeakList<EditorWindowImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    Editor createEditor(@NotNull DocumentWindowImpl documentRange, @NotNull EditorImpl editor2, @NotNull PsiFile injectedFile) {
        if (documentRange == null) {
            EditorWindowTrackerImpl.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EditorWindowTrackerImpl.$$$reportNull$$$0(1);
        }
        if (injectedFile == null) {
            EditorWindowTrackerImpl.$$$reportNull$$$0(2);
        }
        assert (documentRange.isValid());
        assert (injectedFile.isValid());
        Ref editorWindow = Ref.create();
        Collection<EditorWindowImpl> collection = this.allEditors;
        synchronized (collection) {
            for (EditorWindowImpl oldEditorWindow : this.allEditors) {
                if (oldEditorWindow.getDocument() != documentRange || oldEditorWindow.getDelegate() != editor2) continue;
                oldEditorWindow.myInjectedFile = injectedFile;
                if (!oldEditorWindow.isValid()) continue;
                EditorWindowImpl editorWindowImpl = oldEditorWindow;
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var5_5
                if (editorWindowImpl == null) {
                    EditorWindowTrackerImpl.$$$reportNull$$$0(3);
                }
                return editorWindowImpl;
            }
            editor2.executeNonCancelableBlock(() -> {
                EditorWindowImpl newEditorWindow = new EditorWindowImpl(documentRange, editor2, injectedFile, documentRange.isOneLine());
                editorWindow.set(newEditorWindow);
                this.allEditors.add(newEditorWindow);
                newEditorWindow.assertValid();
            });
        }
        Editor editor3 = (Editor)editorWindow.get();
        if (editor3 == null) {
            EditorWindowTrackerImpl.$$$reportNull$$$0(4);
        }
        return editor3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeInvalidEditors() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Collection<EditorWindowImpl> collection = this.allEditors;
        synchronized (collection) {
            Iterator<EditorWindowImpl> iterator2 = this.allEditors.iterator();
            while (iterator2.hasNext()) {
                EditorWindowImpl editorWindow = iterator2.next();
                if (editorWindow.isValid()) continue;
                editorWindow.dispose();
                iterator2.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeEditorFor(@NotNull DocumentWindow documentWindow) {
        if (documentWindow == null) {
            EditorWindowTrackerImpl.$$$reportNull$$$0(5);
        }
        Collection<EditorWindowImpl> collection = this.allEditors;
        synchronized (collection) {
            Iterator<EditorWindowImpl> iterator2 = this.allEditors.iterator();
            while (iterator2.hasNext()) {
                EditorWindowImpl editor2 = iterator2.next();
                if (!InjectionRegistrarImpl.intersect(editor2.getDocument(), (DocumentWindowImpl)documentWindow)) continue;
                editor2.dispose();
                iterator2.remove();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/EditorWindowTrackerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/EditorWindowTrackerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disposeEditorFor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }

    private static final class EditorWindowImpl
    extends UserDataHolderBase
    implements EditorWindow,
    EditorEx {
        private final DocumentWindowImpl myDocumentWindow;
        private final EditorImpl myDelegate;
        private volatile PsiFile myInjectedFile;
        private final boolean myOneLine;
        private final CaretModelWindow myCaretModelDelegate;
        private final SelectionModelWindow mySelectionModelDelegate;
        private volatile boolean myDisposed;
        private final MarkupModelWindow myMarkupModelDelegate;
        private final MarkupModelWindow myDocumentMarkupModelDelegate;
        private final FoldingModelWindow myFoldingModelWindow;
        private final SoftWrapModelWindow mySoftWrapModel;
        private final InlayModelWindow myInlayModel;
        private final ListenerWrapperMap<EditorMouseListener> myEditorMouseListeners;
        private final ListenerWrapperMap<EditorMouseMotionListener> myEditorMouseMotionListeners;

        private EditorWindowImpl(@NotNull DocumentWindowImpl documentWindow, @NotNull EditorImpl delegate2, @NotNull PsiFile injectedFile, boolean oneLine) {
            if (documentWindow == null) {
                EditorWindowImpl.$$$reportNull$$$0(0);
            }
            if (delegate2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(1);
            }
            if (injectedFile == null) {
                EditorWindowImpl.$$$reportNull$$$0(2);
            }
            this.myEditorMouseListeners = new ListenerWrapperMap();
            this.myEditorMouseMotionListeners = new ListenerWrapperMap();
            this.myDocumentWindow = documentWindow;
            this.myDelegate = delegate2;
            this.myInjectedFile = injectedFile;
            this.myOneLine = oneLine;
            this.myCaretModelDelegate = new CaretModelWindow((CaretModel)this.myDelegate.getCaretModel(), this);
            this.mySelectionModelDelegate = new SelectionModelWindow((EditorEx)this.myDelegate, this.myDocumentWindow, this);
            this.myMarkupModelDelegate = new MarkupModelWindow(this.myDelegate.getMarkupModel(), (DocumentWindow)this.myDocumentWindow);
            this.myDocumentMarkupModelDelegate = new MarkupModelWindow(this.myDelegate.getFilteredDocumentMarkupModel(), (DocumentWindow)this.myDocumentWindow);
            this.myFoldingModelWindow = new FoldingModelWindow((FoldingModelEx)delegate2.getFoldingModel(), documentWindow, this);
            this.mySoftWrapModel = new SoftWrapModelWindow();
            this.myInlayModel = new InlayModelWindow();
        }

        public boolean isValid() {
            return !this.isDisposed() && !this.myInjectedFile.getProject().isDisposed() && this.myInjectedFile.isValid() && this.myDocumentWindow.isValid();
        }

        private void assertValid() {
            PsiUtilCore.ensureValid(this.myInjectedFile);
            if (!this.isValid()) {
                StringBuilder reason = new StringBuilder("Not valid");
                if (this.myDisposed) {
                    reason.append("; editorWindow: disposed");
                }
                if (!this.myDocumentWindow.isValid()) {
                    reason.append("; documentWindow: invalid");
                }
                if (this.myDelegate.isDisposed()) {
                    reason.append("; editor: disposed");
                }
                if (this.myInjectedFile.getProject().isDisposed()) {
                    reason.append("; project: disposed");
                }
                throw new AssertionError((Object)reason.toString());
            }
        }

        @NotNull
        public PsiFile getInjectedFile() {
            PsiFile psiFile = this.myInjectedFile;
            if (psiFile == null) {
                EditorWindowImpl.$$$reportNull$$$0(3);
            }
            return psiFile;
        }

        @NotNull
        public LogicalPosition hostToInjected(@NotNull LogicalPosition hPos) {
            LogicalPosition iPos;
            if (hPos == null) {
                EditorWindowImpl.$$$reportNull$$$0(4);
            }
            this.assertValid();
            DocumentEx hostDocument = this.myDelegate.getDocument();
            int hLineEndOffset = hPos.line >= hostDocument.getLineCount() ? hostDocument.getTextLength() : hostDocument.getLineEndOffset(hPos.line);
            LogicalPosition hLineEndPos = this.myDelegate.offsetToLogicalPosition(hLineEndOffset);
            if (hLineEndPos.column < hPos.column && (iPos = this.myDocumentWindow.hostToInjectedInVirtualSpace(hPos)) != null) {
                LogicalPosition logicalPosition = iPos;
                if (logicalPosition == null) {
                    EditorWindowImpl.$$$reportNull$$$0(5);
                }
                return logicalPosition;
            }
            int hOffset = this.myDelegate.logicalPositionToOffset(hPos);
            int iOffset = this.myDocumentWindow.hostToInjected(hOffset);
            LogicalPosition logicalPosition = this.offsetToLogicalPosition(iOffset);
            if (logicalPosition == null) {
                EditorWindowImpl.$$$reportNull$$$0(6);
            }
            return logicalPosition;
        }

        @NotNull
        public LogicalPosition injectedToHost(@NotNull LogicalPosition pos) {
            if (pos == null) {
                EditorWindowImpl.$$$reportNull$$$0(7);
            }
            this.assertValid();
            int offset2 = this.logicalPositionToOffset(pos);
            LogicalPosition samePos = this.offsetToLogicalPosition(offset2);
            int virtualSpaceDelta = offset2 < this.myDocumentWindow.getTextLength() && samePos.line == pos.line && samePos.column < pos.column ? pos.column - samePos.column : 0;
            LogicalPosition hostPos = this.myDelegate.offsetToLogicalPosition(this.myDocumentWindow.injectedToHost(offset2));
            return new LogicalPosition(hostPos.line, hostPos.column + virtualSpaceDelta);
        }

        private void dispose() {
            assert (!this.myDisposed);
            this.myCaretModelDelegate.disposeModel();
            for (EditorMouseListener editorMouseListener2 : this.myEditorMouseListeners.wrappers()) {
                this.myDelegate.removeEditorMouseListener(editorMouseListener2);
            }
            this.myEditorMouseListeners.clear();
            for (EditorMouseMotionListener editorMouseMotionListener : this.myEditorMouseMotionListeners.wrappers()) {
                this.myDelegate.removeEditorMouseMotionListener(editorMouseMotionListener);
            }
            this.myEditorMouseMotionListeners.clear();
            this.myDisposed = true;
            Disposer.dispose(this.myDocumentWindow);
            InjectedLanguageUtilBase.clearCaches(this.myInjectedFile.getProject(), this.getDocument());
        }

        public void setViewer(boolean isViewer) {
            this.myDelegate.setViewer(isViewer);
        }

        public boolean isViewer() {
            return this.myDelegate.isViewer();
        }

        public boolean isRendererMode() {
            return this.myDelegate.isRendererMode();
        }

        public void setRendererMode(boolean isRendererMode) {
            this.myDelegate.setRendererMode(isRendererMode);
        }

        public void setFile(VirtualFile vFile) {
            this.myDelegate.setFile(vFile);
        }

        public void setHeaderComponent(@Nullable JComponent header) {
        }

        public boolean hasHeaderComponent() {
            return false;
        }

        @Nullable
        public JComponent getHeaderComponent() {
            return null;
        }

        public TextDrawingCallback getTextDrawingCallback() {
            return this.myDelegate.getTextDrawingCallback();
        }

        @NotNull
        public SelectionModel getSelectionModel() {
            SelectionModelWindow selectionModelWindow = this.mySelectionModelDelegate;
            if (selectionModelWindow == null) {
                EditorWindowImpl.$$$reportNull$$$0(8);
            }
            return selectionModelWindow;
        }

        @NotNull
        public MarkupModelEx getMarkupModel() {
            MarkupModelWindow markupModelWindow = this.myMarkupModelDelegate;
            if (markupModelWindow == null) {
                EditorWindowImpl.$$$reportNull$$$0(9);
            }
            return markupModelWindow;
        }

        @NotNull
        public MarkupModelEx getFilteredDocumentMarkupModel() {
            MarkupModelWindow markupModelWindow = this.myDocumentMarkupModelDelegate;
            if (markupModelWindow == null) {
                EditorWindowImpl.$$$reportNull$$$0(10);
            }
            return markupModelWindow;
        }

        @NotNull
        public FoldingModelEx getFoldingModel() {
            FoldingModelWindow foldingModelWindow = this.myFoldingModelWindow;
            if (foldingModelWindow == null) {
                EditorWindowImpl.$$$reportNull$$$0(11);
            }
            return foldingModelWindow;
        }

        @NotNull
        public CaretModel getCaretModel() {
            CaretModelWindow caretModelWindow = this.myCaretModelDelegate;
            if (caretModelWindow == null) {
                EditorWindowImpl.$$$reportNull$$$0(12);
            }
            return caretModelWindow;
        }

        @NotNull
        public ScrollingModelEx getScrollingModel() {
            ScrollingModelEx scrollingModelEx = this.myDelegate.getScrollingModel();
            if (scrollingModelEx == null) {
                EditorWindowImpl.$$$reportNull$$$0(13);
            }
            return scrollingModelEx;
        }

        @NotNull
        public SoftWrapModelEx getSoftWrapModel() {
            SoftWrapModelWindow softWrapModelWindow = this.mySoftWrapModel;
            if (softWrapModelWindow == null) {
                EditorWindowImpl.$$$reportNull$$$0(14);
            }
            return softWrapModelWindow;
        }

        @NotNull
        public EditorSettings getSettings() {
            EditorSettings editorSettings = this.myDelegate.getSettings();
            if (editorSettings == null) {
                EditorWindowImpl.$$$reportNull$$$0(15);
            }
            return editorSettings;
        }

        @NotNull
        public InlayModel getInlayModel() {
            InlayModelWindow inlayModelWindow = this.myInlayModel;
            if (inlayModelWindow == null) {
                EditorWindowImpl.$$$reportNull$$$0(16);
            }
            return inlayModelWindow;
        }

        @NotNull
        public EditorKind getEditorKind() {
            EditorKind editorKind = this.myDelegate.getEditorKind();
            if (editorKind == null) {
                EditorWindowImpl.$$$reportNull$$$0(17);
            }
            return editorKind;
        }

        public void reinitSettings() {
            this.myDelegate.reinitSettings();
        }

        public void setFontSize(int fontSize) {
            this.myDelegate.setFontSize(fontSize);
        }

        public void setFontSize(float fontSize) {
            this.myDelegate.setFontSize(fontSize);
        }

        public void setHighlighter(@NotNull EditorHighlighter highlighter) {
            if (highlighter == null) {
                EditorWindowImpl.$$$reportNull$$$0(18);
            }
            this.myDelegate.setHighlighter(highlighter);
        }

        @NotNull
        public EditorHighlighter getHighlighter() {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.myInjectedFile.getLanguage(), (Project)this.getProject(), (VirtualFile)this.myInjectedFile.getVirtualFile());
            EditorHighlighter highlighter = HighlighterFactory.createHighlighter((SyntaxHighlighter)syntaxHighlighter, (EditorColorsScheme)scheme);
            highlighter.setText((CharSequence)this.getDocument().getText());
            highlighter.setEditor((HighlighterClient)new LightHighlighterClient((Document)this.getDocument(), this.getProject()));
            EditorHighlighter editorHighlighter = highlighter;
            if (editorHighlighter == null) {
                EditorWindowImpl.$$$reportNull$$$0(19);
            }
            return editorHighlighter;
        }

        public JComponent getPermanentHeaderComponent() {
            return this.myDelegate.getPermanentHeaderComponent();
        }

        public void setPermanentHeaderComponent(JComponent component2) {
            this.myDelegate.setPermanentHeaderComponent(component2);
        }

        @NotNull
        public JComponent getContentComponent() {
            EditorComponentImpl editorComponentImpl = this.myDelegate.getContentComponent();
            if (editorComponentImpl == null) {
                EditorWindowImpl.$$$reportNull$$$0(20);
            }
            return editorComponentImpl;
        }

        @NotNull
        public EditorGutterComponentEx getGutterComponentEx() {
            EditorGutterComponentEx editorGutterComponentEx = this.myDelegate.getGutterComponentEx();
            if (editorGutterComponentEx == null) {
                EditorWindowImpl.$$$reportNull$$$0(21);
            }
            return editorGutterComponentEx;
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(22);
            }
            this.myDelegate.addPropertyChangeListener(listener2);
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(23);
            }
            if (parentDisposable == null) {
                EditorWindowImpl.$$$reportNull$$$0(24);
            }
            this.myDelegate.addPropertyChangeListener(listener2, parentDisposable);
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(25);
            }
            this.myDelegate.removePropertyChangeListener(listener2);
        }

        public void setInsertMode(boolean mode) {
            this.myDelegate.setInsertMode(mode);
        }

        public boolean isInsertMode() {
            return this.myDelegate.isInsertMode();
        }

        public void setColumnMode(boolean mode) {
            this.myDelegate.setColumnMode(mode);
        }

        public boolean isColumnMode() {
            return this.myDelegate.isColumnMode();
        }

        @NotNull
        public VisualPosition xyToVisualPosition(@NotNull Point p) {
            if (p == null) {
                EditorWindowImpl.$$$reportNull$$$0(26);
            }
            VisualPosition visualPosition = this.logicalToVisualPosition(this.xyToLogicalPosition(p));
            if (visualPosition == null) {
                EditorWindowImpl.$$$reportNull$$$0(27);
            }
            return visualPosition;
        }

        @NotNull
        public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
            if (p == null) {
                EditorWindowImpl.$$$reportNull$$$0(28);
            }
            this.assertValid();
            Point2D pp = p.getX() >= 0.0 && p.getY() >= 0.0 ? p : new Point2D.Double(Math.max(p.getX(), 0.0), Math.max(p.getY(), 0.0));
            LogicalPosition hostPos = this.myDelegate.visualToLogicalPosition(this.myDelegate.xyToVisualPosition(pp));
            VisualPosition visualPosition = this.logicalToVisualPosition(this.hostToInjected(hostPos));
            if (visualPosition == null) {
                EditorWindowImpl.$$$reportNull$$$0(29);
            }
            return visualPosition;
        }

        @NotNull
        public VisualPosition offsetToVisualPosition(int offset2) {
            VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset2));
            if (visualPosition == null) {
                EditorWindowImpl.$$$reportNull$$$0(30);
            }
            return visualPosition;
        }

        @NotNull
        public VisualPosition offsetToVisualPosition(int offset2, boolean leanForward, boolean beforeSoftWrap) {
            VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset2).leanForward(leanForward));
            if (visualPosition == null) {
                EditorWindowImpl.$$$reportNull$$$0(31);
            }
            return visualPosition;
        }

        @NotNull
        public LogicalPosition offsetToLogicalPosition(int offset2) {
            this.assertValid();
            int lineNumber = this.myDocumentWindow.getLineNumber(offset2);
            int lineStartOffset = this.myDocumentWindow.getLineStartOffset(lineNumber);
            int column = this.calcLogicalColumnNumber(offset2 - lineStartOffset, lineNumber, lineStartOffset);
            return new LogicalPosition(lineNumber, column);
        }

        @NotNull
        public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
            EditorColorsScheme editorColorsScheme = this.myDelegate.createBoundColorSchemeDelegate(customGlobalScheme);
            if (editorColorsScheme == null) {
                EditorWindowImpl.$$$reportNull$$$0(32);
            }
            return editorColorsScheme;
        }

        @NotNull
        public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
            if (p == null) {
                EditorWindowImpl.$$$reportNull$$$0(33);
            }
            this.assertValid();
            LogicalPosition hostPos = this.myDelegate.xyToLogicalPosition(p);
            LogicalPosition logicalPosition = this.hostToInjected(hostPos);
            if (logicalPosition == null) {
                EditorWindowImpl.$$$reportNull$$$0(34);
            }
            return logicalPosition;
        }

        @NotNull
        public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
            if (pos == null) {
                EditorWindowImpl.$$$reportNull$$$0(35);
            }
            this.assertValid();
            LogicalPosition hostPos = this.injectedToHost(pos);
            Point point = this.myDelegate.logicalPositionToXY(hostPos);
            if (point == null) {
                EditorWindowImpl.$$$reportNull$$$0(36);
            }
            return point;
        }

        @NotNull
        public Point visualPositionToXY(@NotNull VisualPosition pos) {
            if (pos == null) {
                EditorWindowImpl.$$$reportNull$$$0(37);
            }
            this.assertValid();
            Point point = this.logicalPositionToXY(this.visualToLogicalPosition(pos));
            if (point == null) {
                EditorWindowImpl.$$$reportNull$$$0(38);
            }
            return point;
        }

        @NotNull
        public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
            if (pos == null) {
                EditorWindowImpl.$$$reportNull$$$0(39);
            }
            this.assertValid();
            LogicalPosition hostLogical = this.injectedToHost(this.visualToLogicalPosition(pos));
            VisualPosition hostVisual = this.myDelegate.logicalToVisualPosition(hostLogical);
            Point2D point2D = this.myDelegate.visualPositionToPoint2D(hostVisual);
            if (point2D == null) {
                EditorWindowImpl.$$$reportNull$$$0(40);
            }
            return point2D;
        }

        public void repaint(int startOffset, int endOffset) {
            this.assertValid();
            this.myDelegate.repaint(this.myDocumentWindow.injectedToHost(startOffset), this.myDocumentWindow.injectedToHost(endOffset));
        }

        @NotNull
        public DocumentWindowImpl getDocument() {
            DocumentWindowImpl documentWindowImpl = this.myDocumentWindow;
            if (documentWindowImpl == null) {
                EditorWindowImpl.$$$reportNull$$$0(41);
            }
            return documentWindowImpl;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myDelegate.getComponent();
            if (jComponent == null) {
                EditorWindowImpl.$$$reportNull$$$0(42);
            }
            return jComponent;
        }

        public void addEditorMouseListener(final @NotNull EditorMouseListener listener2) {
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(43);
            }
            this.assertValid();
            EditorMouseListener wrapper2 = new EditorMouseListener(){

                public void mousePressed(@NotNull EditorMouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    listener2.mousePressed(this.convertEvent(e));
                }

                public void mouseClicked(@NotNull EditorMouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    listener2.mouseClicked(this.convertEvent(e));
                }

                public void mouseReleased(@NotNull EditorMouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    listener2.mouseReleased(this.convertEvent(e));
                }

                public void mouseEntered(@NotNull EditorMouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    listener2.mouseEntered(this.convertEvent(e));
                }

                public void mouseExited(@NotNull EditorMouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    listener2.mouseExited(this.convertEvent(e));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/EditorWindowTrackerImpl$EditorWindowImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mousePressed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseClicked";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseReleased";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseEntered";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseExited";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myEditorMouseListeners.registerWrapper(listener2, wrapper2);
            this.myDelegate.addEditorMouseListener(wrapper2);
        }

        public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
            EditorMouseListener wrapper2;
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(44);
            }
            if ((wrapper2 = this.myEditorMouseListeners.removeWrapper(listener2)) != null) {
                this.myDelegate.removeEditorMouseListener(wrapper2);
            }
        }

        public void addEditorMouseMotionListener(final @NotNull EditorMouseMotionListener listener2) {
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(45);
            }
            this.assertValid();
            EditorMouseMotionListener wrapper2 = new EditorMouseMotionListener(){

                public void mouseMoved(@NotNull EditorMouseEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    listener2.mouseMoved(this.convertEvent(e));
                }

                public void mouseDragged(@NotNull EditorMouseEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    listener2.mouseDragged(this.convertEvent(e));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/EditorWindowTrackerImpl$EditorWindowImpl$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseMoved";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseDragged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myEditorMouseMotionListeners.registerWrapper(listener2, wrapper2);
            this.myDelegate.addEditorMouseMotionListener(wrapper2);
        }

        public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
            EditorMouseMotionListener wrapper2;
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(46);
            }
            if ((wrapper2 = this.myEditorMouseMotionListeners.removeWrapper(listener2)) != null) {
                this.myDelegate.removeEditorMouseMotionListener(wrapper2);
            }
        }

        private EditorMouseEvent convertEvent(EditorMouseEvent originalEvent) {
            LogicalPosition logicalPosition = this.hostToInjected(originalEvent.getLogicalPosition());
            int offset2 = this.logicalPositionToOffset(logicalPosition);
            VisualPosition visualPosition = this.logicalToVisualPosition(logicalPosition);
            FoldRegion hostFoldRegion = originalEvent.getCollapsedFoldRegion();
            return new EditorMouseEvent((Editor)this, originalEvent.getMouseEvent(), originalEvent.getArea(), offset2, logicalPosition, visualPosition, true, (FoldRegion)(hostFoldRegion == null ? null : FoldingRegionWindow.getInjectedRegion(hostFoldRegion)), null, null);
        }

        public boolean isDisposed() {
            return this.myDisposed || this.myDelegate.isDisposed();
        }

        public void setBackgroundColor(Color color) {
            this.myDelegate.setBackgroundColor(color);
        }

        @NotNull
        public Color getBackgroundColor() {
            Color color = this.myDelegate.getBackgroundColor();
            if (color == null) {
                EditorWindowImpl.$$$reportNull$$$0(47);
            }
            return color;
        }

        public int getMaxWidthInRange(int startOffset, int endOffset) {
            return this.myDelegate.getMaxWidthInRange(startOffset, endOffset);
        }

        public int getLineHeight() {
            return this.myDelegate.getLineHeight();
        }

        public Dimension getContentSize() {
            return this.myDelegate.getContentSize();
        }

        @NotNull
        public JScrollPane getScrollPane() {
            JScrollPane jScrollPane = this.myDelegate.getScrollPane();
            if (jScrollPane == null) {
                EditorWindowImpl.$$$reportNull$$$0(48);
            }
            return jScrollPane;
        }

        public void setBorder(Border border) {
            this.myDelegate.setBorder(border);
        }

        public Insets getInsets() {
            return this.myDelegate.getInsets();
        }

        public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
            if (pos == null) {
                EditorWindowImpl.$$$reportNull$$$0(49);
            }
            int lineStartOffset = this.myDocumentWindow.getLineStartOffset(pos.line);
            return this.calcOffset(pos.column, pos.line, lineStartOffset);
        }

        private int calcLogicalColumnNumber(int offsetInLine, int lineNumber, int lineStartOffset) {
            if (this.myDocumentWindow.getTextLength() == 0) {
                return 0;
            }
            if (offsetInLine == 0) {
                return 0;
            }
            int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
            if (offsetInLine > end - lineStartOffset) {
                offsetInLine = end - lineStartOffset;
            }
            CharSequence text2 = this.myDocumentWindow.getCharsSequence();
            return EditorUtil.calcColumnNumber((Editor)this, (CharSequence)text2, (int)lineStartOffset, (int)(lineStartOffset + offsetInLine));
        }

        private int calcOffset(int col, int lineNumber, int lineStartOffset) {
            CharSequence text2 = this.myDocumentWindow.getImmutableCharSequence();
            int tabSize = EditorUtil.getTabSize((Editor)this.myDelegate);
            int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
            int currentColumn = 0;
            for (int i2 = lineStartOffset; i2 < end; ++i2) {
                char c2 = text2.charAt(i2);
                currentColumn = c2 == '\t' ? (currentColumn / tabSize + 1) * tabSize : ++currentColumn;
                if (col >= currentColumn) continue;
                return i2;
            }
            return end;
        }

        @NotNull
        public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos) {
            if (pos == null) {
                EditorWindowImpl.$$$reportNull$$$0(50);
            }
            this.assertValid();
            return new VisualPosition(pos.line, pos.column);
        }

        @NotNull
        public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
            if (pos == null) {
                EditorWindowImpl.$$$reportNull$$$0(51);
            }
            this.assertValid();
            return new LogicalPosition(pos.line, pos.column);
        }

        @NotNull
        public DataContext getDataContext() {
            DataContext dataContext2 = this.myDelegate.getDataContext();
            if (dataContext2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(52);
            }
            return dataContext2;
        }

        public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
            if (e == null) {
                EditorWindowImpl.$$$reportNull$$$0(53);
            }
            return this.myDelegate.getMouseEventArea(e);
        }

        public boolean setCaretVisible(boolean b) {
            return this.myDelegate.setCaretVisible(b);
        }

        public boolean setCaretEnabled(boolean enabled) {
            return this.myDelegate.setCaretEnabled(enabled);
        }

        public void addFocusListener(@NotNull FocusChangeListener listener2) {
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(54);
            }
            this.myDelegate.addFocusListener(listener2);
        }

        public void addFocusListener(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
            if (listener2 == null) {
                EditorWindowImpl.$$$reportNull$$$0(55);
            }
            if (parentDisposable == null) {
                EditorWindowImpl.$$$reportNull$$$0(56);
            }
            this.myDelegate.addFocusListener(listener2, parentDisposable);
        }

        public Project getProject() {
            return this.myDelegate.getProject();
        }

        public boolean isOneLineMode() {
            return this.myOneLine;
        }

        public void setOneLineMode(boolean isOneLineMode) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmbeddedIntoDialogWrapper() {
            return this.myDelegate.isEmbeddedIntoDialogWrapper();
        }

        public void setEmbeddedIntoDialogWrapper(boolean b) {
            this.myDelegate.setEmbeddedIntoDialogWrapper(b);
        }

        public VirtualFile getVirtualFile() {
            return this.myDelegate.getVirtualFile();
        }

        @NotNull
        public CopyProvider getCopyProvider() {
            CopyProvider copyProvider = this.myDelegate.getCopyProvider();
            if (copyProvider == null) {
                EditorWindowImpl.$$$reportNull$$$0(57);
            }
            return copyProvider;
        }

        @NotNull
        public CutProvider getCutProvider() {
            CutProvider cutProvider = this.myDelegate.getCutProvider();
            if (cutProvider == null) {
                EditorWindowImpl.$$$reportNull$$$0(58);
            }
            return cutProvider;
        }

        @NotNull
        public PasteProvider getPasteProvider() {
            PasteProvider pasteProvider = this.myDelegate.getPasteProvider();
            if (pasteProvider == null) {
                EditorWindowImpl.$$$reportNull$$$0(59);
            }
            return pasteProvider;
        }

        @NotNull
        public DeleteProvider getDeleteProvider() {
            DeleteProvider deleteProvider = this.myDelegate.getDeleteProvider();
            if (deleteProvider == null) {
                EditorWindowImpl.$$$reportNull$$$0(60);
            }
            return deleteProvider;
        }

        public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                EditorWindowImpl.$$$reportNull$$$0(61);
            }
            this.myDelegate.setColorsScheme(scheme);
        }

        @NotNull
        public EditorColorsScheme getColorsScheme() {
            EditorColorsScheme editorColorsScheme = this.myDelegate.getColorsScheme();
            if (editorColorsScheme == null) {
                EditorWindowImpl.$$$reportNull$$$0(62);
            }
            return editorColorsScheme;
        }

        public void setVerticalScrollbarOrientation(int type) {
            this.myDelegate.setVerticalScrollbarOrientation(type);
        }

        public int getVerticalScrollbarOrientation() {
            return this.myDelegate.getVerticalScrollbarOrientation();
        }

        public void setVerticalScrollbarVisible(boolean b) {
            this.myDelegate.setVerticalScrollbarVisible(b);
        }

        public void setHorizontalScrollbarVisible(boolean b) {
            this.myDelegate.setHorizontalScrollbarVisible(b);
        }

        public boolean processKeyTyped(@NotNull KeyEvent e) {
            if (e == null) {
                EditorWindowImpl.$$$reportNull$$$0(63);
            }
            return this.myDelegate.processKeyTyped(e);
        }

        @NotNull
        public EditorGutter getGutter() {
            EditorGutter editorGutter = this.myDelegate.getGutter();
            if (editorGutter == null) {
                EditorWindowImpl.$$$reportNull$$$0(64);
            }
            return editorGutter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EditorWindowImpl that = (EditorWindowImpl)o;
            DocumentWindowImpl thatWindow = that.getDocument();
            return this.myDelegate.equals(that.myDelegate) && this.myDocumentWindow.equals(thatWindow);
        }

        public int hashCode() {
            return this.myDocumentWindow.hashCode();
        }

        @NotNull
        public Editor getDelegate() {
            EditorImpl editorImpl = this.myDelegate;
            if (editorImpl == null) {
                EditorWindowImpl.$$$reportNull$$$0(65);
            }
            return editorImpl;
        }

        @NotNull
        public IndentsModel getIndentsModel() {
            IndentsModel indentsModel = this.myDelegate.getIndentsModel();
            if (indentsModel == null) {
                EditorWindowImpl.$$$reportNull$$$0(66);
            }
            return indentsModel;
        }

        public void setPlaceholder(@Nullable CharSequence text2) {
            this.myDelegate.setPlaceholder(text2);
        }

        public void setPlaceholderAttributes(@Nullable TextAttributes attributes) {
            this.myDelegate.setPlaceholderAttributes(attributes);
        }

        public void setShowPlaceholderWhenFocused(boolean show2) {
            this.myDelegate.setShowPlaceholderWhenFocused(show2);
        }

        public boolean isStickySelection() {
            return this.myDelegate.isStickySelection();
        }

        public void setStickySelection(boolean enable) {
            this.myDelegate.setStickySelection(enable);
        }

        public boolean isPurePaintingMode() {
            return this.myDelegate.isPurePaintingMode();
        }

        public void setPurePaintingMode(boolean enabled) {
            this.myDelegate.setPurePaintingMode(enabled);
        }

        public void registerLineExtensionPainter(@NotNull @NotNull IntFunction<? extends @NotNull Collection<? extends LineExtensionInfo>> lineExtensionPainter) {
            if (lineExtensionPainter == null) {
                EditorWindowImpl.$$$reportNull$$$0(67);
            }
            throw new UnsupportedOperationException();
        }

        public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
            this.myDelegate.registerScrollBarRepaintCallback(callback);
        }

        public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes) {
            this.myDelegate.setPrefixTextAndAttributes(prefixText, attributes);
        }

        public int getPrefixTextWidthInPixels() {
            return this.myDelegate.getPrefixTextWidthInPixels();
        }

        @Override
        public String toString() {
            return super.toString() + "[disposed=" + this.myDisposed + "; valid=" + this.isValid() + "]";
        }

        public int getExpectedCaretOffset() {
            return this.myDocumentWindow.hostToInjected(this.myDelegate.getExpectedCaretOffset());
        }

        public void setContextMenuGroupId(@Nullable String groupId) {
            this.myDelegate.setContextMenuGroupId(groupId);
        }

        @Nullable
        public String getContextMenuGroupId() {
            return this.myDelegate.getContextMenuGroupId();
        }

        public void installPopupHandler(@NotNull EditorPopupHandler popupHandler) {
            if (popupHandler == null) {
                EditorWindowImpl.$$$reportNull$$$0(68);
            }
            this.myDelegate.installPopupHandler(popupHandler);
        }

        public void uninstallPopupHandler(@NotNull EditorPopupHandler popupHandler) {
            if (popupHandler == null) {
                EditorWindowImpl.$$$reportNull$$$0(69);
            }
            this.myDelegate.installPopupHandler(popupHandler);
        }

        public void setCustomCursor(@NotNull Object requestor, @Nullable Cursor cursor) {
            if (requestor == null) {
                EditorWindowImpl.$$$reportNull$$$0(70);
            }
            this.myDelegate.setCustomCursor(requestor, cursor);
        }

        public int getAscent() {
            return this.myDelegate.getAscent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 27, 29, 30, 31, 32, 34, 36, 38, 40, 41, 42, 47, 48, 52, 57, 58, 59, 60, 62, 64, 65, 66 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documentWindow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectedFile";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 36: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 47: 
                case 48: 
                case 52: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 64: 
                case 65: 
                case 66: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/EditorWindowTrackerImpl$EditorWindowImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hPos";
                    break;
                }
                case 7: 
                case 35: 
                case 37: 
                case 39: 
                case 49: 
                case 50: 
                case 51: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pos";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighter";
                    break;
                }
                case 22: 
                case 23: 
                case 25: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 54: 
                case 55: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 24: 
                case 56: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 26: 
                case 28: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 53: 
                case 63: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 61: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 67: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineExtensionPainter";
                    break;
                }
                case 68: 
                case 69: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popupHandler";
                    break;
                }
                case 70: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/EditorWindowTrackerImpl$EditorWindowImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInjectedFile";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "hostToInjected";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectionModel";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMarkupModel";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilteredDocumentMarkupModel";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFoldingModel";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaretModel";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollingModel";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSoftWrapModel";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInlayModel";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorKind";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlighter";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentComponent";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGutterComponentEx";
                    break;
                }
                case 27: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "xyToVisualPosition";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "offsetToVisualPosition";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBoundColorSchemeDelegate";
                    break;
                }
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[1] = "xyToLogicalPosition";
                    break;
                }
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logicalPositionToXY";
                    break;
                }
                case 38: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visualPositionToXY";
                    break;
                }
                case 40: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visualPositionToPoint2D";
                    break;
                }
                case 41: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
                case 42: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 47: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBackgroundColor";
                    break;
                }
                case 48: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScrollPane";
                    break;
                }
                case 52: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataContext";
                    break;
                }
                case 57: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCopyProvider";
                    break;
                }
                case 58: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCutProvider";
                    break;
                }
                case 59: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPasteProvider";
                    break;
                }
                case 60: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeleteProvider";
                    break;
                }
                case 62: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColorsScheme";
                    break;
                }
                case 64: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGutter";
                    break;
                }
                case 65: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
                case 66: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndentsModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 36: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 47: 
                case 48: 
                case 52: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 64: 
                case 65: 
                case 66: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "hostToInjected";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "injectedToHost";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "setHighlighter";
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "addPropertyChangeListener";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "removePropertyChangeListener";
                    break;
                }
                case 26: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "xyToVisualPosition";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "xyToLogicalPosition";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "logicalPositionToXY";
                    break;
                }
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "visualPositionToXY";
                    break;
                }
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "visualPositionToPoint2D";
                    break;
                }
                case 43: {
                    objectArray = objectArray;
                    objectArray[2] = "addEditorMouseListener";
                    break;
                }
                case 44: {
                    objectArray = objectArray;
                    objectArray[2] = "removeEditorMouseListener";
                    break;
                }
                case 45: {
                    objectArray = objectArray;
                    objectArray[2] = "addEditorMouseMotionListener";
                    break;
                }
                case 46: {
                    objectArray = objectArray;
                    objectArray[2] = "removeEditorMouseMotionListener";
                    break;
                }
                case 49: {
                    objectArray = objectArray;
                    objectArray[2] = "logicalPositionToOffset";
                    break;
                }
                case 50: {
                    objectArray = objectArray;
                    objectArray[2] = "logicalToVisualPosition";
                    break;
                }
                case 51: {
                    objectArray = objectArray;
                    objectArray[2] = "visualToLogicalPosition";
                    break;
                }
                case 53: {
                    objectArray = objectArray;
                    objectArray[2] = "getMouseEventArea";
                    break;
                }
                case 54: 
                case 55: 
                case 56: {
                    objectArray = objectArray;
                    objectArray[2] = "addFocusListener";
                    break;
                }
                case 61: {
                    objectArray = objectArray;
                    objectArray[2] = "setColorsScheme";
                    break;
                }
                case 63: {
                    objectArray = objectArray;
                    objectArray[2] = "processKeyTyped";
                    break;
                }
                case 67: {
                    objectArray = objectArray;
                    objectArray[2] = "registerLineExtensionPainter";
                    break;
                }
                case 68: {
                    objectArray = objectArray;
                    objectArray[2] = "installPopupHandler";
                    break;
                }
                case 69: {
                    objectArray = objectArray;
                    objectArray[2] = "uninstallPopupHandler";
                    break;
                }
                case 70: {
                    objectArray = objectArray;
                    objectArray[2] = "setCustomCursor";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 27, 29, 30, 31, 32, 34, 36, 38, 40, 41, 42, 47, 48, 52, 57, 58, 59, 60, 62, 64, 65, 66 -> new IllegalStateException(string2);
            };
        }
    }
}

