/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.ClassMapCachingNulls;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.EditorWindowTracker;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class InjectedLanguageManagerImpl
extends InjectedLanguageManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(InjectedLanguageManagerImpl.class);
    static final Object ourInjectionPsiLock = ObjectUtils.sentinel("injectionPsiLock");
    private final Project myProject;
    private final DumbService myDumbService;
    private final PsiDocumentManager myDocManager;
    private final Set<MultiHostInjector> myManualInjectors = Collections.synchronizedSet(new LinkedHashSet());
    private volatile ClassMapCachingNulls<MultiHostInjector> cachedInjectors;
    private final Map<Class<?>, MultiHostInjector[]> myInjectorsClone = new HashMap();

    public static InjectedLanguageManagerImpl getInstanceImpl(Project project2) {
        return (InjectedLanguageManagerImpl)InjectedLanguageManager.getInstance(project2);
    }

    public InjectedLanguageManagerImpl(Project project2) {
        this.myProject = project2;
        this.myDumbService = DumbService.getInstance(this.myProject);
        this.myDocManager = PsiDocumentManager.getInstance(project2);
        MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.addChangeListener(project2, this::clearInjectorCache, this);
        LanguageInjector.EXTENSION_POINT_NAME.addChangeListener(this::clearInjectorCache, this);
        project2.getMessageBus().connect(this).subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void dispose() {
        InjectedLanguageManagerImpl.disposeInvalidEditors();
    }

    public static void clearInvalidInjections(@NotNull PsiFile hostFile) {
        if (hostFile == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(0);
        }
        List<DocumentWindow> invalid = ContainerUtil.findAll(InjectedLanguageUtilBase.getCachedInjectedDocuments(hostFile), doc -> !doc.isValid());
        for (DocumentWindow window : invalid) {
            InjectedLanguageUtilBase.clearCaches(hostFile.getProject(), window);
        }
    }

    public static void disposeInvalidEditors() {
        EditorWindowTracker editorWindowTracker = ApplicationManager.getApplication().getServiceIfCreated(EditorWindowTracker.class);
        if (editorWindowTracker != null) {
            editorWindowTracker.disposeInvalidEditors();
        }
    }

    @Override
    public PsiLanguageInjectionHost getInjectionHost(@NotNull FileViewProvider injectedProvider) {
        if (injectedProvider == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(1);
        }
        if (!(injectedProvider instanceof InjectedFileViewProvider)) {
            return null;
        }
        return ((InjectedFileViewProvider)injectedProvider).getShreds().getHostPointer().getElement();
    }

    @Override
    public PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement injectedElement) {
        PsiElement host;
        PsiFile file2;
        VirtualFile virtualFile2;
        if (injectedElement == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile3 = virtualFile2 = (file2 = injectedElement.getContainingFile()) == null ? null : file2.getVirtualFile();
        if (virtualFile2 instanceof VirtualFileWindow && (host = FileContextUtil.getFileContext(file2)) instanceof PsiLanguageInjectionHost) {
            return (PsiLanguageInjectionHost)host;
        }
        return InjectedLanguageUtilBase.findInjectionHost(file2);
    }

    @Override
    @NotNull
    public TextRange injectedToHost(@NotNull PsiElement injectedContext, @NotNull TextRange injectedTextRange) {
        DocumentWindow documentWindow;
        if (injectedContext == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(3);
        }
        if (injectedTextRange == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(4);
        }
        TextRange textRange = (documentWindow = InjectedLanguageManagerImpl.getDocumentWindow(injectedContext)) == null ? injectedTextRange : documentWindow.injectedToHost(injectedTextRange);
        if (textRange == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @Override
    public int injectedToHost(@NotNull PsiElement element, int offset2) {
        DocumentWindow documentWindow;
        if (element == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(6);
        }
        return (documentWindow = InjectedLanguageManagerImpl.getDocumentWindow(element)) == null ? offset2 : documentWindow.injectedToHost(offset2);
    }

    @Override
    public int injectedToHost(@NotNull PsiElement injectedContext, int injectedOffset, boolean minHostOffset) {
        DocumentWindow documentWindow;
        if (injectedContext == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(7);
        }
        return (documentWindow = InjectedLanguageManagerImpl.getDocumentWindow(injectedContext)) == null ? injectedOffset : ((DocumentWindowImpl)documentWindow).injectedToHost(injectedOffset, minHostOffset);
    }

    private static DocumentWindow getDocumentWindow(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(8);
        }
        if ((file2 = element.getContainingFile()) == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance(file2.getProject()).getCachedDocument(file2);
        return document instanceof DocumentWindow ? (DocumentWindow)document : null;
    }

    public void processInjectableElements(@NotNull Collection<? extends PsiElement> in, @NotNull Processor<? super PsiElement> processor) {
        if (in == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(10);
        }
        ClassMapCachingNulls<MultiHostInjector> map2 = this.getInjectorMap();
        for (PsiElement psiElement : in) {
            if (map2.get(psiElement.getClass()) == null) continue;
            processor.process(psiElement);
        }
    }

    @NotNull
    private ClassMapCachingNulls<MultiHostInjector> getInjectorMap() {
        ClassMapCachingNulls<MultiHostInjector> cached = this.cachedInjectors;
        if (cached != null) {
            ClassMapCachingNulls<MultiHostInjector> classMapCachingNulls = cached;
            if (classMapCachingNulls == null) {
                InjectedLanguageManagerImpl.$$$reportNull$$$0(11);
            }
            return classMapCachingNulls;
        }
        ClassMapCachingNulls<MultiHostInjector> result2 = this.calcInjectorMap();
        this.cachedInjectors = result2;
        ClassMapCachingNulls<MultiHostInjector> classMapCachingNulls = result2;
        if (classMapCachingNulls == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(12);
        }
        return classMapCachingNulls;
    }

    @NotNull
    private ClassMapCachingNulls<MultiHostInjector> calcInjectorMap() {
        HashMap injectors = new HashMap();
        ArrayList<MultiHostInjector> allInjectors = new ArrayList<MultiHostInjector>(this.myManualInjectors);
        allInjectors.addAll(MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getExtensions(this.myProject));
        if (LanguageInjector.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            allInjectors.add(PsiManagerRegisteredInjectorsAdapter.INSTANCE);
        }
        for (MultiHostInjector injector : allInjectors) {
            for (Class<? extends PsiElement> clazz : injector.elementsToInjectIn()) {
                MultiHostInjector[] multiHostInjectorArray;
                LOG.assertTrue(clazz != null, injector);
                MultiHostInjector[] existing = (MultiHostInjector[])injectors.get(clazz);
                if (existing == null) {
                    MultiHostInjector[] multiHostInjectorArray2 = new MultiHostInjector[1];
                    multiHostInjectorArray = multiHostInjectorArray2;
                    multiHostInjectorArray2[0] = injector;
                } else {
                    multiHostInjectorArray = ArrayUtil.append(existing, injector);
                }
                injectors.put(clazz, multiHostInjectorArray);
            }
        }
        return new ClassMapCachingNulls<MultiHostInjector>(injectors, new MultiHostInjector[0], allInjectors);
    }

    private void clearInjectorCache() {
        this.cachedInjectors = null;
        if (this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        for (VirtualFile file2 : FileEditorManager.getInstance(this.myProject).getOpenFiles()) {
            PsiFile psiFile = PsiManager.getInstance(this.myProject).findFile(file2);
            if (psiFile == null) continue;
            for (DocumentWindow document : InjectedLanguageUtilBase.getCachedInjectedDocuments(psiFile)) {
                EditorWindowTracker.getInstance().disposeEditorFor(document);
            }
            this.dropFileCaches(psiFile);
        }
    }

    @Override
    public void registerMultiHostInjector(@NotNull MultiHostInjector injector, @NotNull Disposable parentDisposable) {
        if (injector == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(14);
        }
        this.myManualInjectors.add(injector);
        this.clearInjectorCache();
        Disposer.register(parentDisposable, () -> this.unregisterMultiHostInjector(injector));
    }

    private void unregisterMultiHostInjector(@NotNull MultiHostInjector injector) {
        if (injector == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(15);
        }
        try {
            this.myManualInjectors.remove(injector);
        }
        finally {
            this.clearInjectorCache();
        }
    }

    @Override
    @NotNull
    public String getUnescapedText(@NotNull PsiElement injectedNode) {
        String leafText;
        if (injectedNode == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(16);
        }
        if ((leafText = InjectedLanguageUtilBase.getUnescapedLeafText(injectedNode, false)) != null) {
            String string2 = leafText;
            if (string2 == null) {
                InjectedLanguageManagerImpl.$$$reportNull$$$0(17);
            }
            return string2;
        }
        final StringBuilder text2 = new StringBuilder(injectedNode.getTextLength());
        injectedNode.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                String leafText;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((leafText = InjectedLanguageUtilBase.getUnescapedLeafText(element, false)) != null) {
                    text2.append(leafText);
                    return;
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$2", "visitElement"));
            }
        });
        String string3 = text2.toString();
        if (string3 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(18);
        }
        return string3;
    }

    @Override
    @NotNull
    public List<TextRange> intersectWithAllEditableFragments(@NotNull PsiFile injectedPsi, @NotNull TextRange rangeToEdit) {
        Place shreds;
        if (injectedPsi == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(19);
        }
        if (rangeToEdit == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(20);
        }
        if ((shreds = InjectedLanguageUtilBase.getShreds(injectedPsi)) == null) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                InjectedLanguageManagerImpl.$$$reportNull$$$0(21);
            }
            return list2;
        }
        Serializable result2 = null;
        int count2 = 0;
        int offset2 = 0;
        for (PsiLanguageInjectionHost.Shred shred : shreds) {
            TextRange encodedRange = TextRange.from(offset2 + shred.getPrefix().length(), shred.getRangeInsideHost().getLength());
            TextRange intersection = encodedRange.intersection(rangeToEdit);
            if (intersection != null) {
                if (++count2 == 1) {
                    result2 = intersection;
                } else if (count2 == 2) {
                    TextRange range = result2;
                    if (range.isEmpty()) {
                        result2 = intersection;
                        count2 = 1;
                    } else if (intersection.isEmpty()) {
                        count2 = 1;
                    } else {
                        ArrayList<TextRange> list3 = new ArrayList<TextRange>();
                        list3.add(range);
                        list3.add(intersection);
                        result2 = list3;
                    }
                } else if (intersection.isEmpty()) {
                    --count2;
                } else {
                    ((List)((Object)result2)).add(intersection);
                }
            }
            offset2 += shred.getPrefix().length() + shred.getRangeInsideHost().getLength() + shred.getSuffix().length();
        }
        List<TextRange> list4 = count2 == 0 ? Collections.emptyList() : (count2 == 1 ? Collections.singletonList((TextRange)result2) : (List<TextRange>)((Object)result2));
        if (list4 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(22);
        }
        return list4;
    }

    @Override
    public boolean isInjectedFragment(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(23);
        }
        return injectedFile.getViewProvider() instanceof InjectedFileViewProvider;
    }

    @Override
    public PsiElement findInjectedElementAt(@NotNull PsiFile hostFile, int hostDocumentOffset) {
        if (hostFile == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(24);
        }
        return InjectedLanguageUtilBase.findInjectedElementNoCommit(hostFile, hostDocumentOffset);
    }

    @Override
    public void dropFileCaches(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(25);
        }
        InjectedLanguageUtilBase.clearCachedInjectedFragmentsForFile(file2);
    }

    @Override
    public PsiFile getTopLevelFile(@NotNull PsiElement element) {
        if (element == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(26);
        }
        return InjectedLanguageUtilBase.getTopLevelFile(element);
    }

    @Override
    @NotNull
    public List<DocumentWindow> getCachedInjectedDocumentsInRange(@NotNull PsiFile hostPsiFile, @NotNull TextRange range) {
        if (hostPsiFile == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(27);
        }
        if (range == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(28);
        }
        List<DocumentWindow> list2 = InjectedLanguageUtilBase.getCachedInjectedDocumentsInRange(hostPsiFile, range);
        if (list2 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(29);
        }
        return list2;
    }

    @Override
    public void enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        if (host == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(30);
        }
        if (visitor2 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(31);
        }
        InjectedLanguageUtilBase.enumerate(host, visitor2);
    }

    @Override
    public void enumerateEx(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        if (host == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(32);
        }
        if (containingFile == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(33);
        }
        if (visitor2 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(34);
        }
        InjectedLanguageUtilBase.enumerate(host, containingFile, probeUp, visitor2);
    }

    @Override
    @NotNull
    public List<TextRange> getNonEditableFragments(@NotNull DocumentWindow window) {
        if (window == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(35);
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        int offset2 = 0;
        for (PsiLanguageInjectionHost.Shred shred : ((DocumentWindowImpl)window).getShreds()) {
            Segment hostRange = shred.getHostRangeMarker();
            if (hostRange == null) continue;
            offset2 = InjectedLanguageManagerImpl.appendRange(result2, offset2, shred.getPrefix().length());
            offset2 += hostRange.getEndOffset() - hostRange.getStartOffset();
            offset2 = InjectedLanguageManagerImpl.appendRange(result2, offset2, shred.getSuffix().length());
        }
        ArrayList<TextRange> arrayList = result2;
        if (arrayList == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @Override
    public boolean mightHaveInjectedFragmentAtOffset(@NotNull Document hostDocument, int hostOffset) {
        if (hostDocument == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(37);
        }
        return InjectedLanguageUtilBase.mightHaveInjectedFragmentAtCaret(this.myProject, hostDocument, hostOffset);
    }

    @Override
    @NotNull
    public DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(38);
        }
        Place shreds = ((DocumentWindowImpl)document).getShreds();
        Project project2 = shreds.getHostPointer().getProject();
        DocumentEx delegate2 = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project2)).getLastCommittedDocument(document.getDelegate());
        Place place = new Place();
        place.addAll(ContainerUtil.map(shreds, shred -> ((ShredImpl)shred).withPsiRange()));
        return new DocumentWindowImpl(delegate2, place);
    }

    private static int appendRange(@NotNull List<TextRange> result2, int start, int length) {
        if (result2 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(39);
        }
        if (length > 0) {
            TextRange lastRange;
            int lastIndex = result2.size() - 1;
            TextRange textRange = lastRange = lastIndex >= 0 ? result2.get(lastIndex) : null;
            if (lastRange != null && lastRange.getEndOffset() == start) {
                result2.set(lastIndex, lastRange.grown(length));
            } else {
                result2.add(TextRange.from(start, length));
            }
        }
        return start + length;
    }

    @TestOnly
    public static void pushInjectors(@NotNull Project project2) {
        InjectedLanguageManagerImpl cachedManager;
        if (project2 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(40);
        }
        if ((cachedManager = (InjectedLanguageManagerImpl)project2.getServiceIfCreated(InjectedLanguageManager.class)) == null) {
            return;
        }
        try {
            assert (cachedManager.myInjectorsClone.isEmpty()) : cachedManager.myInjectorsClone;
        }
        finally {
            cachedManager.myInjectorsClone.clear();
        }
        cachedManager.myInjectorsClone.putAll(cachedManager.getInjectorMap().getBackingMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void checkInjectorsAreDisposed(@NotNull Project project2) {
        InjectedLanguageManagerImpl cachedManager;
        if (project2 == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(41);
        }
        if ((cachedManager = (InjectedLanguageManagerImpl)project2.getServiceIfCreated(InjectedLanguageManager.class)) == null) {
            return;
        }
        try {
            ClassMapCachingNulls<MultiHostInjector> cached = cachedManager.cachedInjectors;
            if (cached == null) {
                return;
            }
            for (Map.Entry<Class<?>, MultiHostInjector[]> entry : cached.getBackingMap().entrySet()) {
                Class<?> key = entry.getKey();
                if (cachedManager.myInjectorsClone.isEmpty()) {
                    return;
                }
                Object[] oldInjectors = cachedManager.myInjectorsClone.get(key);
                for (MultiHostInjector injector : entry.getValue()) {
                    if (ArrayUtil.indexOf(oldInjectors, injector) == -1) {
                        throw new AssertionError((Object)("Injector was not disposed: " + key + " -> " + injector));
                    }
                }
            }
        }
        finally {
            cachedManager.myInjectorsClone.clear();
        }
    }

    InjectionResult processInPlaceInjectorsFor(@NotNull PsiFile hostPsiFile, @NotNull PsiElement element) {
        MultiHostInjector[] infos;
        if (hostPsiFile == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(42);
        }
        if (element == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(43);
        }
        if ((infos = this.getInjectorMap().get(element.getClass())) == null || infos.length == 0) {
            return null;
        }
        if (element instanceof PsiLanguageInjectionHost && !((PsiLanguageInjectionHost)element).isValidHost()) {
            return null;
        }
        boolean dumb = this.myDumbService.isDumb();
        InjectionRegistrarImpl hostRegistrar = new InjectionRegistrarImpl(this.myProject, hostPsiFile, element, this.myDocManager);
        for (MultiHostInjector injector : infos) {
            if (dumb && !DumbService.isDumbAware(injector)) continue;
            injector.getLanguagesToInject(hostRegistrar, element);
            InjectionResult result2 = hostRegistrar.getInjectedResult();
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    @Nullable
    public List<Pair<PsiElement, TextRange>> getInjectedPsiFiles(@NotNull PsiElement host) {
        if (host == null) {
            InjectedLanguageManagerImpl.$$$reportNull$$$0(44);
        }
        if (!(host instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)host).isValidHost()) {
            return null;
        }
        PsiElement inTree = InjectedLanguageUtilBase.loadTree(host, host.getContainingFile());
        SmartList<Pair<PsiElement, TextRange>> result2 = new SmartList<Pair<PsiElement, TextRange>>();
        this.enumerate(inTree, (injectedPsi, places) -> {
            for (PsiLanguageInjectionHost.Shred place : places) {
                if (place.getHost() != inTree) continue;
                result2.add(new Pair<PsiFile, TextRange>(injectedPsi, place.getRangeInsideHost()));
            }
        });
        return result2.isEmpty() ? null : result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11, 12, 17, 18, 21, 22, 29, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedElement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedTextRange";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl";
                break;
            }
            case 6: 
            case 8: 
            case 26: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injector";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedNode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToEdit";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 30: 
            case 32: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "injectedToHost";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectorMap";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnescapedText";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWithAllEditableFragments";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInjectedDocumentsInRange";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEditableFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "clearInvalidInjections";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionHost";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "injectedToHost";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 29: 
            case 36: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentWindow";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processInjectableElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerMultiHostInjector";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unregisterMultiHostInjector";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getUnescapedText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithAllEditableFragments";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInjectedFragment";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedElementAt";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "dropFileCaches";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedDocumentsInRange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "enumerateEx";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNonEditableFragments";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "mightHaveInjectedFragmentAtOffset";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "freezeWindow";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "appendRange";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "pushInjectors";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkInjectorsAreDisposed";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processInPlaceInjectorsFor";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedPsiFiles";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 11, 12, 17, 18, 21, 22, 29, 36 -> new IllegalStateException(string2);
        };
    }

    private static class PsiManagerRegisteredInjectorsAdapter
    implements MultiHostInjector {
        static final PsiManagerRegisteredInjectorsAdapter INSTANCE = new PsiManagerRegisteredInjectorsAdapter();

        private PsiManagerRegisteredInjectorsAdapter() {
        }

        @Override
        public void getLanguagesToInject(@NotNull MultiHostRegistrar injectionPlacesRegistrar, @NotNull PsiElement context2) {
            if (injectionPlacesRegistrar == null) {
                PsiManagerRegisteredInjectorsAdapter.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                PsiManagerRegisteredInjectorsAdapter.$$$reportNull$$$0(1);
            }
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context2;
            InjectedLanguagePlaces placesRegistrar = (language, rangeInsideHost, prefix, suffix) -> injectionPlacesRegistrar.startInjecting(language).addPlace(prefix, suffix, host, rangeInsideHost).doneInjecting();
            for (LanguageInjector injector : LanguageInjector.EXTENSION_POINT_NAME.getExtensionList()) {
                injector.getLanguagesToInject(host, placesRegistrar);
            }
        }

        @NotNull
        public List<Class<? extends PsiElement>> elementsToInjectIn() {
            List<Class<? extends PsiElement>> list2 = Collections.singletonList(PsiLanguageInjectionHost.class);
            if (list2 == null) {
                PsiManagerRegisteredInjectorsAdapter.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectionPlacesRegistrar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "elementsToInjectIn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLanguagesToInject";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

