/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.VirtualFileWindowImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.ReadActionCache;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.Internal
public class InjectedLanguageUtilBase {
    public static final Key<IElementType> INJECTED_FRAGMENT_TYPE = Key.create("INJECTED_FRAGMENT_TYPE");
    private static final Key<CachedValue<InjectionResult>> INJECTION_RESULT_KEY = Key.create("INJECTION_RESULT");
    private static final Key<List<TokenInfo>> HIGHLIGHT_TOKENS = Key.create("HIGHLIGHT_TOKENS");
    private static final Key<Supplier<InjectionResult>> INJECTED_PSI = Key.create("INJECTED_PSI");
    private static final Key<InjectionResult> INJECTION_HOLDER_BACK_REFERENCE = Key.create("INJECTION_HOLDER_BACK_REFERENCE");
    private static final Key<List<DocumentWindow>> INJECTED_DOCS_KEY = Key.create("INJECTED_DOCS_KEY");

    @NotNull
    static PsiElement loadTree(@NotNull PsiElement host, @NotNull PsiFile containingFile) {
        PsiElement context2;
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(1);
        }
        if (containingFile instanceof DummyHolder && (context2 = containingFile.getContext()) != null) {
            PsiFile topFile = context2.getContainingFile();
            topFile.getNode();
            TextRange textRange = host.getTextRange().shiftRight(context2.getTextRange().getStartOffset());
            Object inLoadedTree = PsiTreeUtil.findElementOfClassAtRange(topFile, textRange.getStartOffset(), textRange.getEndOffset(), host.getClass());
            if (inLoadedTree != null) {
                host = inLoadedTree;
            }
        }
        PsiElement psiElement = host;
        if (psiElement == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    public static List<TokenInfo> getHighlightTokens(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(3);
        }
        return file2.getUserData(HIGHLIGHT_TOKENS);
    }

    public static String getUnescapedText(@NotNull PsiFile file2, final @Nullable PsiElement startElement, final @Nullable PsiElement endElement) {
        InjectedLanguageManager manager;
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(4);
        }
        if ((manager = InjectedLanguageManager.getInstance(file2.getProject())).getInjectionHost(file2) == null) {
            return file2.getText().substring(startElement == null ? 0 : startElement.getTextRange().getStartOffset(), endElement == null ? file2.getTextLength() : endElement.getTextRange().getStartOffset());
        }
        final StringBuilder sb = new StringBuilder();
        file2.accept(new PsiRecursiveElementWalkingVisitor(){
            Boolean myState;
            {
                this.myState = startElement == null ? Boolean.TRUE : null;
            }

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element == startElement) {
                    this.myState = Boolean.TRUE;
                }
                if (element == endElement) {
                    this.myState = Boolean.FALSE;
                }
                if (Boolean.FALSE == this.myState) {
                    return;
                }
                if (Boolean.TRUE == this.myState && element.getFirstChild() == null) {
                    sb.append(InjectedLanguageUtilBase.getUnescapedLeafText(element, false));
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase$1", "visitElement"));
            }
        });
        return sb.toString();
    }

    static void setHighlightTokens(@NotNull PsiFile file2, @NotNull List<TokenInfo> tokens) {
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(5);
        }
        if (tokens == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(6);
        }
        file2.putUserData(HIGHLIGHT_TOKENS, tokens);
    }

    public static Place getShreds(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(7);
        }
        FileViewProvider viewProvider = injectedFile.getViewProvider();
        return InjectedLanguageUtilBase.getShreds(viewProvider);
    }

    public static Place getShreds(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(8);
        }
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            return null;
        }
        InjectedFileViewProvider myFileViewProvider = (InjectedFileViewProvider)viewProvider;
        return InjectedLanguageUtilBase.getShreds(myFileViewProvider.getDocument());
    }

    @NotNull
    private static Place getShreds(@NotNull DocumentWindow document) {
        if (document == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(9);
        }
        Place place = ((DocumentWindowImpl)document).getShreds();
        if (place == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(10);
        }
        return place;
    }

    @Deprecated
    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(11);
        }
        if (visitor2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(12);
        }
        PsiFile containingFile = host.getContainingFile();
        PsiUtilCore.ensureValid(containingFile);
        return InjectedLanguageUtilBase.enumerate(host, containingFile, true, visitor2);
    }

    @Deprecated
    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        PsiDocumentManager documentManager;
        Document document;
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(14);
        }
        if (visitor2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(15);
        }
        if (!containingFile.isPhysical() && containingFile.getOriginalFile() == containingFile && ModelBranch.getPsiBranch(containingFile) == null) {
            PsiLanguageInjectionHost context2 = InjectedLanguageManager.getInstance(containingFile.getProject()).getInjectionHost(containingFile);
            if (context2 == null) {
                return false;
            }
            PsiFile file2 = context2.getContainingFile();
            if (file2 == null || !file2.isPhysical() && file2.getOriginalFile() == file2) {
                return false;
            }
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return false;
        }
        PsiElement inTree = InjectedLanguageUtilBase.loadTree(host, containingFile);
        if (inTree != host) {
            host = inTree;
            containingFile = host.getContainingFile();
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance(containingFile.getProject())).getDocument(containingFile)) == null || documentManager.isCommitted(document)) {
            InjectedLanguageUtilBase.probeElementsUp(host, containingFile, probeUp, visitor2);
        }
        return true;
    }

    static boolean mightHaveInjectedFragmentAtCaret(@NotNull Project project2, @NotNull Document hostDocument, int hostOffset) {
        PsiFile hostPsiFile;
        if (project2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(16);
        }
        if (hostDocument == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(17);
        }
        if ((hostPsiFile = PsiDocumentManager.getInstance(project2).getCachedPsiFile(hostDocument)) == null || !hostPsiFile.isValid()) {
            return false;
        }
        List<DocumentWindow> documents = InjectedLanguageManager.getInstance(project2).getCachedInjectedDocumentsInRange(hostPsiFile, TextRange.create(hostOffset, hostOffset));
        for (DocumentWindow document : documents) {
            if (!document.isValid() || document.getHostRange(hostOffset) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiFile findInjectedPsiNoCommit(@NotNull PsiFile host, int offset2) {
        PsiElement injected;
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(18);
        }
        return (injected = InjectedLanguageManager.getInstance(host.getProject()).findInjectedElementAt(host, offset2)) == null ? null : PsiUtilCore.getTemplateLanguageFile(injected.getContainingFile());
    }

    public static PsiElement findElementAtNoCommit(@NotNull PsiFile file2, int offset2) {
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(19);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        Trinity<PsiElement, PsiElement, Language> result2 = null;
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(file2.getProject());
            result2 = InjectedLanguageUtilBase.tryOffset(file2, offset2, documentManager);
            PsiElement injected = (PsiElement)result2.first;
            if (injected != null) {
                return injected;
            }
        }
        Language baseLanguage = viewProvider.getBaseLanguage();
        if (result2 != null && baseLanguage == result2.third) {
            return (PsiElement)result2.second;
        }
        return viewProvider.findElementAt(offset2, baseLanguage);
    }

    private static void probeElementsUp(@NotNull PsiElement element, @NotNull PsiFile hostPsiFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        if (element == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(20);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(21);
        }
        if (visitor2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(22);
        }
        ReadActionCache.getInstance().allowInWriteAction(() -> InjectedLanguageUtilBase.probeElementsUpInner(element, hostPsiFile, probeUp, visitor2));
    }

    private static void probeElementsUpInner(@NotNull PsiElement element, @NotNull PsiFile hostPsiFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        PsiElement current;
        if (element == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(23);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(24);
        }
        if (visitor2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(25);
        }
        if ((element = InjectedLanguageUtilBase.skipNonInjectablePsi(element, probeUp)) == null) {
            return;
        }
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(hostPsiFile.getProject());
        InjectionResult result2 = null;
        for (current = element; current != null && current != hostPsiFile && !(current instanceof PsiDirectory); current = current.getParent()) {
            ProgressManager.checkCanceled();
            if ("EL".equals(current.getLanguage().getID())) break;
            result2 = SoftReference.deref(current.getUserData(INJECTED_PSI));
            if (result2 == null || !result2.isModCountUpToDate() || !result2.isValid()) {
                result2 = injectedManager.processInPlaceInjectorsFor(hostPsiFile, current);
                InjectedLanguageUtilBase.preventResultFromGCWhileInjectedPsiIsReachable(result2);
            }
            if (result2 == null) continue;
            if (result2.files != null) {
                for (PsiFile psiFile : result2.files) {
                    boolean intersects;
                    Place place = InjectedLanguageUtilBase.getShreds(psiFile);
                    if (!place.isValid() || !(intersects = InjectedLanguageUtilBase.intersects(element, place))) continue;
                    visitor2.visit(psiFile, place);
                }
            }
            if (result2.references == null || !(visitor2 instanceof InjectedReferenceVisitor)) break;
            InjectedReferenceVisitor refVisitor = (InjectedReferenceVisitor)visitor2;
            for (Pair<ReferenceInjector, Place> pair : result2.references) {
                boolean intersects;
                Place place = pair.getSecond();
                if (!place.isValid() || !(intersects = InjectedLanguageUtilBase.intersects(element, place))) continue;
                ReferenceInjector injector = pair.getFirst();
                refVisitor.visitInjectedReference(injector, place);
            }
            break;
        }
        if (element != current && (probeUp || result2 != null)) {
            InjectedLanguageUtilBase.cacheResults(element, current, hostPsiFile, result2);
        }
    }

    private static void cacheResults(@NotNull PsiElement from, @Nullable PsiElement upUntil, @NotNull PsiFile hostFile, @Nullable InjectionResult result2) {
        if (from == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(26);
        }
        if (hostFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(27);
        }
        InjectionResult cachedRef = result2 == null || result2.isEmpty() ? InjectedLanguageUtilBase.getEmptyInjectionResult(hostFile) : new SoftReference<InjectionResult>(result2);
        for (PsiElement e = from; e != upUntil && e != null; e = e.getParent()) {
            ProgressManager.checkCanceled();
            e.putUserData(INJECTED_PSI, cachedRef);
        }
    }

    private static void preventResultFromGCWhileInjectedPsiIsReachable(@Nullable InjectionResult result2) {
        if (result2 != null && result2.files != null) {
            for (PsiFile psiFile : result2.files) {
                psiFile.getViewProvider().putUserData(INJECTION_HOLDER_BACK_REFERENCE, result2);
            }
        }
    }

    @NotNull
    private static InjectionResult getEmptyInjectionResult(@NotNull PsiFile host) {
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(28);
        }
        InjectionResult injectionResult = (InjectionResult)CachedValuesManager.getCachedValue(host, INJECTION_RESULT_KEY, () -> CachedValueProvider.Result.createSingleDependency(new InjectionResult(host, null, null), PsiModificationTracker.MODIFICATION_COUNT));
        if (injectionResult == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(29);
        }
        return injectionResult;
    }

    public static boolean isInjectable(@NotNull PsiElement element, boolean probeUp) {
        if (element == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(30);
        }
        return InjectedLanguageUtilBase.stopLookingForInjection(element) || element.getFirstChild() != null || probeUp;
    }

    @Nullable
    private static PsiElement skipNonInjectablePsi(@NotNull PsiElement element, boolean probeUp) {
        if (element == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(31);
        }
        if (!InjectedLanguageUtilBase.stopLookingForInjection(element) && element.getFirstChild() == null) {
            if (!probeUp) {
                return null;
            }
            for (element = element.getParent(); element != null && !InjectedLanguageUtilBase.stopLookingForInjection(element) && element.getFirstChild() == element.getLastChild(); element = element.getParent()) {
            }
        }
        return element;
    }

    private static boolean stopLookingForInjection(@NotNull PsiElement element) {
        if (element == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(32);
        }
        return element instanceof PsiFileSystemItem || element instanceof PsiLanguageInjectionHost;
    }

    private static boolean intersects(@NotNull PsiElement hostElement, @NotNull Place place) {
        if (hostElement == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(33);
        }
        if (place == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(34);
        }
        TextRange hostElementRange = hostElement.getTextRange();
        boolean intersects = false;
        for (PsiLanguageInjectionHost.Shred shred : place) {
            PsiLanguageInjectionHost shredHost = shred.getHost();
            if (shredHost == null || !shredHost.getTextRange().intersects(hostElementRange)) continue;
            intersects = true;
            break;
        }
        return intersects;
    }

    static PsiElement findInjectedElementNoCommit(@NotNull PsiFile hostFile, int offset2) {
        if (hostFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(35);
        }
        if (hostFile instanceof PsiCompiledElement) {
            return null;
        }
        Project project2 = hostFile.getProject();
        if (InjectedLanguageManager.getInstance(project2).isInjectedFragment(hostFile)) {
            return null;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        Trinity<PsiElement, PsiElement, Language> result2 = InjectedLanguageUtilBase.tryOffset(hostFile, offset2, documentManager);
        return (PsiElement)result2.first;
    }

    @NotNull
    private static Trinity<PsiElement, PsiElement, Language> tryOffset(@NotNull PsiFile hostFile, int offset2, @NotNull PsiDocumentManager documentManager) {
        if (hostFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(36);
        }
        if (documentManager == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(37);
        }
        FileViewProvider provider2 = hostFile.getViewProvider();
        Language leafLanguage = null;
        PsiElement leafElement = null;
        for (Language language : provider2.getLanguages()) {
            PsiElement injected;
            PsiElement leftElement;
            PsiElement element = provider2.findElementAt(offset2, language);
            if (element != null) {
                PsiElement injected2;
                if (leafLanguage == null) {
                    leafLanguage = language;
                    leafElement = element;
                }
                if ((injected2 = InjectedLanguageUtilBase.findInside(element, hostFile, offset2, documentManager)) != null) {
                    Trinity<PsiElement, PsiElement, Language> trinity = Trinity.create(injected2, element, language);
                    if (trinity == null) {
                        InjectedLanguageUtilBase.$$$reportNull$$$0(38);
                    }
                    return trinity;
                }
            }
            if (offset2 == 0 || element != null && element.getTextRange().getStartOffset() != offset2 || (leftElement = provider2.findElementAt(offset2 - 1, language)) == null || leftElement.getTextRange().getEndOffset() != offset2 || (injected = InjectedLanguageUtilBase.findInside(leftElement, hostFile, offset2, documentManager)) == null) continue;
            Trinity<PsiElement, PsiElement, Language> trinity = Trinity.create(injected, element, language);
            if (trinity == null) {
                InjectedLanguageUtilBase.$$$reportNull$$$0(39);
            }
            return trinity;
        }
        Trinity<Object, Object, Object> trinity = Trinity.create(null, leafElement, leafLanguage);
        if (trinity == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(40);
        }
        return trinity;
    }

    private static PsiElement findInside(@NotNull PsiElement element, @NotNull PsiFile hostFile, int hostOffset, @NotNull PsiDocumentManager documentManager) {
        if (element == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(41);
        }
        if (hostFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(42);
        }
        if (documentManager == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(43);
        }
        Ref out = new Ref();
        InjectedLanguageUtilBase.enumerate(element, hostFile, true, (injectedPsi, places) -> {
            for (PsiLanguageInjectionHost.Shred place : places) {
                TextRange hostRange = place.getHost().getTextRange();
                if (!hostRange.cutOut(place.getRangeInsideHost()).grown(1).contains(hostOffset)) continue;
                DocumentWindowImpl document = (DocumentWindowImpl)documentManager.getCachedDocument(injectedPsi);
                if (document == null) {
                    return;
                }
                int injectedOffset = document.hostToInjected(hostOffset);
                PsiElement injElement = injectedPsi.findElementAt(injectedOffset);
                out.set(injElement == null ? injectedPsi : injElement);
            }
        });
        return (PsiElement)out.get();
    }

    @Deprecated
    @NotNull
    public static ConcurrentList<DocumentWindow> getCachedInjectedDocuments(@NotNull PsiFile hostPsiFile) {
        List injected;
        if (hostPsiFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(44);
        }
        if ((injected = hostPsiFile.getUserData(INJECTED_DOCS_KEY)) == null) {
            injected = ((UserDataHolderEx)((Object)hostPsiFile)).putUserDataIfAbsent(INJECTED_DOCS_KEY, ContainerUtil.createConcurrentList());
        }
        ConcurrentList concurrentList = (ConcurrentList)injected;
        if (concurrentList == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(45);
        }
        return concurrentList;
    }

    @NotNull
    static List<DocumentWindow> getCachedInjectedDocumentsInRange(@NotNull PsiFile hostPsiFile, @NotNull TextRange range) {
        if (hostPsiFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(46);
        }
        if (range == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(47);
        }
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtilBase.getCachedInjectedDocuments(hostPsiFile);
        List<DocumentWindow> list2 = ContainerUtil.filter(injected, inj -> Arrays.stream(inj.getHostRanges()).anyMatch(range::intersects));
        if (list2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(48);
        }
        return list2;
    }

    static void clearCachedInjectedFragmentsForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(49);
        }
        file2.putUserData(INJECTED_DOCS_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches(@NotNull Project project2, @NotNull DocumentWindow documentWindow) {
        if (project2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(50);
        }
        if (documentWindow == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(51);
        }
        if (project2.isDisposed()) {
            return;
        }
        VirtualFileWindowImpl virtualFile2 = (VirtualFileWindowImpl)Objects.requireNonNull(FileDocumentManager.getInstance().getFile(documentWindow));
        PsiManagerEx psiManagerEx = PsiManagerEx.getInstanceEx(project2);
        DebugUtil.performPsiModification("injected clearCaches", () -> psiManagerEx.getFileManager().setViewProvider(virtualFile2, null));
        VirtualFile delegate2 = virtualFile2.getDelegate();
        if (!delegate2.isValid()) {
            return;
        }
        FileViewProvider viewProvider = psiManagerEx.getFileManager().findCachedViewProvider(delegate2);
        if (viewProvider == null) {
            return;
        }
        for (PsiFile hostFile : ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles()) {
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                ConcurrentList<DocumentWindow> cachedInjectedDocuments = InjectedLanguageUtilBase.getCachedInjectedDocuments(hostFile);
                for (int i2 = cachedInjectedDocuments.size() - 1; i2 >= 0; --i2) {
                    DocumentWindow cachedInjectedDocument = (DocumentWindow)cachedInjectedDocuments.get(i2);
                    if (cachedInjectedDocument != documentWindow) continue;
                    cachedInjectedDocuments.remove(i2);
                }
            }
        }
    }

    @Deprecated
    public static PsiFile getTopLevelFile(@NotNull PsiElement element) {
        PsiLanguageInjectionHost host;
        PsiFile containingFile;
        if (element == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(52);
        }
        if ((containingFile = element.getContainingFile()) == null) {
            return null;
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider && (host = InjectedLanguageManager.getInstance(containingFile.getProject()).getInjectionHost(containingFile)) != null) {
            containingFile = host.getContainingFile();
        }
        return containingFile;
    }

    @Nullable
    public static String getUnescapedLeafText(PsiElement element, boolean strict) {
        String unescaped = element.getCopyableUserData(LeafPatcher.UNESCAPED_TEXT);
        if (unescaped != null) {
            return unescaped;
        }
        if (!strict && element.getFirstChild() == null) {
            return element.getText();
        }
        return null;
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable PsiElement psi) {
        if (psi == null) {
            return null;
        }
        PsiFile containingFile = psi.getContainingFile().getOriginalFile();
        PsiElement fileContext = containingFile.getContext();
        if (fileContext instanceof PsiLanguageInjectionHost) {
            return (PsiLanguageInjectionHost)fileContext;
        }
        Place shreds = InjectedLanguageUtilBase.getShreds(containingFile.getViewProvider());
        if (shreds == null) {
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(containingFile);
            if (virtualFile2 instanceof LightVirtualFile) {
                virtualFile2 = ((LightVirtualFile)virtualFile2).getOriginalFile();
            }
            if (virtualFile2 instanceof VirtualFileWindow) {
                shreds = InjectedLanguageUtilBase.getShreds(((VirtualFileWindow)((Object)virtualFile2)).getDocumentWindow());
            }
        }
        return shreds != null ? shreds.getHostPointer().getElement() : null;
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable VirtualFile virtualFile2) {
        return virtualFile2 instanceof VirtualFileWindow ? InjectedLanguageUtilBase.getShreds(((VirtualFileWindow)((Object)virtualFile2)).getDocumentWindow()).getHostPointer().getElement() : null;
    }

    @Deprecated(forRemoval=true)
    public static boolean hasInjections(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(53);
        }
        if (!host.isPhysical()) {
            return false;
        }
        Ref<Boolean> result2 = Ref.create(false);
        InjectedLanguageUtilBase.enumerate(host, (injectedPsi, places) -> result2.set(true));
        return result2.get();
    }

    public static boolean isInInjectedLanguagePrefixSuffix(@NotNull PsiElement element) {
        PsiFile injectedFile;
        if (element == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(54);
        }
        if ((injectedFile = element.getContainingFile()) == null) {
            return false;
        }
        Project project2 = injectedFile.getProject();
        InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance(project2);
        if (!languageManager.isInjectedFragment(injectedFile)) {
            return false;
        }
        TextRange elementRange = element.getTextRange();
        List<TextRange> edibles = languageManager.intersectWithAllEditableFragments(injectedFile, elementRange);
        int combinedEdiblesLength = edibles.stream().mapToInt(TextRange::getLength).sum();
        return combinedEdiblesLength != elementRange.getLength();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 29, 38, 39, 40, 45, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 10: 
            case 29: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: 
            case 15: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 16: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 20: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 41: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 24: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 27: 
            case 35: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostElement";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTree";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShreds";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyInjectionResult";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "tryOffset";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInjectedDocuments";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInjectedDocumentsInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadTree";
                break;
            }
            case 2: 
            case 10: 
            case 29: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 48: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTokens";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnescapedText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightTokens";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getShreds";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mightHaveInjectedFragmentAtCaret";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedPsiNoCommit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtNoCommit";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "probeElementsUp";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "probeElementsUpInner";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "cacheResults";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyInjectionResult";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInjectable";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "skipNonInjectablePsi";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "stopLookingForInjection";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedElementNoCommit";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "tryOffset";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findInside";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedDocuments";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedDocumentsInRange";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "clearCachedInjectedFragmentsForFile";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "clearCaches";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "hasInjections";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isInInjectedLanguagePrefixSuffix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 10, 29, 38, 39, 40, 45, 48 -> new IllegalStateException(string2);
        };
    }

    public record TokenInfo(@NotNull IElementType type, @NotNull ProperTextRange rangeInsideInjectionHost, int shredIndex, TextAttributesKey @NotNull [] textAttributesKeys) {
        @NotNull
        private final IElementType type;
        @NotNull
        private final ProperTextRange rangeInsideInjectionHost;
        private final TextAttributesKey @NotNull [] textAttributesKeys;

        public TokenInfo(@NotNull IElementType type, @NotNull ProperTextRange rangeInsideInjectionHost, int shredIndex, TextAttributesKey @NotNull [] textAttributesKeys) {
            if (type == null) {
                TokenInfo.$$$reportNull$$$0(0);
            }
            if (rangeInsideInjectionHost == null) {
                TokenInfo.$$$reportNull$$$0(1);
            }
            if (textAttributesKeys == null) {
                TokenInfo.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public IElementType type() {
            IElementType iElementType = this.type;
            if (iElementType == null) {
                TokenInfo.$$$reportNull$$$0(3);
            }
            return iElementType;
        }

        @NotNull
        public ProperTextRange rangeInsideInjectionHost() {
            ProperTextRange properTextRange = this.rangeInsideInjectionHost;
            if (properTextRange == null) {
                TokenInfo.$$$reportNull$$$0(4);
            }
            return properTextRange;
        }

        public TextAttributesKey @NotNull [] textAttributesKeys() {
            if (this.textAttributesKeys == null) {
                TokenInfo.$$$reportNull$$$0(5);
            }
            return this.textAttributesKeys;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInsideInjectionHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributesKeys";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase$TokenInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase$TokenInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rangeInsideInjectionHost";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "textAttributesKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5 -> new IllegalStateException(string2);
            };
        }
    }
}

