/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.MultipleRootsInjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.PlaceInfo;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.psi.impl.source.tree.injected.SingleRootInjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.VirtualFileWindowImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentList;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectionRegistrarImpl
implements MultiHostRegistrar {
    private final PsiDocumentManagerBase myDocumentManagerBase;
    private List<PsiFile> resultFiles;
    private List<Pair<ReferenceInjector, Place>> resultReferences;
    private Language myLanguage;
    private List<PlaceInfo> placeInfos;
    private boolean cleared;
    private String fileExtension;
    private final Project myProject;
    private final DocumentEx myHostDocument;
    private final VirtualFile myHostVirtualFile;
    private final PsiElement myContextElement;
    private final PsiFile myHostPsiFile;
    private Thread currentThread;
    private static final Key<ASTNode> TREE_HARD_REF = Key.create("TREE_HARD_REF");

    InjectionRegistrarImpl(@NotNull Project project2, @NotNull PsiFile hostPsiFile, @NotNull PsiElement contextElement, @NotNull PsiDocumentManager docManager) {
        if (project2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(0);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(1);
        }
        if (contextElement == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(2);
        }
        if (docManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(3);
        }
        this.cleared = true;
        this.myProject = project2;
        this.myContextElement = contextElement;
        this.myHostPsiFile = PsiUtilCore.getTemplateLanguageFile(hostPsiFile);
        FileViewProvider viewProvider = this.myHostPsiFile.getViewProvider();
        if (viewProvider instanceof InjectedFileViewProvider) {
            throw new IllegalArgumentException(viewProvider + " must not be injected");
        }
        this.myHostVirtualFile = viewProvider.getVirtualFile();
        this.myDocumentManagerBase = (PsiDocumentManagerBase)docManager;
        this.myHostDocument = (DocumentEx)viewProvider.getDocument();
    }

    @Nullable
    InjectionResult getInjectedResult() {
        return this.resultFiles == null && this.resultReferences == null ? null : new InjectionResult(this.myHostPsiFile, this.resultFiles, this.resultReferences);
    }

    @Override
    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(4);
        }
        MultiHostRegistrar multiHostRegistrar = this.startInjecting(language, null);
        if (multiHostRegistrar == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(5);
        }
        return multiHostRegistrar;
    }

    @Override
    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language, @Nullable String extension2) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(6);
        }
        this.fileExtension = extension2;
        this.placeInfos = new SmartList<PlaceInfo>();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        this.currentThread = Thread.currentThread();
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            throw new UnsupportedOperationException("Cannot inject language '" + language + "' because it has no ParserDefinition");
        }
        this.myLanguage = language;
        InjectionRegistrarImpl injectionRegistrarImpl = this;
        if (injectionRegistrarImpl == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(7);
        }
        return injectionRegistrarImpl;
    }

    private void clear() {
        this.fileExtension = null;
        this.myLanguage = null;
        this.cleared = true;
        this.placeInfos = null;
        this.currentThread = null;
    }

    @Override
    @NotNull
    public MultiHostRegistrar addPlace(@NonNls @Nullable String prefix, @NonNls @Nullable String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (host == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(8);
        }
        if (rangeInsideHost == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(9);
        }
        this.checkThreading();
        if (this.myLanguage == null) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called startInjecting()");
        }
        if (!host.isValidHost()) {
            throw new RuntimeExceptionWithAttachments(host + ".isValidHost() in " + host.getClass() + " returned false so you mustn't inject here.", new Attachment("host.txt", host.getText()));
        }
        PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile(host);
        assert (containingFile == this.myHostPsiFile) : InjectionRegistrarImpl.exceptionContext("Trying to inject into foreign file: " + containingFile, this.myLanguage, this.myHostPsiFile, this.myHostVirtualFile, this.myHostDocument, this.placeInfos, this.myDocumentManagerBase);
        TextRange hostTextRange = host.getTextRange();
        if (!hostTextRange.contains(rangeInsideHost.shiftRight(hostTextRange.getStartOffset()))) {
            this.clear();
            throw new IllegalArgumentException("rangeInsideHost must lie within host text range. rangeInsideHost:" + rangeInsideHost + "; host textRange:" + hostTextRange);
        }
        this.cleared = false;
        String nnPrefix = StringUtil.isEmpty(prefix) ? "" : prefix;
        String nnSuffix = StringUtil.isEmpty(suffix) ? "" : suffix;
        PlaceInfo info2 = new PlaceInfo(nnPrefix, nnSuffix, host, rangeInsideHost);
        this.placeInfos.add(info2);
        InjectionRegistrarImpl injectionRegistrarImpl = this;
        if (injectionRegistrarImpl == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(10);
        }
        return injectionRegistrarImpl;
    }

    private void checkThreading() {
        if (this.currentThread != Thread.currentThread()) {
            throw new IllegalStateException("Wow, you must not start injecting in one thread (" + this.currentThread + ") and finish in the other (" + Thread.currentThread() + ")");
        }
    }

    private static void decode(@NotNull PlaceInfo info2, @NotNull StringBuilder outChars) {
        if (info2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(11);
        }
        if (outChars == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(12);
        }
        int startOffset = outChars.length();
        outChars.append(info2.prefix);
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> textEscaper = info2.myEscaper;
        TextRange relevantRange = info2.getRelevantRangeInsideHost();
        if (relevantRange == null) {
            relevantRange = TextRange.from(textEscaper.getRelevantTextRange().getStartOffset(), 0);
        } else {
            int before = outChars.length();
            boolean decodeSuccessful = textEscaper.decode(relevantRange, outChars);
            int after2 = outChars.length();
            assert (after2 >= before) : "Escaper " + textEscaper + "(" + textEscaper.getClass() + ") must not mangle char buffer";
            if (!decodeSuccessful) {
                int charsDecodedSuccessfully = outChars.length() - before;
                int startOffsetInHost = textEscaper.getOffsetInHost(0, info2.registeredRangeInsideHost);
                assert (relevantRange.containsOffset(startOffsetInHost)) : textEscaper.getClass() + " is inconsistent: its.getOffsetInHost(0) = " + startOffsetInHost + " while its relevantRange=" + relevantRange;
                int endOffsetInHost = textEscaper.getOffsetInHost(charsDecodedSuccessfully, info2.registeredRangeInsideHost);
                assert (relevantRange.containsOffset(endOffsetInHost)) : textEscaper.getClass() + " is inconsistent: its.getOffsetInHost(" + charsDecodedSuccessfully + ") = " + endOffsetInHost + " while its relevantRange=" + relevantRange;
                ProperTextRange successfulHostRange = new ProperTextRange(startOffsetInHost, endOffsetInHost);
                relevantRange = relevantRange.intersection(successfulHostRange);
            }
        }
        outChars.append(info2.suffix);
        int endOffset = outChars.length();
        info2.rangeInDecodedPSI = new ProperTextRange(startOffset, endOffset);
        info2.rangeInHostElement = relevantRange;
    }

    @NotNull
    private static ShredImpl createShred(@NotNull PlaceInfo info2, @NotNull StringBuilder outChars, @NotNull PsiFile hostPsiFile) {
        if (info2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(13);
        }
        if (outChars == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(14);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(15);
        }
        InjectionRegistrarImpl.decode(info2, outChars);
        TextRange relevantRange = info2.rangeInHostElement;
        TextRange hostTextRange = info2.host.getTextRange();
        TextRange relevantRangeInHostFile = relevantRange.shiftRight(hostTextRange.getStartOffset());
        SmartPointerManagerImpl manager = (SmartPointerManagerImpl)SmartPointerManager.getInstance(hostPsiFile.getProject());
        return new ShredImpl(manager.createSmartPsiFileRangePointer(hostPsiFile, relevantRangeInHostFile, true), manager.createSmartPsiElementPointer(info2.host, hostPsiFile, true), info2.prefix, info2.suffix, info2.rangeInDecodedPSI, false, info2.myEscaper.isOneLine());
    }

    @Override
    public void doneInjecting() {
        this.checkThreading();
        try {
            if (this.myLanguage == null) {
                throw new IllegalStateException("Seems you haven't called startInjecting()");
            }
            if (this.placeInfos.isEmpty()) {
                throw new IllegalStateException("Seems you haven't called addPlace()");
            }
            Language forcedLanguage = this.myContextElement.getUserData(SingleRootInjectedFileViewProvider.LANGUAGE_FOR_INJECTED_COPY_KEY);
            InjectionRegistrarImpl.checkForCorrectContextElement(this.placeInfos, this.myContextElement, this.myLanguage, this.myHostPsiFile, this.myHostVirtualFile, this.myHostDocument, this.myDocumentManagerBase);
            this.createAndRegisterInjected(forcedLanguage);
        }
        finally {
            this.clear();
        }
    }

    private static void checkForCorrectContextElement(@NotNull List<PlaceInfo> placeInfos, @NotNull PsiElement contextElement, @NotNull Language language, @NotNull PsiFile hostPsiFile, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument, @NotNull PsiDocumentManagerBase documentManager) {
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(16);
        }
        if (contextElement == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(17);
        }
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(18);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(19);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(20);
        }
        if (hostDocument == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(21);
        }
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(22);
        }
        boolean isAncestor = false;
        for (PlaceInfo info2 : placeInfos) {
            isAncestor |= PsiTreeUtil.isAncestor(contextElement, info2.host, false);
        }
        assert (isAncestor) : InjectionRegistrarImpl.exceptionContext("Context element " + contextElement.getTextRange() + ": '" + contextElement + "' (" + contextElement.getClass() + ");  must be the parent of at least one of injection hosts", language, hostPsiFile, hostVirtualFile, hostDocument, placeInfos, documentManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndRegisterInjected(Language forcedLanguage) {
        ASTNode[] parsedNodes;
        StringBuilder decodedChars = new StringBuilder();
        Place place = new Place();
        for (PlaceInfo info2 : this.placeInfos) {
            ShredImpl shred = InjectionRegistrarImpl.createShred(info2, decodedChars, this.myHostPsiFile);
            place.add(shred);
            info2.newInjectionHostRange = shred.getSmartPointer().getRange();
        }
        DocumentWindowImpl documentWindow = new DocumentWindowImpl(this.myHostDocument, place);
        String fileName = PathUtil.makeFileName(this.myHostVirtualFile.getName(), this.fileExtension);
        for (ASTNode node2 : parsedNodes = InjectionRegistrarImpl.parseFile(this.myLanguage, forcedLanguage, documentWindow, this.myHostVirtualFile, this.myHostDocument, this.myHostPsiFile, this.myProject, documentWindow.getText(), this.placeInfos, decodedChars, fileName, this.myDocumentManagerBase)) {
            PsiFile psiFile = (PsiFile)node2.getPsi();
            InjectedFileViewProvider viewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                if (psiFile.getLanguage() == viewProvider.getBaseLanguage()) {
                    psiFile = InjectionRegistrarImpl.createOrMergeInjectedFile(this.myHostPsiFile, this.myDocumentManagerBase, place, documentWindow, psiFile, viewProvider);
                    this.addFileToResults(psiFile);
                } else {
                    InjectionRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile);
                    InjectedLanguageUtilBase.setHighlightTokens(psiFile, InjectedLanguageUtilBase.getHighlightTokens(psiFile));
                }
                DocumentWindowImpl retrieved = (DocumentWindowImpl)this.myDocumentManagerBase.getDocument(psiFile);
                InjectionRegistrarImpl.assertEverythingIsAllright(this.myDocumentManagerBase, retrieved, psiFile);
            }
        }
    }

    @NotNull
    private static PsiFile createOrMergeInjectedFile(@NotNull PsiFile hostPsiFile, @NotNull PsiDocumentManagerBase documentManager, @NotNull Place place, @NotNull DocumentWindowImpl documentWindow, @NotNull PsiFile psiFile, @NotNull InjectedFileViewProvider viewProvider) {
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(23);
        }
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(24);
        }
        if (place == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(25);
        }
        if (documentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(26);
        }
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(27);
        }
        if (viewProvider == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(28);
        }
        InjectionRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile);
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(documentWindow);
        PsiFile cachedPsiFile = ((PsiManagerEx)psiFile.getManager()).getFileManager().findCachedViewProvider(virtualFile2).getPsi(psiFile.getLanguage());
        assert (cachedPsiFile == psiFile) : "Cached psi :" + cachedPsiFile + " instead of " + psiFile;
        assert (place.isValid());
        assert (viewProvider.isValid());
        List<InjectedLanguageUtilBase.TokenInfo> newTokens = InjectedLanguageUtilBase.getHighlightTokens(psiFile);
        PsiFile newFile = InjectionRegistrarImpl.registerDocument(documentWindow, psiFile, place, hostPsiFile, documentManager);
        boolean mergeHappened = newFile != psiFile;
        Place mergedPlace = place;
        if (mergeHappened) {
            boolean shredsReused;
            InjectedLanguageUtilBase.clearCaches(psiFile.getProject(), documentWindow);
            psiFile = newFile;
            viewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
            documentWindow = viewProvider.getDocument();
            boolean bl = shredsReused = !InjectionRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile);
            if (shredsReused) {
                place.dispose();
                mergedPlace = documentWindow.getShreds();
            }
            InjectedLanguageUtilBase.setHighlightTokens(psiFile, newTokens);
        }
        assert (psiFile.isValid());
        assert (mergedPlace.isValid());
        assert (viewProvider.isValid());
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(29);
        }
        return psiFile2;
    }

    private static void patchLeaves(@NotNull List<? extends PlaceInfo> placeInfos, @NotNull InjectedFileViewProvider viewProvider, @NotNull ASTNode parsedNode, @NotNull CharSequence documentText) throws PatchException {
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(30);
        }
        if (viewProvider == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(31);
        }
        if (parsedNode == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(32);
        }
        if (documentText == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(33);
        }
        Runnable patch2 = () -> {
            LeafPatcher patcher = new LeafPatcher(placeInfos, parsedNode.getTextLength());
            patcher.patch(parsedNode, placeInfos);
        };
        if (viewProvider instanceof SingleRootInjectedFileViewProvider) {
            ((SingleRootInjectedFileViewProvider)viewProvider).doNotInterruptMeWhileImPatchingLeaves(patch2);
        } else if (viewProvider instanceof MultipleRootsInjectedFileViewProvider) {
            ((MultipleRootsInjectedFileViewProvider)viewProvider).doNotInterruptMeWhileImPatchingLeaves(patch2);
        }
        if (!((FileElement)parsedNode).textMatches(documentText)) {
            throw new PatchException("After patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText());
        }
    }

    void injectReference(@NotNull Language language, @NotNull String prefix, @NotNull String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        ParserDefinition parser;
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(34);
        }
        if (prefix == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(35);
        }
        if (suffix == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(36);
        }
        if (host == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(37);
        }
        if (rangeInsideHost == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(38);
        }
        if ((parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)) != null) {
            throw new IllegalArgumentException("Language " + language + " being injected as reference must not have ParserDefinition and yet - " + parser);
        }
        ReferenceInjector injector = ReferenceInjector.findById(language.getID());
        if (injector == null) {
            throw new IllegalArgumentException("Language " + language + " being injected as reference must register reference injector");
        }
        this.placeInfos = new SmartList<PlaceInfo>();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        this.myLanguage = language;
        this.currentThread = Thread.currentThread();
        this.addPlace(prefix, suffix, host, rangeInsideHost);
        Place place = new Place();
        StringBuilder decodedChars = new StringBuilder();
        ShredImpl shred = InjectionRegistrarImpl.createShred(this.placeInfos.get(0), decodedChars, this.myHostPsiFile);
        place.add(shred);
        this.addReferenceToResults(Pair.create(injector, place));
        this.clear();
    }

    private static boolean cacheEverything(@NotNull Place place, @NotNull DocumentWindowImpl documentWindow, @NotNull InjectedFileViewProvider viewProvider, @NotNull PsiFile psiFile) {
        if (place == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(39);
        }
        if (documentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(40);
        }
        if (viewProvider == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(41);
        }
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(42);
        }
        FileDocumentManagerBase.registerDocument(documentWindow, viewProvider.getVirtualFile());
        DebugUtil.performPsiModification("MultiHostRegistrar cacheEverything", () -> viewProvider.forceCachedPsi(psiFile));
        SmartPsiElementPointer<PsiLanguageInjectionHost> pointer = ((ShredImpl)place.get(0)).getSmartPointer();
        psiFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, pointer);
        InjectionRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
        return viewProvider.setShreds(place);
    }

    @NonNls
    private static String exceptionContext(@NonNls @NotNull String msg, @NotNull Language language, @NotNull PsiFile hostPsiFile, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument, @NotNull List<PlaceInfo> placeInfos, @NotNull PsiDocumentManagerBase documentManager) {
        if (msg == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(43);
        }
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(44);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(45);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(46);
        }
        if (hostDocument == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(47);
        }
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(48);
        }
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(49);
        }
        return msg + ".\nOK let's see. Host file: " + hostPsiFile + " in '" + hostVirtualFile.getPresentableUrl() + "' (" + hostPsiFile.getLanguage() + ") " + (documentManager.isUncommited(hostDocument) ? " (uncommitted)" : "") + "\nWas injected " + language + " at ranges: " + placeInfos;
    }

    @NotNull
    private static ASTNode keepTreeFromChameleoningBack(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(50);
        }
        FileASTNode node2 = psiFile.getNode();
        ASTNode child = node2.getFirstChildNode();
        assert (!TreeUtil.isCollapsedChameleon(node2)) : "Chameleon " + node2 + " is collapsed; file: " + psiFile + "; language: " + psiFile.getLanguage();
        psiFile.putUserData(TREE_HARD_REF, node2);
        Reference.reachabilityFence(child);
        FileASTNode fileASTNode = node2;
        if (fileASTNode == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(51);
        }
        return fileASTNode;
    }

    private static void assertEverythingIsAllright(@NotNull PsiDocumentManagerBase documentManager, @NotNull DocumentWindowImpl documentWindow, @NotNull PsiFile psiFile) {
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(52);
        }
        if (documentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(53);
        }
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(54);
        }
        InjectedFileViewProvider injectedFileViewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
        assert (injectedFileViewProvider.isValid()) : "Invalid view provider: " + injectedFileViewProvider;
        DocumentEx frozenWindow = documentManager.getLastCommittedDocument(documentWindow);
        assert (psiFile.textMatches(frozenWindow.getText())) : "Document window text mismatch";
        assert (injectedFileViewProvider.getDocument() == documentWindow) : "Provider document mismatch";
        assert (documentManager.getCachedDocument(psiFile) == documentWindow) : "Cached document mismatch";
        assert (Comparing.equal(psiFile.getVirtualFile(), injectedFileViewProvider.getVirtualFile())) : "Virtual file mismatch: " + psiFile.getVirtualFile() + "; " + injectedFileViewProvider.getVirtualFile();
        PsiDocumentManagerBase.checkConsistency(psiFile, frozenWindow);
    }

    void addToResults(@NotNull InjectionResult result2) {
        if (result2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(55);
        }
        if (result2.files != null) {
            for (PsiFile psiFile : result2.files) {
                this.addFileToResults(psiFile);
            }
        }
        if (result2.references != null) {
            for (Pair pair : result2.references) {
                this.addReferenceToResults(pair);
            }
        }
    }

    private void addFileToResults(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(56);
        }
        if (this.resultFiles == null) {
            this.resultFiles = new SmartList<PsiFile>();
        }
        this.resultFiles.add(psiFile);
    }

    private void addReferenceToResults(@NotNull Pair<ReferenceInjector, Place> pair) {
        if (pair == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(57);
        }
        if (this.resultReferences == null) {
            this.resultReferences = new SmartList<Pair<ReferenceInjector, Place>>();
        }
        this.resultReferences.add(pair);
    }

    @NotNull
    private static PsiFile registerDocument(@NotNull DocumentWindowImpl newDocumentWindow, @NotNull PsiFile newInjectedPsi, @NotNull Place shreds, @NotNull PsiFile hostPsiFile, @NotNull PsiDocumentManager documentManager) {
        if (newDocumentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(58);
        }
        if (newInjectedPsi == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(59);
        }
        if (shreds == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(60);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(61);
        }
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(62);
        }
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtilBase.getCachedInjectedDocuments(hostPsiFile);
        for (int i2 = injected.size() - 1; i2 >= 0; --i2) {
            FileViewProvider viewProvider;
            DocumentWindowImpl oldDocument = (DocumentWindowImpl)injected.get(i2);
            PsiFileImpl oldFile = (PsiFileImpl)documentManager.getCachedPsiFile(oldDocument);
            if (oldFile == null || !oldFile.isValid() || !((viewProvider = oldFile.getViewProvider()) instanceof InjectedFileViewProvider) || ((InjectedFileViewProvider)viewProvider).isDisposed()) {
                injected.remove(i2);
                Disposer.dispose(oldDocument);
                continue;
            }
            FileASTNode newInjectedNode = newInjectedPsi.getNode();
            FileASTNode oldFileNode = oldFile.getNode();
            assert (newInjectedNode != null) : "New node is null";
            if (oldDocument.areRangesEqual(newDocumentWindow)) {
                if (oldFile.getFileType() != newInjectedPsi.getFileType() || oldFile.getLanguage() != newInjectedPsi.getLanguage()) {
                    injected.remove(i2);
                    Disposer.dispose(oldDocument);
                    continue;
                }
                oldFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, newInjectedPsi.getUserData(FileContextUtil.INJECTED_IN_ELEMENT));
                assert (shreds.isValid());
                InjectionRegistrarImpl.mergePsi(oldFile, oldFileNode, newInjectedPsi, newInjectedNode);
                assert (shreds.isValid());
                PsiFileImpl psiFileImpl = oldFile;
                if (psiFileImpl == null) {
                    InjectionRegistrarImpl.$$$reportNull$$$0(63);
                }
                return psiFileImpl;
            }
            if (!InjectionRegistrarImpl.intersect(oldDocument, newDocumentWindow)) continue;
            injected.remove(i2);
        }
        injected.add(newDocumentWindow);
        PsiFile psiFile = newInjectedPsi;
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(64);
        }
        return psiFile;
    }

    private static void mergePsi(@NotNull PsiFile oldFile, @NotNull ASTNode oldFileNode, @NotNull PsiFile injectedPsi, @NotNull ASTNode injectedNode) {
        if (oldFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(65);
        }
        if (oldFileNode == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(66);
        }
        if (injectedPsi == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(67);
        }
        if (injectedNode == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(68);
        }
        if (!oldFile.textMatches(injectedPsi)) {
            InjectedFileViewProvider oldViewProvider = (InjectedFileViewProvider)oldFile.getViewProvider();
            oldViewProvider.performNonPhysically(() -> DebugUtil.performPsiModification("injected tree diff", () -> {
                DiffLog diffLog = BlockSupportImpl.mergeTrees((PsiFileImpl)oldFile, oldFileNode, injectedNode, new DaemonProgressIndicator(), oldFileNode.getText());
                diffLog.doActualPsiChange(oldFile);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BooleanRunnable reparse(@NotNull Language language, @NotNull DocumentWindowImpl oldDocumentWindow, @NotNull PsiFile oldInjectedPsi, @NotNull VirtualFileWindow oldInjectedVirtualFile, @NotNull VirtualFile hostVirtualFile, @NotNull PsiFile hostPsiFile, @NotNull DocumentEx hostDocument, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiDocumentManagerBase documentManager) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(69);
        }
        if (oldDocumentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(70);
        }
        if (oldInjectedPsi == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(71);
        }
        if (oldInjectedVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(72);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(73);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(74);
        }
        if (hostDocument == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(75);
        }
        if (indicator == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(76);
        }
        if (oldRoot == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(77);
        }
        if (newRoot == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(78);
        }
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(79);
        }
        Project project2 = hostPsiFile.getProject();
        String newText = oldDocumentWindow.getText();
        FileASTNode oldNode = oldInjectedPsi.getNode();
        InjectedFileViewProvider oldInjectedPsiViewProvider = (InjectedFileViewProvider)oldInjectedPsi.getViewProvider();
        String oldPsiText = oldNode.getText();
        if (newText.equals(oldPsiText)) {
            return () -> true;
        }
        if (oldDocumentWindow.isOneLine() && newText.contains("\n") != oldPsiText.contains("\n")) {
            return null;
        }
        Place oldPlace = oldDocumentWindow.getShreds();
        StringBuilder newDocumentText = new StringBuilder(newText.length());
        SmartList<PlaceInfo> placeInfos = new SmartList<PlaceInfo>();
        StringBuilder chars = new StringBuilder();
        for (PsiLanguageInjectionHost.Shred shred : oldPlace) {
            PsiLanguageInjectionHost oldHost = shred.getHost();
            if (oldHost == null) {
                return null;
            }
            SmartPsiElementPointer<PsiLanguageInjectionHost> hostPointer = ((ShredImpl)shred).getSmartPointer();
            Segment hostPsiRange = hostPointer.getPsiRange();
            Segment newInjectionHostRange = SelfElementInfo.calcActualRangeAfterDocumentEvents(hostPsiFile, hostDocument, hostPsiRange, true);
            if (newInjectionHostRange == null) {
                return null;
            }
            PsiLanguageInjectionHost newDummyInjectionHost = InjectionRegistrarImpl.findNewInjectionHost(hostPsiFile, oldRoot, newRoot, oldHost, newInjectionHostRange);
            if (newDummyInjectionHost == null) {
                return null;
            }
            newInjectionHostRange = newDummyInjectionHost.getTextRange().shiftRight(oldRoot.getTextRange().getStartOffset());
            Segment hostInjectionRange = shred.getHostRangeMarker();
            if (hostInjectionRange == null) {
                return null;
            }
            TextRange rangeInsideHost = TextRange.create(hostInjectionRange).shiftLeft(newInjectionHostRange.getStartOffset());
            PlaceInfo info2 = new PlaceInfo(shred.getPrefix(), shred.getSuffix(), newDummyInjectionHost, rangeInsideHost);
            placeInfos.add(info2);
            info2.newInjectionHostRange = newInjectionHostRange;
            InjectionRegistrarImpl.decode(info2, chars);
            TextRange rangeInHostElementPSI = info2.rangeInHostElement;
            newDocumentText.append(shred.getPrefix());
            newDocumentText.append(newDummyInjectionHost.getText(), rangeInHostElementPSI.getStartOffset(), rangeInHostElementPSI.getEndOffset());
            newDocumentText.append(shred.getSuffix());
        }
        assert (documentManager.isUncommited(hostDocument));
        String fileName = ((VirtualFileWindowImpl)oldInjectedVirtualFile).getName();
        ASTNode[] parsedNodes = InjectionRegistrarImpl.parseFile(language, language, oldDocumentWindow, hostVirtualFile, hostDocument, hostPsiFile, project2, newDocumentText, placeInfos, chars, fileName, documentManager);
        List<PsiFile> oldFiles = ((AbstractFileViewProvider)((Object)oldInjectedPsiViewProvider)).getCachedPsiFiles();
        Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
        synchronized (object) {
            DiffLog[] diffLogs = new DiffLog[parsedNodes.length];
            for (int i2 = 0; i2 < parsedNodes.length; ++i2) {
                ASTNode parsedNode = parsedNodes[i2];
                PsiFile oldFile = oldFiles.get(i2);
                diffLogs[i2] = BlockSupportImpl.mergeTrees((PsiFileImpl)oldFile, oldFile.getNode(), parsedNode, indicator, oldPsiText);
            }
            return () -> {
                oldInjectedPsiViewProvider.performNonPhysically(() -> DebugUtil.performPsiModification("injected tree diff", () -> {
                    for (int i2 = 0; i2 < diffLogs.length; ++i2) {
                        DiffLog diffLog = diffLogs[i2];
                        diffLog.doActualPsiChange((PsiFile)oldFiles.get(i2));
                        Place newPlace = new Place();
                        for (int j = 0; j < oldPlace.size(); ++j) {
                            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)oldPlace.get(j);
                            PlaceInfo info2 = (PlaceInfo)placeInfos.get(j);
                            ProperTextRange rangeInDecodedPSI = info2.rangeInDecodedPSI;
                            TextRange rangeInHostElementPSI = info2.rangeInHostElement;
                            FileASTNode root = hostPsiFile.getNode();
                            PsiLanguageInjectionHost newHost = InjectionRegistrarImpl.findNewInjectionHost(hostPsiFile, root, root, info2.host, info2.newInjectionHostRange);
                            ShredImpl newShred = ((ShredImpl)shred).withRange(rangeInDecodedPSI, rangeInHostElementPSI, newHost);
                            newPlace.add(newShred);
                        }
                        InjectionRegistrarImpl.cacheEverything(newPlace, oldDocumentWindow, oldInjectedPsiViewProvider, (PsiFile)oldFiles.get(i2));
                        String docText = oldDocumentWindow.getText();
                        assert (docText.equals(newText)) : "=\n" + docText + "\n==\n" + newDocumentText + "\n===\n";
                    }
                }));
                return true;
            };
        }
    }

    private static ASTNode @NotNull [] parseFile(@NotNull Language language, Language forcedLanguage, @NotNull DocumentWindowImpl documentWindow, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument, @NotNull PsiFile hostPsiFile, @NotNull Project project2, @NotNull CharSequence documentText, @NotNull List<PlaceInfo> placeInfos, @NotNull StringBuilder decodedChars, @NotNull String fileName, @NotNull PsiDocumentManagerBase documentManager) {
        if (language == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(80);
        }
        if (documentWindow == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(81);
        }
        if (hostVirtualFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(82);
        }
        if (hostDocument == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(83);
        }
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(84);
        }
        if (project2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(85);
        }
        if (documentText == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(86);
        }
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(87);
        }
        if (decodedChars == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(88);
        }
        if (fileName == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(89);
        }
        if (documentManager == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(90);
        }
        VirtualFileWindowImpl virtualFile2 = new VirtualFileWindowImpl(fileName, hostVirtualFile, documentWindow, language, decodedChars);
        Language finalLanguage = forcedLanguage == null ? LanguageSubstitutors.getInstance().substituteLanguage(language, virtualFile2, project2) : forcedLanguage;
        InjectedFileViewProvider viewProvider = InjectedFileViewProvider.create(PsiManagerEx.getInstanceEx(project2), virtualFile2, documentWindow, finalLanguage);
        Set<Language> languages = viewProvider.getLanguages();
        ASTNode[] parsedNodes = new ASTNode[languages.size()];
        int i2 = 0;
        for (Language lang : languages) {
            IElementType elementType;
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            assert (parserDefinition != null) : "Parser definition for language " + finalLanguage + " is null";
            PsiFileImpl psiFile = (PsiFileImpl)parserDefinition.createFile(viewProvider);
            if (viewProvider instanceof TemplateLanguageFileViewProvider && (elementType = ((TemplateLanguageFileViewProvider)((Object)viewProvider)).getContentElementType(lang)) != null) {
                psiFile.setContentElementType(elementType);
            }
            ASTNode parsedNode = InjectionRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
            assert (parsedNode instanceof FileElement) : "Parsed to " + parsedNode + " instead of FileElement";
            assert (((FileElement)parsedNode).textMatches(decodedChars)) : InjectionRegistrarImpl.exceptionContext("Before patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + decodedChars + "'", finalLanguage, hostPsiFile, hostVirtualFile, hostDocument, placeInfos, documentManager);
            try {
                InjectionRegistrarImpl.patchLeaves(placeInfos, viewProvider, parsedNode, documentText);
            }
            catch (PatchException e) {
                throw new RuntimeException(InjectionRegistrarImpl.exceptionContext(e.getMessage() + "'\n---chars:\n'" + decodedChars + "'", finalLanguage, hostPsiFile, hostVirtualFile, hostDocument, placeInfos, documentManager));
            }
            try {
                List<InjectedLanguageUtilBase.TokenInfo> tokens = InjectionRegistrarImpl.obtainHighlightTokensFromLexer(decodedChars, virtualFile2, project2, placeInfos);
                InjectedLanguageUtilBase.setHighlightTokens(psiFile, tokens);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new RuntimeException(InjectionRegistrarImpl.exceptionContext("Obtaining tokens error", language, hostPsiFile, hostVirtualFile, hostDocument, placeInfos, documentManager), e);
            }
            parsedNodes[i2++] = parsedNode;
        }
        if (parsedNodes == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(91);
        }
        return parsedNodes;
    }

    private static PsiLanguageInjectionHost findNewInjectionHost(@NotNull PsiFile hostPsiFile, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiLanguageInjectionHost oldInjectionHost, @NotNull Segment newInjectionHostRange) {
        int endToLook;
        int startToLook;
        PsiElement toLookIn;
        if (hostPsiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(92);
        }
        if (oldRoot == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(93);
        }
        if (newRoot == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(94);
        }
        if (oldInjectionHost == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(95);
        }
        if (newInjectionHostRange == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(96);
        }
        TextRange oldRootRange = oldRoot.getTextRange();
        TextRange newRootRange = newRoot.getTextRange();
        if (newInjectionHostRange.getEndOffset() <= oldRootRange.getStartOffset()) {
            toLookIn = hostPsiFile;
            startToLook = newInjectionHostRange.getStartOffset();
            endToLook = newInjectionHostRange.getEndOffset();
        } else if (newInjectionHostRange.getStartOffset() >= oldRootRange.getStartOffset() + newRootRange.getLength()) {
            toLookIn = hostPsiFile;
            startToLook = newInjectionHostRange.getStartOffset() + newRootRange.getLength() - oldRootRange.getLength();
            endToLook = newInjectionHostRange.getEndOffset() + newRootRange.getLength() - oldRootRange.getLength();
        } else {
            toLookIn = newRoot.getPsi();
            if (toLookIn instanceof PsiFile) {
                FileViewProvider viewProvider = toLookIn.getViewProvider();
                toLookIn = ObjectUtils.notNull(viewProvider.getPsi(hostPsiFile.getLanguage()), viewProvider.getPsi(viewProvider.getBaseLanguage()));
            }
            startToLook = newInjectionHostRange.getStartOffset() - oldRootRange.getStartOffset();
            endToLook = newInjectionHostRange.getEndOffset() - oldRootRange.getStartOffset();
        }
        try {
            Identikit.ByType kit = Identikit.fromPsi(oldInjectionHost, hostPsiFile.getLanguage());
            return (PsiLanguageInjectionHost)kit.findInside(toLookIn, startToLook, endToLook);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static boolean intersect(DocumentWindowImpl doc1, DocumentWindowImpl doc2) {
        Segment[] hostRanges1 = doc1.getHostRanges();
        Segment[] hostRanges2 = doc2.getHostRanges();
        for (Segment segment1 : hostRanges1) {
            for (Segment segment2 : hostRanges2) {
                if (Math.max(segment1.getStartOffset(), segment2.getStartOffset()) >= Math.min(segment1.getEndOffset(), segment2.getEndOffset())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static List<InjectedLanguageUtilBase.TokenInfo> obtainHighlightTokensFromLexer(@NotNull CharSequence outChars, @NotNull VirtualFileWindow virtualFile2, @NotNull Project project2, @NotNull List<? extends PlaceInfo> placeInfos) {
        if (outChars == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(97);
        }
        if (virtualFile2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(98);
        }
        if (project2 == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(99);
        }
        if (placeInfos == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(100);
        }
        VirtualFile file2 = (VirtualFile)((Object)virtualFile2);
        FileType fileType = file2.getFileType();
        EditorHighlighterProvider provider2 = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = provider2.getEditorHighlighter(project2, fileType, file2, scheme);
        highlighter.setText(outChars);
        HighlighterIterator iterator2 = highlighter.createIterator(0);
        int hostNum = -1;
        int prevHostEndOffset = 0;
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper = null;
        int prefixLength = 0;
        int suffixLength = 0;
        TextRange rangeInsideHost = null;
        int shredEndOffset = -1;
        ArrayList<InjectedLanguageUtilBase.TokenInfo> tokens = new ArrayList<InjectedLanguageUtilBase.TokenInfo>(outChars.length() / 5);
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            TextRange range = new ProperTextRange(iterator2.getStart(), iterator2.getEnd());
            while (range != null && !range.isEmpty()) {
                if (range.getStartOffset() >= shredEndOffset) {
                    PlaceInfo info2 = placeInfos.get(++hostNum);
                    shredEndOffset = info2.rangeInDecodedPSI.getEndOffset();
                    prevHostEndOffset = range.getStartOffset();
                    escaper = info2.myEscaper;
                    rangeInsideHost = info2.rangeInHostElement;
                    prefixLength = info2.prefix.length();
                    suffixLength = info2.suffix.length();
                }
                if (range.getStartOffset() < prevHostEndOffset + prefixLength) {
                    range = new UnfairTextRange(prevHostEndOffset + prefixLength, range.getEndOffset());
                }
                UnfairTextRange spilled = null;
                if (range.getEndOffset() > shredEndOffset - suffixLength) {
                    spilled = new UnfairTextRange(shredEndOffset, range.getEndOffset());
                    range = new UnfairTextRange(range.getStartOffset(), shredEndOffset - suffixLength);
                }
                if (!range.isEmpty()) {
                    int end;
                    int start = escaper.getOffsetInHost(range.getStartOffset() - prevHostEndOffset - prefixLength, rangeInsideHost);
                    if (start == -1) {
                        start = rangeInsideHost.getStartOffset();
                    }
                    if ((end = escaper.getOffsetInHost(range.getEndOffset() - prevHostEndOffset - prefixLength, rangeInsideHost)) == -1) {
                        end = rangeInsideHost.getEndOffset();
                        prevHostEndOffset = shredEndOffset;
                    }
                    ProperTextRange rangeInHost = new ProperTextRange(start, end);
                    tokens.add(new InjectedLanguageUtilBase.TokenInfo(tokenType, rangeInHost, hostNum, iterator2.getTextAttributesKeys()));
                }
                range = spilled;
            }
            iterator2.advance();
        }
        ArrayList<InjectedLanguageUtilBase.TokenInfo> arrayList = tokens;
        if (arrayList == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(101);
        }
        return arrayList;
    }

    public String toString() {
        return String.valueOf(this.resultFiles);
    }

    @NotNull
    PsiFile getHostPsiFile() {
        PsiFile psiFile = this.myHostPsiFile;
        if (psiFile == null) {
            InjectionRegistrarImpl.$$$reportNull$$$0(102);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 10, 29, 51, 63, 64, 91, 101, 102 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 15: 
            case 19: 
            case 23: 
            case 45: 
            case 61: 
            case 74: 
            case 84: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docManager";
                break;
            }
            case 4: 
            case 6: 
            case 18: 
            case 34: 
            case 44: 
            case 69: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 29: 
            case 51: 
            case 63: 
            case 64: 
            case 91: 
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectionRegistrarImpl";
                break;
            }
            case 8: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 9: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: 
            case 14: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 16: 
            case 30: 
            case 48: 
            case 87: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfos";
                break;
            }
            case 20: 
            case 46: 
            case 73: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostVirtualFile";
                break;
            }
            case 21: 
            case 47: 
            case 75: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 22: 
            case 24: 
            case 49: 
            case 52: 
            case 62: 
            case 79: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 26: 
            case 40: 
            case 53: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 27: 
            case 42: 
            case 50: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 28: 
            case 31: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedNode";
                break;
            }
            case 33: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDocumentWindow";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInjectedPsi";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shreds";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNode";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedNode";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDocumentWindow";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInjectedPsi";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInjectedVirtualFile";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 77: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 78: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decodedChars";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInjectionHost";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInjectionHostRange";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectionRegistrarImpl";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startInjecting";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addPlace";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrMergeInjectedFile";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "keepTreeFromChameleoningBack";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "registerDocument";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFile";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainHighlightTokensFromLexer";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startInjecting";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 29: 
            case 51: 
            case 63: 
            case 64: 
            case 91: 
            case 101: 
            case 102: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPlace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createShred";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkForCorrectContextElement";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createOrMergeInjectedFile";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "patchLeaves";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "injectReference";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "cacheEverything";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "exceptionContext";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "keepTreeFromChameleoningBack";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "assertEverythingIsAllright";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addToResults";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addFileToResults";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceToResults";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "mergePsi";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "findNewInjectionHost";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "obtainHighlightTokensFromLexer";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 7, 10, 29, 51, 63, 64, 91, 101, 102 -> new IllegalStateException(string2);
        };
    }

    private static class PatchException
    extends Exception {
        PatchException(String message) {
            super(message);
        }
    }
}

